/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseConverter;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.LicenseReader;
import chemaxon.license.LicenseThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseHandler {
    public static final String JCHEM = "JChem Base";
    public static final String INSTANT_JCHEM = "Instant JChem";
    public static final String INSTANT_JCHEM_VIZ = "Instant JChem VIZ";
    public static final String CARTRIDGE = "JChem Cartridge";
    public static final String STANDARDIZER = "Standardizer";
    public static final String SCREEN = "Screen";
    public static final String REACTOR = "Reactor";
    public static final String FRAGMENTER = "Fragmenter";
    public static final String JKLUSTOR = "JKlustor";
    public static final String METABOLIZER = "Metabolizer";
    public static final String MARKUSH_SEARCH = "Markush Search";
    public static final String NAME_TO_STRUCTURE = "Name to Structure";
    public static final String DOCUMENT_TO_STRUCTURE = "Document to Structure";
    public static final String JCHEM_FOR_EXCEL = "JChem for Excel";
    public static final String CALCULATIONS_PACK = "Calculations Pack";
    public static final String SOAP = "Web Services Server";
    public static final String SHAREPOINT = "SharePoint";
    public static final String STRUCTURE_CHECKER = "Structure Checker";
    public static final String ALIGNMENT = "3D Alignment";
    public static final String SCREEN_3D = "3D Screen";
    public static final String MCES = "MCES";
    public static final String MOLECULAR_DESCRIPTORS = "Molecular Descriptors";
    public static final String ECFP_FCFP = "ECFP/FCFP";
    public static final String REGISTRATION_SYSTEM = "Registration System";
    public static final String NMR = "NMR Predictor";
    public static final String PROTONATION_PLUGIN_GROUP = "Protonation Plugin Group";
    public static final String PARTITIONING_PLUGIN_GROUP = "Partitioning Plugin Group";
    public static final String CHARGE_PLUGIN_GROUP = "Charge Plugin Group";
    public static final String ISOMERS_PLUGIN_GROUP = "Isomers Plugin Group";
    public static final String CONFORMATION_PLUGIN_GROUP = "Conformation Plugin Group";
    public static final String GEOMETRY_PLUGIN_GROUP = "Geometry Plugin Group";
    public static final String HUCKEL_ANALYSIS_PLUGIN = "Huckel Analysis Plugin";
    public static final String REFRACTIVITY_PLUGIN = "Refractivity Plugin";
    public static final String HBDA_PLUGIN = "HBDA Plugin";
    public static final String MARKUSH_ENUM_PLUGIN = "Markush Enumeration Plugin";
    public static final String STRUCTURE_TO_NAME = "Structure to Name Plugin";
    public static final String IUPAC_NAMING_PLUGIN = "IUPAC Naming Plugin";
    public static final String STRUCTURAL_FRAMEWORKS = "Structural Frameworks Plugin";
    public static final String PREDICTOR_PLUGIN = "Predictor Plugin";
    public static final String FREE_PLUGIN = "Free Plugin";
    public static final String PHARMACOPHORE_RECOGNITION = "Pharmacophore Recognition";
    public static final String SYNTHESIZER = "Synthesizer";
    public static final String OPTIMIZE_METRICS = "Optimize Metrics";
    public static final String LIBRARY_MCS = "Library MCS";
    public static final String MOLSEARCH = "Structure Search";
    static final String LICENSE_PROBLEM = "No valid license has been found";
    static final String LICENSE_CONTACT = "Please contact sales@chemaxon.com to obtain the corresponding license.\nStudents and academic researchers are entitled of free use\nthrough our Academic Package, for more information\nplease visit: http://www.chemaxon.com/acpack_conditions.html";
    static final String LICENSE_CONTACT_HTML = "Please contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\nStudents and academic researchers are entitled of free use through our Academic Package, for more information\nplease visit: <a href=\"http://www.chemaxon.com/acpack_conditions.html\">http://www.chemaxon.com/acpack_conditions.html</a>\n";
    private static ArrayList<String> productList = new ArrayList<String>(Arrays.asList(LicenseConverter.products));
    private static ArrayList<String> pluginList = new ArrayList<String>(Arrays.asList(LicenseConverter.plugins));
    private boolean processed = false;
    boolean addTestLicenses = false;
    boolean allowIJCRegistration = false;
    private HashMap<String, Long> validLicenses = new HashMap();
    private HashMap<String, HashMap<String, Long>> internalLicenseUsages = new HashMap();
    private InternalLicenseUsageChecker internalUsageChecker = new InternalLicenseUsageChecker();
    boolean ignoreReadLicenses = false;
    boolean ignoreRefresh = false;
    private static Object isLicensedLock = new Object();
    private static Logger installLogger = Logger.getLogger("cxl.license.install");
    private static Logger verifyLogger = Logger.getLogger("cxl.license.verify");

    protected LicenseHandler() {
        this.initLoggers();
        LicenseReader.getInstance().setLoggers(installLogger, verifyLogger);
        this.addBuiltInLicenses();
        LicenseReader.getInstance().read();
    }

    public static LicenseHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized void init() {
        if (!this.processed) {
            try {
                this.process();
            }
            catch (LicenseProcessingException e) {
                installLogger.warning("Problem reading license file: " + LicenseReader.getInstance().getLastLicensePath());
            }
            this.processed = true;
        }
    }

    public synchronized void process() throws LicenseProcessingException {
        LicenseReader.getInstance().fetch();
        this.convertToTechnicalLicense(LicenseReader.getInstance().getReadLicenses());
    }

    public synchronized void refresh() {
        LicenseReader.getInstance().read();
        try {
            this.process();
        }
        catch (LicenseProcessingException lpe) {
            installLogger.warning("Problem reading license file: " + LicenseReader.getInstance().getLastLicensePath());
        }
    }

    public void setLicenseFile(String licensePath) throws LicenseProcessingException {
        LicenseReader.getInstance().setLicenseFile(licensePath);
        this.process();
    }

    public void setLicense(String s) throws LicenseProcessingException {
        LicenseReader.getInstance().setLicense(s);
        this.process();
    }

    private synchronized void addBuiltInLicenses() {
        LicenseConverter.addBuiltInLicenses(this.addTestLicenses, this.validLicenses, this.internalLicenseUsages);
    }

    private synchronized void initLoggers() {
        try {
            if (System.getProperty("chemaxon.license.install.verbose") != null) {
                installLogger.setLevel(Level.FINER);
                this.setFinerLevel(installLogger, installLogger.getHandlers());
            }
            if (System.getProperty("chemaxon.license.verify.verbose") != null) {
                verifyLogger.setLevel(Level.FINER);
                this.setFinerLevel(verifyLogger, verifyLogger.getHandlers());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void setFinerLevel(Logger logger, Handler[] handlers) {
        if (handlers.length == 0) {
            ConsoleHandler h = new ConsoleHandler();
            h.setLevel(Level.FINER);
            try {
                logger.addHandler(h);
            }
            catch (SecurityException se) {
                return;
            }
            return;
        }
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof ConsoleHandler)) continue;
            handlers[i].setLevel(Level.FINER);
        }
    }

    public synchronized ArrayList<String> getProductList(boolean includePlugins) {
        if (includePlugins) {
            ArrayList<String> list = new ArrayList<String>(productList);
            list.addAll(pluginList);
            return list;
        }
        return productList;
    }

    public synchronized ArrayList<String> getPluginList() {
        return pluginList;
    }

    public String getLicenseExceptionMessage() {
        return LicenseExceptionHandler.getInstance().getLicenseExceptionMessage();
    }

    public String getLicenseExceptionMessage(String product) {
        return LicenseExceptionHandler.getInstance().getLicenseExceptionMessage(product);
    }

    public String getFullLicensePath() {
        return LicenseReader.getInstance().getFullLicensePath();
    }

    public String getLastLicensePath() {
        return LicenseReader.getInstance().getLastLicensePath();
    }

    synchronized void removeAllReadLicenses() {
        LicenseReader.getInstance().clear();
        this.validLicenses.clear();
        this.internalLicenseUsages.clear();
        this.addBuiltInLicenses();
    }

    public void runWithoutAnyLicense(Runnable action) {
        this.runWithoutAnyLicenseExcept(null, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutAnyLicenseExcept(String keepLicense, Runnable action) {
        Object object = this.getIsLicensedLock();
        synchronized (object) {
            try {
                this.refresh();
                this.ignoreRefresh(true);
                LicenseReader.getInstance().clear();
                Iterator<String> licenses = this.validLicenses.keySet().iterator();
                while (licenses.hasNext()) {
                    String license = licenses.next();
                    if (keepLicense != null && keepLicense.equals(license)) continue;
                    licenses.remove();
                }
                this.internalLicenseUsages.clear();
                this.addBuiltInLicenses();
                action.run();
            }
            finally {
                this.ignoreRefresh(false);
            }
        }
    }

    public synchronized boolean isLicensed(String product) {
        return this.isLicensed(product, "");
    }

    public synchronized boolean isDemoModePluginOnly(String plugin) {
        if (NAME_TO_STRUCTURE.equals(plugin) || STRUCTURE_TO_NAME.equals(plugin)) {
            return false;
        }
        this.init();
        long time = System.currentTimeMillis();
        return !this.hasValidLicense(plugin, time) && this.internalUsageChecker.isLicensed(plugin, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isLicensed(String product, String env) {
        Object object = this.getIsLicensedLock();
        synchronized (object) {
            if (this.ignoreReadLicenses) {
                return false;
            }
            this.init();
            long time = System.currentTimeMillis();
            if (product.equals(REACTOR)) {
                if (this.internalUsageChecker.isLegalEnvironment("chemaxon.jchem.cartridge.servlets.react.InteropReactor")) {
                    return this.internalUsageChecker.isLicensed(REACTOR, time);
                }
                if (this.addTestLicenses && this.internalUsageChecker.isLegalEnvironment("chemaxon.license.util.CartridgeStub")) {
                    return this.internalUsageChecker.isLicensed(REACTOR, time);
                }
            }
            if (this.hasValidLicense(product, time)) {
                verifyLogger.fine("Quick check passed: " + product);
                return true;
            }
            if (this.internalUsageChecker.isLicensed(product, time)) {
                return true;
            }
            if (this.isLicensedQuickCheck(product, env, time)) {
                return true;
            }
            return STRUCTURE_TO_NAME.equals(product) && (this.isLicensed(IUPAC_NAMING_PLUGIN, env) || this.isLicensed("Structure to Name", env));
        }
    }

    private boolean hasValidLicense(String product, long currentTime) {
        if (this.validLicenses.containsKey(product)) {
            long expTime = this.validLicenses.get(product);
            if (currentTime <= expTime) {
                return true;
            }
            this.validLicenses.remove(product);
        }
        return false;
    }

    private boolean isLicensedQuickCheck(String product, String environment, long currentTime) {
        HashMap<String, Long> extraLicenses;
        if (this.internalLicenseUsages.containsKey(product) && (extraLicenses = this.internalLicenseUsages.get(product)).containsKey(environment)) {
            long expTime = extraLicenses.get(environment);
            if (currentTime <= expTime) {
                verifyLogger.fine("Quick check passed: " + product + ", " + environment);
                return true;
            }
            this.internalLicenseUsages.remove(product);
        }
        return false;
    }

    public synchronized License getStrongestLicense(String product) {
        this.init();
        return LicenseReader.getInstance().getStrongestLicense(product);
    }

    public synchronized int getJChemSearchPerMin() {
        this.init();
        return LicenseReader.getInstance().getJChemSearchPerMin();
    }

    public synchronized int getJChemSearchPerMin(String env) {
        this.init();
        return "InstantJChemLicenseEnvironment".equals(env) ? Integer.MAX_VALUE : LicenseReader.getInstance().getJChemSearchPerMin();
    }

    public synchronized void checkLicense(String product) throws LicenseException {
        this.checkLicense(product, "");
    }

    public final synchronized void checkLicense(String product, String env) throws LicenseException {
        if (!this.isLicensed(product, env)) {
            if (this.ignoreRefresh) {
                throw new LicenseException(product, env);
            }
            this.refresh();
            if (!this.isLicensed(product, env)) {
                if (product.equals(REACTOR) && env != null && env.equals(CARTRIDGE)) {
                    throw new LicenseException(product + " " + "Professional", env);
                }
                throw new LicenseException(product, env);
            }
        }
    }

    public synchronized void registerInternalLicense(String clazz, List<String> licenses) {
        block6: {
            block5: {
                if (!this.internalUsageChecker.isLegalEnvironment("com.im.commons.misc.LicenseRegistration")) break block5;
                for (String license : licenses) {
                    if (!license.equals(JCHEM) && !this.allowIJCRegistration) {
                        return;
                    }
                    HashMap<String, Long> extraLicenses = this.internalLicenseUsages.get(license);
                    if (extraLicenses == null) {
                        extraLicenses = new HashMap();
                    }
                    extraLicenses.put(clazz, Long.MAX_VALUE);
                    this.internalLicenseUsages.put(license, extraLicenses);
                }
                break block6;
            }
            if (!this.internalUsageChecker.isLegalEnvironment("chemaxon.license.LicenseEnvironmentAcceptanceTest")) break block6;
            for (String license : licenses) {
                HashMap<String, Long> extraLicenses = this.internalLicenseUsages.get(license);
                if (extraLicenses == null) {
                    extraLicenses = new HashMap();
                }
                extraLicenses.put(clazz, Long.MAX_VALUE);
                this.internalLicenseUsages.put(license, extraLicenses);
            }
        }
    }

    public synchronized ArrayList<License> getLicenses(String product, String term) {
        this.init();
        return LicenseReader.getInstance().getLicenses(product, term);
    }

    public synchronized String report() {
        this.init();
        return LicenseReader.getInstance().report();
    }

    public synchronized String report(String product, String term) {
        this.init();
        return LicenseReader.report(product, term);
    }

    public synchronized String report(String product, String term, boolean expired) {
        this.init();
        return LicenseReader.getInstance().report(product, term, expired);
    }

    public synchronized String techreport() {
        this.init();
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public synchronized boolean isExpired(String product) {
        this.init();
        return LicenseReader.getInstance().isExpired(product);
    }

    public synchronized boolean isAboutToExpire(String product) {
        this.init();
        return LicenseReader.getInstance().isAboutToExpire(product);
    }

    public void ignoreReadLicenses(boolean b) {
        this.ignoreReadLicenses = b;
    }

    public void ignoreRefresh(boolean b) {
        this.ignoreRefresh = b;
    }

    public Object getIsLicensedLock() {
        return isLicensedLock;
    }

    public void addTestLicenses(boolean b) {
        this.addTestLicenses = b;
    }

    private void convertToTechnicalLicense(ArrayList<License> readLicenses) {
        for (License license : readLicenses) {
            LicenseConverter.convert(license, this.validLicenses, this.internalLicenseUsages);
        }
    }

    public static void main(String[] args) {
        try {
            LicenseReader.getInstance().setLicenseFile(args[0]);
            installLogger.finer(LicenseHandler.getInstance().report());
            installLogger.finer("----------");
            installLogger.finer(LicenseHandler.getInstance().techreport());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<String> getCurrentCallStack() {
        return this.internalUsageChecker.getCallStack();
    }

    final class InternalLicenseUsageChecker
    extends SecurityManager {
        InternalLicenseUsageChecker() {
        }

        public boolean isLicensed(String product, long time) {
            HashMap internalUsages = (HashMap)LicenseHandler.this.internalLicenseUsages.get(product);
            if (internalUsages == null) {
                return false;
            }
            for (String environment : internalUsages.keySet()) {
                if (!this.isLegalEnvironment(environment) || time > (Long)internalUsages.get(environment)) continue;
                verifyLogger.fine("License environment checker passed: " + product);
                return true;
            }
            return false;
        }

        public boolean isLegalEnvironment(String environment) {
            Vector<String> callStack = this.getCallStack();
            if (Thread.currentThread() instanceof LicenseThread) {
                callStack.addAll(((LicenseThread)Thread.currentThread()).getCallStack());
            }
            return callStack.contains(environment);
        }

        public Vector<String> getCallStack() {
            Vector<String> cs = new Vector<String>();
            for (Class<?> c : super.getClassContext()) {
                cs.add(c.getName());
            }
            return cs;
        }
    }

    private static class SingletonHolder {
        private static final LicenseHandler INSTANCE = new LicenseHandler();

        private SingletonHolder() {
        }
    }
}

