/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.license.License;
import chemaxon.license.LicenseDescriptionGUIFactory;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManagerTool;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.LicenseReader;
import chemaxon.marvin.help.HelpResource;
import chemaxon.marvin.util.Environment;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class LicenseManagerGUI {
    private static final String mainTitle = "ChemAxon License Manager";
    private static final String chemaxonLicensingTitle = "ChemAxon licensing";
    private static final String chemaxonProductsTitle = "ChemAxon products";
    private static final String getHelpTitle = "Getting help";
    private static final String faqTitle = "Frequently asked questions";
    private static final String installTitle = "Installing licenses";
    private static final String requestLicenseTitle = "Request license";
    private static final String productLicenseTitle = "Product license details";
    private static final String pluginsTitle = "Calculator Plugins";
    private static final String helpTitle = "Help";
    private static final String overviewTitle = "License overview";
    private static final String installOverviewTitle = "Installation overview";
    private static final String licenseInstallerTitle = "Install license file";
    private static final String licenseInstallerText = "Please enter the location of the license file or press the Browse button to select path from the file system.";
    private static final String licenseInstallerText1 = "After specifying the path, press the Install button.";
    private static final String licenseInstallerText2 = "If your e-mail client supports drag and drop of attachments, you can drag the license file you received by e-mail to this dialog.";
    private static final String licenseInstallerText3 = "The following licenses will be installed by pressing the Install button:";
    private static final String aboutToExpireText = "The licenses below are about to expire:";
    private static final String licensePathText = "Licenses are read from: ";
    private static final String defaultLocationText = "Default license file location: ";
    private static final String jchemSearchPerMinText = "Maximum Search/Minute: ";
    private static final String LICENSE_DESCRIPTION_DOC = "/help/licensedoc/licensing.html";
    private static final String REQUEST_LICENSE_DOC = "/help/licensedoc/request.html";
    private static final String GETHELP_DOC = "/help/licensedoc/gethelp.html";
    private static final String INSTALL_LICENSE_DOC = "/help/licensedoc/install.html";
    private static final String LICENSE_FAQ_DOC = "/help/licensedoc/licenseFAQ.html";
    private static final String PRODUCTS_DOC = "/help/licensedoc/products.html";
    private static final String HELP_DOC = "/help/licensedoc/index.html";
    private static final String LICENSE_ICON = "/chemaxon/icons/license/licensekey16.png";
    private static final String INFO_ICON = "/chemaxon/icons/license/info16.png";
    private static final String YES_ICON = "/chemaxon/icons/license/yes16.png";
    private static final String INSTALL_ICON = "/chemaxon/icons/license/execute16.png";
    private static final String TABLE_ICON = "/chemaxon/icons/license/table16.png";
    private static final String OPEN_ICON = "/chemaxon/icons/license/open16.png";
    private static final String CLOCK_ICON = "/chemaxon/icons/license/clock16.png";
    private final String PRODUCT_LICENSE_CARD = "card0";
    private final String CHEMAXON_LICENSING_CARD = "card1";
    private final String CHEMAXON_PRODUCTS_CARD = "card2";
    private final String GETHELP_CARD = "card3";
    private final String REQUEST_LICENSE_CARD = "card4";
    private final String LICENSE_INSTALLER_CARD = "card5";
    private final String FAQ_CARD = "card8";
    private final String HELP_CARD = "card9";
    private final String INSTALL_CARD = "card10";
    private Font titleFont = new Font("Tahoma", 0, 16);
    private Font baseFont = new Font("Tahoma", 0, 11);
    private Font uiFont = new Font("Tahoma", 0, 7);
    private JPanel contentPanel;
    private JPanel cardPanel;
    private JPanel ilfPanel;
    private JPanel cldPanel;
    private JPanel rlfPanel;
    private JPanel prodPanel;
    private JPanel overviewPanel;
    private JPanel licPanel;
    private JPanel helpPanel;
    private JPanel installPanel;
    private JPanel faqPanel;
    private JPanel emptyPanel;
    private JPanel installOverviewPanel;
    private JPanel helpOverviewPanel;
    private JFileChooser licenseFileChooser;
    private JTextField licenseFilePath;
    private JTextField jchemSPMTextField;
    private JTextArea licensePathTextArea;
    private JTable licenseContentsTable;
    CellConstraints cc = new CellConstraints();
    LicenseDescriptionGUIFactory pdf = new LicenseDescriptionGUIFactory(this.baseFont);
    JTree contentTree = new JTree();
    HashMap<String, String> cardMap = new HashMap();

    public LicenseManagerGUI() {
        this.licenseFileChooser = new JFileChooser();
        this.licenseFileChooser.setMultiSelectionEnabled(false);
        this.addFileFilter(this.licenseFileChooser, "dat", "Old ChemAxon License Files (*.dat)");
        this.addFileFilter(this.licenseFileChooser, "cxl", "ChemAxon License Files (*.cxl)");
    }

    private static ImageIcon createIcon(String path) {
        try {
            URL u = LicenseManagerGUI.class.getResource(path);
            return new ImageIcon(u);
        }
        catch (NullPointerException npe) {
            return new ImageIcon();
        }
    }

    public static JPanel createLicenseManagerPanel() {
        LicenseManagerGUI lmg = new LicenseManagerGUI();
        return lmg.createContentPanel();
    }

    public static JPanel getLicenseCheckPanel() {
        ArrayList<String> products = LicenseHandler.getInstance().getProductList(true);
        ArrayList<String> expires = new ArrayList<String>();
        for (int i = 0; i < products.size(); ++i) {
            if (!LicenseHandler.getInstance().isAboutToExpire(products.get(i))) continue;
            expires.add(products.get(i));
        }
        if (expires.size() == 0) {
            return null;
        }
        JPanel panel = new JPanel();
        JLabel warningLabel = new JLabel(aboutToExpireText);
        warningLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        panel.setLayout(new BorderLayout());
        panel.add((Component)warningLabel, "North");
        JTextPane licensePane = new JTextPane();
        StyledDocument doc = licensePane.getStyledDocument();
        Style baseStyle = doc.addStyle("base", null);
        StyleConstants.setFontFamily(baseStyle, "Tahoma");
        StyleConstants.setFontSize(baseStyle, 11);
        for (int i = 0; i < expires.size(); ++i) {
            try {
                doc.insertString(doc.getLength(), (String)expires.get(i) + "\n", doc.getStyle("bold"));
                continue;
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        licensePane.setEditable(false);
        licensePane.setOpaque(false);
        panel.add((Component)licensePane, "Center");
        return panel;
    }

    public static void doLicenseCheck(Component parent) {
        JPanel panel = LicenseManagerGUI.getLicenseCheckPanel();
        if (panel == null) {
            return;
        }
        JOptionPane.showMessageDialog(parent, panel, "Warning", 2);
    }

    public JPanel createContentPanel() {
        this.createContentTree();
        this.createCardPanel();
        this.createCardMap();
        this.contentPanel = new JPanel();
        JSplitPane splitPane1 = new JSplitPane();
        JScrollPane treeScrollPane = new JScrollPane();
        this.contentPanel.setLayout(new BorderLayout());
        splitPane1.setContinuousLayout(true);
        splitPane1.setDividerLocation(220);
        treeScrollPane.setViewportView(this.contentTree);
        treeScrollPane.setMinimumSize(new Dimension(100, 100));
        splitPane1.setLeftComponent(treeScrollPane);
        splitPane1.setRightComponent(this.cardPanel);
        this.contentPanel.add((Component)splitPane1, "Center");
        return this.contentPanel;
    }

    public JTree createContentTree() {
        this.contentTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(mainTitle){
            {
                this.add(new DefaultMutableTreeNode(LicenseManagerGUI.licenseInstallerTitle));
                this.add(new DefaultMutableTreeNode(LicenseManagerGUI.overviewTitle));
                DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(LicenseManagerGUI.productLicenseTitle);
                ArrayList<String> products = LicenseHandler.getInstance().getProductList(false);
                ArrayList<String> plugins = LicenseHandler.getInstance().getPluginList();
                for (int i = 0; i < products.size(); ++i) {
                    node1.add(new DefaultMutableTreeNode(products.get(i)));
                }
                DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(LicenseManagerGUI.pluginsTitle);
                for (int i = 0; i < plugins.size(); ++i) {
                    node2.add(new DefaultMutableTreeNode(plugins.get(i)));
                }
                node1.add(node2);
                this.add(node1);
                DefaultMutableTreeNode node3 = new DefaultMutableTreeNode(LicenseManagerGUI.helpTitle);
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.chemaxonLicensingTitle));
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.chemaxonProductsTitle));
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.requestLicenseTitle));
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.getHelpTitle));
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.installTitle));
                node3.add(new DefaultMutableTreeNode(LicenseManagerGUI.faqTitle));
                this.add(node3);
            }
        }));
        this.contentTree.setRootVisible(false);
        this.contentTree.setShowsRootHandles(true);
        this.contentTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LicenseManagerGUI.this.contentTreeValueChanged(e);
            }
        });
        this.contentTree.setCellRenderer(new TreeRenderer());
        this.contentTree.expandRow(3);
        this.contentTree.setFont(this.baseFont);
        return this.contentTree;
    }

    private void createCardMap() {
        this.cardMap.put(chemaxonLicensingTitle, "card1");
        this.cardMap.put(chemaxonProductsTitle, "card2");
        this.cardMap.put(getHelpTitle, "card3");
        this.cardMap.put(faqTitle, "card8");
        this.cardMap.put(installTitle, "card10");
        this.cardMap.put(requestLicenseTitle, "card4");
        this.cardMap.put(licenseInstallerTitle, "card5");
        this.cardMap.put(productLicenseTitle, "card0");
        this.cardMap.put(pluginsTitle, "card0");
        this.cardMap.put(helpTitle, "card9");
    }

    private void contentTreeValueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.contentTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        String card = this.cardMap.get(node.getUserObject().toString());
        if ("card9".equals(card)) {
            this.setHtmlContent(this.helpOverviewPanel, HELP_DOC);
        } else if ("card1".equals(card)) {
            this.setHtmlContent(this.cldPanel, LICENSE_DESCRIPTION_DOC);
        } else if ("card2".equals(card)) {
            this.setHtmlContent(this.prodPanel, PRODUCTS_DOC);
        } else if ("card3".equals(card)) {
            this.setHtmlContent(this.helpPanel, GETHELP_DOC);
        } else if ("card8".equals(card)) {
            this.setHtmlContent(this.faqPanel, LICENSE_FAQ_DOC);
        } else if ("card10".equals(card)) {
            this.setHtmlContent(this.installPanel, INSTALL_LICENSE_DOC);
        } else if ("card4".equals(card)) {
            this.setHtmlContent(this.rlfPanel, REQUEST_LICENSE_DOC);
        }
        if (card != null) {
            cl.show(this.cardPanel, card);
        } else if (node.getUserObject().equals(overviewTitle)) {
            this.createLicenseOverviewPanel();
            cl.show(this.cardPanel, "card7");
        } else {
            this.createLicensePanel(node.getUserObject().toString());
            cl.show(this.cardPanel, "card6");
        }
    }

    public JPanel createCardPanel() {
        this.emptyPanel = new JPanel();
        this.createHelpOverviewPanel();
        this.createLicenseDescriptionPanel();
        this.createProductsPanel();
        this.createGetHelpPanel();
        this.createInstallPanel();
        this.createFaqPanel();
        this.createRequestLicensePanel();
        this.createLicenseInstallerPanel();
        this.createLicensePanel(null);
        this.createLicenseOverviewPanel();
        this.cardPanel = new JPanel();
        this.cardPanel.setMinimumSize(new Dimension(300, 208));
        this.cardPanel.setLayout(new CardLayout(1, 1));
        this.cardPanel.add((Component)this.emptyPanel, "card0");
        this.cardPanel.add((Component)this.cldPanel, "card1");
        this.cardPanel.add((Component)this.prodPanel, "card2");
        this.cardPanel.add((Component)this.helpPanel, "card3");
        this.cardPanel.add((Component)this.rlfPanel, "card4");
        this.cardPanel.add((Component)this.ilfPanel, "card5");
        this.cardPanel.add((Component)this.licPanel, "card6");
        this.cardPanel.add((Component)this.overviewPanel, "card7");
        this.cardPanel.add((Component)this.faqPanel, "card8");
        this.cardPanel.add((Component)this.helpOverviewPanel, "card9");
        this.cardPanel.add((Component)this.installPanel, "card10");
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, "card5");
        return this.cardPanel;
    }

    private void setHtmlContent(JPanel panel, String url) {
        panel.setPreferredSize(new Dimension(630, 400));
        panel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(630, 400));
        scrollPane.setAutoscrolls(true);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    URL url = e.getURL();
                    if (url != null) {
                        LicenseManagerGUI.this.setURL(pane, url);
                    } else {
                        System.err.println("No URL is specified.");
                    }
                }
            }
        });
        URL helpURL = null;
        try {
            helpURL = this.createURL(url);
        }
        catch (MalformedURLException muex) {
            System.err.println("Cannot create URL from " + url + ":" + muex.getMessage());
        }
        if (helpURL != null) {
            try {
                editorPane.setContentType("text/html");
                editorPane.setPage(helpURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Couldn't find file: " + url);
        }
        editorPane.setPreferredSize(new Dimension(612, 398));
        editorPane.setMinimumSize(new Dimension(612, 398));
        scrollPane.setViewportView(editorPane);
        panel.add((Component)scrollPane, "Center");
    }

    private void setURL(JEditorPane pane, URL url) {
        String urlstr = url.toString();
        try {
            if (!urlstr.startsWith("file:") && !urlstr.startsWith("jar:")) {
                URL codebase = Environment.getCodeBase();
                if (codebase == null || !urlstr.startsWith(codebase.toString())) {
                    BrowserLauncher.openURL(urlstr);
                } else {
                    pane.setContentType("text/html");
                    pane.setPage(url);
                }
            } else {
                pane.setContentType("text/html");
                pane.setPage(url);
            }
        }
        catch (IOException ex) {
            System.err.println("Attempted to read a bad URL: " + urlstr);
        }
    }

    private URL createURL(String filename) throws MalformedURLException {
        URL url = null;
        if (Environment.APPLET) {
            URL codebase = Environment.getCodeBase();
            String s = filename.startsWith("/") ? filename.substring(1) : filename;
            url = new URL(codebase, s);
        } else {
            url = Environment.getLocalURL(HelpResource.class, filename);
        }
        return url;
    }

    public JPanel createHelpOverviewPanel() {
        this.helpOverviewPanel = new JPanel();
        return this.helpOverviewPanel;
    }

    public JPanel createLicenseDescriptionPanel() {
        this.cldPanel = new JPanel();
        return this.cldPanel;
    }

    public JPanel createRequestLicensePanel() {
        this.rlfPanel = new JPanel();
        return this.rlfPanel;
    }

    public JPanel createGetHelpPanel() {
        this.helpPanel = new JPanel();
        return this.helpPanel;
    }

    public JPanel createInstallPanel() {
        this.installPanel = new JPanel();
        return this.installPanel;
    }

    public JPanel createProductsPanel() {
        this.prodPanel = new JPanel();
        return this.prodPanel;
    }

    public JPanel createFaqPanel() {
        this.faqPanel = new JPanel();
        return this.faqPanel;
    }

    public JPanel createLicensePanel(String product) {
        if (this.licPanel == null) {
            this.licPanel = this.constructLicensePanel(product);
        } else {
            this.pdf.updateLicenseTable(product);
        }
        return this.licPanel;
    }

    public JPanel createLicenseOverviewPanel() {
        if (this.overviewPanel == null) {
            this.overviewPanel = this.constructLicenseOverviewPanel();
        } else {
            this.pdf.updateLicenseOverviewTable();
            this.licensePathTextArea.setText(LicenseReader.getInstance().getFullLicensePath());
            int spm = LicenseHandler.getInstance().getJChemSearchPerMin();
            String spms = spm == Integer.MAX_VALUE ? "Unlimited" : "" + spm;
            this.jchemSPMTextField.setText(spms);
        }
        return this.overviewPanel;
    }

    public JPanel constructLicensePanel(String product) {
        this.licPanel = new JPanel();
        this.licPanel.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.licPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX7, 0.0), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.PREF_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.DEFAULT, (Size)Sizes.DEFAULT, 1.0)}));
        JLabel label9 = new JLabel(productLicenseTitle);
        this.setTitleFont(label9);
        this.licPanel.add((Component)label9, this.cc.xywh(1, 1, 2, 1));
        JTable licenseTable = this.pdf.createLicenseTable(product);
        licenseTable.setAutoResizeMode(0);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(licenseTable);
        scrollPane1.setPreferredSize(new Dimension(350, 150));
        this.licPanel.add((Component)scrollPane1, this.cc.xy(2, 3));
        return this.licPanel;
    }

    public JPanel constructLicenseOverviewPanel() {
        this.overviewPanel = new JPanel();
        this.overviewPanel.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.overviewPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;150dlu):grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("min(default;100dlu)"), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        JLabel title = new JLabel();
        title.setText(overviewTitle);
        this.setTitleFont(title);
        this.overviewPanel.add((Component)title, this.cc.xywh(1, 1, 3, 1));
        JLabel defaultLocationLabel = new JLabel();
        defaultLocationLabel.setText(defaultLocationText);
        this.overviewPanel.add((Component)defaultLocationLabel, this.cc.xy(1, 3));
        JTextField defaultLocationTextField = new JTextField(LicenseReader.getInstance().getDefaultLicensePath());
        defaultLocationTextField.setEditable(false);
        this.overviewPanel.add((Component)defaultLocationTextField, this.cc.xy(3, 3));
        JLabel licensePathLabel = new JLabel();
        licensePathLabel.setText(licensePathText);
        this.overviewPanel.add((Component)licensePathLabel, this.cc.xy(1, 7));
        this.licensePathTextArea = new JTextArea();
        this.licensePathTextArea.setEditable(false);
        this.licensePathTextArea.setLineWrap(true);
        this.licensePathTextArea.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.licensePathTextArea);
        this.overviewPanel.add((Component)scroll, this.cc.xy(3, 7));
        JLabel jchemSPMLabel = new JLabel();
        jchemSPMLabel.setText(jchemSearchPerMinText);
        this.overviewPanel.add((Component)jchemSPMLabel, this.cc.xy(1, 5));
        this.jchemSPMTextField = new JTextField();
        this.jchemSPMTextField.setEditable(false);
        this.overviewPanel.add((Component)this.jchemSPMTextField, this.cc.xy(3, 5));
        JTable licenseOverviewTable = this.pdf.createLicenseOverviewTable();
        licenseOverviewTable.setAutoResizeMode(0);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setVerticalScrollBarPolicy(22);
        scrollPane1.setViewportView(licenseOverviewTable);
        this.overviewPanel.add((Component)scrollPane1, this.cc.xywh(1, 9, 3, 1));
        return this.overviewPanel;
    }

    public JPanel createLicenseInstallerPanel() {
        this.ilfPanel = new JPanel();
        this.ilfPanel.setBorder(Borders.TABBED_DIALOG_BORDER);
        JLabel label1 = new JLabel(licenseInstallerTitle);
        JTextArea textArea1 = new JTextArea();
        JTextArea textArea2 = new JTextArea();
        JLabel label2 = new JLabel("License file:");
        label2.setFont(this.baseFont);
        this.licenseFilePath = new JTextField();
        JButton button1 = new JButton();
        JButton button2 = new JButton();
        this.ilfPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.DLUX7), new ColumnSpec("max(pref;45dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(pref;60dlu):grow"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(pref;50dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(pref;50dlu)")}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0)}));
        this.setTitleFont(label1);
        this.ilfPanel.add((Component)label1, this.cc.xywh(1, 1, 8, 1));
        textArea1.setFocusable(false);
        textArea1.setEditable(false);
        textArea1.setFont(label2.getFont());
        textArea1.setText(licenseInstallerText);
        textArea1.setWrapStyleWord(true);
        textArea1.setLineWrap(true);
        textArea1.setOpaque(false);
        textArea1.setFont(this.baseFont);
        JLabel label11 = new JLabel(licenseInstallerText1);
        label11.setFont(this.baseFont.deriveFont(1));
        textArea2.setFocusable(false);
        textArea2.setEditable(false);
        textArea2.setFont(label2.getFont());
        textArea2.setText(licenseInstallerText2);
        textArea2.setWrapStyleWord(true);
        textArea2.setLineWrap(true);
        textArea2.setOpaque(false);
        textArea2.setFont(this.baseFont);
        this.ilfPanel.add((Component)textArea1, this.cc.xywh(2, 3, 7, 1));
        this.ilfPanel.add((Component)label11, this.cc.xywh(2, 5, 7, 1));
        this.ilfPanel.add((Component)label2, this.cc.xy(2, 7));
        this.ilfPanel.add((Component)this.licenseFilePath, this.cc.xywh(4, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.CENTER));
        button1.setText("Browse...");
        button1.setIcon(LicenseManagerGUI.createIcon(OPEN_ICON));
        button1.setFont(this.baseFont);
        button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LicenseManagerGUI.this.licenseFileChooser.showOpenDialog(LicenseManagerGUI.this.ilfPanel) == 0) {
                    LicenseManagerGUI.this.setLicenseFileLocation(LicenseManagerGUI.this.licenseFileChooser.getSelectedFile().getPath());
                }
            }
        });
        this.ilfPanel.add((Component)button1, this.cc.xywh(6, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.CENTER));
        button2.setText("Install");
        button2.setIcon(LicenseManagerGUI.createIcon(INSTALL_ICON));
        button2.setFont(this.baseFont);
        button2.setRolloverEnabled(true);
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LicenseManagerTool.main(new String[]{LicenseManagerGUI.this.licenseFilePath.getText()});
                    LicenseHandler.getInstance().refresh();
                    ArrayList<License> licenses = LicenseManagerTool.newLicenses.size() > 0 ? LicenseManagerTool.newLicenses : LicenseHandler.getInstance().getLicenses(null, null);
                    LicenseManagerGUI.this.installOverviewPanel = LicenseManagerGUI.this.constructInstallOverviewPanel(licenses);
                    CardLayout cl = (CardLayout)LicenseManagerGUI.this.cardPanel.getLayout();
                    LicenseManagerGUI.this.cardPanel.add((Component)LicenseManagerGUI.this.installOverviewPanel, "ioCard");
                    cl.show(LicenseManagerGUI.this.cardPanel, "ioCard");
                    LicenseManagerGUI.this.contentTree.revalidate();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.ilfPanel.add((Component)button2, this.cc.xywh(8, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.CENTER));
        this.ilfPanel.add((Component)textArea2, this.cc.xywh(2, 9, 7, 1));
        JLabel label3 = new JLabel(licenseInstallerText3);
        label3.setFont(this.baseFont);
        this.ilfPanel.add((Component)label3, this.cc.xywh(2, 11, 7, 1));
        ArrayList<License> lics = new ArrayList<License>();
        this.licenseContentsTable = this.pdf.createInstallOverviewTable(lics);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setVerticalScrollBarPolicy(22);
        scrollPane1.setViewportView(this.licenseContentsTable);
        scrollPane1.setPreferredSize(new Dimension(550, 150));
        this.licenseContentsTable.setAutoResizeMode(0);
        this.ilfPanel.add((Component)scrollPane1, this.cc.xywh(2, 13, 7, 1));
        return this.ilfPanel;
    }

    private void setLicenseFileLocation(String s) {
        this.licenseFilePath.setText(s);
        ArrayList<License> licenses = new ArrayList();
        try {
            licenses = LicenseReader.getInstance().readLicensesFromFile(s);
        }
        catch (LicenseProcessingException e) {
            JOptionPane.showMessageDialog(this.ilfPanel, e.getMessage(), "Error", 0);
        }
        this.pdf.updateLicenseOverviewTable(licenses, this.licenseContentsTable);
        this.pdf.setCustomLicenseState(this.licenseContentsTable, "To be installed");
    }

    public JPanel constructInstallOverviewPanel(ArrayList<License> installedLicenses) {
        this.installOverviewPanel = new JPanel();
        this.installOverviewPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.DLUX7), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX7), new ColumnSpec("max(pref;150dlu):grow"), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec((Size)Sizes.DLUY7), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        JLabel label3 = new JLabel();
        label3.setText(installOverviewTitle);
        this.setTitleFont(label3);
        this.installOverviewPanel.add((Component)label3, this.cc.xywh(3, 3, 2, 1));
        JTable installOverviewTable = this.pdf.createInstallOverviewTable(installedLicenses);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setVerticalScrollBarPolicy(22);
        scrollPane1.setViewportView(installOverviewTable);
        installOverviewTable.setAutoResizeMode(0);
        this.installOverviewPanel.add((Component)scrollPane1, this.cc.xy(4, 5));
        return this.installOverviewPanel;
    }

    private void addFileFilter(JFileChooser chooser, final String ext, final String desc) {
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fileName = f.getName().toLowerCase();
                    if (fileName.endsWith(ext)) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        });
    }

    private void setTitleFont(JLabel label) {
        label.setFont(this.titleFont);
    }

    public static JFrame createFrame(String arg) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle(mainTitle);
        LicenseManagerGUI.setIconImage(frame);
        LicenseManagerGUI lmg = new LicenseManagerGUI();
        frame.getContentPane().add(lmg.createContentPanel());
        frame.pack();
        frame.setLocationRelativeTo(null);
        if (arg != null) {
            lmg.setLicenseFileLocation(arg);
        }
        return frame;
    }

    public static JFrame createFrame() {
        return LicenseManagerGUI.createFrame(null);
    }

    public static JDialog createDialog(Component parent) {
        Frame pw;
        JDialog dialog = null;
        Dialog pd = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        dialog = pd != null ? new JDialog(pd) : ((pw = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent)) != null ? new JDialog(pw) : new JDialog());
        dialog.setTitle(mainTitle);
        LicenseManagerGUI lmg = new LicenseManagerGUI();
        dialog.getContentPane().add(lmg.createContentPanel());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public static void setIconImage(JFrame frame) {
        try {
            URL u = LicenseManagerGUI.class.getResource(LICENSE_ICON);
            if (u != null) {
                Image img = Toolkit.getDefaultToolkit().createImage((ImageProducer)u.getContent());
                frame.setIconImage(img);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String arg = args.length == 0 ? null : args[0];
        JFrame mainFrame = LicenseManagerGUI.createFrame(arg);
        mainFrame.setVisible(true);
        LicenseManagerGUI.doLicenseCheck(mainFrame);
    }

    static void addHyperlinkListener(JEditorPane editorPane) {
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public static JPanel getLicenseExceptionPanel(String product) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JEditorPane editorPane1 = new JEditorPane();
        editorPane1.setEditorKit(new HTMLEditorKit());
        editorPane1.setOpaque(false);
        editorPane1.setEditable(false);
        editorPane1.setText("<html>\n" + LicenseExceptionHandler.getInstance().getProblemMessage() + " for <b>" + product + "</b>.<br>\n" + "License path: <em>" + LicenseHandler.getInstance().getLastLicensePath() + "</em><br>\n" + "Please contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\nStudents and academic researchers are entitled of free use through our Academic Package, for more information\nplease visit: <a href=\"http://www.chemaxon.com/acpack_conditions.html\">http://www.chemaxon.com/acpack_conditions.html</a>\n" + "</html>");
        LicenseManagerGUI.addHyperlinkListener(editorPane1);
        editorPane1.setPreferredSize(new Dimension(400, 200));
        panel.add((Component)editorPane1, "Center");
        return panel;
    }

    public static JPanel getLicenseExceptionPanel(LicenseException exc) {
        return LicenseManagerGUI.getLicenseExceptionPanel(exc.getProduct());
    }

    public static JPanel getLicenseEvaluationPanel(String product) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JEditorPane editorPane1 = new JEditorPane();
        editorPane1.setEditorKit(new HTMLEditorKit());
        editorPane1.setOpaque(false);
        editorPane1.setEditable(false);
        editorPane1.setText("<html>\n" + LicenseExceptionHandler.getInstance().getProblemMessage() + " for <b>" + product + "</b>.<br>\n" + "<br><b>" + "The product will run in Evaluation Mode." + "</b><br><br>\n" + "To disable this dialog please contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\nStudents and academic researchers are entitled of free use through our Academic Package, for more information\nplease visit: <a href=\"http://www.chemaxon.com/acpack_conditions.html\">http://www.chemaxon.com/acpack_conditions.html</a>\n" + "</html>");
        LicenseManagerGUI.addHyperlinkListener(editorPane1);
        editorPane1.setPreferredSize(new Dimension(400, 200));
        panel.add((Component)editorPane1, "Center");
        return panel;
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon clock;
        ImageIcon info;
        ImageIcon yes;
        ImageIcon install;
        ImageIcon table;
        ImageIcon empty;
        HashMap<String, ImageIcon> iconMap = new HashMap();

        public TreeRenderer() {
            this.clock = LicenseManagerGUI.createIcon(LicenseManagerGUI.CLOCK_ICON);
            this.info = LicenseManagerGUI.createIcon(LicenseManagerGUI.INFO_ICON);
            this.yes = LicenseManagerGUI.createIcon(LicenseManagerGUI.YES_ICON);
            this.install = LicenseManagerGUI.createIcon(LicenseManagerGUI.INSTALL_ICON);
            this.table = LicenseManagerGUI.createIcon(LicenseManagerGUI.TABLE_ICON);
            this.empty = new ImageIcon(new BufferedImage(16, 16, 6));
            this.iconMap.put(LicenseManagerGUI.chemaxonLicensingTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.chemaxonProductsTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.getHelpTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.installTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.faqTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.requestLicenseTitle, this.info);
            this.iconMap.put(LicenseManagerGUI.licenseInstallerTitle, this.install);
            this.iconMap.put(LicenseManagerGUI.overviewTitle, this.table);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!leaf) {
                return this;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            ImageIcon icon = this.iconMap.get(node.getUserObject().toString());
            if (icon != null) {
                this.setIcon(icon);
            } else if (LicenseHandler.getInstance().isAboutToExpire(node.getUserObject().toString())) {
                this.setIcon(this.clock);
            } else if (LicenseHandler.getInstance().isLicensed(node.getUserObject().toString())) {
                this.setIcon(this.yes);
            } else {
                this.setIcon(this.empty);
            }
            return this;
        }
    }
}

