/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.XMLReader;
import chemaxon.license.XMLWriter;
import chemaxon.util.CLQ;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class LicenseManagerTool {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String HELP_MESSAGE = lineSep + "LicenseHandler, (C) 1998-2012 ChemAxon Ltd," + lineSep + "This will install ChemAxon license files, or lists the available ChemAxon licenses with their statuses." + lineSep + lineSep + "Usage:" + lineSep + "  license {hltpm} [license file path]" + lineSep + lineSep + "Options:" + lineSep + "  -h, --help                     print this help message" + lineSep + "  -l, --list <all|valid|invalid> list available licenses" + lineSep + "                                   all: all licenses" + lineSep + "                                   valid: valid licenses only" + lineSep + "                                   invalid: expired licenses only" + lineSep + "                                   (default: all)" + lineSep + "  -t, --term <license term>      list license(s) of the given term" + lineSep + "  -p, --product <product name>   list license(s) of the given product" + lineSep + "  -m, --merge                    merges 2 license files, see Example 5" + lineSep + "  <license file path>            install a license file from the given path" + lineSep + "  Installation merges the contains of the given license file with the already existing one," + lineSep + "  the merged file will be saved to user_home/chemaxon/license.cxl" + lineSep + lineSep + "Example 1: install a license file:" + lineSep + "  license c:/Temp/license.cxl" + lineSep + "Example 2: list all valid licenses of Standardizer:" + lineSep + "  license -p Standardizer" + lineSep + "Example 3: list all Evaluation licenses:" + lineSep + "  license -t Evaluation" + lineSep + "Example 4: list all expired Evaluation licenses:" + lineSep + "  license -l invalid -t Evaluation" + lineSep + "Example 5: merge 2 license files and save it as a new file:" + lineSep + "  license -m license.cxl ../license.cxl newlicense.cxl";
    private static String product = null;
    private static String term = null;
    private static String list = null;
    private static String path = null;
    private static String path1 = null;
    private static String path2 = null;
    private static String path3 = null;
    static ArrayList<License> newLicenses = new ArrayList();

    public static void main(String[] args) throws IOException {
        if (LicenseManagerTool.processCmdLine(args)) {
            if (term != null || product != null || list != null) {
                if (list != null && !list.equals("all")) {
                    boolean expired = list.equals("invalid");
                    System.out.println(LicenseHandler.getInstance().report(product, term, expired));
                } else {
                    System.out.println(LicenseHandler.getInstance().report(product, term));
                }
            } else if (path1 != null) {
                try {
                    LicenseManagerTool.merge(path1, path2, path3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    LicenseManagerTool.install(path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void merge(String path1, String path2, String path3) throws Exception {
        FileInputStream is1 = new FileInputStream(path1);
        FileInputStream is2 = new FileInputStream(path2);
        XMLReader reader = new XMLReader();
        ArrayList<License> licenses1 = reader.readXML(is1);
        ((InputStream)is1).close();
        ArrayList<License> licenses2 = reader.readXML(is2);
        ((InputStream)is2).close();
        licenses1.addAll(licenses2);
        FileOutputStream os = new FileOutputStream(path3);
        XMLWriter writer = new XMLWriter();
        writer.writeXML(licenses1, os);
        ((OutputStream)os).close();
    }

    public static synchronized void install(String licenseFile) throws Exception {
        InputStream lfis = null;
        boolean serverOnly = false;
        if (LicenseManagerTool.isURL(licenseFile)) {
            URLConnection conn = new URL(licenseFile).openConnection();
            lfis = conn.getInputStream();
            serverOnly = true;
        } else {
            File lf = new File(licenseFile);
            if (lf.exists()) {
                lfis = new FileInputStream(lf);
            }
        }
        if (lfis == null) {
            return;
        }
        XMLReader reader = new XMLReader();
        ArrayList<Object> licenses = new ArrayList();
        try {
            InputStream defis = DotfileUtil.open("license.cxl");
            licenses = reader.readXML(defis);
        }
        catch (Exception ex) {
            // empty catch block
        }
        newLicenses = reader.readXML(lfis);
        lfis.close();
        if (serverOnly) {
            for (int i = 0; i < newLicenses.size(); ++i) {
                License lic = newLicenses.get(i);
                if (!lic.getRestriction("Server Use").equals("Not Allowed")) continue;
                newLicenses.remove(i);
            }
        }
        licenses.addAll(newLicenses);
        OutputStream os = DotfileUtil.create("license.cxl");
        XMLWriter writer = new XMLWriter();
        writer.writeXML(licenses, os);
        os.close();
    }

    private static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    protected static boolean processCmdLine(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println(HELP_MESSAGE);
            return false;
        }
        CLQ cmdLine = new CLQ(args, null);
        try {
            if (cmdLine.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(HELP_MESSAGE);
                return false;
            }
            CLQ.Parameter tParam = cmdLine.lookup("-t", "--term", "", 2, false, false);
            term = tParam != null ? tParam.getString() : null;
            CLQ.Parameter pParam = cmdLine.lookup("-p", "--product", "", 2, false, false);
            product = pParam != null ? pParam.getString() : null;
            CLQ.Parameter lParam = cmdLine.lookup("-l", "--list", "", 2, false, false);
            String string = list = lParam != null ? lParam.getString().toLowerCase() : null;
            if (!(list == null || list.equals("all") || list.equals("valid") || list.equals("invalid"))) {
                System.out.println("Invalid list option: " + list);
                return false;
            }
            CLQ.Parameter merge = cmdLine.lookup("-m", "--merge", "", 4, false, false);
            if (merge != null) {
                path1 = merge.getString(0);
                path2 = merge.getString(1);
                path3 = merge.getString(2);
            } else {
                path = cmdLine.notUsed();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

