/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriter {
    public void writeXML(ArrayList<License> licenses, String outputFileName) throws Exception {
        this.writeXML(licenses, new FileOutputStream(outputFileName));
        System.out.println("XML Output Save to File: " + outputFileName);
    }

    public void writeXML(ArrayList<License> licenses, OutputStream outputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        doc.appendChild(doc.createComment("PLEASE DO NOT MODIFY THIS FILE AND BE AWARE THAT THE FILE CONTAINS CONFIDENTIAL INFORMATION."));
        Element root = doc.createElement("ChemAxon");
        for (License license : licenses) {
            Element le = doc.createElement("License");
            for (int j = 0; j < license.getFieldCount(); ++j) {
                if (license.getFieldValue(j) == null) continue;
                Element field = doc.createElement("Field");
                field.setAttribute("Name", license.getFieldName(j));
                field.setAttribute("Value", license.getFieldValue(j));
                le.appendChild(field);
            }
            Iterator ri = license.getRestrictionNames().iterator();
            while (ri.hasNext()) {
                Element res = doc.createElement("Restriction");
                String r = (String)ri.next();
                res.setAttribute("Name", r);
                res.setAttribute("Value", license.getRestriction(r));
                le.appendChild(res);
            }
            if (license.getSignature() != null) {
                Element sig = doc.createElement("Signature");
                sig.setAttribute("Value", license.getSignature());
                le.appendChild(sig);
            }
            root.appendChild(le);
        }
        doc.appendChild(root);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.transform(new DOMSource(doc), new StreamResult(outputStream));
    }
}

