/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush;

import chemaxon.markush.CalculatorDataProvider;
import chemaxon.markush.MarkushDataProvider;
import chemaxon.markush.MarkushFeature;
import chemaxon.markush.PropertyAggregator;
import chemaxon.markush.PropertyCalculator;
import chemaxon.markush.graph.ExpansionGraph;
import chemaxon.markush.graph.ExpansionGraphParameters;
import chemaxon.markush.graph.FeatureNode;
import chemaxon.markush.graph.StructureNode;
import chemaxon.markush.graph.UnsupportedMarkushException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.util.IntRange;
import java.util.Hashtable;

public class AdditivePropertyAssembler<T> {
    private PropertyCalculator<T> calculator = null;
    private PropertyAggregator<T> aggregator = null;
    private ExpansionGraph graph = null;
    private MarkushDataProvider mdp = null;
    private Hashtable<FeatureNode, T> featurenode2value = new Hashtable();

    public AdditivePropertyAssembler(PropertyCalculator<T> calculator, PropertyAggregator<T> aggregator) {
        this(calculator, aggregator, new ExpansionGraph());
    }

    public AdditivePropertyAssembler(PropertyCalculator<T> calculator, PropertyAggregator<T> aggregator, ExpansionGraphParameters params) {
        this(calculator, aggregator, new ExpansionGraph(params));
    }

    public AdditivePropertyAssembler(PropertyCalculator<T> calculator, PropertyAggregator<T> aggregator, ExpansionGraph graph) {
        this.calculator = calculator;
        this.aggregator = aggregator;
        this.graph = graph;
    }

    public final T calculate(Molecule markush) throws UnsupportedMarkushException {
        this.graph.setMarkush(markush);
        return this.calculate();
    }

    private T calculate() {
        this.featurenode2value.clear();
        this.mdp = new MarkushDataProvider(this.graph.getMarkush(), this.graph.getStandardizedMarkush());
        return this.calculate(this.graph.getRoot());
    }

    public T calculate(StructureNode node) {
        T result = this.calculator.calculate(new CalculatorDataProvider(node.getFixedPart()), this.mdp);
        int count = node.getFeatureNodeCount();
        for (int i = 0; i < count; ++i) {
            FeatureNode fnode = node.getFeatureNode(i);
            result = this.aggregator.and(result, this.calculate(fnode));
        }
        return result;
    }

    public T calculate(FeatureNode node) {
        T result = this.featurenode2value.get(node);
        if (result != null) {
            return result;
        }
        int count = node.getStructureNodeCount();
        for (int i = 0; i < count; ++i) {
            StructureNode snode = node.getStructureNode(i);
            result = result == null ? this.calculate(snode) : this.aggregator.or(result, this.calculate(snode));
        }
        MarkushFeature feature = node.getFeature();
        IntRange range = AdditivePropertyAssembler.getRange(feature, this.mdp.getStandardizedMarkush());
        if (range != null) {
            result = this.assemble(result, range);
        }
        this.featurenode2value.put(node, result);
        return result;
    }

    private T assemble(T value, IntRange range) {
        Object result = null;
        T subresult = value;
        int prev = 1;
        while (range.hasNext()) {
            int next = range.next();
            if (next == 0) {
                result = this.calculator.calculate(new CalculatorDataProvider(new SelectionMolecule()), this.mdp);
                continue;
            }
            for (int i = prev; i < next; ++i) {
                subresult = this.aggregator.and(subresult, value);
            }
            result = result == null ? subresult : this.aggregator.or(result, subresult);
            prev = next;
        }
        return result;
    }

    private static IntRange getRange(MarkushFeature feature, Molecule mol) {
        switch (feature.getType()) {
            case 3: {
                int index = feature.getData();
                MolAtom atom = mol.getAtom(index);
                return new IntRange(atom.getMinRepetitions(), atom.getMaxRepetitions());
            }
            case 5: {
                int index = feature.getData();
                Sgroup repunit = mol.getSgroup(index);
                int x = repunit.findCrossingBonds().length;
                if (x > 1) {
                    IntRange range = new IntRange(repunit.getSubscript());
                    range.setMaxCount(10);
                    return range;
                }
                return new IntRange("1");
            }
        }
        return null;
    }
}

