/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush;

import chemaxon.common.util.ArrayTools;
import chemaxon.markush.MarkushFeature;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;

public class MarkushDataProvider {
    public static final String MARKUSH_ATOM_INDEX = "MARKUSH_ATOM_INDEX";
    public static final String STANDARDIZED_MARKUSH_ATOM_INDEX = "STANDARDIZED_MARKUSH_ATOM_INDEX";
    public static final String MARKUSH_FEATURE = "MARKUSH_FEATURE";
    public static final String IS_H = "IS_H";
    private Molecule markush = null;
    private RgMolecule standardizedMarkush = null;

    MarkushDataProvider(Molecule markush, RgMolecule standardizedMarkush) {
        this.markush = markush;
        this.standardizedMarkush = standardizedMarkush;
    }

    public Molecule getMarkush() {
        return this.markush;
    }

    public RgMolecule getStandardizedMarkush() {
        return this.standardizedMarkush;
    }

    public static int[] getAtomIndexMap(MoleculeGraph structure) {
        return MarkushDataProvider.getAtomIndexMap(structure, MARKUSH_ATOM_INDEX);
    }

    public static int[] getStandardizedAtomIndexMap(MoleculeGraph structure) {
        return MarkushDataProvider.getAtomIndexMap(structure, STANDARDIZED_MARKUSH_ATOM_INDEX);
    }

    private static int[] getAtomIndexMap(MoleculeGraph structure, String prop) {
        int[] map = new int[structure.getAtomCount()];
        for (int i = 0; i < map.length; ++i) {
            map[i] = (Integer)structure.getAtom(i).getProperty(prop);
        }
        return map;
    }

    public static int getMarkushAtomIndex(MolAtom atom) {
        return (Integer)atom.getProperty(MARKUSH_ATOM_INDEX);
    }

    public static int getStandardizedMarkushAtomIndex(MolAtom atom) {
        return (Integer)atom.getProperty(STANDARDIZED_MARKUSH_ATOM_INDEX);
    }

    public static MarkushFeature getMarkushFeature(MolAtom attachment) {
        return (MarkushFeature)attachment.getProperty(MARKUSH_FEATURE);
    }

    public static IsHAtom isHAtom(MolAtom atom) {
        int atno = atom.getAtno();
        switch (atno) {
            case 138: {
                IsHAtom isH = (IsHAtom)((Object)atom.getProperty(IS_H));
                return isH != null ? isH : IsHAtom.NO;
            }
            case 1: {
                return atom.getMassno() == 0 ? IsHAtom.YES : IsHAtom.NO;
            }
            case 136: {
                return IsHAtom.NO;
            }
            case 128: {
                int[] list = atom.getList();
                return ArrayTools.foundInArray(list, 1) ? (list.length > 1 ? IsHAtom.MAYBE : IsHAtom.YES) : IsHAtom.NO;
            }
            case 134: {
                return IsHAtom.NO;
            }
        }
        return IsHAtom.NO;
    }

    public static enum IsHAtom {
        NO,
        YES,
        MAYBE;

    }
}

