/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush;

import java.io.Serializable;
import java.util.Arrays;

public class MarkushFeature
implements Serializable {
    static final long serialVersionUID = 8770437891053649928L;
    public static final int MAX_ENUM_COUNT = 10;
    public static final int RGROUP = 6;
    public static final int LINKNODE = 3;
    public static final int REPUNIT = 5;
    public static final int ATOMLIST = 1;
    public static final int BONDLIST = 2;
    public static final int MULTIBOND = 4;
    private int type;
    private int data;
    private int hashCode;

    public MarkushFeature(int type, int data) {
        this.type = type;
        this.data = data;
        int[] hash = new int[]{type, data};
        this.hashCode = Arrays.hashCode(hash);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkushFeature)) {
            return false;
        }
        MarkushFeature mf = (MarkushFeature)o;
        if (this.type != mf.type) {
            return false;
        }
        return this.data == mf.data;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getType() {
        return this.type;
    }

    public int getData() {
        return this.data;
    }

    public static int calcMultiBondData(int i1, int i2, int atomCount) {
        return i1 + atomCount * i2;
    }

    public static int calcVariableAtomIndex(int data, int atomCount) {
        return data % atomCount;
    }

    public static int calcFixedAtomIndex(int data, int atomCount) {
        return data / atomCount;
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 6: {
                return "RG";
            }
            case 3: {
                return "LN";
            }
            case 5: {
                return "RU";
            }
            case 1: {
                return "AL";
            }
            case 2: {
                return "BL";
            }
            case 4: {
                return "MB";
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MarkushFeature.getTypeString(this.type));
        buffer.append(":" + (this.data + 1));
        return buffer.toString();
    }
}

