/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.markush.MarkushFeature;
import chemaxon.markush.graph.ExpansionGraphParameters;
import chemaxon.markush.graph.FeatureNode;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class ExpansionData {
    ExpansionGraphParameters params = null;
    RgMolecule markush = null;
    Hashtable<MarkushFeature, FeatureNode> feature2node = new Hashtable();
    Hashtable<MarkushFeature, MoleculeGraph> feature2part = new Hashtable();
    Hashtable<MolAtom, HashSet<MarkushFeature>> atom2features = new Hashtable();

    ExpansionData(RgMolecule markush, ExpansionGraphParameters params) {
        int i;
        this.params = params;
        this.markush = markush;
        int count = markush.getSgroupCount();
        for (i = 0; i < count; ++i) {
            Sgroup sgroup = markush.getSgroup(i);
            if (!ExpansionData.isExpandableRepeatingUnit(sgroup)) continue;
            this.store(new MarkushFeature(5, i), sgroup.getSgroupGraph());
        }
        count = markush.getGraphUnion().getAtomCount();
        for (i = 0; i < count; ++i) {
            MolAtom atom = markush.getAtom(i);
            if (!atom.isLinkNode()) continue;
            this.store(new MarkushFeature(3, i), ExpansionData.getLinkPart(atom));
        }
    }

    private void store(MarkushFeature feature, MoleculeGraph part) {
        for (int i = part.getAtomCount() - 1; i >= 0; --i) {
            this.store(feature, part.getAtom(i));
        }
        this.feature2part.put(feature, part);
    }

    private void store(MarkushFeature feature, MolAtom atom) {
        HashSet<MarkushFeature> features = this.atom2features.get(atom);
        if (features == null) {
            features = new HashSet();
            this.atom2features.put(atom, features);
        }
        features.add(feature);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Enumeration<MarkushFeature> keys = this.feature2part.keys();
        while (keys.hasMoreElements()) {
            MarkushFeature key = keys.nextElement();
            MoleculeGraph part = this.feature2part.get(key);
            b.append(key + " -> " + part + " : atomCount = " + part.getAtomCount() + "\n");
        }
        return new String(b);
    }

    private static MoleculeGraph getLinkPart(MolAtom atom) {
        MolBond bond1;
        MoleculeGraph parent = atom.getParent();
        SelectionMolecule m = new SelectionMolecule();
        m.fuse(parent);
        int idx0 = atom.getLinkNodeOuterAtom(0);
        int idx1 = atom.getLinkNodeOuterAtom(1);
        MolBond bond0 = idx0 != -1 ? atom.getBond(idx0) : null;
        MolBond molBond = bond1 = idx1 != -1 ? atom.getBond(idx1) : null;
        if (bond0 != null) {
            m.removeBond(bond0);
        }
        if (bond1 != null) {
            m.removeBond(bond1);
        }
        SelectionMolecule part = new SelectionMolecule();
        m.findFrag(m.indexOf(atom), part);
        return part;
    }

    public static boolean isExpandableRepeatingUnit(Sgroup sgroup) {
        if (sgroup instanceof RepeatingUnitSgroup) {
            int x = sgroup.findCrossingBonds().length;
            return !PolymerUtil.isPolymerSgroup(sgroup) && x > 0 && x <= 4;
        }
        return false;
    }
}

