/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.markush.graph.DefaultParameters;
import chemaxon.markush.graph.ExpansionData;
import chemaxon.markush.graph.ExpansionGraphParameters;
import chemaxon.markush.graph.ExpansionGraphUtil;
import chemaxon.markush.graph.StructureNode;
import chemaxon.markush.graph.UnsupportedMarkushException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;

public class ExpansionGraph {
    private ExpansionGraphParameters params = null;
    private Molecule markush = null;
    private RgMolecule standardizedMarkush = null;
    private StructureNode root = null;

    public ExpansionGraph() {
        this(new DefaultParameters());
    }

    public ExpansionGraph(ExpansionGraphParameters params) {
        this.params = params;
    }

    public void setMarkush(Molecule markush) throws UnsupportedMarkushException {
        ExpansionGraphUtil.checkMarkush(markush);
        this.markush = markush;
        Molecule mol = markush.cloneMolecule();
        ExpansionGraphUtil.setAtomIndexProperties(mol, "MARKUSH_ATOM_INDEX");
        RgMolecule rgmol = null;
        if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
            ExpansionGraphUtil.convertAttachmentBonds(rgmol);
            ExpansionGraphUtil.addMissingAttachments(rgmol);
            ExpansionGraphUtil.setIsHAttachmentProperties(rgmol);
        } else {
            rgmol = new RgMolecule();
            rgmol.setRoot(mol);
        }
        ExpansionGraphUtil.setAtomIndexProperties(rgmol, "STANDARDIZED_MARKUSH_ATOM_INDEX");
        this.standardizedMarkush = rgmol;
        this.root = new StructureNode(rgmol.getRoot(), new ExpansionData(rgmol, this.params));
    }

    public Molecule getMarkush() {
        return this.markush;
    }

    public RgMolecule getStandardizedMarkush() {
        return this.standardizedMarkush;
    }

    public StructureNode getRoot() {
        return this.root;
    }
}

