/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.checkers.RgroupAttachmentCountErrorChecker;
import chemaxon.checkers.RgroupOrphanAttachmentErrorChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.BasicCheckerRunner;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.StaticRgMoleculeUtil;
import chemaxon.markush.MarkushDataProvider;
import chemaxon.markush.MarkushFeature;
import chemaxon.markush.graph.UnsupportedMarkushException;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class ExpansionGraphUtil {
    public static boolean isBondList(MolBond bond) {
        switch (bond.getType()) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static void addAttachment(MolAtom atom, MolBond bond, MoleculeGraph part, RgMolecule markush) {
        ExpansionGraphUtil.addAttachment(atom, bond, part, markush, null);
    }

    public static void addAttachment(MolAtom atom, MolBond bond, MoleculeGraph part, RgMolecule markush, MarkushFeature feature) {
        MolAtom refatom = null;
        if (bond.getAtom1() == atom) {
            refatom = bond.getAtom2();
        } else if (bond.getAtom2() == atom) {
            refatom = bond.getAtom1();
        }
        ExpansionGraphUtil.addAttachment(atom, bond, part, markush, feature, refatom);
    }

    public static void addAttachment(MolAtom atom, MolBond bond, MoleculeGraph part, RgMolecule markush, MarkushFeature feature, MolAtom refatom) {
        int count = MolImportUtil.countAttachments(part);
        MolAtom attachment = new MolAtom(138);
        attachment.putProperty("MARKUSH_ATOM_INDEX", -1);
        if (refatom != null) {
            MarkushDataProvider.IsHAtom isH;
            attachment.setXYZ(refatom.getX(), refatom.getY(), refatom.getZ());
            Integer refindex = (Integer)refatom.getProperty("MARKUSH_ATOM_INDEX");
            if (refindex != -1 && (isH = ExpansionGraphUtil.isHAtom(markush.getAtom(refindex), markush)) != MarkushDataProvider.IsHAtom.NO) {
                attachment.putProperty("IS_H", (Object)isH);
            }
        }
        if (feature != null) {
            attachment.putProperty("MARKUSH_FEATURE", feature);
        }
        attachment.setRgroupAttachmentPointOrder(count + 1);
        part.add(attachment);
        MolBond attachBond = bond.cloneBond(atom, attachment);
        part.add(attachBond);
    }

    public static void setFeatureInAttachments(MoleculeGraph m, MarkushFeature feature) {
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            if (m.getAtom(i).getAtno() != 138) continue;
            m.getAtom(i).putProperty("MARKUSH_FEATURE", feature);
        }
    }

    public static void checkMarkush(Molecule mol) throws UnsupportedMarkushException {
        ExpansionGraphUtil.checkCrossingBonds(mol);
        ExpansionGraphUtil.checkMulticenters(mol);
        if (mol instanceof RgMolecule) {
            ExpansionGraphUtil.checkMultipleRAtomLigands((RgMolecule)mol);
            ExpansionGraphUtil.checkRgroups((RgMolecule)mol);
        }
    }

    private static void checkCrossingBonds(Molecule mol) throws UnsupportedMarkushException {
        int type;
        int i;
        for (i = mol.getGraphUnion().getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (!atom.isLinkNode()) continue;
            type = -1;
            for (int j = 0; j < 2; ++j) {
                int idx = atom.getLinkNodeOuterAtom(j);
                if (idx == -1) continue;
                MolBond bond = atom.getBond(idx);
                if (ExpansionGraphUtil.isBondList(bond)) {
                    throw new UnsupportedMarkushException("Link atom with bond list link bond is not supported (atom " + (i + 1) + ").");
                }
                if (type == -1) {
                    type = bond.getType();
                    continue;
                }
                if (type == bond.getType()) continue;
                throw new UnsupportedMarkushException("Link atom with different link bond types is not supported (atom " + (i + 1) + ").");
            }
        }
        for (i = mol.getSgroupCount() - 1; i >= 0; --i) {
            MolBond[] xbonds;
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getType() != 2) continue;
            type = -1;
            for (MolBond xbond : xbonds = sgroup.findCrossingBonds()) {
                if (ExpansionGraphUtil.isBondList(xbond)) {
                    throw new UnsupportedMarkushException("Repeating unit with bond list crossing bond is not supported.");
                }
                if (type == -1) {
                    type = xbond.getType();
                    continue;
                }
                if (type == xbond.getType()) continue;
                throw new UnsupportedMarkushException("Repeating unit with different crossing bond types is not supported.");
            }
        }
    }

    private static void checkMulticenters(Molecule mol) throws UnsupportedMarkushException {
        HashMap multicenterAtoms = new HashMap();
        RgMolecule rgmol = mol instanceof RgMolecule ? (RgMolecule)mol : null;
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            if (mol.getSgroup(i).getType() != 14) continue;
            MulticenterSgroup sgroup = (MulticenterSgroup)mol.getSgroup(i);
            for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = sgroup.getAtom(j);
                for (MolAtom ligand : sgroup.getCentralAtom().getLigands()) {
                    if (multicenterAtoms.containsKey(atom)) {
                        if (((List)multicenterAtoms.get(atom)).contains(ligand)) {
                            throw new UnsupportedMarkushException("Overlapping multicenters are not supported.");
                        }
                        ((List)multicenterAtoms.get(atom)).add(ligand);
                        continue;
                    }
                    multicenterAtoms.put(atom, new ArrayList());
                    ((List)multicenterAtoms.get(atom)).add(ligand);
                }
                if (rgmol != null && atom.getAtno() == 134 && rgmol.findRgroupIndex(atom.getRgroup()) != -1) {
                    throw new UnsupportedMarkushException("R-group within multicenter is not supported.");
                }
                if (!atom.isLinkNode()) continue;
                int idx0 = atom.getLinkNodeOuterAtom(0);
                int idx1 = atom.getLinkNodeOuterAtom(1);
                if ((idx0 == -1 || sgroup.indexOf(atom.getLigand(idx0)) == -1) && (idx1 == -1 || sgroup.indexOf(atom.getLigand(idx1)) == -1)) continue;
                throw new UnsupportedMarkushException("Link atom within multicenter is not supported.");
            }
        }
    }

    private static void checkMultipleRAtomLigands(RgMolecule mol) throws UnsupportedMarkushException {
        Hashtable<Integer, int[]> rid2bondtypes = new Hashtable<Integer, int[]>();
        for (int i = mol.getGraphUnion().getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 134 || mol.findRgroupIndex(atom.getRgroup()) == -1) continue;
            int rid = atom.getRgroup();
            int[] bondtypes = (int[])rid2bondtypes.get(rid);
            if (bondtypes == null) {
                rid2bondtypes.put(rid, ExpansionGraphUtil.getBondTypesInOrder(atom));
                continue;
            }
            if (Arrays.equals(bondtypes, ExpansionGraphUtil.getBondTypesInOrder(atom))) continue;
            throw new UnsupportedMarkushException("Multiple R-atoms: R" + rid + " with different R-ligand bond types are not supported.");
        }
    }

    private static int[] getBondTypesInOrder(MolAtom atom) {
        int[] bondtypes = new int[atom.getBondCount()];
        for (int i = 0; i < bondtypes.length; ++i) {
            MolAtom ligand = atom.getLigand(i);
            MolBond bond = atom.getBond(i);
            bondtypes[atom.getLigandOrder((MolAtom)ligand) - 1] = bond.getType();
        }
        return bondtypes;
    }

    private static void checkRgroups(Molecule mol) throws UnsupportedMarkushException {
        ArrayList<StructureChecker> rgroupCheckers = new ArrayList<StructureChecker>();
        rgroupCheckers.add(new RgroupAttachmentCountErrorChecker());
        rgroupCheckers.add(new RgroupOrphanAttachmentErrorChecker());
        BasicCheckerRunner checkerRunner = new BasicCheckerRunner(rgroupCheckers);
        checkerRunner.setMolecule(mol);
        List<StructureCheckerResult> results = checkerRunner.checkAndWait();
        if (!results.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (StructureCheckerResult result : results) {
                sb.append(result.getDescription());
                sb.append("\n");
            }
            throw new UnsupportedMarkushException(sb.toString().trim());
        }
    }

    public static void setAtomIndexProperties(Molecule mol, String prop) {
        MoleculeGraph union = mol.getGraphUnion();
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom;
            atom.putProperty(prop, (atom = union.getAtom(i)).getAtno() == 138 ? -1 : i);
        }
    }

    public static void convertAttachmentBonds(RgMolecule mol) {
        Molecule root = mol.getRoot();
        MoleculeGraph union = mol.getGraphUnion();
        StaticRgMoleculeUtil srgmu = new StaticRgMoleculeUtil(mol);
        for (int i = union.getBondCount() - 1; i >= 0; --i) {
            MolBond rbond;
            MolBond bond = union.getBond(i);
            if (bond.getParent() == root) continue;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            if (atom1.getAtno() != 138 && atom2.getAtno() != 138 || (rbond = ExpansionGraphUtil.getRBond(mol, bond, union, srgmu)) == null || rbond.getType() == bond.getType()) continue;
            bond.setType(rbond.getType());
        }
    }

    public static void addMissingAttachments(RgMolecule mol) {
        for (int i = mol.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = mol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MolAtom atom;
                MolAtom ratom;
                Molecule m = mol.getRgroupMember(i, j);
                if (m.getAtomCount() != 1 || (ratom = ExpansionGraphUtil.getRAtom(mol, atom = m.getAtom(0))) == null) continue;
                for (int k = ratom.getBondCount() - 1; k >= 0; --k) {
                    MolAtom rligand = ratom.getLigand(k);
                    MolBond rbond = ratom.getBond(k);
                    int order = ratom.getLigandOrder(rligand);
                    int type = rbond.getType();
                    MolAtom attachment = MolImportUtil.addCleanedRgroupAttachmentPoint(atom, order, type);
                    attachment.putProperty("MARKUSH_ATOM_INDEX", -1);
                }
                if (atom.getAtno() != 1 || atom.getMassno() != 0) continue;
                atom.setCharge(0);
            }
        }
    }

    public static void setIsHAttachmentProperties(RgMolecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        int count = union.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() != 134) continue;
            ExpansionGraphUtil.setIsHAttachmentProperties(mol, atom);
        }
    }

    private static void setIsHAttachmentProperties(RgMolecule mol, MolAtom ratom) {
        int i = mol.findRgroupIndex(ratom.getRgroup());
        if (i == -1) {
            return;
        }
        MarkushDataProvider.IsHAtom[] isHStates = new MarkushDataProvider.IsHAtom[ratom.getBondCount()];
        boolean found = false;
        for (int k = 0; k < isHStates.length; ++k) {
            MarkushDataProvider.IsHAtom isH;
            MolAtom ligand = ratom.getLigand(k);
            isHStates[ratom.getLigandOrder((MolAtom)ligand) - 1] = isH = ExpansionGraphUtil.isHAtom(ligand, mol);
            if (isH == MarkushDataProvider.IsHAtom.NO) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        int memberCount = mol.getRgroupMemberCount(i);
        for (int j = 0; j < memberCount; ++j) {
            Molecule m = mol.getRgroupMember(i, j);
            MolAtom[] attachments = MolImportUtil.getAttachments(m);
            for (int k = 0; k < attachments.length; ++k) {
                if (isHStates[k] == MarkushDataProvider.IsHAtom.NO) continue;
                attachments[k].putProperty("IS_H", (Object)isHStates[k]);
            }
        }
    }

    private static MarkushDataProvider.IsHAtom isHAtom(MolAtom atom, RgMolecule mol) {
        switch (atom.getAtno()) {
            case 134: {
                int i = mol.findRgroupIndex(atom.getRgroup());
                if (i == -1) {
                    return MarkushDataProvider.IsHAtom.NO;
                }
                boolean foundNo = false;
                boolean foundYes = false;
                int memberCount = mol.getRgroupMemberCount(i);
                for (int j = 0; j < memberCount; ++j) {
                    Molecule m = mol.getRgroupMember(i, j);
                    if (m.getAtomCount() == 2) {
                        MolAtom atom1 = m.getAtom(0);
                        MolAtom atom2 = m.getAtom(1);
                        MolAtom realAtom = atom1.getAtno() != 138 ? atom1 : atom2;
                        switch (ExpansionGraphUtil.isHAtom(realAtom, mol)) {
                            case NO: {
                                foundNo = true;
                                break;
                            }
                            case YES: {
                                foundYes = true;
                                break;
                            }
                            case MAYBE: {
                                return MarkushDataProvider.IsHAtom.MAYBE;
                            }
                        }
                        continue;
                    }
                    foundNo = true;
                }
                if (foundYes) {
                    return foundNo ? MarkushDataProvider.IsHAtom.MAYBE : MarkushDataProvider.IsHAtom.YES;
                }
                return MarkushDataProvider.IsHAtom.NO;
            }
        }
        return MarkushDataProvider.isHAtom(atom);
    }

    private static MolBond getRBond(RgMolecule mol, MolBond bond, MoleculeGraph union, StaticRgMoleculeUtil srgmu) {
        MolAtom attachment = bond.getAtom1().getAtno() == 138 ? bond.getAtom1() : bond.getAtom2();
        int attachmentIndex = union.indexOf(attachment);
        IntVector parentIndexes = srgmu.getParentIndexes(attachmentIndex);
        if (parentIndexes.size() == 0) {
            return null;
        }
        MolAtom ratom = union.getAtom(parentIndexes.get(0));
        int order = attachment.getRgroupAttachmentPointOrder();
        for (int i = ratom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = ratom.getLigand(i);
            if (ratom.getLigandOrder(ligand) != order) continue;
            return ratom.getBond(i);
        }
        return null;
    }

    private static MolAtom getRAtom(RgMolecule mol, MolAtom atom) {
        int rid = mol.rgroupIdOf(atom);
        if (rid == -1) {
            return null;
        }
        MoleculeGraph union = mol.getGraphUnion();
        int count = union.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom a = union.getAtom(i);
            if (a.getAtno() != 134 || a.getRgroup() != rid) continue;
            return a;
        }
        return null;
    }

    public static MolBond[] getBonds(SelectionMolecule part, MolAtom atom) {
        ArrayList<MolBond> list = new ArrayList<MolBond>();
        int count = part.getBondCount();
        for (int i = 0; i < count; ++i) {
            MolBond bond = part.getBond(i);
            if (bond.getAtom1() != atom && bond.getAtom2() != atom) continue;
            list.add(bond);
        }
        return list.toArray(new MolBond[list.size()]);
    }
}

