/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.markush.MarkushFeature;
import chemaxon.markush.graph.ExpansionData;
import chemaxon.markush.graph.ExpansionGraphUtil;
import chemaxon.markush.graph.MarkushSelectionMolecule;
import chemaxon.markush.graph.Node;
import chemaxon.markush.graph.StructureNode;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;

public class FeatureNode
extends Node {
    private MarkushFeature feature = null;
    private StructureNode[] structureNodes = null;

    FeatureNode(MarkushFeature feature, ExpansionData data, SelectionMolecule part) {
        this.feature = feature;
        this.init(data, part);
    }

    private void init(ExpansionData data, SelectionMolecule part) {
        ArrayList<StructureNode> v = new ArrayList<StructureNode>();
        switch (this.feature.getType()) {
            case 6: {
                int rgindex = this.feature.getData();
                int count = data.markush.getRgroupMemberCount(rgindex);
                for (int i = 0; i < count; ++i) {
                    Molecule structure = data.markush.getRgroupMember(rgindex, i);
                    ExpansionGraphUtil.setFeatureInAttachments(structure, this.feature);
                    v.add(new StructureNode(structure, data));
                }
                break;
            }
            case 1: {
                int[] atnos;
                int index = this.feature.getData();
                MolAtom atom = data.markush.getAtom(index);
                MolBond[] bonds = ExpansionGraphUtil.getBonds(part, atom);
                for (int atno : atnos = atom.getList()) {
                    Molecule structure = new Molecule();
                    MolAtom la = (MolAtom)atom.clone();
                    la.setAtno(atno);
                    structure.add(la);
                    for (int i = 0; i < bonds.length; ++i) {
                        MolBond bond = bonds[i];
                        MolAtom refatom = bond.getOtherAtom(atom);
                        ExpansionGraphUtil.addAttachment(la, bond, structure, data.markush, this.feature, refatom);
                    }
                    v.add(new StructureNode(structure, data));
                }
                break;
            }
            case 4: {
                int d = this.feature.getData();
                int atomCount = data.markush.getGraphUnion().getAtomCount();
                int variableIndex = MarkushFeature.calcVariableAtomIndex(d, atomCount);
                int fixedIndex = MarkushFeature.calcFixedAtomIndex(d, atomCount);
                MolAtom variableAtom = data.markush.getAtom(variableIndex);
                MolAtom fixedAtom = data.markush.getAtom(fixedIndex);
                MolBond bond = variableAtom.getBondTo(fixedAtom);
                MulticenterSgroup sgroup = data.markush.findContainingMulticenterSgroup(variableAtom);
                MarkushSelectionMolecule baseStructure = new MarkushSelectionMolecule();
                MolAtom[] atoms = sgroup.getSgroupGraph().getAtomArray();
                baseStructure.fuse(sgroup.getSgroupGraph());
                for (MolAtom atom : atoms) {
                    MarkushSelectionMolecule structure = new MarkushSelectionMolecule();
                    structure.fuse(baseStructure);
                    FeatureNode.addAttachments(structure, data.markush, this.feature);
                    ExpansionGraphUtil.addAttachment(atom, bond, structure, data.markush, this.feature, fixedAtom);
                    v.add(new StructureNode(structure, data));
                }
                break;
            }
            case 3: {
                MoleculeGraph linkpart = data.feature2part.get(this.feature);
                int index = this.feature.getData();
                MolAtom atom = data.markush.getAtom(index);
                for (int i = 0; i < 2; ++i) {
                    int idx = atom.getLinkNodeOuterAtom(i);
                    if (idx == -1) continue;
                    MolBond bond = atom.getBond(idx);
                    ExpansionGraphUtil.addAttachment(atom, bond, linkpart, data.markush, this.feature);
                }
                v.add(new StructureNode(linkpart, data));
                break;
            }
            case 5: {
                MolBond[] bonds;
                MoleculeGraph reppart = data.feature2part.get(this.feature);
                int index = this.feature.getData();
                Sgroup sgroup = data.markush.getSgroup(index);
                for (MolBond bond : bonds = sgroup.findCrossingBonds()) {
                    MolAtom atom = reppart.contains(bond.getAtom1()) ? bond.getAtom1() : bond.getAtom2();
                    ExpansionGraphUtil.addAttachment(atom, bond, reppart, data.markush, this.feature);
                }
                v.add(new StructureNode(reppart, data));
                break;
            }
        }
        this.structureNodes = v.toArray(new StructureNode[v.size()]);
    }

    private static void addAttachments(MoleculeGraph structure, RgMolecule markush, MarkushFeature feature) {
        for (int i = structure.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = structure.getAtom(i);
            for (int j = atom.getBondCount() - 1; j >= 0; --j) {
                MolAtom ligand = atom.getLigand(j);
                if (structure.contains(ligand)) continue;
                MolBond bond = atom.getBond(j);
                ExpansionGraphUtil.addAttachment(atom, bond, structure, markush, feature);
            }
        }
    }

    public MarkushFeature getFeature() {
        return this.feature;
    }

    public int getStructureNodeCount() {
        return this.structureNodes.length;
    }

    public StructureNode getStructureNode(int i) {
        return this.structureNodes[i];
    }
}

