/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.markush.graph;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.SelectionMolecule;
import java.util.ArrayList;

public class MarkushSelectionMolecule
extends SelectionMolecule {
    private transient int foreign = -1;

    @Override
    public void setBond(int i, MolBond bond) {
        super.setBond(i, bond);
        if (this.foreign != 1) {
            this.updateForeign(bond);
        }
    }

    @Override
    protected void addBond0(MolBond bond) {
        super.addBond0(bond);
        if (this.foreign != 1) {
            this.updateForeign(bond);
        }
    }

    @Override
    protected MolBond[] getBonds(MolAtom atom) {
        MolBond bond;
        int i;
        ArrayList<MolBond> list = new ArrayList<MolBond>();
        int count = atom.getBondCount();
        for (i = 0; i < count; ++i) {
            bond = atom.getBond(i);
            list.add(bond);
        }
        if (this.foreign != 0) {
            for (i = 0; i < this.bondCount; ++i) {
                bond = this.theBonds[i];
                if (this.foreign == -1) {
                    this.updateForeign(bond);
                }
                if (bond.getAtom1() != atom && bond.getAtom2() != atom || list.contains(bond)) continue;
                list.add(bond);
            }
            if (this.foreign == -1) {
                this.foreign = 0;
            }
        }
        return list.toArray(new MolBond[list.size()]);
    }

    @Override
    public Object clone() {
        MarkushSelectionMolecule g = new MarkushSelectionMolecule();
        this.clonecopy(g);
        return g;
    }

    private void updateForeign(MolBond bond) {
        if (bond.getParent() != bond.getAtom1().getParent() || bond.getParent() != bond.getAtom2().getParent()) {
            this.foreign = 1;
        }
    }
}

