/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.marvin.util.Environment;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OSXHelper {
    private static String bundleClassName = "chemaxon.natives.macosx.MacOSXApplicationBundle";
    private static Class bundleClass = null;
    private Object appbundle = null;

    private OSXHelper() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (bundleClass == null) {
            bundleClass = Class.forName(bundleClassName);
            this.appbundle = bundleClass.newInstance();
        }
    }

    public boolean addListener(PropertyChangeListener l) {
        if (this.appbundle != null) {
            try {
                Method m = bundleClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                m.invoke(this.appbundle, l);
                return true;
            }
            catch (NoSuchMethodException nsmex) {
            }
            catch (IllegalAccessException iaex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean removeListener(PropertyChangeListener l) {
        if (bundleClass != null && this.appbundle != null) {
            try {
                Method m = bundleClass.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                m.invoke(this.appbundle, l);
                return true;
            }
            catch (NoSuchMethodException nsmex) {
            }
            catch (IllegalAccessException iaex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public static OSXHelper getNewInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Environment.MACOS) {
            return new OSXHelper();
        }
        throw new InstantiationException("Not Mac OS X platform.");
    }

    public void dispose() {
        this.appbundle = null;
    }
}

