/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.OSXHelper;
import chemaxon.marvin.beans.MSketch;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.beans.MarvinPane;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MenuBarChangeListener;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.MDocument;
import chemaxon.struc.RgMolecule;
import chemaxon.util.SplashScreenUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Sketch
extends JFrame
implements WindowListener,
ActionListener,
PropertyChangeListener,
Serializable {
    private static final ResourceBundle RESOURCES;
    private static Vector sketchWindows;
    private MSketchPane sketchPane;
    private String outSerName;
    private static final String BEGIN_DATA = "<BEGIN_MARVIN_OLE_DATA>";
    private static final String END_DATA = "<END_MARVIN_OLE_DATA>";
    private static final String BEGIN_IMAGE_PATH = "<BEGIN_MARVIN_OLE_IMAGE_PATH>";
    private static final String END_IMAGE_PATH = "<END_MARVIN_OLE_IMAGE_PATH>";
    private static boolean isOleMode;
    private final Action newWindowAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Sketch w = new Sketch(null, Sketch.this.sketchPane.getUserSettings(), Sketch.this.sketchPane.isExperimentalEnabled());
            SwingUtilities.invokeLater(new ShowWindow(w));
        }
    };
    private final Action exitAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Sketch w;
            int i;
            for (i = sketchWindows.size() - 1; i >= 0; --i) {
                w = (Sketch)sketchWindows.elementAt(i);
                if (!w.sketchPane.isExitCanceled()) continue;
                return;
            }
            for (i = sketchWindows.size() - 1; i >= 0; --i) {
                w = (Sketch)sketchWindows.elementAt(i);
                w.close();
            }
        }
    };
    private static AppEventHandler aeh;
    private static String fileWaittingForDisplay;

    private Sketch(String inSerName, UserSettings settings, boolean devel) {
        this.initActions();
        sketchWindows.addElement(this);
        this.setTitle("MarvinSketch " + VersionInfo.MARVIN_VERSION);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        if (inSerName != null) {
            this.sketchPane = this.loadBeanState(inSerName);
            if (this.sketchPane == null) {
                System.exit(1);
            }
        } else {
            Environment.setSkinEnabled(true);
            this.sketchPane = new MSketchPane(settings);
            this.sketchPane.setExperimentalEnabled(devel);
            if (isOleMode) {
                this.sketchPane.setConfirmExit(false);
            }
            this.sketchPane.setSaveIniEnabled(!isOleMode);
        }
        this.addKeyListener(this.sketchPane);
        this.setContentPane(this.sketchPane);
        this.sketchPane.addActionListener(this);
        this.sketchPane.addPropertyChangeListener(this);
        if (inSerName == null) {
            JMenuBar menubar = this.sketchPane.getJMenuBar();
            this.customizeMenuBar(menubar);
            this.sketchPane.setJMenuBar(null);
            this.setJMenuBar(menubar);
        }
        this.sketchPane.addMenuBarChangeListener(new MenuBarChangeListener(){

            @Override
            public void menuBarChanged(JMenuBar menubar) {
                Sketch.this.customizeMenuBar(menubar);
                Sketch.this.setJMenuBar(menubar);
                Sketch.this.validate();
            }
        });
        URL u = this.getClass().getResource("/chemaxon/icons/marvin/msketch24.png");
        Image img = new ImageIcon(u).getImage();
        this.setIconImage(img);
    }

    private void customizeMenuBar(JMenuBar menubar) {
        JMenuItem mi;
        if (menubar == null || menubar.getMenuCount() == 0) {
            return;
        }
        boolean ismac = System.getProperty("os.name").indexOf("Mac") >= 0;
        String jver = System.getProperty("java.version");
        String macmenu = System.getProperty(jver.startsWith("1.3") ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar");
        JMenu filemenu = menubar.getMenu(0);
        filemenu.setSelected(true);
        filemenu.setSelected(false);
        boolean hasExit = false;
        for (int j = 0; j < filemenu.getItemCount(); ++j) {
            mi = filemenu.getItem(j);
            if (mi == null) continue;
            String cmd = mi.getActionCommand();
            if (cmd.equals("new")) {
                filemenu.remove(j);
                JMenu newMenu = SwingUtil.createMenu(RESOURCES, "new");
                filemenu.insert(newMenu, j);
                newMenu.add(mi);
                SwingUtil.initButton(mi, RESOURCES, "clearDesk");
                newMenu.add(new JMenuItem(this.newWindowAction));
                continue;
            }
            if (!cmd.equals("exit")) continue;
            hasExit = true;
        }
        if (!(hasExit || ismac && macmenu != null && macmenu.equals("true"))) {
            filemenu.addSeparator();
            mi = new JMenuItem(this.exitAction);
            filemenu.add(mi);
            mi.setActionCommand("exit");
        }
    }

    private void initActions() {
        SwingUtil.initAction(this.exitAction, RESOURCES, "exit", SwingUtil.getCommandKeyStroke(81));
        SwingUtil.initAction(this.newWindowAction, RESOURCES, "newWindow", SwingUtil.getCommandKeyStroke(78));
    }

    private static void openFile(String filename) {
        if (sketchWindows.size() == 1) {
            Sketch w = (Sketch)sketchWindows.get(0);
            if (w.sketchPane.getMol().isEmpty()) {
                w.sketchPane.setMol(filename);
            } else {
                Sketch.openFileInNewWindow(filename);
            }
        } else if (sketchWindows.size() == 0) {
            fileWaittingForDisplay = filename;
        } else {
            Sketch.openFileInNewWindow(filename);
        }
    }

    private static void openFileInNewWindow(String filename) {
        int x = sketchWindows.size() - 1;
        Sketch pw = (Sketch)sketchWindows.get(x);
        Sketch w = new Sketch(null, pw.sketchPane.getUserSettings(), pw.sketchPane.isExperimentalEnabled());
        SwingUtilities.invokeLater(new ShowWindow(w));
        w.sketchPane.setMol(new File(filename), null);
    }

    private static void closeAll() {
        while (sketchWindows.size() > 0) {
            Sketch w = (Sketch)sketchWindows.get(0);
            if (!w.close()) {
                return;
            }
            if (sketchWindows.indexOf(w) <= -1) continue;
            sketchWindows.remove(w);
        }
    }

    private boolean close() {
        if (this.sketchPane.isExitCanceled()) {
            return false;
        }
        if (isOleMode && this.sketchPane.isLoadedMolModified()) {
            int r = 0;
            r = JOptionPane.showConfirmDialog(this, "Would you like to update the Marvin OLE object?", "Update Marvin OLE", 0, 3);
            if (r == 0) {
                System.out.print(BEGIN_DATA + this.sketchPane.getMol("mrv") + END_DATA);
                try {
                    File tempfile = this.createImageTempFile();
                    System.out.print(BEGIN_IMAGE_PATH + tempfile.getCanonicalPath() + END_IMAGE_PATH);
                }
                catch (Exception e) {
                    System.err.println("Cannot create temporary file");
                }
            }
        }
        this.sketchPane.exit();
        this.setVisible(false);
        this.dispose();
        sketchWindows.remove(this);
        if (sketchWindows.size() == 0) {
            boolean success = true;
            if (this.outSerName != null) {
                this.sketchPane.removeActionListener(this);
                this.sketchPane.removePropertyChangeListener(this);
                success = this.saveBeanState(this.outSerName);
            }
            if (aeh != null) {
                aeh.dispose();
            }
            System.exit(success ? 0 : 1);
        }
        return true;
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.close();
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd != null && cmd.equals("close")) {
            this.close();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        if (name.equals("file")) {
            File f = (File)ev.getNewValue();
            if (f != null) {
                if (!isOleMode) {
                    this.setTitle(f.getName() + " - MarvinSketch " + VersionInfo.MARVIN_VERSION);
                } else {
                    this.setTitle("MarvinSketch " + VersionInfo.MARVIN_VERSION);
                }
            } else {
                this.setTitle("MarvinSketch " + VersionInfo.MARVIN_VERSION);
            }
        }
    }

    private boolean saveBeanState(String fname) {
        try {
            FileOutputStream out = new FileOutputStream(fname);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            JMenuBar menubar = this.getJMenuBar();
            this.sketchPane.setJMenuBar(menubar);
            this.setJMenuBar(null);
            oos.writeObject(new MSketch(this.sketchPane));
            this.setJMenuBar(menubar);
            this.sketchPane.setJMenuBar(null);
            out.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private MSketchPane loadBeanState(String fname) {
        try {
            MSketchPane newPane;
            FileInputStream in = new FileInputStream(fname);
            ObjectInputStream ois = new ObjectInputStream(in);
            Object o = ois.readObject();
            if (o instanceof MSketch) {
                newPane = ((MSketch)o).getMSketchPane();
            } else if (o instanceof MSketchPane) {
                newPane = (MSketchPane)o;
            } else {
                System.err.println("Cannot deserialize " + o);
                return null;
            }
            this.setJMenuBar(newPane.getJMenuBar());
            newPane.setJMenuBar(null);
            in.close();
            return newPane;
        }
        catch (FileNotFoundException ex) {
            System.err.println(fname + " not found");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String splashScreenPath = System.getProperty("splash");
        SplashScreenUtils.showSplashScreen(splashScreenPath != null && splashScreenPath.contains("-red") ? SplashScreenUtils.Product.MarvinSketch_NET : SplashScreenUtils.Product.MarvinSketch, Sketch.class.getResource(splashScreenPath == null ? "beans/splash/sketch-splash-blue.jpg" : splashScreenPath));
        Vector<String> molstrs = new Vector<String>();
        int debug = 0;
        boolean devel = false;
        String inSerName = null;
        String outSerName = null;
        String stdinOpts = null;
        String strhelp = "MarvinSketch " + MSketchPane.VERSION + ", (C) 2000-2012 ChemAxon Ltd.\n" + "Licenses of additionally used third party programs can be found in license.html\n" + "Online version: http://www.chemaxon.com/marvin/license.html \n" + "Usage: msketch [options] [files or URLs...]\n" + "Options:\n" + "-h  --help     this help message\n" + "-              import a structure from standard input\n" + "--debug        debug mode\n" + "--serialize    write state into the file MarvinSketch.ser at exit\n" + "--deserialize  read state from the file MarvinSketch.ser at start";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.equals("--help")) {
                    System.out.println(strhelp);
                    return;
                }
                if (arg.equals("--debug")) {
                    ++debug;
                    continue;
                }
                if (arg.equals("--serialize")) {
                    outSerName = "MarvinSketch.ser";
                    continue;
                }
                if (arg.equals("--deserialize")) {
                    inSerName = "MarvinSketch.ser";
                    continue;
                }
                if (arg.equals("--devel")) {
                    devel = true;
                    continue;
                }
                if (arg.equals("--desktoplauncher")) continue;
                if (arg.equals("--olemode")) {
                    isOleMode = true;
                    continue;
                }
                System.err.println("WARNING: Unknown option " + args[i]);
                continue;
            }
            if (arg.equals("-")) {
                molstrs.addElement("-");
                continue;
            }
            if (arg.startsWith("-(") && arg.endsWith(")") || arg.startsWith("-{") && arg.endsWith("}")) {
                molstrs.addElement("-");
                stdinOpts = arg.substring(2, arg.length() - 1);
                continue;
            }
            if (arg.startsWith("-")) {
                for (int j = 1; j < arg.length(); ++j) {
                    char c = arg.charAt(j);
                    switch (c) {
                        case 'h': {
                            System.out.println(strhelp);
                            return;
                        }
                    }
                    System.err.println("WARNING: Unknown option -" + c);
                }
                continue;
            }
            molstrs.addElement(arg);
        }
        if (fileWaittingForDisplay != null) {
            molstrs.addElement(fileWaittingForDisplay);
            fileWaittingForDisplay = null;
        }
        if (molstrs.size() == 0) {
            molstrs.addElement("");
        }
        UserSettings settings = new UserSettings();
        for (int i = 0; i < molstrs.size(); ++i) {
            String s = (String)molstrs.elementAt(i);
            Sketch w = new Sketch(inSerName, settings, devel);
            if (debug > 0) {
                w.sketchPane.setDebug(debug);
            }
            w.outSerName = outSerName;
            SwingUtilities.invokeLater(new ShowWindow(w));
            boolean isdir = false;
            if (s.equals("-")) {
                MolImporter mi = null;
                try {
                    w.sketchPane.beginHourglass();
                    mi = new MolImporter(System.in, stdinOpts);
                    RgMolecule m = new RgMolecule();
                    MDocument doc = mi.readDoc(null, m);
                    if (m.getDim() < 2) {
                        m.clean(2, null);
                    }
                    w.sketchPane.setDocument(doc);
                }
                catch (IOException ioe) {
                    w.sketchPane.showErrorDialog("Read error on the standard input:\n" + ioe.getMessage(), ioe);
                }
                finally {
                    if (mi != null) {
                        try {
                            mi.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    w.sketchPane.endHourglass();
                }
            } else if (s.length() != 0) {
                File f = new File(s);
                if (f.isDirectory()) {
                    isdir = true;
                    w.sketchPane.setDirectory(f);
                } else if (f.isFile()) {
                    w.sketchPane.setMol(f, null);
                } else {
                    w.sketchPane.setMol(s);
                }
            }
            if (!isdir) continue;
            w.sketchPane.showFileOpenDialog();
        }
        MarvinSplashScreen.disposeSplash();
    }

    private File createImageTempFile() throws IOException, MolFormatException, MolExportException, FileNotFoundException {
        File tempfile = File.createTempFile("ole", "emf");
        FileOutputStream outputStream = new FileOutputStream(tempfile);
        MolExporter exporter = new MolExporter(outputStream, "emf");
        exporter.write(MolImporter.importMol(this.sketchPane.getMol("mrv")));
        exporter.close();
        outputStream.close();
        return tempfile;
    }

    static {
        sketchWindows = new Vector();
        isOleMode = false;
        aeh = null;
        String jver = System.getProperty("java.version");
        System.setProperty(jver.startsWith("1.3") ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar", "true");
        ResourceBundle rc = null;
        try {
            rc = MarvinPane.getResourceBundle(Sketch.class.getName());
        }
        catch (MissingResourceException ex) {
            System.err.println("Sketch.properties not found");
            System.exit(1);
        }
        RESOURCES = rc;
        aeh = AppEventHandler.getDefaultAppEventHandler();
        Environment.installPlasticLookAndFeel(false);
        fileWaittingForDisplay = null;
    }

    private static class AppEventHandler
    implements PropertyChangeListener {
        private OSXHelper helper;

        public static AppEventHandler getDefaultAppEventHandler() {
            if (Environment.MACOS) {
                try {
                    OSXHelper h = OSXHelper.getNewInstance();
                    return new AppEventHandler(h);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
            return null;
        }

        private AppEventHandler(OSXHelper helper) {
            this.helper = helper;
            if (helper != null) {
                helper.addListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if (name.equals("apple.OpenFile")) {
                Sketch.openFile((String)ev.getNewValue());
            } else if (name.equals("apple.Quit")) {
                Sketch.closeAll();
            }
        }

        public void dispose() {
            if (this.helper != null) {
                this.helper.removeListener(this);
            }
        }
    }

    private static class ShowWindow
    implements Runnable {
        private JFrame win;

        ShowWindow(JFrame w) {
            this.win = w;
        }

        @Override
        public void run() {
            this.win.pack();
            this.win.setLocationRelativeTo(null);
            this.win.setVisible(true);
        }
    }
}

