/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin;

import chemaxon.calculations.pka.PKaTraining;
import chemaxon.calculations.training.AtomicContributionBasedTrainer;
import chemaxon.calculations.training.TrainerFactory;
import chemaxon.calculations.training.logp.LogPTrainer;
import chemaxon.calculations.training.logp.LogPTrainerFactory;
import chemaxon.formats.MolFileHandler;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.calculations.PredictorPlugin;
import chemaxon.marvin.calculations.logPPlugin;
import chemaxon.marvin.calculations.pKaPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.logging.CustomFormatter;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Trainer {
    public static final String BASE_PARAMETER_FOLDER_NAME = "calculations/training/";
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = lineSep + "Molecular Property Prediction Trainer, (C) 1998-2012 ChemAxon Ltd." + lineSep + "version " + VersionInfo.MARVIN_VERSION + lineSep + "Trains molecular property predictions: pKa, logP, etc." + lineSep + lineSep + "Usage:" + lineSep + "  cxtrain <prediction> [options] [input file (training set)]" + lineSep + "" + lineSep + "" + "Prediction: " + lineSep + "  pka                              train pKa prediction" + lineSep + "  logp                             train logP prediction" + lineSep + "  prediction                       train custom prediction" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  cxtrain -h, --help               this help message" + lineSep + "  -i, --training-id <training ID>  sets the training ID" + lineSep + "  -l, --list                       list available training ID's" + lineSep + "  -g, --ignore-error               continue with next molecule on error" + lineSep + "" + lineSep + "" + "pKa options: " + lineSep + "  -V, --validation <filepath>      validation results file path" + lineSep + "" + lineSep + "" + "logP options: " + lineSep + "  -t, --tag <tag name>             name of the SDFile tag that stores the" + lineSep + "                                   experimental logP values" + lineSep + "  -a, --add-built-in-training-set  add built-in logP training set" + lineSep + "" + lineSep + "" + "Custom prediction options: " + lineSep + "  -t, --tag <tag name>             name of the SDFile tag that stores the" + lineSep + "                                   experimental property values" + lineSep;
    private static final String examplestext = lineSep + "Examples:" + lineSep + "  cxtrain pka -i mypka pKa_trainingset.sdf" + lineSep + "  cxtrain logp -t LOGP -i mylogp -a logP_trainingset.sdf" + lineSep + "  cxtrain logp --list" + lineSep + "  cxtrain prediction -t PAMPA -i mypampa pampa_trainingset.sdf" + lineSep;
    private static final Logger logger = Logger.getLogger(Trainer.class.getName());
    private static final String[] PREDICTIONS = new String[]{"pka", "logp", "prediction"};

    private static void initLogger(Logger logger) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new CustomFormatter());
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
    }

    private static void printIds(String[] ids) {
        for (String id : ids) {
            System.out.println(id);
        }
    }

    public static void main(String[] args) throws Exception {
        String trainingId;
        boolean listIds;
        String prediction;
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext + examplestext);
            return;
        }
        CLQ.Parameter pPrediction = clq.lookup(0, 1, "", true, false);
        String string = prediction = pPrediction != null ? pPrediction.name().toLowerCase() : null;
        if (!Arrays.asList(PREDICTIONS).contains(prediction)) {
            System.err.println("Prediction has to be one of the following: pka, logp, prediction.");
            return;
        }
        String[] argsAfterPrediction = new String[args.length - 1];
        System.arraycopy(args, 1, argsAfterPrediction, 0, args.length - 1);
        clq = new CLQ(argsAfterPrediction, null);
        boolean bl = listIds = clq.lookup("-l", "--list", "", 1, false, false) != null;
        if (listIds) {
            if (prediction.equalsIgnoreCase("pka")) {
                Trainer.printIds(pKaPlugin.getCorrectionLibraryIds());
            } else if (prediction.equalsIgnoreCase("logp")) {
                Trainer.printIds(logPPlugin.getTrainingIds());
            } else {
                Trainer.printIds(PredictorPlugin.getTrainingIds());
            }
            return;
        }
        boolean ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        CLQ.Parameter pTrainingId = clq.lookup("-i", "--training-id", "", 2, false, false);
        if (pTrainingId == null) {
            pTrainingId = clq.lookup("-I", "--trainingid", "", 2, false, false);
        }
        String string2 = trainingId = pTrainingId != null ? pTrainingId.getString() : null;
        if (trainingId == null) {
            System.err.println("Training ID is missing. Use the --training-id option to specify the training ID.");
            return;
        }
        CLQ.Parameter pValidationFilePath = clq.lookup("-V", "--validation", "", 2, false, false);
        String validationFilePath = pValidationFilePath != null ? pValidationFilePath.getString() : null;
        CLQ.Parameter pTag = clq.lookup("-t", "--tag", "", 2, false, false);
        String tag = pTag != null ? pTag.getString() : null;
        boolean addBuiltInTrainingSet = clq.lookup("-a", "--add-built-in-training-set", "", 1, false, false) != null;
        MolImporter importer = null;
        String input = null;
        input = clq.notUsed();
        importer = input != null ? new MolImporter(input) : new MolImporter(System.in);
        Trainer.initLogger(logger);
        if (prediction.equalsIgnoreCase("pka")) {
            if (importer != null) {
                PKaTraining.calculatepKaIncrements(importer, trainingId, validationFilePath);
            }
        } else if (prediction.equalsIgnoreCase("logp")) {
            if (importer != null) {
                if (tag == null) {
                    String filename = importer.getFileName();
                    Vector fields = new Vector();
                    if (filename != null) {
                        MolFileHandler.collectFileInfo(new FileInputStream(filename), 1, fields);
                    }
                    if (fields.contains("LOGP")) {
                        tag = "LOGP";
                    } else if (fields.contains("FIELD_0")) {
                        tag = "FIELD_0";
                    }
                    if (tag != null) {
                        System.err.println("No SDFile tag specified, reading logP values from field: " + tag);
                    } else {
                        System.err.println("Error: no SDFile tag specified. Use the --tag option to specify the name of the field which contains the logP values.");
                        return;
                    }
                }
                CLQ.Parameter pHValue = clq.lookup("-H", "--pH", "", false, false);
                LogPTrainer trainer = LogPTrainerFactory.createLogPTrainer();
                if (pHValue != null) {
                    trainer.setPH(pHValue.getDouble());
                }
                if (addBuiltInTrainingSet && !trainer.addPrimerData()) {
                    throw new PluginException("Failed to add built-in logP training set.");
                }
                Molecule mol = null;
                int counter = 0;
                while ((mol = importer.read()) != null) {
                    ++counter;
                    try {
                        trainer.add(mol, tag);
                    }
                    catch (Exception e) {
                        if (!ignoreError) {
                            logger.log(Level.WARNING, "Invalid property at molecule " + counter + ": \"" + mol.getProperty(tag) + "\".");
                            throw e;
                        }
                        logger.log(Level.WARNING, "Ignored invalid property at molecule " + counter + ": \"" + mol.getProperty(tag) + "\".");
                    }
                }
                trainer.saveResults(trainingId);
            }
        } else {
            AtomicContributionBasedTrainer trainer = TrainerFactory.createAtomicContributionBasedTrainer();
            if (importer != null && tag != null) {
                Molecule mol = null;
                int counter = 0;
                while ((mol = importer.read()) != null) {
                    ++counter;
                    try {
                        trainer.add(mol, tag);
                    }
                    catch (IllegalArgumentException e) {
                        if (!ignoreError) {
                            logger.log(Level.WARNING, "Invalid property at molecule " + counter + ": \"" + mol.getProperty(tag) + "\".");
                            throw e;
                        }
                        logger.log(Level.WARNING, "Ignored invalid property at molecule " + counter + ": \"" + mol.getProperty(tag) + "\".");
                    }
                }
                trainer.saveResults("general", trainingId);
            } else if (tag == null) {
                System.err.println("Error: no SDFile tag specified. Use the --tag option to specify the name of the field which contains the measured molecular property values.");
            }
        }
    }
}

