/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentBase;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionTwoMolsQuatFit;
import chemaxon.marvin.alignment.NoConstraintException;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.QuaternionAlign;
import chemaxon.struc.Molecule;

public class AlignOnPairedAtoms
extends AlignmentBase {
    private QuaternionAlign q;

    public AlignOnPairedAtoms() {
        this.setProperty(AlignmentProperties.PAIRED);
        this.factory.setNodeType(AlignmentProperties.NodeType.SIMPLE);
        this.q = new QuaternionAlign();
    }

    public void removeMolecules() {
        this.removeAllMolecules();
    }

    public void setReferenceMolecule(Molecule m, boolean flexible) throws AlignmentException {
        this.removeAllMolecules();
        this.addMolecule(m, flexible, flexible);
    }

    public void setMoleculeToAlign(Molecule m, boolean flexible) throws AlignmentException {
        if (this.molecules.size() == 0) {
            throw new AlignmentException("Set the reference molecule first.");
        }
        if (this.molecules.size() > 2) {
            throw new IllegalStateException();
        }
        AlignmentMolecule ref = (AlignmentMolecule)this.molecules.get(0);
        this.removeMolecules();
        this.addMol(ref);
        this.addMolecule(m, flexible, false);
    }

    public double[][] getCoordinatesOfReference() {
        return this.getAlignmentMolecule(0).getMolCrd();
    }

    public double[][] getCoordinatesOfAligned() {
        return this.getAlignmentMolecule(1).getMolCrd();
    }

    public Molecule getReferenceWithNewCoordinates() {
        return this.getMoleculeWithAlignedCoordinates(0);
    }

    public Molecule getAlignedWithNewCoordinates() {
        return this.getMoleculeWithAlignedCoordinates(1);
    }

    public void addAtomPair(int atom0, int atom1, double weight) throws AlignmentException {
        this.addAlignmentConstraint(0, atom0, 1, atom1, weight, 0.0, PotentialType.QUADRATIC, 2);
    }

    public void addAtomPair(int atom0, int atom1) throws AlignmentException {
        this.addAtomPair(atom0, atom1, 1.0);
    }

    public void findFirst() throws AlignmentException {
        FlexibleMolecule f;
        this.checkLicense();
        if (this.alignmentC.isEmpty()) {
            throw new NoConstraintException();
        }
        if (this.molecules.size() != 2) {
            throw new AlignmentException("2 molecules are reqested to align.");
        }
        if (!((AlignmentMolecule)this.molecules.get(0)).isRigidMol()) {
            f = (FlexibleMolecule)this.molecules.get(0);
            f.setRigidPath(false);
            f.calcRigidPath(this.alignmentC);
        }
        if (!((AlignmentMolecule)this.molecules.get(1)).isRigidMol()) {
            f = (FlexibleMolecule)this.molecules.get(1);
            f.setRigidPath(false);
            f.calcRigidPath(this.alignmentC);
        }
        if (((AlignmentMolecule)this.molecules.get(0)).isRigid() && ((AlignmentMolecule)this.molecules.get(1)).isRigid()) {
            if (this.vis != null) {
                this.vis.init(this.molecules, this.alignmentC);
                this.vis.showSteps();
            }
            this.q.align(this.alignmentC, (AlignmentMolecule)this.molecules.get(1));
            if (this.vis != null) {
                this.vis.showSteps();
                this.vis.showSteps();
            }
        } else {
            if (this.vis != null) {
                this.vis.init(this.molecules, this.alignmentC);
            }
            this.function = new FunctionTwoMolsQuatFit((AlignmentMolecule)this.molecules.get(0), (AlignmentMolecule)this.molecules.get(1), this.alignmentC, this.getStepLimit(), this.getTimeLimit());
            this.function.update();
            this.function.getVariables();
            if (this.vis != null) {
                this.function.setVis(this.vis);
                this.vis.showSteps();
            }
            this.optimization();
        }
    }

    public void findNext() throws AlignmentException {
        this.checkLicense();
        if (((AlignmentMolecule)this.molecules.get(0)).isRigid() && ((AlignmentMolecule)this.molecules.get(0)).isRigid()) {
            return;
        }
        this.randomizeDihedrals();
        this.optimization();
    }

    public double getRmsd() {
        return this.calcRMSD();
    }

    public void removeAllPairs() {
        this.removeAllConstraints();
    }
}

