/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentAccuracyMode;
import chemaxon.marvin.alignment.AlignmentBase;
import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionMoreMols;
import chemaxon.marvin.alignment.FunctionOneFlexibleMol;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.NoConstraintException;
import chemaxon.marvin.alignment.Orientation;
import chemaxon.marvin.alignment.OrientationByMCS;
import chemaxon.marvin.alignment.OrientationSimple;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.Status;
import chemaxon.marvin.alignment.TooDissimilarException;
import chemaxon.marvin.alignment.VolumeOverlap;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class Alignment
extends AlignmentBase {
    static int STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR = 1500;
    public static double USER_WEIGHT = 50.0;
    static boolean DEBUG = false;
    static boolean debugPrint = false;
    private int minimumCommonSize = 6;
    private Status best = null;
    private int conformerCount = 1;
    private int orientationCount = 0;
    private AlignmentProperties.OrientationType orientationType;
    private int pos = 0;
    private boolean visDetailed = true;
    private AlignmentAccuracyMode mode = AlignmentAccuracyMode.NORMAL;
    private boolean canSelectedMode = false;
    private int selectedCountLimit = 4;
    private int alignAndSaveTheBestCount = 0;
    private boolean runMode = true;

    public Alignment() {
        this(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE);
    }

    public Alignment(AlignmentProperties props) {
        this.setProperty(props);
    }

    @Override
    public Molecule getMoleculeWithAlignedCoordinates(int molID) {
        return super.getMoleculeWithAlignedCoordinates(molID);
    }

    public void setMode(AlignmentAccuracyMode mode) {
        this.mode = mode;
    }

    @Override
    public Molecule getAlignedMoleculesAsFragments() {
        return super.getAlignedMoleculesAsFragments();
    }

    public AlignmentProperties.OrientationType getOrientationType() {
        return this.orientationType;
    }

    @Override
    public final void setProperty(AlignmentProperties props) {
        super.setProperty(props);
        this.orientationType = props.getOrientation();
    }

    public void setConformerCount(int conformerCount) {
        this.conformerCount = conformerCount;
    }

    public static Molecule randomizeRotatableDihedrals(Molecule m) {
        try {
            AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
            amf.setAromatize(true);
            amf.setDehidrogenize(false);
            amf.setColor(AlignmentProperties.ColoringScheme.SAME);
            amf.setNodeType(AlignmentProperties.NodeType.SIMPLE);
            AlignmentMolecule a = amf.generate(0, m, false, true);
            if (a.isRigidMol()) {
                return m;
            }
            FlexibleMolecule f = (FlexibleMolecule)a;
            f.randomizeDihedrals();
            FunctionOneFlexibleMol ff = new FunctionOneFlexibleMol(f, -1, -1, 0);
            GradientOptimization gr = new GradientOptimization(ff);
            gr.setVerboseLevel(2);
            gr.run();
            if (!gr.isOptimizationConverged()) {
                throw new AlignmentException("Optimization was not converged.");
            }
            return f.getAlignedMolecule();
        }
        catch (Exception a) {
            a.printStackTrace();
            throw new UnsupportedOperationException(a);
        }
    }

    void disableGaussFor(AlignmentConstraint e, int start) {
        for (int j = start; j < this.alignmentC.size(); ++j) {
            AlignmentConstraint e2 = (AlignmentConstraint)this.alignmentC.get(j);
            if ((e2.getStatus() != 3 || !e2.getNode1().equals(e.getNode1()) || !e2.getNode2().equals(e.getNode2())) && (!e2.getNode1().equals(e.getNode2()) || !e2.getNode2().equals(e.getNode1()))) continue;
            if (e2.getPotentialType() == PotentialType.QUADRATIC) {
                System.err.println(j + " " + e2);
                throw new UnsupportedOperationException("dont disable quadratic");
            }
            e2.setStatus(4);
        }
    }

    public void setColoringScheme(AlignmentProperties.ColoringScheme c) {
        this.factory.setColor(c);
    }

    public void addNodeColorWeight(int t1, int t2, double w) {
        this.factory.getColor().addWeight(t1, t2, w);
    }

    public void setDefaultNodeWeightBehavior(AlignmentProperties.ColorNotSpecifiedCase n) {
        this.factory.getColor().setNotSpec(n);
    }

    public void setOrientationType(AlignmentProperties.OrientationType orientationType) {
        this.orientationType = orientationType;
        if (orientationType == AlignmentProperties.OrientationType.SIMPLE) {
            this.factory.setShape(AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER);
        }
    }

    @Override
    public void removeAllConstraints() {
        super.removeAllConstraints();
        this.best = null;
    }

    @Override
    public void removeAllMolecules() {
        super.removeAllMolecules();
        this.best = null;
    }

    @Override
    public void addMolecule(Molecule m, boolean flexible, boolean enableTranslateAndRotate) throws AlignmentException {
        this.best = null;
        super.addMolecule(m, flexible, enableTranslateAndRotate);
    }

    public void addUserConstraint(int molSeq0, int atomSeq0, int molSeq1, int atomSeq1) throws AlignmentException {
        this.addAlignmentConstraint(molSeq0, atomSeq0, molSeq1, atomSeq1, USER_WEIGHT, 1.0, PotentialType.QUADRATIC, 2);
        AlignmentMolecule am0 = (AlignmentMolecule)this.molecules.get(molSeq0);
        AlignmentMolecule am1 = (AlignmentMolecule)this.molecules.get(molSeq1);
        am0.setAssigned(atomSeq0, true);
        am1.setAssigned(atomSeq1, true);
        this.best = null;
    }

    private Orientation orientationGenerator(AlignmentMolecule am1o, AlignmentMolecule am2o) throws AlignmentException {
        Orientation o = null;
        if (!am1o.isEnableTranslateAndRotate() && !am2o.isEnableTranslateAndRotate()) {
            return o;
        }
        AlignmentMolecule am1 = am1o;
        AlignmentMolecule am2 = am2o;
        if (!am1o.isEnableTranslateAndRotate() && am2o.isEnableTranslateAndRotate()) {
            am1 = am2o;
            am2 = am1o;
        }
        if (this.orientationType == AlignmentProperties.OrientationType.MCS) {
            o = new OrientationByMCS(am1, am2, this.minimumCommonSize);
        }
        if (this.orientationType == AlignmentProperties.OrientationType.SIMPLE) {
            o = new OrientationSimple(am1, am2);
        }
        return o;
    }

    private void update(AlignmentMolecule am) {
        am.updateIterator();
        if (this.mode.getMode() == VolumeOverlap.MODE.SELECTED) {
            am.updateRingCenters();
        }
        if (this.mode.getMode() == VolumeOverlap.MODE.FULL) {
            am.updateGaussianProducts();
        }
        if (!am.isRigid()) {
            FlexibleMolecule fm = (FlexibleMolecule)am;
            fm.updateConstraints();
            fm.updateDihedrals();
            fm.resetProximities();
        }
    }

    public double tanimoto() throws AlignmentException {
        if (this.molecules.size() != 2) {
            return -1.0;
        }
        if (this.function == null) {
            this.createFunction();
        }
        FunctionMoreMols f = (FunctionMoreMols)this.function;
        f.setMode(this.mode.getMode());
        VolumeOverlap o12 = f.overlaps[0];
        o12.enableAll();
        f.update();
        VolumeOverlap o11 = new VolumeOverlap((AlignmentMolecule)this.molecules.get(0), (AlignmentMolecule)this.molecules.get(0));
        VolumeOverlap o22 = new VolumeOverlap((AlignmentMolecule)this.molecules.get(1), (AlignmentMolecule)this.molecules.get(1));
        o11.setMode(this.mode.getMode());
        o22.setMode(this.mode.getMode());
        o11.update();
        o22.update();
        double x = o12.getWeightedOverlap();
        double denom1 = o11.getWeightedOverlap();
        double denom2 = o22.getWeightedOverlap();
        return x / (denom1 + denom2 - x);
    }

    public Status getStatus() {
        return this.best;
    }

    private boolean next(Orientation[] o) throws AlignmentException {
        this.removeConstraintsAddedByThisOrientation(o[this.pos]);
        if (o[this.pos].nextOrientation()) {
            this.addConstraintsOfThisOrientation(o[this.pos]);
            return true;
        }
        if (this.pos == o.length - 1) {
            return false;
        }
        o[this.pos].reset();
        if (!o[this.pos].nextOrientation()) {
            throw new AlignmentException("bug");
        }
        this.addConstraintsOfThisOrientation(o[this.pos]);
        ++this.pos;
        return this.next(o);
    }

    private void addConstraintsOfThisOrientation(Orientation o) throws AlignmentException {
        if (!o.areConstraintsAddable()) {
            return;
        }
        FunctionMoreMols f = (FunctionMoreMols)this.function;
        f.disableVolumeForConstraints(o);
        for (AlignmentConstraint aco : o.getConstr()) {
            aco.setStatus(1);
            this.alignmentC.add(aco);
        }
    }

    private void removeConstraintsAddedByThisOrientation(Orientation o) {
        if (!o.areConstraintsAddable()) {
            return;
        }
        int count = 0;
        while (count < this.alignmentC.size()) {
            AlignmentConstraint a = (AlignmentConstraint)this.alignmentC.get(count);
            int id1 = o.getAm1().getMolID();
            int id2 = o.getAm2().getMolID();
            if (a.getStatus() == 1 && id1 == a.getNode1().getMolID() && id2 == a.getNode2().getMolID() || id2 == a.getNode1().getMolID() && id1 == a.getNode1().getMolID()) {
                this.removeThisConstraintOnly(a);
                continue;
            }
            ++count;
        }
    }

    private void align(String name, double convergenceLimit, boolean allRigid, double displacement, int smallStep, VolumeOverlap.MODE mode, boolean bigSoft) throws AlignmentException {
        if (debugPrint) {
            System.err.println(name);
        }
        this.setConvergenceLimit(convergenceLimit);
        FunctionMoreMols f = (FunctionMoreMols)this.function;
        this.setAllRigid(allRigid);
        f.resetStepCount();
        f.setCenterDisplacementLimit(displacement);
        f.setSmallStepCountLimit(smallStep);
        f.setMode(mode);
        if (bigSoft) {
            f.bigSoft(true);
        }
        if (DEBUG) {
            f.setSmallStepCountLimit(-1);
        }
        do {
            f.resetStepCount();
            this.optimization();
            if (!debugPrint) continue;
            System.err.println("steps: " + f.stepCount + " cancelled: " + f.isCancelled() + " center: " + f.isCenterDisplacement());
        } while (f.isCenterDisplacement());
        if (bigSoft) {
            f.bigSoft(false);
        }
        f.checkMols();
    }

    private boolean canSelectedModeGo(int selectedCountLimit) {
        for (int i = 0; i < this.molecules.size(); ++i) {
            AlignmentMolecule am = (AlignmentMolecule)this.molecules.get(i);
            int selected = 0;
            if (!(am.nodes instanceof GaussianSum)) {
                return false;
            }
            GaussianSum gs = (GaussianSum)am.nodes;
            for (int j = 0; j < gs.size(); ++j) {
                MolecularGaussian mg = (MolecularGaussian)gs.get(j);
                if (!mg.isSelected()) continue;
                ++selected;
            }
            if (selected < selectedCountLimit) {
                return false;
            }
            if (!debugPrint) continue;
            System.err.println("selectedCountLimit: " + selectedCountLimit);
            System.err.println("selectedCount: " + selected);
        }
        return true;
    }

    private void alignAndSaveTheBest() throws AlignmentException {
        ++this.alignAndSaveTheBestCount;
        this.function.setProgressBarCounterStart(this.function.getProgressBarCounter());
        if (this.canSelectedMode) {
            this.align("SELECT/FLEX/BS", 0.1, false, 2.0, 100, VolumeOverlap.MODE.SELECTED, true);
            this.align("SELECT/FLEX", 0.1, false, 2.0, 100, VolumeOverlap.MODE.SELECTED, false);
            this.align("ATOMIC/FLEX", 0.1, false, 2.0, 10, VolumeOverlap.MODE.ATOMIC, false);
        } else {
            this.align("ATOMIC/FLEX", 0.1, false, 2.0, 200, VolumeOverlap.MODE.ATOMIC, false);
        }
        if (!this.visDetailed && this.vis != null) {
            this.vis.showSteps();
        }
        if (this.best == null) {
            this.best = this.function.getStatusOpt().clone();
            this.copyMolsToBest();
        } else {
            double scoreBest = this.best.getVolumeScore() + this.best.getConstraintScore();
            double score = this.function.getStatusOpt().getConstraintScore() + this.function.getStatusOpt().getVolumeScore();
            if (debugPrint) {
                System.err.println("scoreBest : " + scoreBest + " score: " + score);
            }
            if (scoreBest > score) {
                this.best = this.function.getStatusOpt().clone();
                this.copyMolsToBest();
            }
        }
        if (this.progressMonitor != null) {
            this.function.setProgressBarCounter(this.alignAndSaveTheBestCount * STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR);
            this.progressMonitor.setProgressValue(this.function.getProgressBarCounter());
        }
    }

    private void copyMolsToBest() {
        for (int i = 0; i < this.molecules.size(); ++i) {
            AlignmentMolecule am = this.getAlignmentMolecule(i);
            this.best.getStatusMol(i).setAlignedCrd(am.getAllCrd());
        }
    }

    void createFunction() throws AlignmentException {
        this.function = new FunctionMoreMols(this.molecules, this.alignmentC, this.stepLimit, this.timeLimit);
        this.function.update();
        this.function.getVariables();
        if (this.vis != null) {
            FunctionMoreMols f = (FunctionMoreMols)this.function;
            this.vis.setVg(f.getGrid());
        }
        this.canSelectedMode = this.canSelectedModeGo(this.selectedCountLimit);
        this.function.setProgressBarCounterStart(0);
    }

    public void align() throws AlignmentException {
        Orientation[] o;
        this.checkLicense();
        this.best = null;
        this.alignAndSaveTheBestCount = 0;
        if (this.molecules.size() < 2) {
            throw new AlignmentException("At least two molecules are required to align.");
        }
        if (this.alignmentC.isEmpty() && !this.factory.getNodeType().isGaussLike()) {
            throw new NoConstraintException();
        }
        int transRotEnabledCount = 0;
        for (AlignmentMolecule a : this.molecules) {
            if (!a.isEnableTranslateAndRotate()) continue;
            ++transRotEnabledCount;
        }
        if (transRotEnabledCount == 0) {
            throw new AlignmentException("At least one molecule must be enabled to translate and rotate.");
        }
        if (this.orientationType != AlignmentProperties.OrientationType.ALIGN_AS_IS && this.molecules.size() - transRotEnabledCount > 1) {
            throw new AlignmentException("More than 1 molecule can be freezed only if OrientationType.ALIGN_AS_IS selected.");
        }
        this.createFunction();
        if (this.orientationType == AlignmentProperties.OrientationType.ALIGN_AS_IS) {
            if (this.progressMonitor != null) {
                this.progressMonitor = this.progressMonitor.newInstance();
                int maxP = STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR;
                this.progressMonitor.initProgressMonitor("Alignment in progress ...", 0, maxP);
                this.progressMonitor.setProgressValue(0);
                this.function.setProgressMonitor(this.progressMonitor);
            }
            this.alignAndSaveTheBest();
        } else if (this.molecules.size() == 2) {
            o = this.orientationGenerator(this.getAlignmentMolecule(0), this.getAlignmentMolecule(1));
            if (this.progressMonitor != null) {
                this.progressMonitor = this.progressMonitor.newInstance();
                this.orientationCount = o.getOrientationCount();
                int maxP = this.orientationCount * STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR * this.conformerCount;
                this.progressMonitor.initProgressMonitor("Alignment in progress ...", 0, maxP);
                this.progressMonitor.setProgressValue(0);
                this.function.setProgressMonitor(this.progressMonitor);
            }
            for (int ir = 0; ir < this.conformerCount; ++ir) {
                if (debugPrint) {
                    System.err.println("rand conf: " + ir);
                }
                o.saveConformations();
                while (o.nextOrientation()) {
                    if (debugPrint) {
                        System.err.println("ori");
                    }
                    this.addConstraintsOfThisOrientation((Orientation)o);
                    this.alignAndSaveTheBest();
                    this.removeConstraintsAddedByThisOrientation((Orientation)o);
                }
                o.reset();
                if (o.randomize()) {
                    continue;
                }
                break;
            }
        } else {
            if (this.progressMonitor != null) {
                int i;
                this.orientationCount = 0;
                this.runMode = false;
                o = new Orientation[this.molecules.size() - 1];
                if (this.molecules.size() == transRotEnabledCount) {
                    for (i = 0; i < this.molecules.size(); ++i) {
                        this.orientationOnMoreMolecules(o, i);
                    }
                } else {
                    for (i = 0; i < this.molecules.size(); ++i) {
                        if (this.getAlignmentMolecule(i).isEnableTranslateAndRotate()) continue;
                        this.orientationOnMoreMolecules(o, i);
                    }
                }
                this.progressMonitor = this.progressMonitor.newInstance();
                int maxP = this.orientationCount * this.conformerCount * STEPCOUNT_DEFAULT_FOR_PROGRESS_BAR;
                this.progressMonitor.initProgressMonitor("Alignment in progress ...", 0, maxP);
                this.progressMonitor.setProgressValue(0);
                this.function.resetStepCount();
                this.function.setProgressMonitor(this.progressMonitor);
                this.runMode = true;
            }
            o = new Orientation[this.molecules.size() - 1];
            if (this.molecules.size() == transRotEnabledCount) {
                for (int i = 0; i < this.molecules.size(); ++i) {
                    this.orientationOnMoreMolecules(o, i);
                }
            } else {
                for (int i = 0; i < this.molecules.size(); ++i) {
                    if (this.getAlignmentMolecule(i).isEnableTranslateAndRotate()) continue;
                    this.orientationOnMoreMolecules(o, i);
                }
            }
        }
        if (this.best == null) {
            throw new TooDissimilarException();
        }
        for (int i = 0; i < this.molecules.size(); ++i) {
            AlignmentMolecule am = this.getAlignmentMolecule(i);
            am.copyAllCrd(this.best.getStatusMol(i).getAlignedCrd());
            this.update(am);
        }
        if (this.mode != AlignmentAccuracyMode.FAST && this.canSelectedMode) {
            this.align("ATOMIC/FLEX", 0.1, false, 2.0, 100, VolumeOverlap.MODE.ATOMIC, false);
        }
        if (this.mode == AlignmentAccuracyMode.ACCURATE) {
            this.align("FULL/FLEX", 0.1, false, 2.0, 100, VolumeOverlap.MODE.ATOMIC, false);
        }
        this.setProgressMonitorFinalState();
    }

    private void orientationOnMoreMolecules(Orientation[] o, int baseMol) throws AlignmentException {
        int c = 0;
        for (int j = 0; j < this.molecules.size(); ++j) {
            if (baseMol == j) continue;
            o[c++] = this.orientationGenerator(this.getAlignmentMolecule(baseMol), this.getAlignmentMolecule(j));
        }
        for (int ir = 0; ir < this.conformerCount; ++ir) {
            for (int j = 0; j < o.length; ++j) {
                o[j].saveConformations();
                if (!o[j].nextOrientation()) {
                    throw new AlignmentException("Could not generate the initial orientation between molecules: " + baseMol + " " + j);
                }
                this.addConstraintsOfThisOrientation(o[j]);
            }
            this.pos = 0;
            do {
                if (this.runMode) {
                    this.alignAndSaveTheBest();
                    continue;
                }
                ++this.orientationCount;
            } while (this.next(o));
            boolean allRigid = true;
            for (int j = 0; j < o.length; ++j) {
                this.removeConstraintsAddedByThisOrientation(o[j]);
                o[j].reset();
                if (!o[j].randomize()) continue;
                allRigid = false;
            }
            if (allRigid) break;
        }
        if (this.runMode) {
            this.setProgressMonitorFinalState();
        }
    }

    public double getVolumeScore() {
        if (this.factory.getNodeType().isGaussLike()) {
            return this.best.getVolumeScore();
        }
        return -1.0;
    }

    public double getRmsd() {
        return this.calcRMSD();
    }

    public void addConstraintsFromUserMappedAtoms() throws AlignmentException {
        int id;
        int a;
        Molecule mg;
        int m;
        BitSet added = new BitSet();
        for (m = 0; m < this.molecules.size(); ++m) {
            mg = this.getAlignmentMolecule(m).getMoleculeOrig();
            for (a = 0; a < mg.getAtomCount(); ++a) {
                id = mg.getAtom(a).getAtomMap();
                if (id == 0) continue;
                for (int i = a + 1; i < mg.getAtomCount(); ++i) {
                    int id2 = mg.getAtom(i).getAtomMap();
                    if (id != id2) continue;
                    throw new AlignmentException("There are more same atom mapping within the same molecule : " + id);
                }
            }
        }
        for (m = 0; m < this.molecules.size() - 1; ++m) {
            mg = this.getAlignmentMolecule(m).getMoleculeOrig();
            for (a = 0; a < mg.getAtomCount(); ++a) {
                id = mg.getAtom(a).getAtomMap();
                if (id == 0) continue;
                for (int m2 = m + 1; m2 < this.molecules.size(); ++m2) {
                    Molecule mg2 = this.getAlignmentMolecule(m2).getMoleculeOrig();
                    for (int a2 = 0; a2 < mg2.getAtomCount(); ++a2) {
                        int id2 = mg2.getAtom(a2).getAtomMap();
                        if (id != id2) continue;
                        added.set(id, true);
                        this.addUserConstraint(m, a, m2, a2);
                    }
                }
                if (added.get(id)) continue;
                throw new AlignmentException("Cannot find pair for map id: " + id);
            }
        }
    }

    public void setMinimumCommonSize(int minimumCommonSize) {
        this.minimumCommonSize = minimumCommonSize;
    }
}

