/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.alignment.Alignment;
import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.Constraint;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.Function;
import chemaxon.marvin.alignment.InternalBowlPotential;
import chemaxon.marvin.alignment.IntraMolDistanceConstraint;
import chemaxon.marvin.alignment.Matchable;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.QuadraticPotential;
import chemaxon.marvin.alignment.Status;
import chemaxon.marvin.alignment.StatusMol;
import chemaxon.marvin.alignment.Visualizer;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class AlignmentBase
implements Licensable {
    AlignmentMoleculeFactory factory;
    List<AlignmentConstraint> alignmentC = new ArrayList<AlignmentConstraint>();
    List<AlignmentMolecule> molecules;
    List<IntraMolDistanceConstraint> internalC = new ArrayList<IntraMolDistanceConstraint>();
    Visualizer vis;
    Function function;
    int stepLimit = -1;
    int timeLimit = -1;
    MProgressMonitor progressMonitor = null;
    double convergenceLimit = 1.0;
    private String licenseEnvironment = "";
    boolean debug = false;

    AlignmentBase() {
        this.molecules = new ArrayList<AlignmentMolecule>();
        this.factory = new AlignmentMoleculeFactory();
    }

    public void setProperty(AlignmentProperties props) {
        this.factory.setColor(props.getColor());
        this.factory.setGenerateDistanceRanges(props.isDistancerangeSet());
        this.factory.setNodeType(props.getType());
        this.factory.setProximityPotType(props.getProxy());
        this.factory.setShape(props.getShape());
        this.factory.setNotSpecCase(props.getNotSpec());
    }

    public AlignmentProperties.NodeType getNodeType() {
        return this.factory.getNodeType();
    }

    public NodeColor getNodeColor() {
        return this.factory.getColor();
    }

    public void setAromatize(boolean aromatize) {
        this.factory.setAromatize(aromatize);
    }

    public void setDehidrogenize(boolean hy) {
        this.factory.setDehidrogenize(hy);
    }

    public void setFlexibleRingSize(int s) {
        this.factory.setFlexibleRingSize(s);
    }

    public void setFlexibleRingRotatableBondCount(int b) {
        this.factory.setFlexibleRingRotatableBondCount(b);
    }

    void addMol(AlignmentMolecule alm) {
        this.molecules.add(alm);
    }

    void addMolecule(Molecule m, boolean flexible, boolean enableTranslateAndRotate) throws AlignmentException {
        this.molecules.add(this.factory.generate(this.molecules.size(), m, enableTranslateAndRotate, flexible));
    }

    public Collection<AlignmentMolecule> getMolecules() {
        return this.molecules;
    }

    void setAllRigid(boolean rigid) {
        if (this.function == null) {
            throw new IllegalStateException("Function cannot be null here!!");
        }
        for (AlignmentMolecule a : this.molecules) {
            if (a.isRigid()) continue;
            FlexibleMolecule f = (FlexibleMolecule)a;
            f.freezeAllBonds(rigid);
            f.setProximity(!rigid);
        }
    }

    void addIntraMolDistanceConstraint(int p1, int p2, double weight, double distance, double tolerance, PotentialType potType) throws AlignmentException {
        if (p1 == p2) {
            throw new AlignmentException("The two endpoint IDs are equal.");
        }
        for (IntraMolDistanceConstraint intr : this.internalC) {
            if ((intr.getP1ID() != p1 || intr.getP2ID() != p2) && (intr.getP1ID() != p2 || intr.getP2ID() != p1)) continue;
            throw new AlignmentException("Internal distance with this pointID was found. " + p1 + " " + p2);
        }
        PotentialFunction pot = null;
        if (potType == PotentialType.QUADRATIC) {
            pot = new QuadraticPotential(distance, weight, tolerance);
        }
        if (potType == PotentialType.BOWL) {
            pot = new InternalBowlPotential(weight / 2.0, tolerance, distance);
        }
        IntraMolDistanceConstraint c = new IntraMolDistanceConstraint(p1, p2, pot);
        this.internalC.add(c);
    }

    Molecule getAlignedMoleculesAsFragments() {
        Molecule ret = this.getMoleculeWithAlignedCoordinates(0).cloneMolecule();
        for (int i = 1; i < this.molecules.size(); ++i) {
            ret.fuse(this.getMoleculeWithAlignedCoordinates(i));
        }
        return ret;
    }

    Molecule getMoleculeWithAlignedCoordinates(int molID) {
        return this.molecules.get(molID).getAlignedMolecule();
    }

    static double[][] getCrd(boolean extraGauss, ArrayList<AlignmentMolecule> molecules) {
        int nodeCount = 0;
        for (AlignmentMolecule a : molecules) {
            if (extraGauss) {
                nodeCount += a.nodes.size();
                continue;
            }
            nodeCount += a.getAtomCount();
        }
        double[][] ret = new double[nodeCount][];
        nodeCount = 0;
        for (AlignmentMolecule a : molecules) {
            int l = a.getAtomCount();
            if (extraGauss) {
                l = a.nodes.size();
            }
            for (int i = 0; i < l; ++i) {
                ret[nodeCount++] = a.nodes.get(i).getCrd();
            }
        }
        return ret;
    }

    void mapIntraDist(int molID, int atomSeq, int pointID) throws AlignmentException {
        if (this.molecules.size() <= molID) {
            throw new AlignmentException("First define molecule, than add map.");
        }
        AlignmentMolecule molRot = this.molecules.get(molID);
        if (atomSeq < 0 || atomSeq > molRot.getNodeCount()) {
            throw new AlignmentException("Atom sequence number is not valid for this molecule.");
        }
        boolean found = false;
        for (IntraMolDistanceConstraint e : this.internalC) {
            if (!e.tryToMap(molRot.getAtom(atomSeq), pointID)) continue;
            found = true;
        }
        if (!found) {
            throw new AlignmentException("This pointID was not found ");
        }
    }

    void removeAllMolecules() {
        this.molecules.clear();
        this.alignmentC.clear();
        this.resetIntraDistMap();
        this.function = null;
    }

    boolean removeThisConstraintOnly(Constraint c) {
        Constraint e;
        int i;
        boolean wasRemoved = false;
        if (c instanceof AlignmentConstraint) {
            for (i = 0; i < this.alignmentC.size(); ++i) {
                e = this.alignmentC.get(i);
                if (!e.equals(c)) continue;
                if (wasRemoved) {
                    System.err.println(e);
                    System.err.println(c);
                    throw new IllegalStateException("bug");
                }
                this.alignmentC.remove(i);
                wasRemoved = true;
            }
        }
        if (c instanceof MolecularConstraint) {
            for (i = 0; i < this.internalC.size(); ++i) {
                e = this.internalC.get(i);
                if (!e.equals(c)) continue;
                if (wasRemoved) {
                    throw new IllegalStateException("bug");
                }
                this.internalC.remove(i);
                wasRemoved = true;
            }
        }
        return wasRemoved;
    }

    double[][] getCrd(int molID) {
        for (AlignmentMolecule m : this.molecules) {
            if (m.getMolID() != molID) continue;
            return m.getMolCrd();
        }
        return null;
    }

    double calcRMSD() {
        double m = 0.0;
        double w = 0.0;
        for (AlignmentConstraint e : this.alignmentC) {
            m += e.getDistSQ() * e.getWeight();
            w += e.getWeight();
        }
        for (IntraMolDistanceConstraint d : this.internalC) {
            double w2 = d.pot.getWeight();
            m += d.getMSDComponent() * w2;
            w += w2;
        }
        m = Math.sqrt(m / w);
        return m;
    }

    void calcMatch() {
        int mcount = 0;
        int tot = 0;
        for (AlignmentConstraint ex : this.alignmentC) {
            if (!(ex instanceof Matchable)) continue;
            Matchable m = (Matchable)((Object)ex);
            ++tot;
            if (m.isMatch()) continue;
            ++mcount;
        }
        if (tot != mcount || tot != 0) {
            // empty if block
        }
    }

    void addAlignmentConstraint(int mol0, int atom0, int mol1, int atom1, double weight, double tolerance, PotentialType p, int status) throws AlignmentException {
        if (mol0 == mol1) {
            throw new AlignmentException("MolIDs cannot be the same.");
        }
        if (this.molecules.size() <= mol0) {
            throw new AlignmentException("No molecule is added. MolID: " + mol0);
        }
        if (this.molecules.size() <= mol1) {
            throw new AlignmentException("No molecule is added. MolID: " + mol0);
        }
        if (atom0 < 0 || atom0 > this.molecules.get(mol0).getNodeCount()) {
            throw new AlignmentException("Atom sequence number is not valid for this molecule.");
        }
        if (atom1 < 0 || atom1 > this.molecules.get(mol1).getNodeCount()) {
            throw new AlignmentException("Atom sequence number is not valid for this molecule.");
        }
        Node ai0 = this.molecules.get(mol0).getAtom(atom0);
        Node ai1 = this.molecules.get(mol1).getAtom(atom1);
        AlignmentConstraint a = new AlignmentConstraint(ai0, ai1, weight, tolerance, p);
        a.setStatus(status);
        this.alignmentC.add(a);
    }

    void addAlignmentConstraint(AlignmentConstraint ext) {
        this.alignmentC.add(ext);
    }

    void addInternalCToMols() throws AlignmentException {
        for (IntraMolDistanceConstraint e : this.internalC) {
            if (!e.isAssigned()) {
                throw new AlignmentException("MolecularConstraint was not mapped ");
            }
            AlignmentMolecule am = this.molecules.get(e.getMolID());
            if (am.isRigid()) continue;
            FlexibleMolecule fm = (FlexibleMolecule)am;
            fm.addIntraMolConstr(e);
        }
    }

    final void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    void optimization() throws AlignmentException {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            return;
        }
        this.function.reset();
        if (this.vis != null) {
            this.function.setVis(this.vis);
            this.vis.init(this.molecules, this.alignmentC);
        }
        if (this.function.variables.length > 0) {
            GradientOptimization gr = new GradientOptimization(this.function);
            gr.setGradientRMSLimit(this.convergenceLimit);
            gr.setMaxStepComponent(1.5707963267948966);
            this.function.setGr(gr);
            gr.setChangeCorrector(this.function.getChangeCorrector());
            try {
                gr.run();
                if (!this.function.isCancelled() && !gr.isOptimizationConverged()) {
                    this.function.getStatusOpt().setConverged(false);
                    if (Alignment.DEBUG) {
                        throw new AlignmentException("Optimization was not converged.");
                    }
                    System.err.println("NOT CONVERGED!");
                }
            }
            catch (GradientOptimization.GradientOptimizationException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.function.fillStatus();
    }

    void resetIntraDistMap() {
        for (IntraMolDistanceConstraint r : this.internalC) {
            r.reset();
        }
        for (AlignmentMolecule am : this.molecules) {
            if (am.isRigid()) continue;
            FlexibleMolecule fm = (FlexibleMolecule)am;
            fm.removeAllIntraMolConstr();
        }
    }

    void resetCoordinates() {
        for (AlignmentMolecule am : this.molecules) {
            am.resetToOriginalCoordinates();
        }
    }

    void removeAllConstraints() {
        this.internalC.clear();
        this.alignmentC.clear();
        for (AlignmentMolecule am : this.molecules) {
            if (am.isRigid()) continue;
            FlexibleMolecule fm = (FlexibleMolecule)am;
            fm.removeAllIntraMolConstr();
        }
    }

    void setVis(Visualizer vis) {
        this.vis = vis;
    }

    Status getStatusOpt() {
        return this.function.getStatusOpt();
    }

    AlignmentMolecule getAlignmentMolecule(int seq) {
        return this.molecules.get(seq);
    }

    public int getStepLimit() {
        return this.stepLimit;
    }

    public void setStepLimit(int stepLimit) {
        this.stepLimit = stepLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setNodeType(AlignmentProperties.NodeType t) {
        this.factory.setNodeType(t);
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    void randomizeDihedrals() {
        for (AlignmentMolecule r : this.molecules) {
            if (r.isRigid()) continue;
            FlexibleMolecule f = (FlexibleMolecule)r;
            f.randomizeDihedrals();
        }
        if (this.vis != null) {
            this.vis.showSteps();
        }
    }

    StatusMol getStatusMol(int molSeq) {
        return this.molecules.get(molSeq).getStatus();
    }

    public void setProgressMonitor(MProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    void setProgressMonitorFinalState() {
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgressValue(this.progressMonitor.getMaximum());
        }
    }

    void setConvergenceLimit(double convergenceLimit) {
        this.convergenceLimit = convergenceLimit;
    }

    public void setProximity(AlignmentProperties.ProximityPotentialType pot) {
        this.factory.setProximityPotType(pot);
    }
}

