/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.Constraint;
import chemaxon.marvin.alignment.ExpandingPotential;
import chemaxon.marvin.alignment.ExternalHalfBowlPotential;
import chemaxon.marvin.alignment.GaussianPotential;
import chemaxon.marvin.alignment.GaussianPotentialDouble;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.QuadraticPotentialZeroR0;

class AlignmentConstraint
extends Constraint {
    public static final int MATCH_FOUND = 0;
    public static final int ADDED_BY_ORIENTATION = 1;
    public static final int ADDED_BY_USER = 2;
    public static final int ENABLED = 3;
    public static final int DISABLED_GAUSS = 4;
    int status = 3;

    public AlignmentConstraint(Node atom1, Node atom2, double weight, double tolerance, PotentialType pot) throws AlignmentException {
        super(atom1, atom2, null);
        if (atom1.getMolID() == atom2.getMolID()) {
            throw new AlignmentException("MolIDs for alignment constraint cannot be equal. ");
        }
        if (!atom1.isRealAtom() && !(atom1 instanceof MultiCenterGaussian)) {
            throw new AlignmentException("Alignment constraint can be added only between real atoms. ");
        }
        if (!atom2.isRealAtom() && !(atom2 instanceof MultiCenterGaussian)) {
            throw new AlignmentException("Alignment constraint can be added only between real atoms. ");
        }
        this.changePot(weight, tolerance, pot);
    }

    public final void changePot(double weight, double tolerance, PotentialType potToUse) {
        if (potToUse == PotentialType.QUADRATIC) {
            this.pot = new QuadraticPotentialZeroR0(weight, tolerance);
        } else if (potToUse == PotentialType.HALF_BOWL) {
            this.pot = new ExternalHalfBowlPotential(weight, tolerance);
        } else if (potToUse == PotentialType.GAUSSIAN) {
            this.pot = new GaussianPotential(weight, tolerance);
        } else if (potToUse == PotentialType.GAUSSIAN_DOUBLE) {
            this.pot = new GaussianPotentialDouble(weight, tolerance);
        } else if (potToUse == PotentialType.EXPANDING) {
            this.pot = new ExpandingPotential(weight);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "w: " + this.pot.getWeight() + " status:" + this.status;
    }

    @Override
    public double getEnergy() {
        if (this.status != 4) {
            return super.getEnergy();
        }
        return 0.0;
    }

    @Override
    public double derivateDividedByDist() {
        if (this.status != 4) {
            return super.derivateDividedByDist();
        }
        return 0.0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getWeight() {
        return this.pot.getWeight();
    }

    public double getWeightSqrt() {
        return 1.0;
    }
}

