/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.DegreeOfFeedom;
import chemaxon.marvin.alignment.DistanceRangeStore;
import chemaxon.marvin.alignment.EulerRotate;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.Quaternion;
import chemaxon.marvin.alignment.RotationByAngles;
import chemaxon.marvin.alignment.StatusMol;
import chemaxon.marvin.alignment.Visualizable;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class AlignmentMolecule
implements Serializable {
    NodeList<? extends Node> nodes;
    double[] mins;
    double[] maxs;
    Bond[] bonds;
    transient double[][] crdOrig;
    transient int molID;
    transient double[][] crdSafe;
    transient StatusMol status;
    transient DegreeOfFeedom translate;
    transient DegreeOfFeedom rotate;
    transient double[] center;
    transient double[] centerActual;
    transient Iterator<DegreeOfFeedom> dfIterator;
    transient int iteratorPos = 0;
    transient Molecule storeOnly;
    transient Node[] shapeNodes;
    transient boolean enableTranslateAndRotate = false;
    private static double DIST_LIMIT = 0.1;
    private static double BOND_LIMIT = 1.2;

    AlignmentMolecule(NodeList nodes) {
        this.nodes = nodes;
    }

    void setMolID(int molID) {
        this.molID = molID;
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).setMolID(molID);
        }
    }

    public NodeList<? extends Node> getNodes() {
        return this.nodes;
    }

    public void initVariables(boolean enableTranslateAndRotate) {
        int i;
        this.molID = this.nodes.get(0).getMolID();
        this.status = new StatusMol(this.molID);
        this.status.setStatus(64);
        this.crdOrig = new double[this.getAtomCount()][];
        for (i = 0; i < this.crdOrig.length; ++i) {
            this.crdOrig[i] = MolGeom.arrayCopy(this.nodes.get(i).getCrd());
        }
        this.shapeNodes = this.nodes.getShapeNodes();
        this.enableTranslateAndRotate = enableTranslateAndRotate;
        if (enableTranslateAndRotate) {
            this.center = new double[3];
            this.centerActual = new double[3];
            this.translate = new DFTrans();
            this.rotate = new DFEuler();
            this.crdSafe = new double[this.nodes.size()][3];
            for (i = 0; i < this.nodes.size(); ++i) {
                double[] c = this.nodes.get(i).getCrd();
                this.crdSafe[i][0] = c[0];
                this.crdSafe[i][1] = c[1];
                this.crdSafe[i][2] = c[2];
            }
        } else {
            this.center = null;
            this.centerActual = null;
            this.translate = null;
            this.rotate = null;
            this.crdSafe = null;
        }
    }

    public AlignmentProperties.ColoringScheme getColoringScheme() {
        return this.nodes.color.getScheme();
    }

    public NodeColor getColors() {
        return this.nodes.color;
    }

    public Visualizable getVisualizable() {
        if (this.nodes instanceof Visualizable) {
            if (this.nodes instanceof GaussianSum) {
                ((GaussianSum)this.nodes).updateGaussianProducts();
            }
            return (Visualizable)((Object)this.nodes);
        }
        return null;
    }

    Node[] getShapeNodes() {
        return this.shapeNodes;
    }

    void checkCoordinates() {
        for (Node node : this.nodes) {
            if (!U.isDoubleOK(node.getCrd()[0])) {
                throw new IllegalStateException("Error in x coordinate of: " + ((Object)node).toString());
            }
            if (!U.isDoubleOK(node.getCrd()[1])) {
                throw new IllegalStateException("Error in y coordinate of: " + ((Object)node).toString());
            }
            if (U.isDoubleOK(node.getCrd()[2])) continue;
            throw new IllegalStateException("Error in z coordinate of: " + ((Object)node).toString());
        }
    }

    void checkProximity() {
        for (int i = 0; i < this.nodes.size() - 1; ++i) {
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                double d = this.nodes.get(i).getDistSQ(this.nodes.get(j));
                if (!(d < DIST_LIMIT)) continue;
                throw new IllegalStateException("Proximity between nodes:\n" + this.nodes.get(i) + "\n" + this.nodes.get(j));
            }
        }
    }

    void checkBondLength() throws AlignmentException {
        for (int i = 0; i < this.bonds.length; ++i) {
            double l = Math.sqrt(this.nodes.get(this.bonds[i].atom1).getDistSQ(this.nodes.get(this.bonds[i].atom2)));
            if (!(l * BOND_LIMIT < this.bonds[i].length0) && !(l > this.bonds[i].length0 * BOND_LIMIT)) continue;
            throw new AlignmentException("Bond length mismatch between: " + this.bonds[i].atom1 + " " + this.bonds[i].atom2 + " Expected: " + this.bonds[i].length0 + " Found: " + l);
        }
    }

    void setMolecule(Molecule m) throws AlignmentException {
        if (m.getAtomCount() != this.getAtomCount()) {
            throw new AlignmentException("Atomcount mismatch " + m.getAtomCount() + " " + this.getAtomCount());
        }
        this.storeOnly = m;
    }

    public int getRotBondCount() {
        return 0;
    }

    void extractBondInfo(Molecule m) throws AlignmentException {
        if (m.getAtomCount() != this.getAtomCount()) {
            throw new AlignmentException("Atomcount mismatch " + m.getAtomCount() + " " + this.getAtomCount());
        }
        this.bonds = new Bond[m.getBondCount()];
        for (int i = 0; i < m.getBondCount(); ++i) {
            int ma1 = m.indexOf(m.getBond(i).getAtom1());
            int ma2 = m.indexOf(m.getBond(i).getAtom2());
            this.bonds[i] = new Bond(ma1, ma2, m.getBond(i).getType(), m.getBond(i).getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlignmentMolecule create(byte[] bytes) {
        AlignmentMolecule a;
        block16: {
            ObjectInputStream in = null;
            a = null;
            Exception t = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                a = (AlignmentMolecule)in.readObject();
            }
            catch (ClassNotFoundException c) {
                t = c;
                return t;
            }
            catch (IOException io) {
                t = io;
                return t;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io2) {
                    io2.printStackTrace();
                    System.exit(0);
                }
                if (t == null) break block16;
                throw new UnsupportedOperationException(t);
            }
        }
        return a;
    }

    public AlignmentMolecule clone() {
        byte[] b = this.toData();
        byte[] bnew = new byte[b.length];
        System.arraycopy(b, 0, bnew, 0, b.length);
        return AlignmentMolecule.create(bnew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toData() {
        ByteArrayOutputStream bos;
        block12: {
            bos = null;
            ObjectOutput out = null;
            IOException t = null;
            try {
                bos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bos);
                out.writeObject(this);
            }
            catch (IOException io) {
                t = io;
                return t;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException io2) {
                    io2.printStackTrace();
                    System.exit(0);
                }
                if (t == null) break block12;
                throw new UnsupportedOperationException(t);
            }
        }
        return bos.toByteArray();
    }

    void setDistanceData(double[] mins, double[] maxs) {
        this.mins = mins;
        this.maxs = maxs;
    }

    DistanceRangeStore distanceRangeStore() throws AlignmentException {
        if (this.mins == null) {
            return null;
        }
        return new DistanceRangeStore(this.mins, this.maxs, this.nodes.color, this.nodes.getSelectedNodes());
    }

    void createDFIterator() {
        this.dfIterator = new Iterator<DegreeOfFeedom>(){

            @Override
            public boolean hasNext() {
                return AlignmentMolecule.this.isEnableTranslateAndRotate() && AlignmentMolecule.this.iteratorPos < 2;
            }

            @Override
            public DegreeOfFeedom next() {
                if (AlignmentMolecule.this.iteratorPos == 0) {
                    ++AlignmentMolecule.this.iteratorPos;
                    return AlignmentMolecule.this.translate;
                }
                if (AlignmentMolecule.this.iteratorPos == 1) {
                    ++AlignmentMolecule.this.iteratorPos;
                    return AlignmentMolecule.this.rotate;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    double[] gradient(double[] gradient, List<? extends AlignmentConstraint> constr) {
        if (this.isEnableTranslateAndRotate()) {
            for (AlignmentConstraint alignmentConstraint : constr) {
                gradient = this.translate.gradient(gradient, alignmentConstraint);
            }
            for (AlignmentConstraint alignmentConstraint : constr) {
                gradient = this.rotate.gradient(gradient, alignmentConstraint);
            }
        }
        return gradient;
    }

    void setVariables(double[] variables) {
        if (this.isEnableTranslateAndRotate()) {
            this.translate.setVariable(variables);
            this.rotate.setVariable(variables);
        }
    }

    void setVariableValueOnly(double[] variables) {
        if (this.isEnableTranslateAndRotate()) {
            this.translate.setVariableValueOnly(variables);
            this.rotate.setVariableValueOnly(variables);
        }
    }

    double[] getVariables(double[] variables) {
        if (this.isEnableTranslateAndRotate()) {
            variables = this.translate.getVariable(variables);
            variables = this.rotate.getVariable(variables);
        }
        return variables;
    }

    Iterator<DegreeOfFeedom> getDfIterator() {
        return this.dfIterator;
    }

    DegreeOfFeedom getRotate() {
        return this.rotate;
    }

    DegreeOfFeedom getTranslate() {
        return this.translate;
    }

    void updateIterator() {
        this.iteratorPos = 0;
    }

    void updateGaussianProducts() {
        if (this.nodes instanceof GaussianSum) {
            ((GaussianSum)this.nodes).updateGaussianProducts();
        }
    }

    void updateRingCenters() {
        if (this.nodes instanceof GaussianSum) {
            ((GaussianSum)this.nodes).updateRingCenters();
        }
    }

    public double getVolume() {
        if (this.nodes instanceof GaussianSum) {
            return ((GaussianSum)this.nodes).integral();
        }
        return 0.0;
    }

    public int getAtomCount() {
        return this.nodes.getRealAtomCount();
    }

    public void crdSafeRefresh() {
        if (this.isEnableTranslateAndRotate()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                double[] c = this.nodes.get(i).getCrd();
                this.crdSafe[i][0] = c[0];
                this.crdSafe[i][1] = c[1];
                this.crdSafe[i][2] = c[2];
            }
        }
    }

    public void crdMolRefresh() {
        if (this.isEnableTranslateAndRotate()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                double[] c = this.nodes.get(i).getCrd();
                c[0] = this.crdSafe[i][0];
                c[1] = this.crdSafe[i][1];
                c[2] = this.crdSafe[i][2];
            }
            this.calcMyCenter();
        }
    }

    double centerDistance() {
        if (this.isEnableTranslateAndRotate()) {
            this.centerActual = this.calcCenter(this.centerActual);
            return Math.sqrt(MolGeom.getDistSq(this.center, this.centerActual));
        }
        return 0.0;
    }

    void calcMyCenter() {
        if (this.isEnableTranslateAndRotate()) {
            this.center = this.calcCenter(this.center);
        }
    }

    double[] calcCenter(double[] centerCalcd) {
        centerCalcd[0] = 0.0;
        centerCalcd[1] = 0.0;
        centerCalcd[2] = 0.0;
        int count = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).isCenteringMembers()) continue;
            double[] c = this.nodes.get(i).getCrd();
            centerCalcd[0] = centerCalcd[0] + c[0];
            centerCalcd[1] = centerCalcd[1] + c[1];
            centerCalcd[2] = centerCalcd[2] + c[2];
            ++count;
        }
        if (count == 0) {
            throw new UnsupportedOperationException("No atom selected for center");
        }
        centerCalcd[0] = centerCalcd[0] / (double)count;
        centerCalcd[1] = centerCalcd[1] / (double)count;
        centerCalcd[2] = centerCalcd[2] / (double)count;
        return centerCalcd;
    }

    int getDFCount() {
        if (this.isEnableTranslateAndRotate()) {
            return this.translate.getLength() + this.rotate.getLength();
        }
        return 0;
    }

    int[] getTypesAsArray() {
        int[] ret = new int[this.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            if (!this.nodes.get(i).isRealAtom()) {
                throw new UnsupportedOperationException("not real atom!");
            }
            ret[i] = this.nodes.get(i).getType();
        }
        return ret;
    }

    public int getMolID() {
        return this.molID;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    Molecule getAlignedMolecule() {
        this.storeOnly = MolGeom.putCoordinates(this.getMoleculeOrig(), this.getMolCrd());
        return this.storeOnly;
    }

    boolean isRigidMol() {
        return this.status.isRigidMol();
    }

    boolean isRigidPath() {
        return this.status.isRigidPath();
    }

    boolean isRigid() {
        return this.isRigidMol() || this.isRigidPath();
    }

    void resetToOriginalCoordinates() {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            double[] c = this.nodes.get(i).getCrd();
            MolGeom.arrayCopy(this.crdOrig[i], c);
        }
    }

    StatusMol getStatus() {
        return this.status;
    }

    public double[][] getMolCrd() {
        double[][] crd = new double[this.getAtomCount()][];
        for (int i = 0; i < crd.length; ++i) {
            crd[i] = this.nodes.get(i).getCrd();
        }
        return crd;
    }

    void copyAllCrd(double[][] crd) {
        if (crd.length != this.nodes.size()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            double[] c = this.nodes.get(i).getCrd();
            c[0] = crd[i][0];
            c[1] = crd[i][1];
            c[2] = crd[i][2];
        }
    }

    public Molecule getMoleculeOrig() {
        if (this.storeOnly == null) {
            int i;
            this.storeOnly = new Molecule();
            this.storeOnly.setDim(3);
            int atomCount = this.nodes.size();
            if (this.nodes instanceof GaussianSum) {
                atomCount = ((GaussianSum)this.nodes).getRealAtomCount();
            }
            for (i = 0; i < atomCount; ++i) {
                Node n = this.nodes.get(i);
                if (!n.isRealAtom()) {
                    throw new UnsupportedOperationException();
                }
                this.storeOnly.add(new MolAtom(n.getOriginalAtomType(), n.getCrd()[0], n.getCrd()[1], n.getCrd()[2]));
            }
            for (i = 0; i < this.bonds.length; ++i) {
                this.storeOnly.add(new MolBond(this.storeOnly.getAtom(this.bonds[i].atom1), this.storeOnly.getAtom(this.bonds[i].atom2), this.bonds[i].type));
            }
        }
        return this.storeOnly;
    }

    Molecule addRingCenterNodes(Molecule m, boolean for2d) {
        if (!(this.nodes instanceof GaussianSum)) {
            return m;
        }
        GaussianSum s = (GaussianSum)this.nodes;
        for (int i = s.size() - s.getMulticenterNodeCount(); i < s.size(); ++i) {
            MultiCenterGaussian mu = (MultiCenterGaussian)s.get(i);
            int atno = mu.getOriginalAtomType();
            if (NodeColor.isAliphaticRingCenter(mu.getType())) {
                atno = 74;
            }
            if (NodeColor.isAromaticRingCenter(mu.getType())) {
                atno = 42;
            }
            MolAtom ma = null;
            ma = for2d ? new MolAtom(134) : new MolAtom(atno);
            ma.setXYZ(mu.getCrd()[0], mu.getCrd()[1], mu.getCrd()[2]);
            m.add(ma);
        }
        return m;
    }

    Molecule getSelectedAtomsColored() {
        int pos;
        int i;
        Molecule ret = this.getMoleculeOrig().cloneMolecule();
        this.addRingCenterNodes(ret, false);
        GaussianSum g = (GaussianSum)this.nodes;
        MDocument mdoc = new MDocument(ret);
        mdoc.setAtomSetColorMode(1, 1);
        mdoc.setAtomSetRGB(1, Color.BLUE.getRGB());
        mdoc.setAtomSetColorMode(2, 1);
        mdoc.setAtomSetRGB(2, Color.YELLOW.getRGB());
        for (i = 0; i < ret.getAtomCount(); ++i) {
            ret.getAtom(i).setSetSeq(1);
        }
        for (i = 0; i < g.getRealAtomCount(); ++i) {
            Object n = g.get(i);
            MolAtom a = ret.getAtom(i);
            a.setExtraLabel("" + i + this.nodes.color.typeLabel(n.getType()));
            if (!n.isSelected()) continue;
            a.setSetSeq(2);
        }
        for (int i2 = pos = g.size() - g.getMulticenterNodeCount(); i2 < g.size(); ++i2) {
            Object n = g.get(i2);
            MolAtom a = ret.getAtom(i2 - pos + g.getRealAtomCount());
            if (!n.isSelected()) continue;
            a.setExtraLabel("" + i2 + this.nodes.color.typeLabel(n.getType()));
            a.setSetSeq(2);
        }
        return ret;
    }

    Molecule getSelectedAtomsColored2D() {
        int pos;
        int i;
        Molecule ret = this.getMoleculeOrig().cloneMolecule();
        this.addRingCenterNodes(ret, true);
        GaussianSum g = (GaussianSum)this.nodes;
        MDocument mdoc = new MDocument(ret);
        mdoc.setAtomSetColorMode(1, 1);
        mdoc.setAtomSetRGB(1, Color.BLACK.getRGB());
        mdoc.setAtomSetColorMode(2, 1);
        mdoc.setAtomSetRGB(2, Color.GREEN.getRGB());
        for (i = 0; i < ret.getAtomCount(); ++i) {
            ret.getAtom(i).setSetSeq(1);
        }
        for (i = 0; i < g.getRealAtomCount(); ++i) {
            Object n = g.get(i);
            MolAtom a = ret.getAtom(i);
            if (!n.isSelected()) continue;
            String s = this.nodes.color.typeLabel(n.getType());
            a.setExtraLabel("" + i + s);
            a.setSetSeq(2);
        }
        for (int i2 = pos = g.size() - g.getMulticenterNodeCount(); i2 < g.size(); ++i2) {
            Object n = g.get(i2);
            MolAtom a = ret.getAtom(i2 - pos + g.getRealAtomCount());
            if (!n.isSelected()) continue;
            a.setExtraLabel("" + i2 + this.nodes.color.typeLabel(n.getType()));
            a.setSetSeq(2);
        }
        int bc = ret.getBondCount();
        GaussianSum s = (GaussianSum)this.nodes;
        int centerAtom = this.getAtomCount();
        for (int i3 = s.size() - s.getMulticenterNodeCount(); i3 < s.size(); ++i3) {
            MultiCenterGaussian mu = (MultiCenterGaussian)s.get(i3);
            AtomicGaussian[] a = mu.getMembers();
            for (int j = 0; j < a.length; ++j) {
                MolAtom a1 = ret.getAtom(centerAtom);
                MolAtom a2 = ret.getAtom(a[j].getFirstAtomSeq());
                MolBond mb = new MolBond(a1, a2);
                ret.add(mb);
            }
            ++centerAtom;
        }
        ret.clean(2, null);
        while (ret.getBondCount() > bc) {
            ret.removeBond(ret.getBondCount() - 1);
        }
        return ret;
    }

    Molecule addMolCenters(Molecule m) {
        if (this.center == null) {
            return m;
        }
        MolAtom ma = new MolAtom(1);
        ma.setXYZ(this.center[0], this.center[1], this.center[2]);
        m.add(ma);
        ma.setExtraLabel("centerSupposed");
        MolAtom ma2 = new MolAtom(1);
        ma2.setXYZ(this.centerActual[0], this.centerActual[1], this.centerActual[2]);
        m.add(ma2);
        ma2.setExtraLabel("centerActual");
        return m;
    }

    Molecule addGaussProducts(Molecule ret) {
        for (int i = this.getAtomCount(); i < this.nodes.size(); ++i) {
            MolecularGaussianProduct n = (MolecularGaussianProduct)this.nodes.get(i);
            n.update();
            int z = 8;
            if (n.getMemberCount() % 2 == 0) {
                z = 7;
            }
            MolAtom ma = new MolAtom(z);
            ret.add(ma);
        }
        return ret;
    }

    double[][] getAllCrd() {
        double[][] ret = new double[this.getNodeCount()][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.nodes.get(i).getCrd();
        }
        return ret;
    }

    public void setAssigned(int i, boolean b) {
        this.nodes.setAssigned(i, b);
    }

    public boolean isAssigned(int i) {
        return this.nodes.isAssigned(i);
    }

    public void clearAssigned() {
        this.nodes.clearAssigned();
    }

    public String toString() {
        int i;
        String s = "molID: " + this.molID + "\n";
        s = s + "Nodes:\n";
        for (i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.get(i);
            s = s + i + " " + ((Object)node).toString() + "\n";
        }
        if (this.mins != null) {
            s = s + "Distance ranges on selected nodes:\n";
            for (i = 0; i < this.mins.length; ++i) {
                s = s + this.mins[i] + " " + this.maxs[i] + "\n";
            }
        }
        return s;
    }

    Node getAtom(int atomSeq) {
        Node n = this.nodes.get(atomSeq);
        if (!n.isRealAtom() && n.getFirstAtomSeq() != atomSeq) {
            throw new UnsupportedOperationException();
        }
        return n;
    }

    public boolean isEnableTranslateAndRotate() {
        return this.enableTranslateAndRotate;
    }

    public void setEnableTranslateAndRotate(boolean enableTranslateAndRotate) throws AlignmentException {
        if ((this.translate == null || this.rotate == null) && enableTranslateAndRotate) {
            throw new AlignmentException("translate and rotate was not enabled at initVariables");
        }
        this.enableTranslateAndRotate = enableTranslateAndRotate;
    }

    int getAtomCountInReturnedMol(boolean withExtraGaussianNodes, boolean withRingCenters) {
        int ringCenterCount = 0;
        int extraGaussCount = 0;
        if (this.nodes instanceof GaussianSum) {
            GaussianSum g = (GaussianSum)this.nodes;
            if (withRingCenters) {
                ringCenterCount = g.getMulticenterNodeCount();
            }
            if (withExtraGaussianNodes) {
                extraGaussCount = g.size() - g.getRealAtomCount() - g.getMulticenterNodeCount();
            }
        }
        return this.getAtomCount() + extraGaussCount + ringCenterCount;
    }

    int getAtomSeqInReturnedMol(Node n, boolean withExtraGaussianNodes) {
        if (n.isRealAtom() && !(n instanceof MultiCenterGaussian)) {
            return n.getFirstAtomSeq();
        }
        if (!(this.nodes instanceof GaussianSum)) {
            throw new UnsupportedOperationException();
        }
        GaussianSum g = (GaussianSum)this.nodes;
        int pos = -1;
        for (int i = g.getRealAtomCount(); i < g.size(); ++i) {
            if (!((MolecularGaussian)g.get(i)).equals(n)) continue;
            pos = i;
            break;
        }
        if (!withExtraGaussianNodes) {
            int extraGaussCount = g.size() - g.getRealAtomCount() - g.getMulticenterNodeCount();
            pos -= extraGaussCount;
        }
        return pos;
    }

    public Molecule showSelectedNodes() {
        Molecule ret = this.getAlignedMolecule().cloneMolecule();
        this.addRingCenterNodes(ret, false);
        MDocument mdoc = new MDocument(ret);
        mdoc.setAtomSetColorMode(2, 1);
        mdoc.setAtomSetRGB(2, Color.YELLOW.getRGB());
        mdoc.setAtomSetColorMode(2, 1);
        mdoc.setAtomSetRGB(3, Color.RED.getRGB());
        for (int i = 0; i < ret.getAtomCount(); ++i) {
            ret.getAtom(i).setSetSeq(2);
        }
        Node[] sel = this.nodes.getSelectedNodes();
        for (int i = 0; i < sel.length; ++i) {
            Node node = sel[i];
            int atom = this.getAtomSeqInReturnedMol(node, false);
            ret.getAtom(atom).setSetSeq(3);
            ret.getAtom(atom).setExtraLabel("" + atom + "_" + this.nodes.color.typeLabel(node.getType()));
        }
        return ret;
    }

    class DFQuaternion
    extends DF3My {
        Quaternion q;
        double[] rotatedCoord;
        double[] centered1;
        double[] centered2;
        double[] diff;

        DFQuaternion() {
            this.q = new Quaternion();
            this.rotatedCoord = new double[3];
            this.centered1 = new double[3];
            this.centered2 = new double[3];
            this.diff = new double[3];
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public double[] gradient(double[] gradient, Interaction a) {
            Node n1 = a.getNode1();
            Node n2 = a.getNode2();
            if (n1.getMolID() != AlignmentMolecule.this.molID && n2.getMolID() != AlignmentMolecule.this.molID || n1.getMolID() == AlignmentMolecule.this.molID && n2.getMolID() == AlignmentMolecule.this.molID) {
                return gradient;
            }
            double der = a.derivateDividedByDist();
            if (der == 0.0) {
                return gradient;
            }
            double[] x1 = n1.getCrd();
            double[] x2 = n2.getCrd();
            if (n1.getMolID() != AlignmentMolecule.this.molID) {
                x1 = n2.getCrd();
                x2 = n1.getCrd();
            }
            MolGeom.minusVec(x1, AlignmentMolecule.this.center, this.centered1);
            MolGeom.minusVec(x2, AlignmentMolecule.this.center, this.centered2);
            this.rotatedCoord = this.q.rotate(this.centered1);
            MolGeom.minusVec(this.rotatedCoord, this.centered2, this.diff);
            double[] g = null;
            this.q.createGradientMatrixU();
            g = this.q.dXYZdparam(this.centered1);
            int n = this.getPosition();
            gradient[n] = gradient[n] + (g[0] * this.diff[0] + g[1] * this.diff[1] + g[2] * this.diff[2]) * der;
            this.q.createGradientMatrixV();
            g = this.q.dXYZdparam(this.centered1);
            int n3 = this.getPosition() + 1;
            gradient[n3] = gradient[n3] + (g[0] * this.diff[0] + g[1] * this.diff[1] + g[2] * this.diff[2]) * der;
            this.q.createGradientMatrixW();
            g = this.q.dXYZdparam(this.centered1);
            int n4 = this.getPosition() + 2;
            gradient[n4] = gradient[n4] + (g[0] * this.diff[0] + g[1] * this.diff[1] + g[2] * this.diff[2]) * der;
            this.q.createGradientMatrixS();
            g = this.q.dXYZdparam(this.centered1);
            int n5 = this.getPosition() + 3;
            gradient[n5] = gradient[n5] + (g[0] * this.diff[0] + g[1] * this.diff[1] + g[2] * this.diff[2]) * der;
            return gradient;
        }

        @Override
        public double[] getVariable(double[] variables) {
            variables[this.getPosition()] = this.q.u;
            variables[this.getPosition() + 1] = this.q.v;
            variables[this.getPosition() + 2] = this.q.w;
            variables[this.getPosition() + 3] = this.q.s;
            return variables;
        }

        @Override
        public void setVariable(double[] var) {
            this.setVariableValueOnly(var);
            for (int i = 0; i < AlignmentMolecule.this.nodes.size(); ++i) {
                Node n = AlignmentMolecule.this.nodes.get(i);
                MolGeom.minusVec(n.getCrd(), AlignmentMolecule.this.center, this.centered1);
                this.q.rotate(this.centered1);
                MolGeom.plusVec(this.centered1, AlignmentMolecule.this.center, n.getCrd());
            }
        }

        @Override
        public void setVariableValueOnly(double[] var) {
            this.q.setParams(var[this.getPosition()], var[this.getPosition() + 1], var[this.getPosition() + 2], var[this.getPosition() + 3]);
            this.q.updateNorm();
            this.q.updateRotationMatrix();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isSmallStep(double[] variables) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class DFEuler
    extends DF3My {
        private RotationByAngles rot;
        private double valueX;
        private double valueY;
        private double valueZ;
        private double[] ubc;
        private double[] vab;
        private double[] ubcXvab;
        private double[] eVec;

        public DFEuler() {
            this.valueX = 0.0;
            this.valueY = 0.0;
            this.valueZ = 0.0;
            this.ubc = new double[3];
            this.vab = new double[3];
            this.ubcXvab = new double[3];
            this.eVec = new double[3];
            this.rot = new EulerRotate();
        }

        @Override
        public double[] gradient(double[] gradient, Interaction a) {
            Node n1 = a.getNode1();
            Node n2 = a.getNode2();
            if (n1.getMolID() != AlignmentMolecule.this.molID && n2.getMolID() != AlignmentMolecule.this.molID || n1.getMolID() == AlignmentMolecule.this.molID && n2.getMolID() == AlignmentMolecule.this.molID) {
                return gradient;
            }
            double der = a.derivateDividedByDist();
            if (der == 0.0) {
                return gradient;
            }
            double[] x1 = n1.getCrd();
            double[] x2 = n2.getCrd();
            if (n1.getMolID() != AlignmentMolecule.this.molID) {
                x1 = n2.getCrd();
                x2 = n1.getCrd();
            }
            MolGeom.minusVec(x1, x2, this.eVec);
            MolGeom.minusVec(x1, AlignmentMolecule.this.center, this.vab);
            this.ubc[0] = 1.0;
            this.ubc[1] = 0.0;
            this.ubc[2] = 0.0;
            MolGeom.getVector3D(this.ubc, this.vab, this.ubcXvab);
            int n = this.getPosition();
            gradient[n] = gradient[n] + MolGeom.dot3D(this.eVec, this.ubcXvab) * der;
            this.ubc[0] = 0.0;
            this.ubc[1] = 1.0;
            this.ubc[2] = 0.0;
            MolGeom.getVector3D(this.ubc, this.vab, this.ubcXvab);
            int n3 = this.getPosition() + 1;
            gradient[n3] = gradient[n3] + MolGeom.dot3D(this.eVec, this.ubcXvab) * der;
            this.ubc[0] = 0.0;
            this.ubc[1] = 0.0;
            this.ubc[2] = 1.0;
            MolGeom.getVector3D(this.ubc, this.vab, this.ubcXvab);
            int n4 = this.getPosition() + 2;
            gradient[n4] = gradient[n4] + MolGeom.dot3D(this.eVec, this.ubcXvab) * der;
            return gradient;
        }

        @Override
        public double[] getVariable(double[] variables) {
            variables[this.getPosition()] = this.valueX;
            variables[this.getPosition() + 1] = this.valueY;
            variables[this.getPosition() + 2] = this.valueZ;
            return variables;
        }

        @Override
        public void setVariable(double[] variables) {
            double ax = MolGeom.dihedralDifference(variables[this.getPosition()], this.valueX);
            double ay = MolGeom.dihedralDifference(variables[this.getPosition() + 1], this.valueY);
            double az = MolGeom.dihedralDifference(variables[this.getPosition() + 2], this.valueZ);
            this.rot.setEulerXYZ(ax, ay, az);
            for (int i = 0; i < AlignmentMolecule.this.nodes.size(); ++i) {
                double[] x = AlignmentMolecule.this.nodes.get(i).getCrd();
                x[0] = x[0] - AlignmentMolecule.this.center[0];
                x[1] = x[1] - AlignmentMolecule.this.center[1];
                x[2] = x[2] - AlignmentMolecule.this.center[2];
                x = this.rot.rotate(x);
                x[0] = x[0] + AlignmentMolecule.this.center[0];
                x[1] = x[1] + AlignmentMolecule.this.center[1];
                x[2] = x[2] + AlignmentMolecule.this.center[2];
            }
            this.setVariableValueOnly(variables);
        }

        @Override
        public void setVariableValueOnly(double[] variables) {
            this.valueX = variables[this.getPosition()];
            this.valueY = variables[this.getPosition() + 1];
            this.valueZ = variables[this.getPosition() + 2];
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isSmallStep(double[] d) {
            double small = Math.PI / 360;
            return MolGeom.dihedralDifference(d[this.getPosition()], this.valueX) < small && MolGeom.dihedralDifference(d[this.getPosition() + 1], this.valueY) < small && MolGeom.dihedralDifference(d[this.getPosition() + 2], this.valueZ) < small;
        }
    }

    class DFTrans
    extends DF3My {
        DFTrans() {
        }

        @Override
        public double[] gradient(double[] gradient, Interaction a) {
            Node n1 = a.getNode1();
            Node n2 = a.getNode2();
            if (n1.getMolID() != AlignmentMolecule.this.molID && n2.getMolID() != AlignmentMolecule.this.molID || n1.getMolID() == AlignmentMolecule.this.molID && n2.getMolID() == AlignmentMolecule.this.molID) {
                return gradient;
            }
            double d = a.derivateDividedByDist();
            if (d == 0.0) {
                return gradient;
            }
            double[] x1 = n1.getCrd();
            double[] x2 = n2.getCrd();
            if (n1.getMolID() != AlignmentMolecule.this.molID) {
                x1 = n2.getCrd();
                x2 = n1.getCrd();
            }
            int n = this.getPosition();
            gradient[n] = gradient[n] + (x1[0] - x2[0]) * d;
            int n3 = this.getPosition() + 1;
            gradient[n3] = gradient[n3] + (x1[1] - x2[1]) * d;
            int n4 = this.getPosition() + 2;
            gradient[n4] = gradient[n4] + (x1[2] - x2[2]) * d;
            return gradient;
        }

        @Override
        public double[] getVariable(double[] variables) {
            variables[this.getPosition()] = AlignmentMolecule.this.center[0];
            variables[this.getPosition() + 1] = AlignmentMolecule.this.center[1];
            variables[this.getPosition() + 2] = AlignmentMolecule.this.center[2];
            return variables;
        }

        @Override
        public void setVariable(double[] variables) {
            double dx = variables[this.getPosition()] - AlignmentMolecule.this.center[0];
            double dy = variables[this.getPosition() + 1] - AlignmentMolecule.this.center[1];
            double dz = variables[this.getPosition() + 2] - AlignmentMolecule.this.center[2];
            for (int i = 0; i < AlignmentMolecule.this.nodes.size(); ++i) {
                double[] x = AlignmentMolecule.this.nodes.get(i).getCrd();
                x[0] = x[0] + dx;
                x[1] = x[1] + dy;
                x[2] = x[2] + dz;
            }
            this.setVariableValueOnly(variables);
        }

        @Override
        public void setVariableValueOnly(double[] variables) {
            AlignmentMolecule.this.center[0] = variables[this.getPosition()];
            AlignmentMolecule.this.center[1] = variables[this.getPosition() + 1];
            AlignmentMolecule.this.center[2] = variables[this.getPosition() + 2];
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isSmallStep(double[] d) {
            double small = 0.05;
            return AlignmentMolecule.this.center[0] - d[this.getPosition()] < small && AlignmentMolecule.this.center[1] - d[this.getPosition() + 1] < small && AlignmentMolecule.this.center[2] - d[this.getPosition() + 2] < small;
        }
    }

    abstract class DF3My
    implements DegreeOfFeedom {
        private int pos = -1;

        DF3My() {
        }

        @Override
        public void setPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public int getPosition() {
            return this.pos;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getMolID() {
            return AlignmentMolecule.this.molID;
        }
    }

    static class Bond
    implements Serializable {
        int atom1;
        int atom2;
        int type;
        double length0;

        public Bond(int atom1, int atom2, int type, double length0) {
            this.atom1 = atom1;
            this.atom2 = atom2;
            this.type = type;
            this.length0 = length0;
        }
    }
}

