/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.FFTest;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.MinMaxDistance;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.NodeSimple;
import chemaxon.marvin.alignment.Pharmacophore3D;
import chemaxon.marvin.alignment.ProximityConstraint;
import chemaxon.marvin.alignment.ProximityConstraintFF;
import chemaxon.marvin.alignment.ProximityPotential;
import chemaxon.marvin.alignment.ProximityPotentialComplex;
import chemaxon.marvin.alignment.ProximityPotentialGauss;
import chemaxon.marvin.alignment.ProximityPotentialSimple;
import chemaxon.marvin.alignment.QuadraticPotential;
import chemaxon.marvin.alignment.RotatableBondDetector;
import chemaxon.marvin.alignment.VanDerWaalsInterface;
import chemaxon.marvin.modelling.geom.Tetrahedron;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.util.ShortestPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class AlignmentMoleculeFactory {
    static final double VDW_SCALE = 1.0;
    static final double RING_CONSTRAINT_WEIGHT = 300.0;
    static final double RING_CONSTRAINT_TOLERANCE = 0.01;
    static final double PROX_WEIGHT = 4.0;
    static final int ROTATABLE_BONDS_IN_RINGS = 4;
    static final int ROTATABLE_RING_SIZE = 8;
    private Molecule resultMolecule;
    private NodeList nodes;
    private AlignmentProperties.NodeType nodeType = AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST;
    private NodeColor color = NodeColor.create(AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES);
    private int flexibleRingRotatableBondCount = 4;
    private int flexibleRingSize = 8;
    private boolean dehidrogenize = true;
    private boolean aromatize = true;
    private boolean removeLonePairs = true;
    private AlignmentProperties.ShapeDescriptorPoints shape = AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER;
    private AlignmentProperties.ProximityPotentialType proximityPotType = AlignmentProperties.ProximityPotentialType.PROX_SIMPLE;
    private boolean generateDistanceRanges = false;
    private boolean createRingCenters = true;
    private int adaptiveBondLimit = 4;
    private ProgressBarInterface progressBar;
    private ForceFieldInterface ffi;

    public byte[] generateData(int molID, Molecule m, boolean enableTranslateAndRotate, boolean flexible) throws AlignmentException {
        AlignmentMolecule am = this.generate(molID, m, enableTranslateAndRotate, flexible);
        return am.toData();
    }

    public ProgressBarInterface getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBarInterface progressBar) {
        this.progressBar = progressBar;
    }

    void setForceFieldPotential(ForceFieldInterface ffi) {
        this.ffi = ffi;
    }

    public AlignmentMolecule generate(int molID, Molecule m, boolean enableTranslateAndRotate, boolean flexible) throws AlignmentException {
        if (this.flexibleRingSize < 4) {
            throw new IllegalArgumentException("Ring size must be >= 4");
        }
        if (m.getDim() != 3) {
            throw new AlignmentException("Molecule is not 3D");
        }
        int[] atomTypes = null;
        String tS = m.getProperty("atomTypes");
        if (tS != null) {
            atomTypes = AlignmentMoleculeFactory.intFromString(tS);
            this.nodeType = AlignmentProperties.NodeType.GAUSS_VOLUME_SIMPLE_FAST;
            this.createRingCenters = true;
            this.shape = AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER;
            this.resultMolecule = m.cloneMolecule();
        } else {
            this.resultMolecule = m.cloneMolecule();
            if (this.dehidrogenize) {
                this.resultMolecule.hydrogenize(false);
            }
            if (this.aromatize) {
                this.resultMolecule.aromatize(1);
            }
            if (this.removeLonePairs) {
                MolGeom.removeLonePairs(this.resultMolecule);
            }
            if (this.ffi != null) {
                this.ffi.init(m);
                double[][] coordinates = this.ffi.optimize();
                MolGeom.putCoordinates(this.resultMolecule, coordinates);
            }
            if (this.color instanceof NodeColor.PharmacophoreColoring) {
                Pharmacophore3D p = new Pharmacophore3D(this.resultMolecule);
                this.resultMolecule = p.getPharmacophore();
                atomTypes = p.getColors();
            } else if (this.color instanceof NodeColor.AtomTypeColoring) {
                atomTypes = new int[this.resultMolecule.getAtomCount()];
                for (int i = 0; i < atomTypes.length; ++i) {
                    atomTypes[i] = this.resultMolecule.getAtom(i).getAtno();
                }
            } else if (this.color instanceof NodeColor.SameColoring) {
                atomTypes = new int[this.resultMolecule.getAtomCount()];
                for (int i = 0; i < atomTypes.length; ++i) {
                    atomTypes[i] = 1;
                }
            } else if (this.color instanceof NodeColor.ExtendedAtomColoring) {
                atomTypes = AlignmentMoleculeFactory.colorByDreidingType(null, this.resultMolecule);
            } else {
                throw new IllegalStateException();
            }
            this.resultMolecule.setProperty("atomTypes", AlignmentMoleculeFactory.intToString(atomTypes));
        }
        double[][] molCrd = MolGeom.getCoordniates(this.resultMolecule);
        if (this.nodeType == AlignmentProperties.NodeType.SIMPLE) {
            this.nodes = new NodeList(this.color);
            for (int i = 0; i < this.resultMolecule.getAtomCount(); ++i) {
                NodeSimple a = new NodeSimple(molID, i, molCrd[i], atomTypes[i], this.resultMolecule.getAtom(i).getAtno());
                double r = PeriodicSystem.getVanDerWaalsRadius(this.resultMolecule.getAtom(i).getAtno());
                a.setVanDerWaalsRadius(r);
                this.nodes.add(a);
            }
        } else {
            int ringcenters = -1;
            if (this.createRingCenters) {
                ringcenters = this.flexibleRingSize;
            }
            this.nodes = GaussianSum.create(molID, this.resultMolecule, molCrd, this.nodeType, atomTypes, this.color, ringcenters);
        }
        int[] shapePoints = null;
        if (this.shape == AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE) {
            shapePoints = AlignmentMoleculeFactory.maxDistanceOnGraph(this.resultMolecule);
        } else if (this.shape == AlignmentProperties.ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER) {
            shapePoints = AlignmentMoleculeFactory.maxDistanceAndCenterOnGraph(this.resultMolecule);
        } else if (this.shape == AlignmentProperties.ShapeDescriptorPoints.MAX_4_DISTANT_POINTS) {
            shapePoints = AlignmentMoleculeFactory.getSel2D(this.resultMolecule);
        } else if (this.shape == AlignmentProperties.ShapeDescriptorPoints.ADAPTIVE) {
            shapePoints = this.adaptiveShapesNodes(this.resultMolecule, this.nodes, this.adaptiveBondLimit);
        }
        if (this.shape != AlignmentProperties.ShapeDescriptorPoints.NOTHING) {
            for (int i = 0; i < shapePoints.length; ++i) {
                Object n = this.nodes.get(shapePoints[i]);
                if (!n.isRealAtom()) {
                    throw new IllegalStateException(n.isRealAtom() + " " + this.color.isShapeLabelled(n.getType()));
                }
                if (this.color.isShapeLabelled(n.getType())) continue;
                int t = this.color.labelWithShape(n.getType());
                n.setType(t);
            }
        }
        this.nodes.initSelectionAndTypes();
        AlignmentMolecule am = null;
        if (!flexible) {
            am = new AlignmentMolecule(this.nodes);
        } else {
            if (this.resultMolecule.getFragCount() > 1) {
                throw new AlignmentException("Molecule with multiple fragments cannot be treated flexible. Please remove fragments leaving only one.");
            }
            try {
                FlexibleMoleculeGenerator flexGen = new FlexibleMoleculeGenerator();
                am = flexGen.generate();
            }
            catch (MolGeom.LinearBondAngleException l) {
                throw new IllegalStateException(l);
            }
        }
        am.extractBondInfo(this.resultMolecule);
        am.initVariables(enableTranslateAndRotate);
        am.createDFIterator();
        am.setMolecule(this.resultMolecule);
        if (this.generateDistanceRanges) {
            double[] mins = null;
            double[] maxs = null;
            Node[] selectedNodes = this.nodes.getSelectedNodes();
            int l = selectedNodes.length * (selectedNodes.length - 1) / 2;
            if (flexible && tS != null && this.resultMolecule.getProperty("mins") != null) {
                mins = AlignmentMoleculeFactory.doubleFromString(this.resultMolecule.getProperty("mins"));
                maxs = AlignmentMoleculeFactory.doubleFromString(this.resultMolecule.getProperty("maxs"));
                if (mins.length != l || maxs.length != l) {
                    throw new IllegalStateException();
                }
            } else if (selectedNodes.length > 0) {
                mins = new double[l];
                maxs = new double[l];
                if (this.progressBar != null) {
                    int max = (int)((double)(selectedNodes.length * (selectedNodes.length - 1)) / 2.0);
                    this.progressBar.setMinimum(0);
                    this.progressBar.setMaximum(max);
                    this.progressBar.start();
                }
                MinMaxDistance mm = new MinMaxDistance();
                mm.setMolecule(am);
                int pos = 0;
                for (int i = 0; i < selectedNodes.length - 1; ++i) {
                    for (int j = i + 1; j < selectedNodes.length; ++j) {
                        mm.resetMap();
                        mm.setNode1(selectedNodes[i]);
                        mm.setNode2(selectedNodes[j]);
                        if (this.progressBar != null) {
                            double max = (double)(selectedNodes.length * (selectedNodes.length - 1)) / 2.0;
                            int progress = (int)((double)pos / max * 100.0);
                            this.progressBar.setProgress(progress);
                        }
                        double rmax = mm.calcMaxDist();
                        double rmin = mm.calcMinDist();
                        if (rmin > rmax) {
                            double d = rmax;
                            rmax = rmin;
                            rmin = d;
                        }
                        mins[pos] = rmin;
                        maxs[pos] = rmax;
                        ++pos;
                    }
                }
                this.resultMolecule.setProperty("mins", AlignmentMoleculeFactory.doubleToString(mins));
                this.resultMolecule.setProperty("maxs", AlignmentMoleculeFactory.doubleToString(maxs));
            }
            if (this.progressBar != null) {
                this.progressBar.stop();
            }
            am.setDistanceData(mins, maxs);
            am.resetToOriginalCoordinates();
            am.updateGaussianProducts();
            am.updateIterator();
            am.updateRingCenters();
            if (!am.isRigid()) {
                FlexibleMolecule fm = (FlexibleMolecule)am;
                fm.updateConstraints();
                fm.updateDihedrals();
            }
        }
        return am;
    }

    private static String intToString(int[] a) {
        String s = "";
        for (int i = 0; i < a.length - 1; ++i) {
            s = s + a[i] + ";";
        }
        s = s + a[a.length - 1];
        return s;
    }

    private static int[] intFromString(String s) {
        String[] a = s.split(";");
        int[] ret = new int[a.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Integer.parseInt(a[i]);
        }
        return ret;
    }

    private static String doubleToString(double[] a) {
        String s = "";
        for (int i = 0; i < a.length - 1; ++i) {
            s = s + a[i] + ";";
        }
        s = s + a[a.length - 1];
        return s;
    }

    private static double[] doubleFromString(String s) {
        String[] a = s.split(";");
        double[] ret = new double[a.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Double.parseDouble(a[i]);
        }
        return ret;
    }

    private int[] adaptiveShapesNodes(Molecule resultMolecule, NodeList nodes, int bondLimit) {
        if (resultMolecule.getAtomCount() != nodes.getRealAtomCount()) {
            throw new IllegalStateException();
        }
        ShortestPath sp = new ShortestPath();
        sp.calculate(resultMolecule);
        BitSet selected = new BitSet();
        BitSet shapeat = new BitSet();
        Node[] sel = nodes.getSelectedNodes();
        if (sel.length == 0) {
            return AlignmentMoleculeFactory.maxDistanceAndCenterOnGraph(resultMolecule);
        }
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i].isRealAtom()) {
                selected.set(sel[i].getFirstAtomSeq(), true);
                continue;
            }
            MultiCenterGaussian mu = (MultiCenterGaussian)sel[i];
            for (int j = 0; j < mu.getMembers().length; ++j) {
                selected.set(mu.getMembers()[j].getFirstAtomSeq(), true);
            }
        }
        int[] path = new int[resultMolecule.getAtomCount()];
        int pos = -1;
        do {
            pos = -1;
            int max = bondLimit;
            for (int i = 0; i < resultMolecule.getAtomCount(); ++i) {
                if (selected.get(i)) continue;
                int minDist = -1;
                for (int j = 0; j < selected.length(); ++j) {
                    if (!selected.get(j)) continue;
                    int l = sp.getPath(i, j, path);
                    if (minDist != -1 && l >= minDist) continue;
                    minDist = l;
                }
                if (max >= minDist) continue;
                max = minDist;
                pos = i;
            }
            if (pos == -1) continue;
            shapeat.set(pos, true);
            selected.set(pos, true);
        } while (pos != -1);
        int[] ret = new int[shapeat.cardinality()];
        int c = 0;
        for (int i = 0; i < shapeat.length(); ++i) {
            if (!shapeat.get(i)) continue;
            ret[c++] = i;
        }
        return ret;
    }

    void setCreateRingCenters(boolean createRingCenters) {
        this.createRingCenters = createRingCenters;
    }

    public boolean isCreateRingCenters() {
        return this.createRingCenters;
    }

    public void setNotSpecCase(AlignmentProperties.ColorNotSpecifiedCase ncase) {
        this.color.setNotSpec(ncase);
    }

    public void setDehidrogenize(boolean dehidrogenize) {
        this.dehidrogenize = dehidrogenize;
    }

    void setShape(AlignmentProperties.ShapeDescriptorPoints shape) {
        this.shape = shape;
    }

    public Molecule getResultMolecule() {
        return this.resultMolecule;
    }

    public void setGenerateDistanceRanges(boolean generateDistanceRanges) {
        this.generateDistanceRanges = generateDistanceRanges;
    }

    public void setAromatize(boolean aromatize) {
        this.aromatize = aromatize;
    }

    void setProximityPotType(AlignmentProperties.ProximityPotentialType proximityPotType) {
        this.proximityPotType = proximityPotType;
    }

    public void setFlexibleRingRotatableBondCount(int rotatableBondsInRings) {
        this.flexibleRingRotatableBondCount = rotatableBondsInRings;
    }

    public void setFlexibleRingSize(int rotatableRingSize) {
        this.flexibleRingSize = rotatableRingSize;
    }

    public void setNodeType(AlignmentProperties.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setColor(AlignmentProperties.ColoringScheme color) {
        this.color = NodeColor.create(color);
    }

    public NodeColor getColor() {
        return this.color;
    }

    void setAdaptiveBondLimit(int adaptiveBondLimit) {
        this.adaptiveBondLimit = adaptiveBondLimit;
    }

    AlignmentProperties.NodeType getNodeType() {
        return this.nodeType;
    }

    int getAdaptiveBondLimit() {
        return this.adaptiveBondLimit;
    }

    public boolean isAromatize() {
        return this.aromatize;
    }

    public boolean isDehidrogenize() {
        return this.dehidrogenize;
    }

    public boolean isGenerateDistanceRanges() {
        return this.generateDistanceRanges;
    }

    AlignmentProperties.ProximityPotentialType getProximityPotType() {
        return this.proximityPotType;
    }

    AlignmentProperties.ShapeDescriptorPoints getShape() {
        return this.shape;
    }

    public int getFlexibleRingRotatableBondCount() {
        return this.flexibleRingRotatableBondCount;
    }

    public int getFlexibleRingSize() {
        return this.flexibleRingSize;
    }

    private static int[] getArrayOfON(Molecule m) {
        ArrayList<Integer> atoms = new ArrayList<Integer>(m.getAtomCount());
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getAtno() != 7 && a.getAtno() != 8) continue;
            atoms.add(new Integer(i));
        }
        int[] atomsToMap = new int[atoms.size()];
        for (int i = 0; i < atomsToMap.length; ++i) {
            atomsToMap[i] = (Integer)atoms.get(i);
        }
        return atomsToMap;
    }

    private static int[] getArrayOf(Molecule m, int every) {
        int[] ret = new int[(int)Math.ceil((double)m.getAtomCount() / (double)every)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = -1;
        }
        int j = 0;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (i % every != 0) continue;
            ret[j++] = i;
        }
        return ret;
    }

    private static int[] colorByAtNo(int[] atoms, Molecule m) {
        int i;
        int[] ret = new int[m.getAtomCount()];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = -1;
        }
        for (i = 0; i < atoms.length; ++i) {
            ret[atoms[i]] = m.getAtom(atoms[i]).getAtno();
        }
        return ret;
    }

    private static int[] colorByDreidingType(int[] atoms, Molecule m) {
        int i;
        Dreiding d = new Dreiding();
        d.setAromatize(false);
        int atomCount = m.getAtomCount();
        m.hydrogenize(true);
        for (int i2 = atomCount; i2 < m.getAtomCount(); ++i2) {
            if ((double)m.getAtom(i2).getAtno() == 1.0) continue;
            throw new IllegalStateException("Explicit H aroms were not added to the end of the atomlist");
        }
        d.calculateAtomTypes(m);
        int l = 0;
        l = atoms != null ? atoms.length : atomCount;
        int[] ret = new int[l];
        for (i = 0; i < l; ++i) {
            ret[i] = -1;
        }
        for (i = 0; i < l; ++i) {
            int pos = i;
            if (atoms != null) {
                pos = atoms[i];
            }
            ret[pos] = d.getDreidingAtomTypeID(pos);
            if (ret[pos] == 61) {
                int n = pos;
                ret[n] = ret[n] + (m.getAtom(pos).getAtno() + 61);
            }
            int n = pos;
            ret[n] = ret[n] + 1;
        }
        while (m.getAtomCount() > atomCount) {
            m.removeAtom(m.getAtomCount() - 1);
        }
        return ret;
    }

    private static int[] colorSame(int[] selectedAtoms, int allAtomCount) {
        int i;
        int[] ret = new int[allAtomCount];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = -1;
        }
        for (i = 0; i < selectedAtoms.length; ++i) {
            ret[selectedAtoms[i]] = 1;
        }
        return ret;
    }

    static int[] maxDistanceOnGraph(Molecule m) {
        ShortestPath sp = new ShortestPath();
        sp.calculate(m);
        int[] ret = new int[2];
        int max = -1;
        for (int i = 0; i < m.getAtomCount() - 1; ++i) {
            for (int j = i + 1; j < m.getAtomCount(); ++j) {
                int curr = sp.minDist(i, j);
                if (max != -1 && curr <= max) continue;
                max = curr;
                ret[0] = i;
                ret[1] = j;
            }
        }
        return ret;
    }

    static int[] maxDistanceAndCenterOnGraph(Molecule m) {
        ShortestPath sp = new ShortestPath();
        sp.calculate(m);
        int[] ret = new int[3];
        int max = -1;
        for (int i = 0; i < m.getAtomCount() - 1; ++i) {
            for (int j = i + 1; j < m.getAtomCount(); ++j) {
                int curr = sp.minDist(i, j);
                if (max != -1 && curr <= max) continue;
                max = curr;
                ret[0] = i;
                ret[1] = j;
            }
        }
        int[] path = new int[m.getAtomCount()];
        int pathLen = sp.getPath(ret[0], ret[1], path);
        ret[2] = path[pathLen / 2];
        return ret;
    }

    private static int[] getSel2D(Molecule m) {
        AtomSelection2D q = new AtomSelection2D(m);
        return q.getSelected();
    }

    private static int[] getSel3D(Molecule m) {
        Tetrahedron t = new Tetrahedron(MolGeom.getCoordniates(m));
        int l = 2;
        if (t.getA3() != -1) {
            ++l;
            if (t.getA4() != -1) {
                ++l;
            }
        }
        int[] ret = new int[l];
        ret[0] = t.getA1();
        ret[1] = t.getA2();
        if (t.getA3() != -1) {
            ret[2] = t.getA3();
            if (t.getA4() != -1) {
                ret[3] = t.getA4();
            }
        }
        return ret;
    }

    public static interface ProgressBarInterface {
        public void start();

        public void stop();

        public void setProgress(int var1);

        public void setMessage(String var1);

        public void setMinimum(int var1);

        public void setMaximum(int var1);
    }

    private class FlexibleMoleculeGenerator {
        private ArrayList<MolecularConstraint> ringConstraints;
        private ArrayList<Dihedral> dihedrals;
        private int[][] ctab;
        private BondTable btab;
        private RotatableBondDetector rota;
        private BitSet rotatableBonds = new BitSet();
        private int[][] sssri;
        private RingProp[] ringP;
        private BitSet nonDeletables;
        private int[][] btabForDihedrals;

        private FlexibleMoleculeGenerator() {
        }

        private boolean isAtomSeq(int a) {
            return a >= 0 && a < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount();
        }

        private BitSet markMemberOfAMulMultiCenter(GaussianSum gs) {
            BitSet ret = new BitSet();
            for (int i = 0; i < gs.size(); ++i) {
                if (!(gs.get(i) instanceof MultiCenterGaussian)) continue;
                AtomicGaussian[] a = ((MultiCenterGaussian)gs.get(i)).getMembers();
                for (int j = 0; j < a.length - 1; ++j) {
                    int bj = a[j].getFirstAtomSeq();
                    for (int k = j + 1; k < a.length; ++k) {
                        int bk = a[k].getFirstAtomSeq();
                        int bondIndex = this.btab.getBondIndex(bj, bk);
                        int ci = -1;
                        if (bondIndex > -1) {
                            ret.set(bondIndex, true);
                            continue;
                        }
                        ci = this.commonNeihgbor(bj, bk);
                        if (ci == -1) continue;
                        ret.set(this.btab.getBondIndex(bj, ci), true);
                        ret.set(this.btab.getBondIndex(bk, ci), true);
                    }
                }
            }
            return ret;
        }

        private int commonNeihgbor(int i, int j) {
            for (int k = 0; k < this.ctab[i].length; ++k) {
                for (int l = 0; l < this.ctab[j].length; ++l) {
                    if (this.ctab[i][k] != this.ctab[j][l]) continue;
                    return this.ctab[i][k];
                }
            }
            return -1;
        }

        public AlignmentMolecule generate() throws MolGeom.LinearBondAngleException, AlignmentException {
            int c;
            int b;
            this.ringConstraints = new ArrayList();
            this.dihedrals = new ArrayList();
            this.btab = BondTable.cloneBondTable(AlignmentMoleculeFactory.this.resultMolecule.getBondTable());
            this.ctab = MolGeom.arrayCopy(AlignmentMoleculeFactory.this.resultMolecule.getCtab());
            this.rota = new RotatableBondDetector(AlignmentMoleculeFactory.this.resultMolecule);
            this.btabForDihedrals = new int[AlignmentMoleculeFactory.this.resultMolecule.getAtomCount()][AlignmentMoleculeFactory.this.resultMolecule.getAtomCount()];
            for (int i = 0; i < this.btabForDihedrals.length; ++i) {
                Arrays.fill(this.btabForDihedrals[i], -1);
            }
            TopologyAnalyser top = new TopologyAnalyser();
            top.setLicenseEnvironment("3D Alignment");
            top.setMolecule(AlignmentMoleculeFactory.this.resultMolecule, 1);
            this.rotatableBonds.clear();
            for (b = 0; b < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount() - 1; ++b) {
                for (c = b + 1; c < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount(); ++c) {
                    this.calcRotatableBond(b, c);
                }
            }
            if (this.rotatableBonds.cardinality() > 0) {
                this.setUpTweakableRings();
                if (this.rotatableBonds.cardinality() > 0) {
                    for (b = 0; b < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount() - 1; ++b) {
                        for (c = b + 1; c < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount(); ++c) {
                            int pos;
                            if (this.btab.getBondIndex(b, c) < 0 || !this.isRotatableBond(b, c)) continue;
                            BitSet rotC = this.getAtomsToRotate(b, c);
                            BitSet rotB = this.getAtomsToRotate(c, b);
                            int bb = this.getNeigh(b, c);
                            int cc = this.getNeigh(c, b);
                            if (bb == -1 || cc == -1) continue;
                            if (!(this.isAtomSeq(bb) && this.isAtomSeq(b) && this.isAtomSeq(c) && this.isAtomSeq(cc))) {
                                throw new IllegalStateException();
                            }
                            if (rotC.cardinality() + rotB.cardinality() + 2 != AlignmentMoleculeFactory.this.resultMolecule.getAtomCount()) {
                                System.err.println("b: " + b + " c: " + c);
                                System.err.println("rotB: " + rotB);
                                System.err.println("rotC: " + rotC);
                                throw new IllegalStateException();
                            }
                            if (rotB.cardinality() <= 0 || rotC.cardinality() <= 0) continue;
                            this.tryToAddRingCentersTo(rotB, b);
                            this.tryToAddRingCentersTo(rotC, c);
                            Dihedral d = new Dihedral(bb, b, c, cc, rotB, rotC, AlignmentMoleculeFactory.this.nodes, 2);
                            d.setDisableForRandomize(top.isRingBond(this.btab.getBondIndex(b, c)));
                            this.dihedrals.add(d);
                            this.btabForDihedrals[b][c] = pos = this.dihedrals.size() - 1;
                            this.btabForDihedrals[c][b] = pos;
                        }
                    }
                }
            }
            if (AlignmentMoleculeFactory.this.ffi != null && AlignmentMoleculeFactory.this.ffi instanceof FFTest) {
                FFTest fft = (FFTest)AlignmentMoleculeFactory.this.ffi;
                fft.setDihedrals(this.dihedrals);
            }
            this.checkFlexiblePathInMultiCenterBonds();
            AlignmentMolecule ret = null;
            if (this.dihedrals.isEmpty()) {
                ret = new AlignmentMolecule(AlignmentMoleculeFactory.this.nodes);
            } else {
                FlexibleMolecule f = new FlexibleMolecule(AlignmentMoleculeFactory.this.nodes, this.dihedrals, this.ringConstraints, this.btabForDihedrals);
                this.setUpProxy(f);
                ret = f;
            }
            return ret;
        }

        private void tryToAddRingCentersTo(BitSet b, int bat) {
            int start;
            if (!(AlignmentMoleculeFactory.this.nodes instanceof GaussianSum)) {
                return;
            }
            BitSet tmp = new BitSet();
            GaussianSum gs = (GaussianSum)AlignmentMoleculeFactory.this.nodes;
            for (int i = start = gs.size() - gs.getMulticenterNodeCount(); i < gs.size(); ++i) {
                tmp.clear();
                MultiCenterGaussian mu = (MultiCenterGaussian)gs.get(i);
                mu.markAtoms(tmp);
                int atomCount = tmp.cardinality();
                tmp.and(b);
                if (tmp.cardinality() == atomCount) {
                    b.set(i);
                    continue;
                }
                if (tmp.cardinality() == 0) continue;
                tmp.set(bat);
                if (tmp.cardinality() != atomCount) {
                    System.err.println(tmp);
                    System.err.println(mu.toString());
                    throw new IllegalStateException("Ring node members are tweaked");
                }
                b.set(i);
                b.set(mu.getFirstAtomSeq(), true);
            }
        }

        public ArrayList<MolecularConstraint> getRingConstraints() {
            return this.ringConstraints;
        }

        private int getNeigh(int i, int not) {
            for (int j = 0; j < this.ctab[i].length; ++j) {
                if (this.ctab[i][j] == not || this.btab.getBondIndex(i, this.ctab[i][j]) == -2) continue;
                return this.ctab[i][j];
            }
            return -1;
        }

        private void traverseOnBonds(int atom, BitSet visited) {
            for (int i = 0; i < this.ctab[atom].length; ++i) {
                int neigh;
                if (this.btab.getBondIndex(atom, this.ctab[atom][i]) == -2 || visited.get(neigh = this.ctab[atom][i])) continue;
                visited.set(neigh, true);
                this.traverseOnBonds(neigh, visited);
            }
        }

        private void checkFlexiblePathInMultiCenterBonds() {
            for (int i = 0; i < AlignmentMoleculeFactory.this.nodes.size() - 1; ++i) {
                if (!(this.getNode(i) instanceof MultiCenterGaussian)) continue;
                AtomicGaussian[] a = ((MultiCenterGaussian)this.getNode(i)).getMembers();
                for (int j = 0; j < a.length - 1; ++j) {
                    for (int k = j + 1; k < a.length; ++k) {
                        int pos = this.btab.getBondIndex(a[j].getFirstAtomSeq(), a[k].getFirstAtomSeq());
                        if (pos <= -1 || !this.rotatableBonds.get(pos)) continue;
                        throw new IllegalStateException("Flexible path found at multicenter bonds");
                    }
                }
            }
        }

        private BitSet getAtomsToRotate(int atom2, int atom3) {
            BitSet visited = new BitSet(AlignmentMoleculeFactory.this.resultMolecule.getAtomCount());
            visited.set(atom2, true);
            visited.set(atom3, true);
            this.traverseOnBonds(atom3, visited);
            visited.set(atom2, false);
            visited.set(atom3, false);
            return visited;
        }

        public boolean isRotatableBond(int a1, int a2) {
            return this.rotatableBonds.get(this.btab.getBondIndex(a1, a2));
        }

        private void calcRotatableBond(int a1, int a2) {
            int b = this.btab.getBondIndex(a1, a2);
            if (b == -1) {
                return;
            }
            this.rotatableBonds.set(b, this.rota.isRotatableBond(b));
        }

        private Node getNode(int i) {
            return AlignmentMoleculeFactory.this.nodes.get(i);
        }

        void setUpProxy(FlexibleMolecule fm) {
            int i;
            if (this.dihedrals.isEmpty() || AlignmentMoleculeFactory.this.proximityPotType == AlignmentProperties.ProximityPotentialType.NONE) {
                return;
            }
            if (AlignmentMoleculeFactory.this.ffi == null) {
                ProximityPotential pot = null;
                if (AlignmentMoleculeFactory.this.proximityPotType == AlignmentProperties.ProximityPotentialType.PROX_COMPLEX) {
                    pot = new ProximityPotentialComplex();
                }
                if (AlignmentMoleculeFactory.this.proximityPotType == AlignmentProperties.ProximityPotentialType.PROX_SIMPLE) {
                    pot = new ProximityPotentialSimple(4.0);
                }
                if (AlignmentMoleculeFactory.this.proximityPotType == AlignmentProperties.ProximityPotentialType.PROX_GAUSS) {
                    pot = new ProximityPotentialGauss(4.0);
                }
                fm.setProximityConstraint(new ProximityConstraint<ProximityPotentialComplex>((ProximityPotentialComplex)pot));
            } else {
                fm.setProximityConstraint(new ProximityConstraintFF(AlignmentMoleculeFactory.this.ffi));
                fm.addForceFieldPotentialToDihedrals();
            }
            ArrayList<Node[]> vec = new ArrayList<Node[]>(AlignmentMoleculeFactory.this.nodes.getRealAtomCount() * AlignmentMoleculeFactory.this.nodes.getRealAtomCount());
            ArrayList<Node[]> vecSel = new ArrayList<Node[]>(AlignmentMoleculeFactory.this.nodes.getRealAtomCount() * AlignmentMoleculeFactory.this.nodes.getRealAtomCount());
            int[] path = new int[AlignmentMoleculeFactory.this.resultMolecule.getAtomCount() + 1];
            ShortestPath sp = new ShortestPath();
            sp.setNNodes(AlignmentMoleculeFactory.this.resultMolecule.getAtomCount());
            sp.calculate(this.btab);
            ShortestPath rigidPath = new ShortestPath();
            BondTable rigidBtab = BondTable.cloneBondTable(this.btab);
            for (i = 0; i < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount(); ++i) {
                for (int j = 0; j < AlignmentMoleculeFactory.this.resultMolecule.getAtomCount(); ++j) {
                    int bond = this.btab.getBondIndex(i, j);
                    if (bond < 0 || !this.rotatableBonds.get(bond)) continue;
                    rigidBtab.setBondIndex(i, j, -1);
                }
            }
            rigidPath.setNNodes(AlignmentMoleculeFactory.this.resultMolecule.getAtomCount());
            rigidPath.calculate(rigidBtab);
            for (i = 0; i < AlignmentMoleculeFactory.this.nodes.size() - 1; ++i) {
                Node n1 = this.getNode(i);
                if (!(n1 instanceof VanDerWaalsInterface)) continue;
                for (int j = i + 1; j < AlignmentMoleculeFactory.this.nodes.size(); ++j) {
                    int pathLenRigid;
                    Node n2 = this.getNode(j);
                    if (!(n2 instanceof VanDerWaalsInterface)) continue;
                    int atom1 = -1;
                    if (n1.isRealAtom()) {
                        atom1 = n1.getFirstAtomSeq();
                    }
                    int atom2 = -1;
                    if (n2.isRealAtom()) {
                        atom2 = n2.getFirstAtomSeq();
                    }
                    int pathLen = -1;
                    if (atom1 != -1 && atom2 != -1 && !(n1 instanceof MultiCenterGaussian) && !(n2 instanceof MultiCenterGaussian)) {
                        if (this.btab.getBondIndex(atom1, atom2) != -1) continue;
                        pathLen = sp.getPath(atom1, atom2, path);
                    } else if (n1 instanceof MultiCenterGaussian && n2 instanceof AtomicGaussian) {
                        MultiCenterGaussian mu = (MultiCenterGaussian)n1;
                        for (int k = 0; k < mu.getMembers().length; ++k) {
                            AtomicGaussian atomicGaussian = mu.getMembers()[k];
                            int curr = sp.getPath(atomicGaussian.getFirstAtomSeq(), atom2, path);
                            if (pathLen != -1 && curr >= pathLen) continue;
                            pathLen = curr;
                            atom1 = atomicGaussian.getFirstAtomSeq();
                        }
                    } else if (n2 instanceof MultiCenterGaussian && n1 instanceof AtomicGaussian) {
                        MultiCenterGaussian mu = (MultiCenterGaussian)n2;
                        for (int k = 0; k < mu.getMembers().length; ++k) {
                            AtomicGaussian atomicGaussian = mu.getMembers()[k];
                            int curr = sp.getPath(atomicGaussian.getFirstAtomSeq(), atom1, path);
                            if (pathLen != -1 && curr >= pathLen) continue;
                            pathLen = curr;
                            atom2 = atomicGaussian.getFirstAtomSeq();
                        }
                    } else if (n1 instanceof MultiCenterGaussian && n2 instanceof MultiCenterGaussian) {
                        MultiCenterGaussian mu1 = (MultiCenterGaussian)n1;
                        MultiCenterGaussian mu2 = (MultiCenterGaussian)n2;
                        for (int k1 = 0; k1 < mu1.getMembers().length; ++k1) {
                            AtomicGaussian atomicGaussian1 = mu1.getMembers()[k1];
                            for (int k2 = 0; k2 < mu2.getMembers().length; ++k2) {
                                AtomicGaussian atomicGaussian2 = mu2.getMembers()[k2];
                                int curr = sp.getPath(atomicGaussian1.getFirstAtomSeq(), atomicGaussian2.getFirstAtomSeq(), path);
                                if (pathLen != -1 && curr >= pathLen) continue;
                                pathLen = curr;
                                atom1 = atomicGaussian1.getFirstAtomSeq();
                                atom2 = atomicGaussian2.getFirstAtomSeq();
                            }
                        }
                    }
                    if (pathLen <= 3 || (pathLenRigid = rigidPath.getPath(atom1, atom2, path)) != 1 || atom1 == atom2) continue;
                    if (n1.isSelected() && n2.isSelected()) {
                        vecSel.add(new Node[]{n1, n2});
                    }
                    if (n1 instanceof MultiCenterGaussian || n2 instanceof MultiCenterGaussian) continue;
                    vec.add(new Node[]{n1, n2});
                    if (n1 instanceof MolecularGaussianProduct) {
                        throw new IllegalStateException("Proximity cannot exist on atommic product.");
                    }
                    if (!(n2 instanceof MolecularGaussianProduct)) continue;
                    throw new IllegalStateException("Proximity cannot exist on atommic product.");
                }
            }
            fm.setProximityEnabledNodes((Node[][])vec.toArray((T[])new Node[vec.size()][]));
            fm.setProximityEnabledNodesSelected((Node[][])vecSel.toArray((T[])new Node[vecSel.size()][]));
        }

        private void setUpTweakableRings() {
            int i;
            int[][] sssr;
            if (AlignmentMoleculeFactory.this.nodes instanceof GaussianSum) {
                this.nonDeletables = this.markMemberOfAMulMultiCenter((GaussianSum)AlignmentMoleculeFactory.this.nodes);
            }
            if ((sssr = AlignmentMoleculeFactory.this.resultMolecule.getSSSR()).length == 0) {
                return;
            }
            this.sssri = AlignmentMoleculeFactory.this.resultMolecule.getSSSRIdxesForAtoms();
            this.ringP = new RingProp[sssr.length];
            boolean changed = true;
            while (changed) {
                changed = false;
                for (i = 0; !(i >= sssr.length || sssr[i].length <= AlignmentMoleculeFactory.this.flexibleRingSize && (changed = this.markTheseBondsRigid(sssr[i]))); ++i) {
                }
            }
            if (this.rotatableBonds.cardinality() == 0) {
                return;
            }
            changed = true;
            block2: while (changed) {
                changed = false;
                for (i = 0; i < sssr.length; ++i) {
                    int bondCount = sssr[i].length;
                    this.ringP[i] = null;
                    int rotBondcount = 0;
                    int deletableCount = 0;
                    for (int j = 0; j < bondCount; ++j) {
                        int a2;
                        int a1 = sssr[i][j];
                        int j2 = j + 1;
                        if (j2 == bondCount) {
                            j2 = 0;
                        }
                        if (this.deletable(a1, a2 = sssr[i][j2])) {
                            ++deletableCount;
                        }
                        if (!this.isRotatableBond(a1, a2)) continue;
                        ++rotBondcount;
                    }
                    if (deletableCount == 0 && (changed = this.markTheseBondsRigid(sssr[i]))) continue block2;
                    if (rotBondcount > AlignmentMoleculeFactory.this.flexibleRingRotatableBondCount) {
                        this.ringP[i] = new RingProp(rotBondcount, deletableCount, sssr[i]);
                        continue;
                    }
                    changed = this.markTheseBondsRigid(sssr[i]);
                    if (changed) continue block2;
                }
            }
            for (i = 0; i < this.ringP.length; ++i) {
                if (this.ringP[i] == null) continue;
                this.ringP[i].substituteBondWithConstr();
            }
        }

        private boolean markTheseBondsRigid(int[] a) {
            boolean ret = false;
            for (int i = 0; i < a.length; ++i) {
                int a2;
                int a1 = a[i];
                int j = i + 1;
                if (j == a.length) {
                    j = 0;
                }
                if (this.rotatableBonds.get(this.btab.getBondIndex(a1, a2 = a[j]))) {
                    ret = true;
                }
                this.rotatableBonds.set(this.btab.getBondIndex(a1, a2), false);
            }
            return ret;
        }

        private boolean deletable(int at1, int at2) {
            if (this.nonDeletables != null && this.nonDeletables.get(this.btab.getBondIndex(at1, at2))) {
                return false;
            }
            int[] a1 = this.sssri[at1];
            int[] a2 = this.sssri[at2];
            int found = 0;
            for (int i = 0; i < a1.length; ++i) {
                for (int j = 0; j < a2.length; ++j) {
                    if (a1[i] != a2[j] || ++found != 2) continue;
                    return false;
                }
            }
            return true;
        }

        private class RingProp {
            int deletedBondAtom1 = -1;
            int deletedBondAtom2 = -1;
            int rotatableBondCount;
            int deletableBondCount;
            int btabOfDeleted;
            int[] atoms;

            public RingProp(int rotatableBondCount, int deletableBondCount, int[] atoms) {
                this.rotatableBondCount = rotatableBondCount;
                this.deletableBondCount = deletableBondCount;
                this.atoms = atoms;
            }

            void substituteBondWithConstr() {
                int i;
                int minInd = -1;
                int minVal = -1;
                for (int j = 0; j < this.atoms.length; ++j) {
                    int a1 = this.atoms[j];
                    int j2 = j + 1;
                    if (j2 == this.atoms.length) {
                        j2 = 0;
                    }
                    int a2 = this.atoms[j2];
                    int c = FlexibleMoleculeGenerator.this.ctab[a1].length + FlexibleMoleculeGenerator.this.ctab[a2].length;
                    if (!FlexibleMoleculeGenerator.this.deletable(a1, a2) || minVal != -1 && c >= minVal) continue;
                    minVal = c;
                    minInd = j;
                }
                if (minInd == -1) {
                    throw new IllegalStateException();
                }
                int a1 = this.atoms[minInd];
                int j2 = minInd + 1;
                if (j2 == this.atoms.length) {
                    j2 = 0;
                }
                int a2 = this.atoms[j2];
                this.deletedBondAtom1 = a1;
                this.deletedBondAtom2 = a2;
                this.btabOfDeleted = FlexibleMoleculeGenerator.this.btab.getBondIndex(a1, a2);
                this.createRingConstr(a1, a2);
                for (i = 0; i < FlexibleMoleculeGenerator.this.ctab[a1].length; ++i) {
                    if (FlexibleMoleculeGenerator.this.ctab[a1][i] == a2) continue;
                    this.createRingConstr(a2, FlexibleMoleculeGenerator.this.ctab[a1][i]);
                }
                for (i = 0; i < FlexibleMoleculeGenerator.this.ctab[a2].length; ++i) {
                    if (FlexibleMoleculeGenerator.this.ctab[a2][i] == a1) continue;
                    this.createRingConstr(a1, FlexibleMoleculeGenerator.this.ctab[a2][i]);
                }
            }

            private void createRingConstr(int atom1, int atom2) {
                Object n1 = AlignmentMoleculeFactory.this.nodes.get(atom1);
                Object n2 = AlignmentMoleculeFactory.this.nodes.get(atom2);
                if (!n1.isRealAtom() || !n2.isRealAtom()) {
                    throw new IllegalStateException();
                }
                if (n1.getFirstAtomSeq() != atom1) {
                    throw new IllegalStateException("Atom 1 mismatch at ringconstr");
                }
                if (n2.getFirstAtomSeq() != atom2) {
                    throw new IllegalStateException("Atom 2 mismatch at ringconstr");
                }
                double r0 = MolGeom.getLength(n1.getCrd(), n2.getCrd());
                MolecularConstraint mc = new MolecularConstraint((Node)n1, (Node)n2, new QuadraticPotential(r0, 300.0, 0.01));
                FlexibleMoleculeGenerator.this.ringConstraints.add(mc);
                FlexibleMoleculeGenerator.this.btab.setBondIndex(atom1, atom2, -2);
                FlexibleMoleculeGenerator.this.btab.setBondIndex(atom2, atom1, -2);
            }
        }
    }

    private static class AtomSelection2D {
        private int[] selected;
        private BitSet deny;
        private ShortestPath sp;
        private int[] path;
        private int THR = 4;

        AtomSelection2D(Molecule m) {
            if (m.getAtomCount() < 4) {
                this.selected = new int[m.getAtomCount()];
                for (int i = 0; i < this.selected.length; ++i) {
                    this.selected[i] = i;
                }
                return;
            }
            this.sp = new ShortestPath();
            this.sp.calculate(m);
            int maxD = -1;
            int[] tmp = new int[4];
            int tmpLength = 0;
            this.path = new int[m.getAtomCount()];
            int[][] distmx = new int[m.getAtomCount()][m.getAtomCount()];
            for (int i = 0; i < distmx.length - 1; ++i) {
                for (int j = i + 1; j < distmx.length; ++j) {
                    distmx[i][j] = this.sp.minDist(i, j);
                    distmx[j][i] = distmx[i][j];
                    if (maxD != -1 && distmx[i][j] <= maxD) continue;
                    maxD = distmx[i][j];
                    tmp[0] = i;
                    tmp[1] = j;
                    tmpLength = 2;
                }
            }
            this.deny = new BitSet(m.getAtomCount());
            this.deny(tmp[0], tmp[1]);
            int maxOfMins = -1;
            do {
                int i;
                maxOfMins = -1;
                int maxPos = -1;
                for (i = 0; i < m.getAtomCount(); ++i) {
                    if (this.deny.get(i)) continue;
                    int min = -1;
                    for (int j = 0; j < m.getAtomCount(); ++j) {
                        if (!this.deny.get(j) || min != -1 && distmx[i][j] >= min) continue;
                        min = distmx[i][j];
                    }
                    if (min == -1 || maxOfMins != -1 && maxOfMins >= min) continue;
                    maxOfMins = min;
                    maxPos = i;
                }
                if (maxOfMins < this.THR) {
                    maxOfMins = -1;
                }
                if (maxOfMins == -1) continue;
                for (i = 0; i < tmpLength; ++i) {
                    this.deny(tmp[i], maxPos);
                }
                tmp[tmpLength++] = maxPos;
            } while (maxOfMins != -1 && tmpLength < 4);
            this.selected = new int[tmpLength];
            System.arraycopy(tmp, 0, this.selected, 0, tmpLength);
        }

        private void deny(int a1, int a2) {
            int pathLen = this.sp.getPath(a1, a2, this.path);
            for (int i = 0; i < pathLen; ++i) {
                this.deny.set(this.path[i], true);
            }
        }

        public int[] getSelected() {
            return this.selected;
        }
    }
}

