/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import java.io.Serializable;

public enum AlignmentProperties implements Serializable
{
    GAUSS_44_SAME(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.SAME, NodeType.GAUSS_VOLUME_SIMPLE_44, OrientationType.SIMPLE, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false),
    GAUSS_FAST_EXTENDED_ATOMTYPE(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.EXTENDED_ATOMTYPES, NodeType.GAUSS_VOLUME_SIMPLE_FAST, OrientationType.SIMPLE, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false),
    GAUSS_FAST_SHAPE_ONLY(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.SAME, NodeType.GAUSS_VOLUME_SIMPLE_FAST, OrientationType.SIMPLE, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false),
    GAUSS_FAST_PHARMACOPHORE(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.PHARMACOPHORE, NodeType.GAUSS_VOLUME_SIMPLE_FAST, OrientationType.SIMPLE, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false),
    PAIRED(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.EXTENDED_ATOMTYPES, NodeType.SIMPLE, OrientationType.ALIGN_AS_IS, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false),
    GAUSS_FAST_EXTENDED_ATOMTYPE_MCS(ProximityPotentialType.PROX_SIMPLE, ColorNotSpecifiedCase.ACCEPT_ONLY_SAME, ColoringScheme.EXTENDED_ATOMTYPES, NodeType.GAUSS_VOLUME_SIMPLE_FAST, OrientationType.MCS, ShapeDescriptorPoints.MAX_DISTANCE_WITH_CENTER, false);

    private boolean distancerangeSet;
    private ProximityPotentialType proxy;
    private ColorNotSpecifiedCase notSpec;
    private ColoringScheme color;
    private NodeType type;
    private OrientationType orientation;
    private ShapeDescriptorPoints shape;

    private AlignmentProperties(ProximityPotentialType pr, ColorNotSpecifiedCase notSpec, ColoringScheme color, NodeType type, OrientationType orientation, ShapeDescriptorPoints shape, boolean distancerangeSet) {
        this.notSpec = notSpec;
        this.color = color;
        this.type = type;
        this.orientation = orientation;
        this.shape = shape;
        this.distancerangeSet = distancerangeSet;
        this.proxy = pr;
    }

    public ColoringScheme getColor() {
        return this.color;
    }

    public boolean isDistancerangeSet() {
        return this.distancerangeSet;
    }

    public ColorNotSpecifiedCase getNotSpec() {
        return this.notSpec;
    }

    public OrientationType getOrientation() {
        return this.orientation;
    }

    ProximityPotentialType getProxy() {
        return this.proxy;
    }

    ShapeDescriptorPoints getShape() {
        return this.shape;
    }

    NodeType getType() {
        return this.type;
    }

    static enum ShapeDescriptorPoints implements Serializable
    {
        MAX_DISTANCE,
        MAX_DISTANCE_WITH_CENTER,
        MAX_4_DISTANT_POINTS,
        NOTHING,
        ADAPTIVE;

    }

    public static enum NodeType implements Serializable
    {
        SIMPLE(false),
        GAUSS_VOLUME_SIMPLE_FULL(true),
        GAUSS_VOLUME_SIMPLE_FAST(true),
        GAUSS_VOLUME_SIMPLE_45(true),
        GAUSS_VOLUME_SIMPLE_44(true),
        MODEL_NODE(false);

        private final boolean gaussLike;

        private NodeType(boolean gaussLike) {
            this.gaussLike = gaussLike;
        }

        public boolean isGaussLike() {
            return this.gaussLike;
        }
    }

    public static enum OrientationType implements Serializable
    {
        MCS,
        SIMPLE,
        ALIGN_AS_IS;

    }

    public static enum ColoringScheme implements Serializable
    {
        SAME,
        ATOM_TYPES,
        EXTENDED_ATOMTYPES,
        PHARMACOPHORE;

    }

    public static enum ColorNotSpecifiedCase {
        ACCEPT_ONLY_SAME,
        DENY_IF_NOT_SPECIFIED,
        EVERY_WEIGHT_IS_ONE;

    }

    static enum ProximityPotentialType implements Serializable
    {
        PROX_SIMPLE,
        PROX_COMPLEX,
        PROX_GAUSS,
        NONE;

    }
}

