/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

public abstract class Backtracking {
    public static final long DEFAULT_STEP_LIMIT = Long.MAX_VALUE;
    private long stepCountLimit = Long.MAX_VALUE;
    private long stepCount = 0L;
    private boolean stepCountLimitReached = false;
    private boolean partialSolutionAllowed = false;
    private int partialSolutionLowerBound = 1;
    private int problemSize = 0;
    private int[] baseNumber = null;
    private int[] state = null;
    private boolean carry = false;
    private int pos = 0;

    public Backtracking(int problemSize, int[] baseNumber) {
        this.problemSize = problemSize;
        this.baseNumber = baseNumber;
        this.state = new int[problemSize];
    }

    public Backtracking(int problemSize) {
        this(problemSize, null);
        this.baseNumber = new int[problemSize];
        for (int i = 0; i < this.baseNumber.length; ++i) {
            this.baseNumber[i] = problemSize;
        }
    }

    public void setAllowPartialSolution(boolean allow) {
        this.partialSolutionAllowed = allow;
    }

    public void setPartialSolutionLowerBound(int lowerBound) {
        this.partialSolutionLowerBound = lowerBound;
    }

    protected abstract void processBeforeNext();

    protected abstract void processAfterNext();

    public void setStepCountLimit(long maxNumberOfSteps) {
        this.stepCountLimit = maxNumberOfSteps;
    }

    public boolean isStepCountLimitReached() {
        return this.stepCountLimitReached;
    }

    public boolean findFirst() {
        this.init();
        this.carry = false;
        this.pos = 0;
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            if (this.stepCountLimitReached) {
                return false;
            }
            this.next();
        }
        return !this.carry;
    }

    public boolean findNext() {
        if (this.stepCountLimitReached) {
            return false;
        }
        if (!this.carry) {
            this.next();
        }
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            if (this.stepCount > this.stepCountLimit) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public int getPos() {
        return this.pos;
    }

    public int getValue() {
        return this.state[this.pos];
    }

    public int getValue(int atPos) {
        return this.state[atPos];
    }

    public int[] getValues() {
        return this.state;
    }

    public int getBaseNumber(int atPos) {
        return this.baseNumber[atPos];
    }

    public boolean isMaxValueAtPos(int atPos) {
        return this.state[atPos] == this.baseNumber[atPos] - 1;
    }

    public double getComplexity() {
        double complexity = 1.0;
        for (int i = 0; i < this.problemSize; ++i) {
            complexity *= (double)this.baseNumber[i];
        }
        return complexity;
    }

    public void dump() {
        int i;
        System.out.println("--> Backtracking.dump()");
        System.out.println("partialSolutionAllowed =" + this.partialSolutionAllowed);
        System.out.println("partialSolutionLowerBound =" + this.partialSolutionLowerBound);
        System.out.println("problemSize =" + this.problemSize);
        System.out.print("baseNumber=[");
        for (i = 0; i < this.baseNumber.length; ++i) {
            System.out.print(this.baseNumber[i] + ", ");
        }
        System.out.println("]");
        System.out.print("state=[");
        for (i = 0; i < this.state.length; ++i) {
            System.out.print(this.state[i] + ", ");
        }
        System.out.println("]");
        System.out.println("carry =" + this.carry);
        System.out.println("pos = " + this.pos);
        System.out.println("<-- Backtracking.dump()");
    }

    private boolean find() {
        while (this.pos != this.problemSize) {
            if (!this.good()) {
                return false;
            }
            if (++this.stepCount > this.stepCountLimit) {
                this.stepCountLimitReached = true;
                return false;
            }
            if (this.partialSolutionAllowed && this.pos >= this.partialSolutionLowerBound) {
                return true;
            }
            ++this.pos;
        }
        --this.pos;
        return true;
    }

    private void next() {
        while (true) {
            this.processBeforeNext();
            if (this.state[this.pos] < this.baseNumber[this.pos] - 1) {
                int n = this.pos;
                this.state[n] = this.state[n] + 1;
                this.carry = false;
                return;
            }
            if (this.pos == 0) {
                this.carry = true;
                return;
            }
            this.state[this.pos--] = 0;
            this.processAfterNext();
        }
    }

    private void init() {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = 0;
        }
        this.stepCountLimitReached = false;
    }

    public void reset() {
        this.init();
        this.pos = 0;
        this.stepCount = 0L;
    }

    protected abstract boolean good();
}

