/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

class BowlFunction {
    double weight;
    double hAbs;

    public BowlFunction(double weight, double h) {
        this.weight = weight;
        this.hAbs = h;
    }

    double function(double x, double r0, boolean increasingPot) {
        double hSign = 1.0;
        if (!increasingPot) {
            hSign = -1.0;
        }
        double h = this.hAbs * hSign;
        if (hSign * x <= hSign * r0) {
            return 0.0;
        }
        double dx = r0 - x;
        if (x * hSign < hSign * (r0 + h)) {
            return -this.weight * dx * dx * dx / (6.0 * h);
        }
        return this.weight / 6.0 * (h * h + 3.0 * h * dx + 3.0 * dx * dx);
    }

    double functionDeriv(double x, double r0, boolean increasingPot) {
        double hSign = 1.0;
        if (!increasingPot) {
            hSign = -1.0;
        }
        double h = this.hAbs * hSign;
        if (hSign * x <= hSign * r0) {
            return 0.0;
        }
        double dx = r0 - x;
        if (x * hSign < hSign * (r0 + h)) {
            return this.weight * dx * dx / (2.0 * h);
        }
        return -this.weight * (dx + h / 2.0);
    }

    public double getWeight() {
        return this.weight;
    }
}

