/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.DegreeOfFeedom;
import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.ProximityConstraint;
import chemaxon.marvin.alignment.VolumeOverlapConstraint;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.modelling.util.U;
import java.io.Serializable;
import java.util.BitSet;

class Dihedral
implements Serializable,
DegreeOfFeedom {
    public static final int B_SIDE = 0;
    public static final int C_SIDE = 1;
    public static final int BOTH_SIDE = 2;
    static final double ZERODISTANCELIMIT = 1.0E-10;
    private int rotationSide;
    private double[][] tmp = new double[8][3];
    private boolean enabled = true;
    private boolean disableForRandomize = false;
    double angle = 0.0;
    Node nA;
    Node nB;
    Node nC;
    Node nD;
    BitSet atomsOnCside;
    BitSet atomsOnBside;
    NodeList nl;
    private static boolean quaternion = false;
    private static BitSet tmpB = new BitSet();
    private static BitSet tmpC = new BitSet();
    private static BitSet all = new BitSet();
    private static BitSet all2 = new BitSet();
    private int pos = -1;
    private Node[][] proximitiesOfThisDihedral;
    private ForceFieldInterface ffi;
    private boolean gradientChanged = false;
    public static double MAX_ANGLE = Math.PI;

    public Dihedral(int a, int b, int c, int d, BitSet atomsOnBside, BitSet atomsOnCside, NodeList nl, int rotationSide) throws MolGeom.LinearBondAngleException {
        this.nA = nl.get(a);
        this.nB = nl.get(b);
        this.nC = nl.get(c);
        this.nD = nl.get(d);
        if (!(this.nA.isRealAtom() && this.nB.isRealAtom() && this.nC.isRealAtom() && this.nD.isRealAtom())) {
            throw new IllegalStateException("Dihedrals must be put only on real atoms.");
        }
        if (this.nA.getMolID() != this.nB.getMolID() || this.nA.getMolID() != this.nC.getMolID() || this.nA.getMolID() != this.nD.getMolID()) {
            throw new IllegalStateException("MolIDs must be the same.");
        }
        this.atomsOnCside = atomsOnCside;
        this.atomsOnBside = atomsOnBside;
        this.nl = nl;
        this.rotationSide = rotationSide;
        this.recalcAngle();
    }

    public double getForceFieldEnergy() {
        return this.ffi.dihedralEnergy(this.nB.getFirstAtomSeq(), this.nC.getFirstAtomSeq());
    }

    public final void recalcAngle() throws MolGeom.LinearBondAngleException {
        this.angle = this.calcAngle();
    }

    public boolean canTweakTheseAtoms(BitSet atoms) {
        tmpB.clear();
        tmpC.clear();
        tmpB.or(this.atomsOnBside);
        tmpC.or(this.atomsOnCside);
        tmpB.and(atoms);
        tmpC.and(atoms);
        return tmpB.cardinality() > 0 && tmpC.cardinality() > 0;
    }

    public boolean canTweakTheseAtoms(Interaction inter) {
        inter.getNode1().markAtoms(tmpB);
        inter.getNode2().markAtoms(tmpC);
        tmpB.or(tmpC);
        tmpC.or(tmpB);
        tmpB.and(this.atomsOnBside);
        tmpC.and(this.atomsOnCside);
        return tmpB.cardinality() > 0 && tmpC.cardinality() > 0;
    }

    void setAtomsToKeepFixed(int atomToKeepFixed) {
        if (this.isCentralAtom(atomToKeepFixed)) {
            return;
        }
        boolean bFix = this.atomsOnBside.get(atomToKeepFixed);
        boolean cFix = this.atomsOnCside.get(atomToKeepFixed);
        if (!bFix && !cFix) {
            System.err.println("Atom to keep fixed: " + atomToKeepFixed);
            System.err.println(bFix + " " + cFix);
            System.err.println(this.toString());
            throw new IllegalStateException();
        }
        if (bFix && cFix) {
            return;
        }
        if (bFix) {
            this.rotationSide = 1;
        } else if (cFix) {
            this.rotationSide = 0;
        }
    }

    public boolean isCentralAtom(int atom) {
        return this.nB.getFirstAtomSeq() == atom || this.nC.getFirstAtomSeq() == atom;
    }

    public void setOneSideRotation(boolean oneSide) {
        if (!oneSide) {
            this.rotationSide = 2;
            return;
        }
        if (this.atomsOnBside.cardinality() < this.atomsOnCside.cardinality()) {
            this.rotationSide = 0;
            return;
        }
        this.rotationSide = 1;
    }

    public void setRotationSide(int rotationSide) {
        this.rotationSide = rotationSide;
    }

    private double internalInteractions(Interaction constr) {
        Node n1 = constr.getNode1();
        Node n2 = constr.getNode2();
        if (n1.isRealAtom() && n2.isRealAtom()) {
            if (this.atomsOnBside.get(n1.getFirstAtomSeq()) && this.atomsOnCside.get(n2.getFirstAtomSeq())) {
                return this.calcDdPerDAngle(this.nB.getCrd(), this.nC.getCrd(), n1.getCrd(), n2.getCrd(), constr);
            }
            if (this.atomsOnCside.get(n1.getFirstAtomSeq()) && this.atomsOnBside.get(n2.getFirstAtomSeq())) {
                return this.calcDdPerDAngle(this.nC.getCrd(), this.nB.getCrd(), n1.getCrd(), n2.getCrd(), constr);
            }
            System.err.println(this);
            System.err.println("against: ");
            System.err.println(constr);
            System.err.println(n1.getFirstAtomSeq() + " " + n2.getFirstAtomSeq());
            throw new IllegalStateException();
        }
        BitSet n1Atoms = n1.markAtoms(all);
        BitSet n2Atoms = n2.markAtoms(all2);
        tmpB.clear();
        tmpB.or(n1Atoms);
        tmpB.or(n2Atoms);
        tmpC.clear();
        tmpC.or(tmpB);
        boolean b = tmpB.get(this.nB.getFirstAtomSeq());
        boolean c = tmpC.get(this.nC.getFirstAtomSeq());
        tmpB.and(this.atomsOnBside);
        tmpC.and(this.atomsOnCside);
        if (tmpB.cardinality() == 0 && tmpC.cardinality() == 0) {
            throw new IllegalStateException();
        }
        if (tmpB.cardinality() == 0 || tmpC.cardinality() == 0) {
            return 0.0;
        }
        tmpB.set(this.nB.getFirstAtomSeq(), b);
        tmpC.set(this.nC.getFirstAtomSeq(), c);
        if (tmpB.equals(n1Atoms) && tmpC.equals(n2Atoms)) {
            return this.calcDdPerDAngle(this.nB.getCrd(), this.nC.getCrd(), n1.getCrd(), n2.getCrd(), constr);
        }
        if (tmpB.equals(n2Atoms) && tmpC.equals(n1Atoms)) {
            return this.calcDdPerDAngle(this.nB.getCrd(), this.nC.getCrd(), n2.getCrd(), n1.getCrd(), constr);
        }
        MolecularGaussian n1new = (MolecularGaussian)this.nl.get(tmpB);
        MolecularGaussian n2new = (MolecularGaussian)this.nl.get(tmpC);
        MolecularGaussianProduct gp = new MolecularGaussianProduct(n1new, n2new, null);
        MolecularGaussianProduct orig = (MolecularGaussianProduct)constr;
        gp.derivateDivDist *= orig.mmsign;
        gp.signedIntegral *= orig.mmsign;
        return this.calcDdPerDAngle(this.nB.getCrd(), this.nC.getCrd(), n1new.getCrd(), n2new.getCrd(), gp);
    }

    private double lengthOfMiddleBondRec() {
        double lengthOfMiddleBondRec = 1.0 / MolGeom.getLength(this.nB.getCrd(), this.nC.getCrd());
        if (!U.isDoubleOK(lengthOfMiddleBondRec)) {
            throw new IllegalStateException("lengthOfMiddleBondRec is incorrect! \n" + this.toString());
        }
        return lengthOfMiddleBondRec;
    }

    private double externalInteractions(Interaction constr) {
        if (!(constr instanceof AlignmentConstraint) && !(constr instanceof VolumeOverlapConstraint)) {
            throw new IllegalStateException();
        }
        Node my = constr.getNode1();
        Node other = constr.getNode2();
        if (constr.getNode2().getMolID() == this.getMolID()) {
            my = constr.getNode2();
            other = constr.getNode1();
        }
        if (my.isRealAtom()) {
            if (this.atomsOnBside.get(my.getFirstAtomSeq())) {
                return this.calcExternalDerivate(constr, this.nB.getCrd(), this.nC.getCrd(), my.getCrd(), other.getCrd());
            }
            if (this.atomsOnCside.get(my.getFirstAtomSeq())) {
                return this.calcExternalDerivate(constr, this.nB.getCrd(), this.nC.getCrd(), other.getCrd(), my.getCrd());
            }
            if (!this.isCentralAtom(my.getFirstAtomSeq())) {
                throw new IllegalStateException();
            }
            return 0.0;
        }
        tmpB = my.markAtoms(tmpB);
        tmpC = my.markAtoms(tmpC);
        boolean b = tmpB.get(this.nB.getFirstAtomSeq());
        boolean c = tmpC.get(this.nC.getFirstAtomSeq());
        tmpB.and(this.atomsOnBside);
        tmpC.and(this.atomsOnCside);
        if (tmpB.cardinality() == 0 && tmpC.cardinality() == 0) {
            if (!this.isCentralAtom(my.getFirstAtomSeq())) {
                throw new IllegalStateException();
            }
            return 0.0;
        }
        if (tmpB.cardinality() == 0) {
            return this.calcExternalDerivate(constr, this.nB.getCrd(), this.nC.getCrd(), other.getCrd(), my.getCrd());
        }
        if (tmpC.cardinality() == 0) {
            return this.calcExternalDerivate(constr, this.nB.getCrd(), this.nC.getCrd(), my.getCrd(), other.getCrd());
        }
        tmpB.set(this.nB.getFirstAtomSeq(), b);
        tmpC.set(this.nC.getFirstAtomSeq(), c);
        MolecularGaussian aA = (MolecularGaussian)this.nl.get(tmpB);
        MolecularGaussian aD = (MolecularGaussian)this.nl.get(tmpC);
        MolecularGaussian aE = (MolecularGaussian)other;
        double a = aA.getA();
        double d = aD.getA();
        double e = aE.getA();
        double[] ab = this.tmp[0];
        double[] ad = this.tmp[1];
        double[] ubc = this.tmp[2];
        double[] ae = this.tmp[3];
        double[] de = this.tmp[4];
        double[] dc = this.tmp[5];
        double[] ubcxvab = this.tmp[6];
        double[] ubcxvdc = this.tmp[7];
        MolGeom.minusVec(this.nB.getCrd(), this.nC.getCrd(), ubc);
        MolGeom.mul(ubc, this.lengthOfMiddleBondRec());
        MolGeom.minusVec(aA.getCrd(), aD.getCrd(), ad);
        MolGeom.minusVec(aA.getCrd(), aE.getCrd(), ae);
        MolGeom.minusVec(aD.getCrd(), aE.getCrd(), de);
        MolGeom.minusVec(aA.getCrd(), this.nB.getCrd(), ab);
        MolGeom.minusVec(aD.getCrd(), this.nC.getCrd(), dc);
        MolGeom.getVector3D(ubc, ab, ubcxvab);
        MolGeom.getVector3D(ubc, dc, ubcxvdc);
        double f = -constr.getEnergy() / (a + d + e);
        double der = a * d * 2.0 * MolGeom.dot3D(ad, ubcxvab);
        der += a * e * MolGeom.dot3D(ae, ubcxvab);
        der -= d * e * MolGeom.dot3D(de, ubcxvdc);
        return der *= f;
    }

    @Override
    public double[] gradient(double[] gradient, Interaction constr) {
        this.gradientChanged = false;
        if (!this.enabled) {
            return gradient;
        }
        int id1 = constr.getNode1().getMolID();
        int id2 = constr.getNode2().getMolID();
        int id = this.getMolID();
        if (id1 != id && id2 != id) {
            return gradient;
        }
        if (id1 == id && id2 == id) {
            if (!this.canTweakTheseAtoms(constr)) {
                return gradient;
            }
            this.gradientChanged = true;
            if (constr.derivateDividedByDist() == 0.0) {
                return gradient;
            }
            int n = this.pos;
            gradient[n] = gradient[n] + this.internalInteractions(constr);
        } else {
            this.gradientChanged = true;
            if (constr.derivateDividedByDist() == 0.0) {
                return gradient;
            }
            int n = this.pos;
            gradient[n] = gradient[n] + this.externalInteractions(constr);
        }
        return gradient;
    }

    public double[] ffGradient(double[] gradient) {
        if (this.ffi != null) {
            int n = this.pos;
            gradient[n] = gradient[n] + this.ffi.dihedralGradient(this.nB.getFirstAtomSeq(), this.nC.getFirstAtomSeq());
        }
        return gradient;
    }

    public void setFfi(ForceFieldInterface ffi) {
        this.ffi = ffi;
    }

    private double calcDdPerDAngle(double[] b, double[] c, double[] a, double[] e, Interaction constr) {
        double[] ae = this.tmp[0];
        double[] ab = this.tmp[1];
        double[] ubc = this.tmp[2];
        double[] ubcXab = this.tmp[3];
        ubc = MolGeom.minusVec(b, c, ubc);
        MolGeom.mul(ubc, this.lengthOfMiddleBondRec());
        ab = MolGeom.minusVec(a, b, ab);
        MolGeom.getVector3D(ubc, ab, ubcXab);
        ae = MolGeom.minusVec(a, e, ae);
        return V.dot(ubcXab, ae) * constr.derivateDividedByDist();
    }

    private double calcExternalDerivate(Interaction constr, double[] b, double[] c, double[] a, double[] e) {
        double der = this.calcDdPerDAngle(b, c, a, e, constr);
        if (this.rotationSide == 2) {
            der /= 2.0;
        }
        return der;
    }

    public void maximizeDistance(Node aa, Node dd) throws MolGeom.LinearBondAngleException {
        if (this.isDisableForRandomize()) {
            return;
        }
        if (aa.equals(dd) || aa.equals(this.nC) || aa.equals(this.nB) || dd.equals(this.nC) || dd.equals(this.nB)) {
            throw new IllegalStateException("Error selecting atoms: " + aa.getFirstAtomSeq() + " " + dd.getFirstAtomSeq() + " on dihedral :\n" + this.toString());
        }
        if (aa.getMolID() != this.getMolID() || dd.getMolID() != this.getMolID()) {
            throw new IllegalStateException("Error selecting atoms: " + aa.getFirstAtomSeq() + " " + dd.getFirstAtomSeq() + " on dihedral :\n" + this.toString());
        }
        Node bSide = null;
        Node cSide = null;
        if (this.atomsOnBside.get(aa.getFirstAtomSeq())) {
            bSide = aa;
        } else if (this.atomsOnBside.get(dd.getFirstAtomSeq())) {
            if (bSide != null) {
                throw new IllegalStateException("Error selecting atoms: " + aa.getFirstAtomSeq() + " " + dd.getFirstAtomSeq() + " on dihedral :\n" + this.toString());
            }
            bSide = dd;
        }
        if (this.atomsOnCside.get(aa.getFirstAtomSeq())) {
            cSide = aa;
        } else if (this.atomsOnCside.get(dd.getFirstAtomSeq())) {
            if (cSide != null) {
                throw new IllegalStateException("Error selecting atoms: " + aa.getFirstAtomSeq() + " " + dd.getFirstAtomSeq() + " on dihedral :\n" + this.toString());
            }
            cSide = dd;
        }
        if (bSide == null || cSide == null) {
            throw new IllegalStateException("Error selecting atoms: " + aa.getFirstAtomSeq() + " " + dd.getFirstAtomSeq() + " on dihedral :\n" + this.toString());
        }
        double currAngle = this.calcAngle(bSide, this.nB, this.nC, cSide);
        double diff = MolGeom.dihedralDifference(MAX_ANGLE, currAngle);
        this.rotateBy(diff);
    }

    public double getAngle() {
        return this.angle;
    }

    double calcAngle() throws MolGeom.LinearBondAngleException {
        return this.calcAngle(this.nA, this.nB, this.nC, this.nD);
    }

    private double calcAngle(Node a, Node b, Node c, Node d) throws MolGeom.LinearBondAngleException {
        double[] b1 = this.tmp[0];
        double[] b2 = this.tmp[1];
        double[] b3 = this.tmp[2];
        double[] b1xb2 = this.tmp[3];
        double[] b2xb3 = this.tmp[4];
        b1 = MolGeom.minusVec(b.getCrd(), a.getCrd(), b1);
        b2 = MolGeom.minusVec(c.getCrd(), b.getCrd(), b2);
        b3 = MolGeom.minusVec(d.getCrd(), c.getCrd(), b3);
        double b1r = 1.0 / MolGeom.getLength(b1);
        double b2r = 1.0 / MolGeom.getLength(b2);
        double b3r = 1.0 / MolGeom.getLength(b3);
        if (!(U.isDoubleOK(b1r) && U.isDoubleOK(b2r) && U.isDoubleOK(b3r))) {
            System.err.println(b1r);
            System.err.println(b2r);
            System.err.println(b3r);
            throw new IllegalStateException("Bond length mismatch " + this.toString());
        }
        MolGeom.mul(b1, b1r);
        MolGeom.mul(b2, b2r);
        MolGeom.mul(b3, b3r);
        double a1 = V.dot(b1, b2);
        double a2 = V.dot(b2, b3);
        if (MolGeom.ifLinear(a1)) {
            throw new MolGeom.LinearBondAngleException("Linear bondangle found, cannot calculate dihedral. Send bug report with molecule.\n" + this);
        }
        if (MolGeom.ifLinear(a2)) {
            throw new MolGeom.LinearBondAngleException("Linear bondangle found, cannot calculate dihedral. Send bug report with molecule.\n" + this);
        }
        MolGeom.getVector3D(b2, b3, b2xb3);
        MolGeom.getVector3D(b1, b2, b1xb2);
        double y = MolGeom.getLength(b2) * MolGeom.dot3D(b1, b2xb3);
        double x = MolGeom.dot3D(b1xb2, b2xb3);
        return Math.atan2(y, x);
    }

    public void rotateTo(double angleNew) throws MolGeom.LinearBondAngleException {
        double diff = MolGeom.dihedralDifference(angleNew, this.getAngle());
        this.rotateBy(diff);
    }

    public void rotateBy(double diff) {
        if (this.rotationSide == 0) {
            this.rotateBside(diff);
        } else if (this.rotationSide == 1) {
            this.rotateCside(diff);
        } else {
            double d = diff / 2.0;
            this.rotateBside(d);
            this.rotateCside(d);
        }
        this.angle += diff;
    }

    private void rotateBside(double theta) {
        this.rotateDihedralBy(theta, this.nB, this.nC, this.atomsOnBside);
    }

    private void rotateCside(double theta) {
        this.rotateDihedralBy(theta, this.nC, this.nB, this.atomsOnCside);
    }

    private void rotateDihedralBy(double theta, Node nB, Node nC, BitSet atomsToRotate) {
        double[] axis = this.tmp[0];
        MolGeom.minusVec(nB.getCrd(), nC.getCrd(), axis);
        MolGeom.mul(axis, this.lengthOfMiddleBondRec());
        double costheta = 0.0;
        double sintheta = 0.0;
        double s1 = 0.0;
        if (!quaternion) {
            costheta = MolGeom.cos(theta);
            sintheta = MolGeom.sin(theta);
        } else {
            double mult = MolGeom.sin(theta / 2.0);
            s1 = MolGeom.cos(theta / 2.0);
            MolGeom.mul(axis, mult);
        }
        double oneMinuscostheta = 1.0 - costheta;
        for (int i = 0; i < atomsToRotate.size(); ++i) {
            if (!atomsToRotate.get(i)) continue;
            double[] crd = this.nl.get(i).getCrd();
            double[] origin = nB.getCrd();
            double x = crd[0] - origin[0];
            double y = crd[1] - origin[1];
            double z = crd[2] - origin[2];
            if (quaternion) {
                double s2 = -axis[0] * x - axis[1] * y - axis[2] * z;
                double rx = s1 * x + axis[1] * z - axis[2] * y;
                double ry = s1 * y + axis[2] * x - axis[0] * z;
                double rz = s1 * z + axis[0] * y - axis[1] * x;
                crd[0] = -s2 * axis[0] + s1 * rx - ry * axis[2] + rz * axis[1];
                crd[1] = -s2 * axis[1] + s1 * ry - rz * axis[0] + rx * axis[2];
                crd[2] = -s2 * axis[2] + s1 * rz - rx * axis[1] + ry * axis[0];
            } else {
                crd[0] = (costheta + oneMinuscostheta * axis[0] * axis[0]) * x + (oneMinuscostheta * axis[0] * axis[1] - axis[2] * sintheta) * y + (oneMinuscostheta * axis[0] * axis[2] + axis[1] * sintheta) * z;
                crd[1] = (oneMinuscostheta * axis[0] * axis[1] + axis[2] * sintheta) * x + (costheta + oneMinuscostheta * axis[1] * axis[1]) * y + (oneMinuscostheta * axis[1] * axis[2] - axis[0] * sintheta) * z;
                crd[2] = (oneMinuscostheta * axis[0] * axis[2] - axis[1] * sintheta) * x + (oneMinuscostheta * axis[1] * axis[2] + axis[0] * sintheta) * y + (costheta + oneMinuscostheta * axis[2] * axis[2]) * z;
            }
            crd[0] = crd[0] + origin[0];
            crd[1] = crd[1] + origin[1];
            crd[2] = crd[2] + origin[2];
        }
    }

    public boolean isDisableForRandomize() {
        return this.disableForRandomize;
    }

    public void setDisableForRandomize(boolean disable) {
        this.disableForRandomize = disable;
    }

    public String toString() {
        int a = 0;
        String s = "DIHEDRAL " + (this.nA.getFirstAtomSeq() + a) + " ";
        s = s + (this.nB.getFirstAtomSeq() + a) + " ";
        s = s + (this.nC.getFirstAtomSeq() + a) + " ";
        s = s + (this.nD.getFirstAtomSeq() + a);
        s = s + " \n";
        s = s + "Angle=" + MolGeom.forHumans(this.getAngle()) + " \n";
        s = s + " Rotate: " + this.rotationSide + "\n";
        s = s + " MolID: " + this.nA.getMolID() + "\n";
        s = s + " DisableForRandomize(in ring): " + this.disableForRandomize + "\n";
        s = s + " Enabled: " + this.enabled + "\n";
        s = s + " b side atoms :  " + this.atomsOnBside + "\n";
        s = s + " c side atoms :  " + this.atomsOnCside + "\n";
        s = s + "pos: " + this.pos + "\n";
        s = s + " Constraints:\n";
        return s;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getMolID() {
        return this.nA.getMolID();
    }

    @Override
    public double[] getVariable(double[] variables) {
        variables[this.pos] = this.getAngle();
        return variables;
    }

    @Override
    public void setVariable(double[] variables) {
        if (!this.enabled) {
            return;
        }
        try {
            this.rotateTo(variables[this.pos]);
        }
        catch (MolGeom.LinearBondAngleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setPosition(int pos) {
        this.pos = pos;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void setVariableValueOnly(double[] variables) {
        this.angle = variables[this.pos];
    }

    public double[] proximityGradients(double[] gradient, ProximityConstraint proximityConstraint, Node[][] p) {
        block6: {
            block5: {
                if (this.proximitiesOfThisDihedral != null) break block5;
                int active = 0;
                for (int i = 0; i < p.length; ++i) {
                    proximityConstraint.setNode1(p[i][0]);
                    proximityConstraint.setNode2(p[i][1]);
                    gradient = this.gradient(gradient, proximityConstraint);
                    if (!this.gradientChanged) continue;
                    ++active;
                }
                this.proximitiesOfThisDihedral = new Node[active][];
                break block6;
            }
            if (this.proximitiesOfThisDihedral.length <= 0) break block6;
            if (this.proximitiesOfThisDihedral[0] == null) {
                int active = 0;
                for (int i = 0; i < p.length; ++i) {
                    proximityConstraint.setNode1(p[i][0]);
                    proximityConstraint.setNode2(p[i][1]);
                    gradient = this.gradient(gradient, proximityConstraint);
                    if (!this.gradientChanged) continue;
                    this.proximitiesOfThisDihedral[active++] = p[i];
                }
            } else {
                for (int i = 0; i < this.proximitiesOfThisDihedral.length; ++i) {
                    proximityConstraint.setNode1(this.proximitiesOfThisDihedral[i][0]);
                    proximityConstraint.setNode2(this.proximitiesOfThisDihedral[i][1]);
                    int n = this.pos;
                    gradient[n] = gradient[n] + this.internalInteractions(proximityConstraint);
                }
            }
        }
        return gradient;
    }

    public void resetMyProximities() {
        this.proximitiesOfThisDihedral = null;
    }

    @Override
    public boolean isSmallStep(double[] d) {
        return MolGeom.dihedralDifference(d[this.pos], this.getAngle()) < Math.PI / 360;
    }
}

