/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Matrix3x3;
import chemaxon.marvin.alignment.RotationByAngles;
import chemaxon.marvin.modelling.struc.MolGeom;

class EulerRotate
implements RotationByAngles {
    Matrix3x3 r = new Matrix3x3();

    @Override
    public void setEulerXYZ(double tx, double ty, double tz) {
        double c1 = MolGeom.cos(tx);
        double s1 = MolGeom.sin(tx);
        double c2 = MolGeom.cos(ty);
        double s2 = MolGeom.sin(ty);
        double c3 = MolGeom.cos(tz);
        double s3 = MolGeom.sin(tz);
        this.r.setParams(c2 * c3, c3 * s1 * s2 - c1 * s3, c1 * c3 * s2 + s1 * s3, c2 * s3, c1 * c3 + s1 * s2 * s3, c1 * s2 * s3 - c3 * s1, -s2, c2 * s1, c1 * c2);
    }

    @Override
    public double[] rotate(double[] x) {
        x = this.r.mulAndWriteBack(x);
        return x;
    }
}

