/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.BowlFunction;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class ExternalHalfBowlPotential
extends BowlFunction
implements PotentialFunction {
    public static final double EXTERNAL_RADIUS_SCALE = 0.9;
    private double tolerance;

    public ExternalHalfBowlPotential(double weight, double tolerance) {
        super(weight, weight / 2.0);
        this.tolerance = tolerance * 0.9;
    }

    @Override
    public double functionValue(double x) {
        return this.function(x, this.tolerance, true);
    }

    private double getFunctionDerivate(double x) {
        return this.functionDeriv(x, this.tolerance, true);
    }

    @Override
    public double getTolerance() {
        return this.tolerance / 0.9;
    }

    @Override
    public boolean isOk(double x) {
        return x < this.getTolerance();
    }

    @Override
    public PotentialType getType() {
        return PotentialType.HALF_BOWL;
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        double r0 = this.tolerance;
        double hSign = 1.0;
        double h = this.hAbs * hSign;
        if (hSign * dist <= hSign * r0) {
            return 0.0;
        }
        double dx = r0 - dist;
        if (dist * hSign < hSign * (r0 + h)) {
            return this.weight * dx * dx / (2.0 * h) / dist;
        }
        return -this.weight * (dx + h / 2.0) / dist;
    }
}

