/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.Constraint;
import chemaxon.marvin.alignment.DegreeOfFeedom;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.Interaction;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeList;
import chemaxon.marvin.alignment.ProximityConstraint;
import chemaxon.marvin.alignment.ProximityConstraintFF;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.util.ShortestPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

class FlexibleMolecule
extends AlignmentMolecule {
    private static Random rand = new Random(50L);
    private List<MolecularConstraint> ringConstraints;
    private transient ArrayList<MolecularConstraint> wishes;
    private List<Dihedral> dihedrals;
    private transient boolean proximity = true;
    private ProximityConstraint proximityConstraint;
    private Node[][] proximityEnabledNodes;
    private Node[][] proximityEnabledNodesSelected;
    private boolean selectedMode = false;
    private transient ShortestPath sp;
    private int[][] btabForDihedrals;
    static final boolean CENTER_DISPLACEMENT = true;

    FlexibleMolecule(NodeList nodes, ArrayList<Dihedral> dihedrals, ArrayList<MolecularConstraint> ringConstraints, int[][] btabForDihedrals) throws AlignmentException, MolGeom.LinearBondAngleException {
        super(nodes);
        this.dihedrals = dihedrals;
        this.ringConstraints = ringConstraints;
        this.btabForDihedrals = btabForDihedrals;
    }

    public void setSelectedMode(boolean selectedMode) {
        this.selectedMode = selectedMode;
    }

    @Override
    public void initVariables(boolean enableTranslateAndRotate) {
        super.initVariables(enableTranslateAndRotate);
        if (this.dihedrals.isEmpty()) {
            throw new IllegalStateException("rigid molecule was found");
        }
        this.status.setDihedralCount(this.dihedrals.size());
        this.status.cleanRigidMol();
        this.status.cleanRigidPath();
    }

    private ShortestPath getSP() {
        if (this.sp != null) {
            return this.sp;
        }
        this.storeOnly = this.getMoleculeOrig();
        this.sp = new ShortestPath();
        this.sp.calculate(this.storeOnly);
        return this.sp;
    }

    public void setProximityConstraint(ProximityConstraint p) {
        this.proximityConstraint = p;
    }

    public void setProximityEnabledNodes(Node[][] proximityEnabledNodes) {
        this.proximityEnabledNodes = proximityEnabledNodes;
    }

    public void setProximityEnabledNodesSelected(Node[][] proximityEnabledNodesSelected) {
        this.proximityEnabledNodesSelected = proximityEnabledNodesSelected;
    }

    public Node[][] getProximityEnabledNodes() {
        if (this.selectedMode) {
            return this.proximityEnabledNodesSelected;
        }
        return this.proximityEnabledNodes;
    }

    @Override
    public String toString() {
        String s = super.toString();
        s = s + "Dihedrals:\n";
        for (Dihedral dihedral : this.dihedrals) {
            s = s + dihedral.toString() + "\n";
        }
        s = s + "Ring Constraints:\n";
        for (MolecularConstraint m : this.ringConstraints) {
            s = s + m.toString() + "\n";
        }
        s = s + "Proximity Constraints:\n";
        for (Node[] m : this.proximityEnabledNodes) {
            s = s + (m[0].getFirstAtomSeq() + m[1].getFirstAtomSeq()) + "\n";
        }
        return s;
    }

    @Override
    void createDFIterator() {
        int maxDF = 0;
        if (this.translate != null) {
            maxDF = 2;
        }
        if (!this.isRigidPath()) {
            maxDF += this.dihedrals.size();
        }
        final int maxDF2 = maxDF;
        this.dfIterator = new Iterator<DegreeOfFeedom>(){

            @Override
            public boolean hasNext() {
                return FlexibleMolecule.this.iteratorPos < maxDF2;
            }

            @Override
            public DegreeOfFeedom next() {
                if (FlexibleMolecule.this.translate != null) {
                    if (FlexibleMolecule.this.iteratorPos == 0) {
                        ++FlexibleMolecule.this.iteratorPos;
                        return FlexibleMolecule.this.translate;
                    }
                    if (FlexibleMolecule.this.iteratorPos == 1) {
                        ++FlexibleMolecule.this.iteratorPos;
                        return FlexibleMolecule.this.rotate;
                    }
                    ++FlexibleMolecule.this.iteratorPos;
                    return (DegreeOfFeedom)FlexibleMolecule.this.dihedrals.get(FlexibleMolecule.this.iteratorPos - 3);
                }
                return (DegreeOfFeedom)FlexibleMolecule.this.dihedrals.get(FlexibleMolecule.this.iteratorPos++);
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Not supported yet.");
            }
        };
    }

    @Override
    int getDFCount() {
        int ret = super.getDFCount();
        if (!this.isRigidPath()) {
            ret += this.dihedrals.size();
        }
        return ret;
    }

    public void freezeFlexibleBond(int atom2, int atom3, boolean freeze) {
        if (atom3 == atom2) {
            throw new IllegalStateException();
        }
        for (Dihedral d : this.dihedrals) {
            if (!d.isCentralAtom(atom2) || !d.isCentralAtom(atom3)) continue;
            d.setEnabled(!freeze);
        }
    }

    public List<MolecularConstraint> getRingConstraints() {
        return this.ringConstraints;
    }

    public void freezeAllBonds(boolean freeze) {
        for (Dihedral d : this.dihedrals) {
            d.setEnabled(!freeze);
        }
    }

    public void fillWarningInfo() {
    }

    public void removeAllIntraMolConstr() {
        if (this.wishes != null) {
            this.wishes.clear();
        }
    }

    public void addIntraMolConstr(MolecularConstraint intra) throws AlignmentException {
        if (intra.getNode1() == null || intra.getNode2() == null) {
            throw new AlignmentException("Intra molecular distance constraint was not mapped");
        }
        if (intra.getMolID() != this.molID) {
            return;
        }
        if (this.wishes == null) {
            this.wishes = new ArrayList();
        }
        this.wishes.add(intra);
    }

    public double functionValue() {
        Node[][] p;
        int i;
        double ret = 0.0;
        if (this.wishes != null) {
            for (i = 0; i < this.wishes.size(); ++i) {
                ret += this.wishes.get(i).getEnergy();
            }
        }
        for (i = 0; i < this.ringConstraints.size(); ++i) {
            ret += this.ringConstraints.get(i).getEnergy();
        }
        if (this.proximity && (p = this.getProximityEnabledNodes()) != null) {
            for (int i2 = 0; i2 < p.length; ++i2) {
                this.proximityConstraint.setNode1(p[i2][0]);
                this.proximityConstraint.setNode2(p[i2][1]);
                this.proximityConstraint.calcDist();
                ret += this.proximityConstraint.getEnergy();
            }
        }
        if (this.proximityConstraint instanceof ProximityConstraintFF) {
            for (Dihedral dihedral : this.dihedrals) {
                ret += dihedral.getForceFieldEnergy();
            }
        }
        return ret;
    }

    public double ownVoumeToChange() {
        double ret = 0.0;
        if (this.nodes instanceof GaussianSum) {
            GaussianSum gs = (GaussianSum)this.nodes;
            int stop = gs.size() - gs.getMulticenterNodeCount();
            for (int i = this.getAtomCount(); i < stop; ++i) {
                MolecularGaussianProduct inter = (MolecularGaussianProduct)this.nodes.get(i);
                ret += inter.getEnergy();
            }
        }
        return ret;
    }

    public void setOneSideRotationForAllDihedrals(boolean oneSide) {
        for (Dihedral dihedral : this.dihedrals) {
            dihedral.setOneSideRotation(oneSide);
        }
    }

    public void setOneSideRotation(ArrayList<AlignmentConstraint> constr) {
        if (constr != null && constr.size() > 0) {
            BitSet selectedAtoms = new BitSet();
            BitSet tmp = new BitSet();
            for (AlignmentConstraint e : constr) {
                Node n = e.getNode1();
                if (n.getMolID() != this.molID) {
                    n = e.getNode2();
                }
                if (n.getMolID() != this.molID) continue;
                n.markAtoms(tmp);
                selectedAtoms.or(tmp);
            }
            if (selectedAtoms.cardinality() == 0) {
                throw new IllegalStateException();
            }
            for (Dihedral d : this.dihedrals) {
                if (d.canTweakTheseAtoms(selectedAtoms)) continue;
                d.setAtomsToKeepFixed(selectedAtoms.length() - 1);
            }
        }
    }

    public boolean isThereFlexiblePathBetween(int a1, int a2) {
        int n2;
        int n1;
        for (Node[] m : this.proximityEnabledNodes) {
            n1 = m[0].getFirstAtomSeq();
            n2 = m[1].getFirstAtomSeq();
            if (a1 == n1 && a2 == n2) {
                return true;
            }
            if (a2 != n1 || a1 != n2) continue;
            return true;
        }
        for (Node[] m : this.proximityEnabledNodesSelected) {
            n1 = m[0].getFirstAtomSeq();
            n2 = m[1].getFirstAtomSeq();
            if (a1 == n1 && a2 == n2) {
                return true;
            }
            if (a2 != n1 || a1 != n2) continue;
            return true;
        }
        return false;
    }

    public void setRigidPath(boolean r) {
        if (r) {
            this.status.setStatus(128);
        } else {
            this.status.cleanRigidPath();
        }
        this.createDFIterator();
    }

    public void setRigidMol() {
        this.status.setStatus(64);
        this.status.setStatus(128);
        this.createDFIterator();
    }

    void calcRigidPath(List<AlignmentConstraint> al) {
        if (this.status.isRigidPath()) {
            return;
        }
        this.status.cleanRigidPath();
        for (int i = 0; i < al.size() - 1; ++i) {
            AlignmentConstraint a1 = al.get(i);
            Node n1 = a1.getNode1();
            if (n1.getMolID() != this.getMolID()) {
                n1 = a1.getNode2();
            }
            if (n1.getMolID() != this.molID || !n1.isRealAtom()) continue;
            for (int j = i + 1; j < al.size(); ++j) {
                AlignmentConstraint a2 = al.get(j);
                Node n2 = a2.getNode1();
                if (n2.getMolID() != this.getMolID()) {
                    n2 = a2.getNode2();
                }
                if (n2.getMolID() != this.molID || !n2.isRealAtom() || !this.isThereFlexiblePathBetween(n1.getFirstAtomSeq(), n2.getFirstAtomSeq())) continue;
                return;
            }
        }
        this.setRigidPath(true);
    }

    private Dihedral getRandomizableDihedral(int a1, int a2) {
        int dPos = this.btabForDihedrals[a1][a2];
        if (dPos < 0 || this.dihedrals.get(dPos).isDisableForRandomize()) {
            return null;
        }
        return this.dihedrals.get(dPos);
    }

    private Node getFurtherNode(Dihedral base, Dihedral neigh) {
        int a = base.nB.getFirstAtomSeq();
        int[] tmp = new int[this.getAtomCount()];
        ShortestPath spLocal = this.getSP();
        int lengthB = spLocal.getPath(a, neigh.nB.getFirstAtomSeq(), tmp);
        int lengthC = spLocal.getPath(a, neigh.nC.getFirstAtomSeq(), tmp);
        if (lengthC < lengthB) {
            return neigh.nB;
        }
        return neigh.nC;
    }

    private int[] getPathBetween(Node n1, Node n2) {
        AtomicGaussian[] arr;
        if (!n1.isRealAtom() || !n2.isRealAtom()) {
            return null;
        }
        ShortestPath spLocal = this.getSP();
        int[] path = new int[this.getAtomCount()];
        int atom1 = n1.getFirstAtomSeq();
        int atom2 = n2.getFirstAtomSeq();
        if (n1 instanceof MultiCenterGaussian && n2 instanceof AtomicGaussian) {
            arr = ((MultiCenterGaussian)n1).getMembers();
            int pathLen = -1;
            atom2 = n2.getFirstAtomSeq();
            for (int k = 0; k < arr.length; ++k) {
                int curr = this.sp.getPath(arr[k].getFirstAtomSeq(), atom2, path);
                if (pathLen != -1 && curr >= pathLen) continue;
                pathLen = curr;
                atom1 = arr[k].getFirstAtomSeq();
            }
        } else if (n2 instanceof MultiCenterGaussian && n1 instanceof AtomicGaussian) {
            arr = ((MultiCenterGaussian)n2).getMembers();
            int pathLen = -1;
            atom1 = n1.getFirstAtomSeq();
            for (int k = 0; k < arr.length; ++k) {
                int curr = this.sp.getPath(arr[k].getFirstAtomSeq(), atom1, path);
                if (pathLen != -1 && curr >= pathLen) continue;
                pathLen = curr;
                atom2 = arr[k].getFirstAtomSeq();
            }
        } else if (n1 instanceof MultiCenterGaussian && n2 instanceof MultiCenterGaussian) {
            AtomicGaussian[] arr1 = ((MultiCenterGaussian)n1).getMembers();
            AtomicGaussian[] arr2 = ((MultiCenterGaussian)n2).getMembers();
            int pathLen = -1;
            for (int k1 = 0; k1 < arr1.length; ++k1) {
                AtomicGaussian atomicGaussian1 = arr1[k1];
                for (int k2 = 0; k2 < arr2.length; ++k2) {
                    AtomicGaussian atomicGaussian2 = arr2[k2];
                    int curr = this.sp.getPath(atomicGaussian1.getFirstAtomSeq(), atomicGaussian2.getFirstAtomSeq(), path);
                    if (pathLen != -1 && curr >= pathLen) continue;
                    pathLen = curr;
                    atom1 = atomicGaussian1.getFirstAtomSeq();
                    atom2 = atomicGaussian2.getFirstAtomSeq();
                }
            }
        }
        int length = spLocal.getPath(atom1, atom2, path);
        return Arrays.copyOf(path, length);
    }

    public void extend() throws AlignmentException {
        if (this.wishes.size() != 1) {
            throw new AlignmentException("Add only a single user defined constraint");
        }
        Constraint c = this.wishes.get(0);
        int[] path = this.getPathBetween(c.getNode1(), c.getNode2());
        int length = path.length;
        if (length > 3) {
            try {
                ArrayList<Dihedral> dihs = new ArrayList<Dihedral>();
                for (int i = 1; i < length - 2; ++i) {
                    Dihedral d = this.getRandomizableDihedral(path[i], path[i + 1]);
                    if (d == null) continue;
                    dihs.add(d);
                }
                for (int j = 0; j < dihs.size(); ++j) {
                    Dihedral d = (Dihedral)dihs.get(j);
                    Object aa = j == 0 ? this.nodes.get(path[0]) : this.getFurtherNode(d, (Dihedral)dihs.get(j - 1));
                    Object dd = j == dihs.size() - 1 ? this.nodes.get(path[length - 1]) : this.getFurtherNode(d, (Dihedral)dihs.get(j + 1));
                    d.maximizeDistance((Node)aa, (Node)dd);
                }
            }
            catch (MolGeom.LinearBondAngleException l) {
                throw new AlignmentException(l);
            }
        }
    }

    private void randomizeThisDihedral(Dihedral rot) {
        if (!rot.isDisableForRandomize()) {
            double rd = (rand.nextDouble() - 0.5) * 2.0 * Math.PI;
            rot.rotateBy(rd);
            this.checkCoordinates();
        }
    }

    public void randomizeDihedrals() {
        for (Dihedral rotr : this.dihedrals) {
            this.randomizeThisDihedral(rotr);
            this.checkCoordinates();
        }
    }

    public static void updateConstraints(List<? extends Interaction> c) {
        for (Interaction interaction : c) {
            interaction.update();
        }
    }

    public void updateConstraints() {
        FlexibleMolecule.updateConstraints(this.ringConstraints);
        if (this.wishes != null) {
            FlexibleMolecule.updateConstraints(this.wishes);
        }
    }

    public void updateDihedrals() {
        try {
            for (Dihedral dihedral : this.dihedrals) {
                dihedral.recalcAngle();
            }
        }
        catch (MolGeom.LinearBondAngleException l) {
            throw new IllegalStateException(l);
        }
    }

    public void resetProximities() {
        for (Dihedral dihedral : this.dihedrals) {
            dihedral.resetMyProximities();
        }
    }

    public void updateForceFieldPotential() {
        if (this.proximityConstraint instanceof ProximityConstraintFF) {
            ProximityConstraintFF pp = (ProximityConstraintFF)this.proximityConstraint;
            pp.getFfi().setCoordinates(this.getMolCrd());
        }
    }

    public void addForceFieldPotentialToDihedrals() {
        if (this.proximityConstraint instanceof ProximityConstraintFF) {
            ProximityConstraintFF pp = (ProximityConstraintFF)this.proximityConstraint;
            for (Dihedral dihedral : this.dihedrals) {
                dihedral.setFfi(pp.getFfi());
            }
        }
    }

    String ownConstraintsToString() {
        String s = "";
        for (MolecularConstraint r : this.ringConstraints) {
            s = s + "Ring " + r.getNode1().getFirstAtomSeq() + " " + r.getNode2().getFirstAtomSeq() + "\n";
        }
        for (Node[] p : this.proximityEnabledNodes) {
            s = s + "Prox " + p[0].getFirstAtomSeq() + " " + p[1].getFirstAtomSeq() + "\n";
        }
        return s;
    }

    @Override
    double[] gradient(double[] gradient, List<? extends AlignmentConstraint> constr) {
        super.gradient(gradient, constr);
        if (this.isRigidPath()) {
            return gradient;
        }
        for (Dihedral df : this.dihedrals) {
            if (!df.isEnabled()) continue;
            if (this.wishes != null) {
                for (MolecularConstraint molecularConstraint : this.wishes) {
                    gradient = df.gradient(gradient, molecularConstraint);
                }
            }
            for (MolecularConstraint molecularConstraint : this.ringConstraints) {
                gradient = df.gradient(gradient, molecularConstraint);
            }
            if (this.proximity && this.getProximityEnabledNodes() != null) {
                gradient = df.proximityGradients(gradient, this.proximityConstraint, this.getProximityEnabledNodes());
            }
            if (constr != null) {
                for (AlignmentConstraint alignmentConstraint : constr) {
                    gradient = df.gradient(gradient, alignmentConstraint);
                }
            }
            if (!(this.proximityConstraint instanceof ProximityConstraintFF)) continue;
            df.ffGradient(gradient);
        }
        return gradient;
    }

    double[] ownVolumeGradient(double[] gradient) {
        for (Dihedral df : this.dihedrals) {
            if (!(this.nodes instanceof GaussianSum)) continue;
            GaussianSum gs = (GaussianSum)this.nodes;
            int stop = gs.size() - gs.getMulticenterNodeCount();
            for (int i = this.getAtomCount(); i < stop; ++i) {
                MolecularGaussianProduct vol = (MolecularGaussianProduct)this.nodes.get(i);
                df.gradient(gradient, vol);
            }
        }
        return gradient;
    }

    @Override
    void setVariables(double[] variables) {
        super.setVariables(variables);
        if (!this.isRigidPath()) {
            for (Dihedral df : this.dihedrals) {
                df.setVariable(variables);
            }
        }
    }

    @Override
    void setVariableValueOnly(double[] variables) {
        super.setVariableValueOnly(variables);
        if (!this.isRigidPath()) {
            for (Dihedral df : this.dihedrals) {
                df.setVariableValueOnly(variables);
            }
        }
    }

    @Override
    double[] getVariables(double[] variables) {
        variables = super.getVariables(variables);
        if (!this.isRigidPath()) {
            for (Dihedral df : this.dihedrals) {
                variables = df.getVariable(variables);
            }
        }
        return variables;
    }

    public List<Dihedral> getDihedrals() {
        return this.dihedrals;
    }

    @Override
    public int getRotBondCount() {
        return this.dihedrals.size();
    }

    public List<MolecularConstraint> getWishes() {
        return this.wishes;
    }

    public void setVolumeSign(double volumeSign) {
        for (int i = this.getAtomCount(); i < this.nodes.size(); ++i) {
            MolecularGaussianProduct mp = (MolecularGaussianProduct)this.nodes.get(i);
            mp.setMmsign(volumeSign);
        }
    }

    public void setProximity(boolean proximity) {
        this.proximity = proximity;
    }
}

