/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.DegreeOfFeedom;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.EulerRotate;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.Function;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.MolecularConstraint;
import chemaxon.marvin.alignment.MolecularGaussianProduct;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeSimple;
import chemaxon.marvin.alignment.Orientation;
import chemaxon.marvin.alignment.Visualizer;
import chemaxon.marvin.alignment.VolumeOverlap;
import chemaxon.marvin.alignment.VolumeOverlapGrid;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.internals.ChangeCorrector;
import java.util.Iterator;
import java.util.List;

class FunctionMoreMols
extends Function {
    List<AlignmentMolecule> am;
    List<AlignmentConstraint> constr;
    VolumeOverlap[] overlaps;
    private double[] variablesAtLineSrchBegin;
    private GradientOptimization gr;
    private boolean centerDisplacement = false;
    private double centerDisplacementLimit = 2.0;
    private boolean overlapVisualization = false;
    private int smallStepCount = 0;
    private int smallStepCountLimit = -1;

    FunctionMoreMols(List<AlignmentMolecule> am, List<AlignmentConstraint> constr, int stepLimit, int timeLimit) throws AlignmentException {
        super(stepLimit, timeLimit);
        int i;
        for (AlignmentMolecule am1 : am) {
            this.statusOpt.addStatusMol(am1.getStatus());
        }
        this.am = am;
        this.constr = constr;
        if (am.get((int)0).nodes instanceof GaussianSum) {
            int l = am.size() * (am.size() - 1) / 2;
            this.overlaps = new VolumeOverlap[l];
            int c = 0;
            for (i = 0; i < am.size() - 1; ++i) {
                for (int j = i + 1; j < am.size(); ++j) {
                    this.overlaps[c++] = !this.overlapVisualization ? new VolumeOverlap(am.get(i), am.get(j)) : new VolumeOverlapGrid(am.get(i), am.get(j));
                }
            }
        }
        int parCount = 0;
        for (AlignmentMolecule a : am) {
            parCount += a.getDFCount();
        }
        this.gradient = new double[parCount];
        this.variables = new double[parCount];
        this.variablesAtLineSrchBegin = new double[parCount];
        int pos = 0;
        parCount = 0;
        for (i = 0; i < am.size(); ++i) {
            AlignmentMolecule a = am.get(i);
            if (a.isEnableTranslateAndRotate()) {
                a.getTranslate().setPosition(pos);
                a.getRotate().setPosition(pos += a.getTranslate().getLength());
                pos += a.getRotate().getLength();
            }
            if (a.isRigidMol()) continue;
            FlexibleMolecule f = (FlexibleMolecule)a;
            f.setOneSideRotationForAllDihedrals(false);
            for (Dihedral d : f.getDihedrals()) {
                d.setPosition(pos);
                pos += d.getLength();
            }
        }
    }

    public void markNodesForCentering() {
        if (this.overlaps != null) {
            VolumeOverlap.MODE m = this.overlaps[0].getMode();
            for (AlignmentMolecule a : this.am) {
                for (int i = 0; i < a.nodes.size(); ++i) {
                    Node n = a.nodes.get(i);
                    n.setCenteringMember(false);
                    if (m == VolumeOverlap.MODE.SELECTED && n.isSelected()) {
                        n.setCenteringMember(true);
                        continue;
                    }
                    if (n instanceof AtomicGaussian || n instanceof NodeSimple) {
                        n.setCenteringMember(true);
                    }
                    if (m != VolumeOverlap.MODE.FULL || !(n instanceof MolecularGaussianProduct)) continue;
                    n.setCenteringMember(true);
                }
            }
        }
        if (this.constr != null) {
            for (int i = 0; i < this.constr.size(); ++i) {
                AlignmentConstraint ac = this.constr.get(i);
                ac.getNode1().setCenteringMember(true);
                ac.getNode2().setCenteringMember(true);
            }
        }
        for (AlignmentMolecule a : this.am) {
            if (!a.isEnableTranslateAndRotate()) continue;
            a.calcMyCenter();
            a.centerDistance();
        }
    }

    @Override
    void setVis(Visualizer vis) {
        super.setVis(vis);
        vis.setVol(this.overlaps[0]);
    }

    public VolumeOverlapGrid getGrid() {
        if (this.overlapVisualization) {
            return (VolumeOverlapGrid)this.overlaps[0];
        }
        return null;
    }

    public void disableVolumeForConstraints(Orientation o) {
        if (!o.areConstraintsAddable()) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.overlaps.length; ++i) {
            if ((this.overlaps[i].am1 != o.am1 || this.overlaps[i].am2 != o.am2) && (this.overlaps[i].am2 != o.am1 || this.overlaps[i].am1 != o.am2)) continue;
            if (found) {
                throw new IllegalStateException("Has been found");
            }
            this.overlaps[i].disableConstraints(o.constr);
            found = true;
        }
        if (!found) {
            throw new IllegalStateException("Orientation not found");
        }
    }

    @Override
    void reset() {
        this.centerDisplacement = false;
        this.markNodesForCentering();
        super.reset();
        for (int i = 0; i < this.am.size(); ++i) {
            AlignmentMolecule a = this.am.get(i);
            if (a.isRigid()) continue;
            FlexibleMolecule f = (FlexibleMolecule)a;
            f.resetProximities();
        }
        this.smallStepCount = 0;
    }

    public void setMode(VolumeOverlap.MODE fast) {
        if (this.overlaps != null) {
            for (int i = 0; i < this.overlaps.length; ++i) {
                this.overlaps[i].setMode(fast);
            }
        }
    }

    public void setProximity(boolean p) {
        for (AlignmentMolecule a : this.am) {
            if (a.isRigid()) continue;
            FlexibleMolecule f = (FlexibleMolecule)a;
            f.setProximity(p);
        }
    }

    @Override
    public void setGr(GradientOptimization gr) {
        this.gr = gr;
    }

    @Override
    void update() {
        FlexibleMolecule.updateConstraints(this.constr);
        for (AlignmentMolecule a : this.am) {
            a.updateIterator();
        }
        if (this.overlaps != null) {
            if (this.overlaps[0].getMode() == VolumeOverlap.MODE.FULL) {
                for (AlignmentMolecule a : this.am) {
                    a.updateGaussianProducts();
                }
            }
            for (VolumeOverlap over : this.overlaps) {
                try {
                    over.update();
                }
                catch (AlignmentException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    @Override
    public double getFunctionValue() {
        double fv = 0.0;
        for (AlignmentMolecule am1 : this.am) {
            if (am1.isRigid()) continue;
            fv += ((FlexibleMolecule)am1).functionValue();
        }
        if (this.constr != null) {
            for (AlignmentConstraint ac : this.constr) {
                fv += ac.getEnergy();
            }
        }
        try {
        }
        catch (AlignmentException a) {
            throw new IllegalStateException(a);
        }
        return fv += this.getVolOverlap();
    }

    @Override
    public double[] getFunctionGradient() {
        if (this.vis != null) {
            this.vis.showSteps();
        }
        ++this.stepCount;
        try {
            for (int i = 0; i < this.gradient.length; ++i) {
                this.gradient[i] = 0.0;
            }
            for (AlignmentMolecule am1 : this.am) {
                am1.gradient(this.gradient, this.constr);
            }
            if (this.overlaps != null) {
                if (this.overlaps.length == 1) {
                    this.gradient = this.overlaps[0].gradient(this.gradient);
                } else {
                    for (VolumeOverlap ovr : this.overlaps) {
                        this.gradient = ovr.gradient(this.gradient);
                    }
                }
            }
        }
        catch (AlignmentException ex) {
            throw new IllegalStateException(ex);
        }
        this.checkGradient();
        return this.gradient;
    }

    @Override
    public boolean setVariables(double[] var) {
        this.isSmallStep();
        if (!this.isInsideNumericGradient && this.gr != null) {
            if (this.gr.getNumberOfInnerSteps() == 0) {
                for (AlignmentMolecule a : this.am) {
                    if (!a.isEnableTranslateAndRotate()) continue;
                    a.crdSafeRefresh();
                    this.variablesAtLineSrchBegin = a.getVariables(this.variablesAtLineSrchBegin);
                }
            } else {
                for (AlignmentMolecule a : this.am) {
                    if (!a.isEnableTranslateAndRotate()) continue;
                    a.crdMolRefresh();
                    a.setVariableValueOnly(this.variablesAtLineSrchBegin);
                }
            }
        }
        for (AlignmentMolecule alignmentMolecule : this.am) {
            alignmentMolecule.setVariables(this.variables);
        }
        this.update();
        if (!this.isInsideNumericGradient && this.gr != null && this.gr.getNumberOfInnerSteps() == 0 && this.stepCount > this.smallStepCountLimit) {
            for (AlignmentMolecule alignmentMolecule : this.am) {
                double d = alignmentMolecule.centerDistance();
                if (alignmentMolecule.isRigid() && d > 0.01) {
                    throw new IllegalStateException("Center displacement for rigid mol!!!!");
                }
                if (!(d > this.centerDisplacementLimit)) continue;
                this.centerDisplacement = true;
            }
        }
        return true;
    }

    public void bigSoft(boolean b) {
        for (int i = 0; i < this.am.size(); ++i) {
            AlignmentMolecule alignmentMolecule = this.am.get(i);
            ((GaussianSum)alignmentMolecule.nodes).bigSoft(b);
        }
    }

    private void isSmallStep() {
        if (this.smallStepCountLimit == -1) {
            return;
        }
        for (AlignmentMolecule a : this.am) {
            a.updateIterator();
            Iterator<DegreeOfFeedom> it = a.getDfIterator();
            while (it.hasNext()) {
                DegreeOfFeedom df = it.next();
                if (df.isSmallStep(this.variables)) continue;
                a.updateIterator();
                return;
            }
            a.updateIterator();
        }
        ++this.smallStepCount;
    }

    @Override
    public double[] getVariables() {
        for (AlignmentMolecule a : this.am) {
            this.variables = a.getVariables(this.variables);
        }
        return this.variables;
    }

    private double getVolOverlap() throws AlignmentException {
        double t = 0.0;
        if (this.overlaps != null) {
            if (this.overlaps.length == 1) {
                t = this.overlaps[0].getWeightedOverlap();
            } else {
                for (VolumeOverlap overlap : this.overlaps) {
                    t += overlap.getWeightedOverlap();
                }
            }
        }
        return t;
    }

    @Override
    public void fillStatus() {
        double f = 0.0;
        for (AlignmentMolecule am1 : this.am) {
            if (am1.isRigid()) continue;
            List<MolecularConstraint> w = ((FlexibleMolecule)am1).getWishes();
            if (w != null) {
                for (MolecularConstraint internal : w) {
                    f += internal.getEnergy();
                }
            }
            ((FlexibleMolecule)am1).fillWarningInfo();
        }
        if (this.constr != null) {
            for (AlignmentConstraint ac : this.constr) {
                f += ac.getEnergy();
            }
        }
        this.statusOpt.setConstraintScore(f);
        try {
            this.statusOpt.setVolumeScore(this.getVolOverlap());
        }
        catch (AlignmentException a) {
            throw new IllegalStateException(a);
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.centerDisplacement) {
            return true;
        }
        if (this.smallStepCountLimit > -1 && this.smallStepCount > this.smallStepCountLimit) {
            return true;
        }
        return super.isCancelled();
    }

    public boolean isCenterDisplacement() {
        return this.centerDisplacement;
    }

    public void setCenterDisplacementLimit(double centerDisplacementLimit) {
        this.centerDisplacementLimit = centerDisplacementLimit;
    }

    @Override
    public ChangeCorrector getChangeCorrector() {
        return new ChangeCorrector(){

            @Override
            public double[] correct(double[] steps) {
                for (AlignmentMolecule a : FunctionMoreMols.this.am) {
                    a.updateIterator();
                    Iterator<DegreeOfFeedom> it = a.getDfIterator();
                    while (it.hasNext()) {
                        DegreeOfFeedom df = it.next();
                        if (!(df instanceof Dihedral) && !(df instanceof EulerRotate)) continue;
                        steps[df.getPosition()] = Function.angleDiff(steps[df.getPosition()]);
                    }
                }
                return steps;
            }
        };
    }

    public void setSmallStepCountLimit(int smallStepCountLimit) {
        this.smallStepCountLimit = smallStepCountLimit;
    }

    void checkMols() throws AlignmentException {
        for (AlignmentMolecule a : this.am) {
            a.checkCoordinates();
            a.checkBondLength();
        }
    }
}

