/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.Dihedral;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.Function;
import chemaxon.marvin.alignment.QuaternionAlign;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.struc.MolGeom;
import java.util.List;

class FunctionTwoMolsQuatFit
extends Function {
    AlignmentMolecule am1;
    AlignmentMolecule am2;
    List<AlignmentConstraint> constr;
    QuaternionAlign qua;

    FunctionTwoMolsQuatFit(AlignmentMolecule am1, AlignmentMolecule am2, List<AlignmentConstraint> constr, int stepLimit, int timeLimit) throws AlignmentException {
        super(stepLimit, timeLimit);
        FlexibleMolecule fm;
        this.am1 = am1;
        this.am2 = am2;
        am1.setEnableTranslateAndRotate(false);
        am2.setEnableTranslateAndRotate(false);
        this.statusOpt.addStatusMol(am1.getStatus());
        this.statusOpt.addStatusMol(am2.getStatus());
        this.constr = constr;
        int l1 = 0;
        int l2 = 0;
        int pos = 0;
        this.qua = new QuaternionAlign();
        if (!am1.isRigid()) {
            fm = (FlexibleMolecule)am1;
            l1 = fm.getDihedrals().size();
            fm.setOneSideRotationForAllDihedrals(true);
            for (Dihedral d : fm.getDihedrals()) {
                d.setPosition(pos);
                pos += d.getLength();
            }
        }
        if (!am2.isRigid()) {
            fm = (FlexibleMolecule)am2;
            fm.setOneSideRotationForAllDihedrals(true);
            l2 = fm.getDihedrals().size();
            for (Dihedral d : fm.getDihedrals()) {
                d.setPosition(pos);
                pos += d.getLength();
            }
        }
        int all = l1 + l2;
        this.gradient = new double[all];
        this.variables = new double[all];
        this.qua.align(constr, am2);
        pos = 0;
        try {
            FlexibleMolecule fm2;
            if (!am1.isRigid()) {
                fm2 = (FlexibleMolecule)am1;
                l1 = fm2.getDihedrals().size();
                fm2.setOneSideRotationForAllDihedrals(true);
                for (Dihedral d : fm2.getDihedrals()) {
                    d.recalcAngle();
                    d.getVariable(this.variables);
                }
            }
            if (!am2.isRigid()) {
                fm2 = (FlexibleMolecule)am2;
                fm2.setOneSideRotationForAllDihedrals(true);
                l2 = fm2.getDihedrals().size();
                for (Dihedral d : fm2.getDihedrals()) {
                    d.recalcAngle();
                    d.getVariable(this.variables);
                }
            }
        }
        catch (MolGeom.LinearBondAngleException l) {
            throw new UnsupportedOperationException(l);
        }
    }

    @Override
    void reset() {
        FlexibleMolecule fm;
        if (!this.am1.isRigid()) {
            fm = (FlexibleMolecule)this.am1;
            fm.resetProximities();
        }
        if (!this.am2.isRigid()) {
            fm = (FlexibleMolecule)this.am2;
            fm.resetProximities();
        }
        super.reset();
    }

    public void setProximity(boolean proximity) {
        if (!this.am1.isRigid()) {
            ((FlexibleMolecule)this.am1).setProximity(proximity);
        }
        if (!this.am2.isRigid()) {
            ((FlexibleMolecule)this.am2).setProximity(proximity);
        }
    }

    @Override
    void update() {
        FlexibleMolecule f;
        FlexibleMolecule.updateConstraints(this.constr);
        if (!this.am1.isRigid()) {
            this.am1.updateIterator();
            f = (FlexibleMolecule)this.am1;
            f.updateConstraints();
        }
        if (!this.am2.isRigid()) {
            this.am2.updateIterator();
            f = (FlexibleMolecule)this.am2;
            f.updateConstraints();
        }
    }

    @Override
    public double getFunctionValue() {
        double fv = 0.0;
        if (!this.am1.isRigid()) {
            fv += ((FlexibleMolecule)this.am1).functionValue();
        }
        if (!this.am2.isRigid()) {
            fv += ((FlexibleMolecule)this.am2).functionValue();
        }
        double ext = 0.0;
        for (AlignmentConstraint ac : this.constr) {
            ext += ac.getEnergy();
        }
        return fv + 2.0 * ext;
    }

    @Override
    public double[] getFunctionGradient() {
        for (int i = 0; i < this.gradient.length; ++i) {
            this.gradient[i] = 0.0;
        }
        this.gradient = this.am1.gradient(this.gradient, this.constr);
        this.gradient = this.am2.gradient(this.gradient, this.constr);
        ++this.stepCount;
        if (this.vis != null) {
            this.vis.showSteps();
        }
        return this.gradient;
    }

    @Override
    public boolean setVariables(double[] var) {
        this.am1.setVariables(this.variables);
        this.am2.setVariables(this.variables);
        try {
            this.qua.align(this.constr, this.am2);
        }
        catch (AlignmentException ex) {
            throw new UnsupportedOperationException(ex);
        }
        this.update();
        return true;
    }

    @Override
    public void setGr(GradientOptimization gr) {
    }

    @Override
    public void fillStatus() {
        double f = 0.0;
        if (this.constr != null) {
            for (AlignmentConstraint ac : this.constr) {
                f += ac.getEnergy();
            }
        }
        this.statusOpt.setConstraintScore(f);
    }

    @Override
    public double[] getVariables() {
        return this.variables;
    }
}

