/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.modelling.struc.MolGeom;
import java.io.Serializable;

class Gaussian
implements Serializable {
    double[] crd;
    double p;
    double a;

    public Gaussian(double p, double alpha, double[] crd) {
        this.crd = crd;
        this.p = p;
        this.a = alpha;
    }

    Gaussian() {
        this.crd = new double[3];
    }

    public double getA() {
        return this.a;
    }

    public double getP() {
        return this.p;
    }

    public double getValue(double rSquare) {
        return this.p * Math.exp(-this.a * rSquare);
    }

    public double getValue(double[] crdPos) {
        double rSquare = MolGeom.getDistSq(this.crd, crdPos);
        return this.getValue(rSquare);
    }

    public double integral() {
        double v = Math.PI / this.a;
        double val = this.p * Math.sqrt(v * v * v);
        return val;
    }

    static void productOf(Gaussian g1, Gaussian g2, Gaussian result, double rSQ) {
        double a = g1.getA() + g2.getA();
        double p = g1.getP() * g2.getP() * Math.exp(-g1.getA() * g2.getA() * rSQ / a);
        double x = (g1.getA() * g1.getCrd()[0] + g2.getA() * g2.getCrd()[0]) / a;
        double y = (g1.getA() * g1.getCrd()[1] + g2.getA() * g2.getCrd()[1]) / a;
        double z = (g1.getA() * g1.getCrd()[2] + g2.getA() * g2.getCrd()[2]) / a;
        result.set(x, y, z, a, p);
    }

    static double productOf(Gaussian g1, Gaussian g2, Gaussian result) {
        double distSQ = g1.getDistSQ(g2);
        Gaussian.productOf(g1, g2, result, distSQ);
        return distSQ;
    }

    void set(double x, double y, double z, double a, double p) {
        this.crd[0] = x;
        this.crd[1] = y;
        this.crd[2] = z;
        this.a = a;
        this.p = p;
    }

    public String toString() {
        return " p: " + this.p + " a: " + this.a;
    }

    public double[] getCrd() {
        return this.crd;
    }

    public double getDistSQ(Gaussian n) {
        return MolGeom.getDistSq(this.crd, n.getCrd());
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }
}

