/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class GaussianPotential
implements PotentialFunction {
    double prefix;
    double denom;
    double weight;
    double tolerance;
    private static double pi = Math.sqrt(Math.PI * 2);

    public GaussianPotential(double weight, double tolerance) {
        this.prefix = 1.0 / pi / tolerance;
        this.denom = 2.0 * tolerance * tolerance;
        this.weight = weight;
        this.tolerance = tolerance;
    }

    @Override
    public double functionValue(double x) {
        return -this.weight * this.prefix * Math.exp(-x * x / this.denom);
    }

    @Override
    public PotentialType getType() {
        return PotentialType.GAUSSIAN;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isOk(double x) {
        return x < this.tolerance;
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        return this.weight * (2.0 / this.denom * this.prefix * Math.exp(-dist * dist / this.denom));
    }
}

