/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignRigidEasy;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class HitAlignment2D {
    private double angle;
    private AlignRigidEasy a;
    private static final double NULL_VEC_SIZE = 1.0E-6;
    private static final double Z_COORDINATE_LIMIT = 1.0E-4;
    private static final double COS_ANGLE_LIMIT = Math.cos(0.17453292519943295);
    private boolean flipped;
    private boolean alignWasPerformed = false;

    public HitAlignment2D(Molecule m) {
        HitAlignment2D.check2D(m);
        this.a = new AlignRigidEasy();
        this.a.setReference(m);
    }

    public void setMoleculeToRotate(Molecule m2) {
        HitAlignment2D.check2D(m2);
        this.a.setRotatable(m2);
        this.alignWasPerformed = false;
    }

    public void align(int[][] map) throws AlignmentException {
        Norm before = HitAlignment2D.normalOfMolecule(this.a.getRotatedCoordinates());
        this.a.align(map);
        HitAlignment2D.checkZExpansion(this.a.getRotatedMolecule());
        double[] q = this.a.getQuaternion();
        this.angle = Math.acos(q[0]) * 2.0;
        if (before != null) {
            Norm after = HitAlignment2D.normalOfAtoms(this.a.getRotatedCoordinates(), before.i, before.j, before.k);
            if (after == null) {
                throw new IllegalStateException("coordinates are messed up");
            }
            this.flipped = before.normalZ * after.normalZ < 0.0;
        } else {
            this.flipped = false;
        }
        this.alignWasPerformed = true;
    }

    boolean isFlipped() {
        this.checkAlignementConsistency();
        return this.flipped;
    }

    private void checkAlignementConsistency() {
        if (!this.alignWasPerformed) {
            throw new IllegalStateException("Incorrect usage: use align method first");
        }
    }

    @Deprecated
    public Molecule getRotatedMolecule() {
        this.checkAlignementConsistency();
        return this.a.getRotatedMolecule();
    }

    public Molecule getRotatedMoleculeAndFlipBonds() {
        this.checkAlignementConsistency();
        Molecule ret = this.a.getRotatedMolecule();
        if (this.flipped) {
            for (MolBond molBond : ret.getBondArray()) {
                HitAlignment2D.flipWedge(molBond);
            }
        }
        return ret;
    }

    private static void checkZExpansion(Molecule m) throws AlignmentException {
        for (MolAtom a : m.getAtomArray()) {
            if (!(Math.abs(a.getZ()) > 1.0E-4)) continue;
            throw new AlignmentException("2D molecule has been rotated into the 3D space. Atom/atom mapping error!");
        }
    }

    private static void flipWedge(MolBond b) {
        if ((b.getFlags() & 0x30) == 16) {
            b.setFlags(32, 48);
        } else if ((b.getFlags() & 0x30) == 32) {
            b.setFlags(16, 48);
        }
    }

    public double rmsd() {
        this.checkAlignementConsistency();
        return this.a.rmsd();
    }

    public double getRotationAngle() {
        this.checkAlignementConsistency();
        return this.angle;
    }

    private static Norm normalOfMolecule(double[][] crd) {
        if (crd.length < 3) {
            return null;
        }
        int g = crd.length - 1;
        Norm n = HitAlignment2D.normalOfAtoms(crd, 0, (int)((double)g / 2.0), g);
        if (n != null) {
            return n;
        }
        for (int i = 0; i < crd.length; ++i) {
            for (int j = i + 1; j < crd.length; ++j) {
                for (int k = j + 1; k < crd.length; ++k) {
                    Norm nn = HitAlignment2D.normalOfAtoms(crd, i, j, k);
                    if (nn == null) continue;
                    return nn;
                }
            }
        }
        return null;
    }

    private static double[] normalVectorFor(double[] ai, double[] aj) {
        double[] v = new double[]{ai[0] - aj[0], ai[1] - aj[1]};
        double length = v[0] * v[0] + v[1] * v[1];
        if (length < 1.0E-6) {
            return null;
        }
        length = 1.0 / Math.sqrt(length);
        v[0] = v[0] * length;
        v[1] = v[1] * length;
        return v;
    }

    private static Norm normalOfAtoms(double[][] crd, int i, int j, int k) {
        double[] v1 = HitAlignment2D.normalVectorFor(crd[i], crd[j]);
        if (v1 == null) {
            return null;
        }
        double[] v2 = HitAlignment2D.normalVectorFor(crd[k], crd[j]);
        if (v2 == null) {
            return null;
        }
        if (Math.abs(v1[0] * v2[0] + v1[1] * v2[1]) < COS_ANGLE_LIMIT) {
            return new Norm(HitAlignment2D.normalZ(v1, v2), i, j, k);
        }
        return null;
    }

    private static double normalZ(double[] v1, double[] v2) {
        return v1[0] * v2[1] - v1[1] * v2[0];
    }

    private static void check2D(Molecule m) {
        if (m.getDim() != 2) {
            throw new IllegalArgumentException("Molecule has to be in 2D.");
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (!(Math.abs(m.getAtom(i).getZ()) > 1.0E-4)) continue;
            throw new IllegalStateException("2D molecule extends to Z direction");
        }
    }

    private static class Norm {
        double normalZ;
        private int i;
        private int j;
        private int k;

        public Norm(double z, int i, int j, int k) {
            this.i = i;
            this.j = j;
            this.k = k;
            this.normalZ = z;
        }
    }
}

