/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.BowlFunction;
import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class InternalBowlPotential
extends BowlFunction
implements PotentialFunction {
    public static final double INTERNAL_RADIUS_SCALE = 0.7;
    double dist0;
    double tolerance;

    public InternalBowlPotential(double weight, double tolerance, double dist0) {
        super(weight, weight / 2.0);
        this.dist0 = dist0;
        this.tolerance = tolerance;
    }

    @Override
    public double functionValue(double x) {
        double r0;
        boolean isIncrease;
        if (x > this.dist0) {
            isIncrease = true;
            r0 = this.dist0 + this.tolerance * 0.7;
        } else {
            isIncrease = false;
            r0 = this.dist0 - this.tolerance * 0.7;
        }
        return this.function(x, r0, isIncrease);
    }

    private double getFunctionDerivate(double x) {
        double r0;
        boolean isIncrease;
        if (x > this.dist0) {
            isIncrease = true;
            r0 = this.dist0 + this.tolerance * 0.7;
        } else {
            isIncrease = false;
            r0 = this.dist0 - this.tolerance * 0.7;
        }
        return this.functionDeriv(x, r0, isIncrease);
    }

    public double getDist0() {
        return this.dist0;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isOk(double x) {
        return Math.abs(x - this.dist0) < this.tolerance;
    }

    @Override
    public PotentialType getType() {
        return PotentialType.BOWL;
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        if (dist < 1.0E-6) {
            throw new UnsupportedOperationException("distance too small");
        }
        return this.getFunctionDerivate(dist) / dist;
    }
}

