/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.TorsionComponent;
import chemaxon.struc.Molecule;
import java.util.Vector;

class MMFF
implements ForceFieldInterface {
    private MMFF94 mmff = new MMFF94();
    private Vector<MMFFComponent> torsions = null;

    MMFF() throws MMFF94Exception {
    }

    @Override
    public void init(Molecule m) {
        this.mmff.init(m);
        this.torsions = this.mmff.getMMFFComponents(4);
    }

    @Override
    public double dihedralEnergy(int a1, int a2) {
        double E = 0.0;
        Vector<TorsionComponent> t = this.getTorsionComponents(a1, a2);
        for (int i = 0; i < t.size(); ++i) {
            E += t.get(i).getEnergy();
        }
        return E;
    }

    @Override
    public double dihedralGradient(int a1, int a2) {
        double dE = 0.0;
        Vector<TorsionComponent> t = this.getTorsionComponents(a1, a2);
        for (int i = 0; i < t.size(); ++i) {
            t.get(i).getEnergy();
            dE += t.get(i).getDerivative()[0];
        }
        return dE;
    }

    private Vector<TorsionComponent> getTorsionComponents(int a1, int a2) {
        Vector<TorsionComponent> dih = new Vector<TorsionComponent>();
        for (int i = 0; i < this.torsions.size(); ++i) {
            TorsionComponent iTors = (TorsionComponent)this.torsions.get(i);
            int[] idx = iTors.getInternalCoordinates()[0].getAtomIndeces();
            if (idx[1] != a1 || idx[2] != a2) continue;
            dih.add(iTors);
        }
        return dih;
    }

    @Override
    public double longRangeEnergy(int a1, int a2) {
        return this.mmff.getLongRange_E(a1, a2);
    }

    @Override
    public double longRangeGradient(int a1, int a2) {
        return this.mmff.getLongRange_dE(a1, a2);
    }

    @Override
    public double[][] optimize() {
        try {
            this.mmff.optimize();
        }
        catch (GradientOptimization.GradientOptimizationException e) {
            System.err.println("Optimization failed!");
        }
        return this.getCoordinates();
    }

    public void setGradientRMSLimit(double gradientRMSLimit) {
        this.mmff.setGradientRMSLimit(gradientRMSLimit);
    }

    public double[][] getCoordinates() {
        double[] var = this.mmff.getVariables();
        double[][] crd = new double[var.length / 3][3];
        int j = 0;
        for (int i = 0; i < crd.length; ++i) {
            crd[i][0] = var[j++];
            crd[i][1] = var[j++];
            crd[i][2] = var[j++];
        }
        return crd;
    }

    @Override
    public void setCoordinates(double[][] crd) {
        double[] var = new double[3 * crd.length];
        for (int i = 0; i < crd.length; ++i) {
            var[3 * i] = crd[i][0];
            var[3 * i + 1] = crd[i][1];
            var[3 * i + 2] = crd[i][2];
        }
        this.mmff.copyCoordinatesFrom(var);
    }
}

