/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

class Matrix3x3 {
    double v11;
    double v12;
    double v13;
    double v21;
    double v22;
    double v23;
    double v31;
    double v32;
    double v33;

    public void getParamsFrom(Matrix3x3 a) {
        this.v11 = a.v11;
        this.v12 = a.v12;
        this.v13 = a.v13;
        this.v21 = a.v21;
        this.v22 = a.v22;
        this.v23 = a.v23;
        this.v31 = a.v31;
        this.v32 = a.v32;
        this.v33 = a.v33;
    }

    public void setParams(double v11, double v12, double v13, double v21, double v22, double v23, double v31, double v32, double v33) {
        this.v11 = v11;
        this.v12 = v12;
        this.v13 = v13;
        this.v21 = v21;
        this.v22 = v22;
        this.v23 = v23;
        this.v31 = v31;
        this.v32 = v32;
        this.v33 = v33;
    }

    public void add(Matrix3x3 a) {
        this.v11 += a.v11;
        this.v12 += a.v12;
        this.v13 += a.v13;
        this.v21 += a.v21;
        this.v22 += a.v22;
        this.v23 += a.v23;
        this.v31 += a.v31;
        this.v32 += a.v32;
        this.v33 += a.v33;
    }

    public void multiplyByScalar(double d) {
        this.v11 *= d;
        this.v12 *= d;
        this.v13 *= d;
        this.v21 *= d;
        this.v22 *= d;
        this.v23 *= d;
        this.v31 *= d;
        this.v32 *= d;
        this.v33 *= d;
    }

    public double[] multiplyByVec(double[] v, double[] res) {
        res[0] = this.v11 * v[0] + this.v12 * v[1] + this.v13 * v[2];
        res[1] = this.v21 * v[0] + this.v22 * v[1] + this.v23 * v[2];
        res[2] = this.v31 * v[0] + this.v32 * v[1] + this.v33 * v[2];
        return res;
    }

    public double[] mulAndWriteBack(double[] v) {
        double xRet = this.v11 * v[0] + this.v12 * v[1] + this.v13 * v[2];
        double yRet = this.v21 * v[0] + this.v22 * v[1] + this.v23 * v[2];
        double zRet = this.v31 * v[0] + this.v32 * v[1] + this.v33 * v[2];
        v[0] = xRet;
        v[1] = yRet;
        v[2] = zRet;
        return v;
    }

    public String toString() {
        return "" + this.v11 + " " + this.v12 + " " + this.v13 + "\n" + this.v21 + " " + this.v22 + " " + this.v23 + "\n" + this.v31 + " " + this.v32 + " " + this.v33 + "\n";
    }
}

