/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentBase;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionMinMax;
import chemaxon.marvin.alignment.MinMaxConstraint;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.VanDerWaalsInterface;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class MinMaxDistance
extends AlignmentBase {
    public static final double WEIGHT = 1.0;
    private double minDist = -1.0;
    private double maxDist = -1.0;
    private MinMaxConstraint span;
    private boolean newFunctionIsReq = true;
    private FlexibleMolecule fm;
    private boolean spanWasAdded = false;
    private int minDistTryCount = 2;

    public MinMaxDistance() {
        this.setProperty(AlignmentProperties.PAIRED);
        this.checkLicense();
        this.span = new MinMaxConstraint(1.0);
        this.convergenceLimit = 0.01;
    }

    public void setMolecule(Molecule m) throws AlignmentException {
        this.molecules.clear();
        this.spanWasAdded = false;
        this.addMolecule(m, true, false);
        this.fm = null;
        if (!((AlignmentMolecule)this.molecules.get(0)).isRigidMol()) {
            this.fm = (FlexibleMolecule)this.molecules.get(0);
        }
        this.resetMap();
    }

    void setMolecule(AlignmentMolecule am) throws AlignmentException {
        this.molecules.clear();
        this.spanWasAdded = false;
        this.addMol(am);
        this.fm = null;
        if (!((AlignmentMolecule)this.molecules.get(0)).isRigidMol()) {
            this.fm = (FlexibleMolecule)this.molecules.get(0);
        }
        this.resetMap();
    }

    void setNode1(Node n) {
        this.span.setAtom1(n);
        this.newFunctionIsReq = true;
    }

    void setNode2(Node n) {
        this.span.setAtom2(n);
        this.newFunctionIsReq = true;
    }

    public void setAtom1(int atom1) {
        this.span.setAtom1(((AlignmentMolecule)this.molecules.get(0)).getAtom(atom1));
        this.newFunctionIsReq = true;
    }

    public void setAtom2(int atom2) {
        this.span.setAtom2(((AlignmentMolecule)this.molecules.get(0)).getAtom(atom2));
        this.newFunctionIsReq = true;
    }

    private void run() throws AlignmentException {
        if (this.newFunctionIsReq) {
            this.function = new FunctionMinMax(this.fm, this.stepLimit, this.timeLimit, 0, this.span);
            if (this.vis != null) {
                this.function.setVis(this.vis);
                ArrayList<AlignmentMolecule> v = new ArrayList<AlignmentMolecule>();
                v.add(this.fm);
                this.vis.init(v, null);
            }
            this.newFunctionIsReq = false;
        }
        this.fm.updateDihedrals();
        this.fm.updateRingCenters();
        this.fm.updateConstraints();
        this.optimization();
    }

    private void handleRigidCase() {
        if (this.fm == null || !this.fm.isThereFlexiblePathBetween(this.span.getNode1().getFirstAtomSeq(), this.span.getNode2().getFirstAtomSeq())) {
            this.maxDist = this.minDist = this.span.getDist();
        }
    }

    public void setMinDistTryCount(int minDistTryCount) {
        this.minDistTryCount = minDistTryCount;
    }

    public double calcMinDist() throws AlignmentException {
        this.isNull();
        if (this.minDist != -1.0) {
            return this.minDist;
        }
        this.handleRigidCase();
        if (this.minDist != -1.0) {
            return this.minDist;
        }
        double r0 = ((VanDerWaalsInterface)((Object)this.span.getNode1())).getVanDerWaalsRadius();
        r0 += ((VanDerWaalsInterface)((Object)this.span.getNode2())).getVanDerWaalsRadius();
        this.span.setDist0(r0 *= 1.0);
        this.fm.resetToOriginalCoordinates();
        if (!this.spanWasAdded) {
            this.fm.addIntraMolConstr(this.span);
            this.spanWasAdded = true;
        }
        this.run();
        this.minDist = this.span.getDist();
        for (int i = 0; i < this.minDistTryCount; ++i) {
            this.fm.randomizeDihedrals();
            this.run();
            if (!(this.minDist > this.span.getDist())) continue;
            this.minDist = this.span.getDist();
        }
        return this.minDist;
    }

    public double calcMaxDist() throws AlignmentException {
        this.isNull();
        if (this.maxDist != -1.0) {
            return this.maxDist;
        }
        this.handleRigidCase();
        if (this.maxDist != -1.0) {
            return this.maxDist;
        }
        this.fm.resetToOriginalCoordinates();
        if (!this.spanWasAdded) {
            this.fm.addIntraMolConstr(this.span);
            this.spanWasAdded = true;
        }
        this.fm.extend();
        this.span.setDist0(-1.0);
        this.run();
        this.maxDist = this.span.getDist();
        return this.maxDist;
    }

    private void isNull() throws AlignmentException {
        if (this.span.getNode1() == null || this.span.getNode2() == null) {
            throw new AlignmentException("Set both atoms to calculate distance");
        }
    }

    public void resetMap() {
        if (this.fm != null) {
            this.fm.resetToOriginalCoordinates();
            this.fm.updateConstraints();
            this.fm.updateDihedrals();
            this.fm.updateRingCenters();
            this.fm.updateIterator();
        }
        this.minDist = -1.0;
        this.maxDist = -1.0;
        this.span.update();
        this.span.resetNodes();
    }
}

