/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AtomicGaussian;
import chemaxon.marvin.alignment.MolecularGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.Updatable;
import chemaxon.marvin.alignment.VanDerWaalsInterface;
import java.util.BitSet;

class MultiCenterGaussian
extends MolecularGaussian
implements Updatable,
VanDerWaalsInterface {
    private int type = -1;
    private AtomicGaussian[] members;
    private int pos = 0;
    private double vanDerWaalsRadius;
    private int originalAtomType;

    public MultiCenterGaussian(int molID, double p, double alpha, AtomicGaussian[] members, int type, int pos) {
        super(molID, p, alpha, new double[3]);
        this.members = members;
        this.type = type;
        this.pos = pos;
        this.update();
    }

    @Override
    public int getMemberCount() {
        return 1;
    }

    @Override
    public double getTypeScale(int type, NodeColor c) {
        if (c.isSameType(type, this.type)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public boolean equals(Node node) {
        MultiCenterGaussian mg;
        if (node instanceof MultiCenterGaussian && (mg = (MultiCenterGaussian)node).getMembers().length == this.members.length) {
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i].equals(mg.getMembers()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCommonMember(Node node) {
        BitSet tmp1 = new BitSet();
        BitSet tmp2 = new BitSet();
        node.markAtoms(tmp1);
        this.markAtoms(tmp2);
        tmp1.and(tmp2);
        return tmp1.cardinality() > 0;
    }

    @Override
    public int getFirstAtomSeq() {
        return this.pos;
    }

    @Override
    public int getNextAtomSeq() {
        return -1;
    }

    @Override
    public boolean isRealAtom() {
        return true;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public BitSet markAtoms(BitSet b) {
        b.clear();
        for (int i = 0; i < this.members.length; ++i) {
            b.set(this.members[i].atomSeq);
        }
        return b;
    }

    public AtomicGaussian[] getMembers() {
        return this.members;
    }

    @Override
    public final void update() {
        this.crd[0] = 0.0;
        this.crd[1] = 0.0;
        this.crd[2] = 0.0;
        for (int i = 0; i < this.members.length; ++i) {
            this.crd[0] = this.crd[0] + this.members[i].crd[0];
            this.crd[1] = this.crd[1] + this.members[i].crd[1];
            this.crd[2] = this.crd[2] + this.members[i].crd[2];
        }
        this.crd[0] = this.crd[0] / (double)this.members.length;
        this.crd[1] = this.crd[1] / (double)this.members.length;
        this.crd[2] = this.crd[2] / (double)this.members.length;
    }

    @Override
    public void setType(int t) {
        this.type = t;
    }

    @Override
    public String toString() {
        String s = "Multicenter Gaussian Type: " + this.type + " " + super.toString() + "\nMembers:\n";
        for (int i = 0; i < this.members.length; ++i) {
            s = s + this.members[i].toString() + "\n";
        }
        return s;
    }

    @Override
    public int getOriginalAtomType() {
        return this.originalAtomType;
    }

    public void setOriginalAtomType(int originalAtomType) {
        this.originalAtomType = originalAtomType;
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.vanDerWaalsRadius;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.vanDerWaalsRadius = radius;
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public boolean equalsForDisabling(Node n) {
        return false;
    }
}

