/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.VanDerWaalsInterface;
import chemaxon.marvin.modelling.struc.MolGeom;
import java.util.BitSet;

class NodeSimple
implements Node,
VanDerWaalsInterface {
    private double[] crd;
    private int molID;
    private int nodeSeq;
    private int type;
    private int originalAtomType;
    private double vanDerWaalsRadius;
    private boolean centeringMember = false;

    public NodeSimple(int molID, int nodeSeq, double[] crd, int type, int originalAtomType) {
        this.crd = crd;
        this.molID = molID;
        this.nodeSeq = nodeSeq;
        this.type = type;
        this.originalAtomType = originalAtomType;
    }

    @Override
    public double[] getCrd() {
        return this.crd;
    }

    @Override
    public String toString() {
        return "molID: " + this.molID + " nodeSeq: " + this.nodeSeq;
    }

    @Override
    public double getDistSQ(Node n) {
        return MolGeom.getDistSq(this.crd, n.getCrd());
    }

    @Override
    public int getMolID() {
        return this.molID;
    }

    @Override
    public boolean equals(Node node) {
        return node instanceof NodeSimple && ((NodeSimple)node).nodeSeq == this.nodeSeq && this.molID == node.getMolID();
    }

    @Override
    public boolean isRealAtom() {
        return true;
    }

    @Override
    public int getFirstAtomSeq() {
        return this.nodeSeq;
    }

    @Override
    public int getNextAtomSeq() {
        return -1;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean hasCommonMember(Node node) {
        return this.equals(node);
    }

    @Override
    public BitSet markAtoms(BitSet b) {
        b.clear();
        b.set(this.nodeSeq, true);
        return b;
    }

    @Override
    public void setType(int t) {
        this.type = t;
    }

    @Override
    public void setMolID(int molID) {
        this.molID = molID;
    }

    @Override
    public int getOriginalAtomType() {
        return this.originalAtomType;
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.vanDerWaalsRadius;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.vanDerWaalsRadius = radius;
    }

    @Override
    public void setCenteringMember(boolean center) {
        this.centeringMember = center;
    }

    @Override
    public boolean isCenteringMembers() {
        return this.centeringMember;
    }

    @Override
    public boolean isSelected() {
        return false;
    }
}

