/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.QuaternionAlign;
import chemaxon.marvin.modelling.struc.MolGeom;
import java.util.ArrayList;
import java.util.List;

abstract class Orientation {
    boolean switch12 = false;
    AlignmentMolecule am1;
    AlignmentMolecule am2;
    QuaternionAlign qua;
    List<AlignmentConstraint> constr;
    boolean enableVis = true;
    public static double WEIGHT = 10.0;
    double[][] crd1;
    double[][] crd2;

    public Orientation(AlignmentMolecule am1, AlignmentMolecule am2) throws AlignmentException {
        this.am1 = am1;
        this.am2 = am2;
        if (am1.getColoringScheme() != am2.getColoringScheme()) {
            throw new AlignmentException("Coloring Scheme mismatch. ");
        }
        if (!am1.isEnableTranslateAndRotate()) {
            throw new AlignmentException("First molecule is requested to be translated/rotated freely.");
        }
        this.qua = new QuaternionAlign();
        this.constr = new ArrayList<AlignmentConstraint>();
    }

    public abstract boolean addConstraints() throws AlignmentException;

    public boolean nextOrientation() throws AlignmentException {
        this.constr.clear();
        if (!this.addConstraints()) {
            return false;
        }
        this.putConformations();
        this.qua.align(this.constr, this.am1);
        return true;
    }

    public abstract void reset();

    public List<AlignmentConstraint> getConstr() {
        return this.constr;
    }

    private boolean randomize(AlignmentMolecule am1) {
        am1.resetToOriginalCoordinates();
        boolean b = false;
        if (!am1.isRigid()) {
            FlexibleMolecule f = (FlexibleMolecule)am1;
            f.randomizeDihedrals();
            f.updateConstraints();
            f.updateDihedrals();
            b = true;
        }
        am1.updateGaussianProducts();
        am1.updateRingCenters();
        am1.updateIterator();
        return b;
    }

    public boolean randomize() {
        boolean b1 = this.randomize(this.am1);
        boolean b2 = this.randomize(this.am2);
        return b1 || b2;
    }

    public abstract boolean areConstraintsAddable();

    void saveConformations() {
        this.crd1 = MolGeom.arrayCopy(this.am1.getAllCrd());
        this.crd2 = MolGeom.arrayCopy(this.am2.getAllCrd());
    }

    void putConformations() {
        FlexibleMolecule fm;
        this.am1.copyAllCrd(this.crd1);
        this.am2.copyAllCrd(this.crd2);
        if (!this.am1.isRigid()) {
            fm = (FlexibleMolecule)this.am1;
            fm.updateConstraints();
            fm.updateDihedrals();
        }
        if (!this.am2.isRigid()) {
            fm = (FlexibleMolecule)this.am2;
            fm.updateConstraints();
            fm.updateDihedrals();
        }
    }

    public AlignmentMolecule getAm1() {
        return this.am1;
    }

    public AlignmentMolecule getAm2() {
        return this.am2;
    }

    public abstract int getOrientationCount();
}

