/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class Pharmacophore3D {
    private Molecule pharmacophore;
    public static int DONR = 1;
    public static int ACCP = 4;
    public static int AROMATIC_ATOM = 8;
    public static int HYDR = 16;
    public static int POS = 32;
    public static int NEG = 64;
    public static int LP = 128;
    public static int H = 256;
    public static int AROMATIC_RINGCENTER = 512;
    public static int ALIPHATIC_RINGCENTER = 1024;
    public static int SHAPE = 2048;
    private static double lpLength = 1.8;
    private int[] colors;
    private double H_LENGTH = 1.1;

    public Pharmacophore3D() {
    }

    public Pharmacophore3D(Molecule m) throws AlignmentException {
        int i;
        String s = m.getProperty("PHColors");
        if (s != null) {
            this.pharmacophore = m;
            String[] a = s.split("_");
            this.colors = new int[a.length];
            for (int i2 = 0; i2 < a.length; ++i2) {
                this.colors[i2] = Integer.parseInt(a[i2]);
            }
            return;
        }
        Dreiding d = new Dreiding();
        d.setAromatize(false);
        Molecule tmp = m.cloneMolecule();
        try {
            MolGeom.addHydrogens3D(tmp);
        }
        catch (GradientOptimization.GradientOptimizationException e) {
            throw new AlignmentException(e);
        }
        int c = 0;
        while (c < tmp.getAtomCount()) {
            if (tmp.getAtom(c).getAtno() == 130) {
                tmp.removeAtom(c);
                continue;
            }
            ++c;
        }
        d.calculateAtomTypes(tmp);
        this.pharmacophore = tmp.cloneMolecule();
        int[][] ctab = tmp.getCtab();
        for (i = 0; i < tmp.getAtomCount(); ++i) {
            int lpcount = d.addableLonePairCountOnOxNi(i);
            if (lpcount <= 0) continue;
            MolAtom[] lps = new MolAtom[lpcount];
            for (int j = 0; j < lpcount; ++j) {
                lps[j] = new MolAtom(130);
                this.pharmacophore.add(lps[j]);
                MolBond mb = new MolBond(this.pharmacophore.getAtom(i), lps[j]);
                this.pharmacophore.add(mb);
            }
            if (lpcount == 2 && d.getDreidingAtomTypeID(i) == 15) {
                int carb = -1;
                int c1 = -1;
                carb = ctab[i][0];
                if (ctab[carb].length != 3 && tmp.getAtom(carb).getAtno() == 6) {
                    throw new UnsupportedOperationException("carbonyl carbons should have 3 neighboring bond.");
                }
                boolean found = false;
                for (int j = 0; j < ctab[carb].length && !found; ++j) {
                    c1 = ctab[carb][j];
                    if (c1 == i) continue;
                    found = true;
                }
                if (!found) {
                    throw new UnsupportedOperationException("sp2 oxigen neighbour mismatch is this carbon monoxide?");
                }
                this.addCarboxiylLonePairCrd(carb, i, c1, lps[0], lps[1]);
            }
            if (lpcount == 2 && d.getDreidingAtomTypeID(i) == 13) {
                if (ctab[i].length != 2) {
                    throw new UnsupportedOperationException("OH oxigens should have two neighbours.");
                }
                this.addOHLonePairCrd(this.pharmacophore.getAtom(i), this.pharmacophore.getAtom(ctab[i][0]), this.pharmacophore.getAtom(ctab[i][1]), lps[0], lps[1]);
            }
            if (lpcount == 1 && (d.getDreidingAtomTypeID(i) == 14 || d.getDreidingAtomTypeID(i) == 10)) {
                if (ctab[i].length != 2) {
                    throw new UnsupportedOperationException("Heteroatoms (N,O) should have two neighbours in the ring.");
                }
                this.addArLonePairCrd(this.pharmacophore.getAtom(i), this.pharmacophore.getAtom(ctab[i][0]), this.pharmacophore.getAtom(ctab[i][1]), lps[0]);
            }
            if (lpcount == 1 && d.getDreidingAtomTypeID(i) == 9) {
                if (ctab[i].length != 3) {
                    throw new UnsupportedOperationException("Amines should have 3 neighbours.");
                }
                this.addAmineLonePairCrd(this.pharmacophore.getAtom(i), this.pharmacophore.getAtom(ctab[i][0]), this.pharmacophore.getAtom(ctab[i][1]), this.pharmacophore.getAtom(ctab[i][2]), lps[0]);
            }
            if (lpcount == 1 && d.getDreidingAtomTypeID(i) == 11) {
                if (ctab[i].length != 2) {
                    throw new UnsupportedOperationException("The N in methylidene amin like substructures should have 2 neighbours.");
                }
                this.addMethilideneLonePairCrd(this.pharmacophore.getAtom(i), this.pharmacophore.getAtom(ctab[i][0]), this.pharmacophore.getAtom(ctab[i][1]), lps[0]);
            }
            if (lpcount != 1 || d.getDreidingAtomTypeID(i) != 12) continue;
            if (ctab[i].length != 1) {
                throw new UnsupportedOperationException("The N in cyanide should have 1 neighbour.");
            }
            this.addCyanideLonePairCrd(this.pharmacophore.getAtom(i), this.pharmacophore.getAtom(ctab[i][0]), lps[0]);
        }
        for (c = this.pharmacophore.getAtomCount() - 1; c >= 0; --c) {
            if ((double)this.pharmacophore.getAtom(c).getAtno() != 1.0 || d.getDreidingAtomTypeID(c) == 1) continue;
            this.pharmacophore.removeAtom(c);
        }
        ctab = this.pharmacophore.getCtab();
        d.calculateAtomTypes(this.pharmacophore);
        this.colors = new int[this.pharmacophore.getAtomCount()];
        for (i = 0; i < this.colors.length; ++i) {
            this.colors[i] = 0;
            for (int j = 0; j < ctab[i].length; ++j) {
                MolBond b;
                if (d.getDreidingAtomTypeID(ctab[i][j]) == 1) {
                    int n = i;
                    this.colors[n] = this.colors[n] | DONR;
                }
                if (this.pharmacophore.getAtom(ctab[i][j]).getAtno() == 130) {
                    int n = i;
                    this.colors[n] = this.colors[n] | ACCP;
                }
                if ((b = this.pharmacophore.getBond(this.pharmacophore.getBondTable().getBondIndex(i, ctab[i][j]))).getType() != 4) continue;
                int n = i;
                this.colors[n] = this.colors[n] | AROMATIC_ATOM;
                break;
            }
            int da = d.getDreidingAtomTypeID(i);
            if (this.pharmacophore.getAtom(i).getCharge() > 0) {
                int n = i;
                this.colors[n] = this.colors[n] | POS;
            }
            if (this.pharmacophore.getAtom(i).getCharge() < 0) {
                int n = i;
                this.colors[n] = this.colors[n] | NEG;
            }
            if (da == 1) {
                int n = i;
                this.colors[n] = this.colors[n] | H;
            }
            if (da == 58) {
                int n = i;
                this.colors[n] = this.colors[n] | LP;
            }
            if (this.colors[i] != 0) continue;
            this.colors[i] = HYDR;
        }
        Pharmacophore3D.setHBondLength(this.pharmacophore, this.H_LENGTH);
    }

    private static Molecule setHBondLength(Molecule m, double h) {
        int[][] ctab = m.getCtab();
        double[] hcrd = new double[3];
        double[] xcrd = new double[3];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getAtno() != 1) continue;
            hcrd[0] = a.getX();
            hcrd[1] = a.getY();
            hcrd[2] = a.getZ();
            if (ctab[i].length <= 0) continue;
            MolAtom b = m.getAtom(ctab[i][0]);
            xcrd[0] = b.getX();
            xcrd[1] = b.getY();
            xcrd[2] = b.getZ();
            MolGeom.minusVec(hcrd, xcrd, hcrd);
            double l = MolGeom.getLength(hcrd);
            MolGeom.mul(hcrd, h / l);
            MolGeom.plusVec(xcrd, hcrd, hcrd);
            a.setXYZ(hcrd[0], hcrd[1], hcrd[2]);
        }
        return m;
    }

    public static String typeLabel(int t) {
        String s = "";
        String sep = ";";
        if (Pharmacophore3D.isAromatic(t)) {
            s = s + "ARM";
        }
        if (Pharmacophore3D.isAcceptor(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "ACC";
        }
        if (Pharmacophore3D.isDonor(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "DON";
        }
        if (Pharmacophore3D.isNegative(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "NEG";
        }
        if (Pharmacophore3D.isPositive(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "POS";
        }
        if (Pharmacophore3D.isH(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "H";
        }
        if (Pharmacophore3D.isHydrophobic(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "HYD";
        }
        if (Pharmacophore3D.isLP(t)) {
            if (!s.equals("")) {
                s = s + sep;
            }
            s = s + "LP";
        }
        if (Pharmacophore3D.isAliphaticRC(t)) {
            return "ALIPHRINGC";
        }
        if (Pharmacophore3D.isAromaticRC(t)) {
            return "AROMRINGC";
        }
        return s.trim();
    }

    public Molecule getPharmacophore() {
        return this.pharmacophore;
    }

    private double[] getAtomCoords(MolAtom a) {
        double[] crd = new double[]{a.getX(), a.getY(), a.getZ()};
        return crd;
    }

    private void putAtomCoords(double[] crd, MolAtom a) {
        a.setXYZ(crd[0], crd[1], crd[2]);
    }

    private void addCyanideLonePairCrd(MolAtom an, MolAtom a1, MolAtom alp1) {
        double[] n = this.getAtomCoords(an);
        double[] c1 = this.getAtomCoords(a1);
        double[] v1 = new double[3];
        MolGeom.minusVec(c1, n, v1);
        V.normalize(v1);
        MolGeom.mul(v1, -1.0 * lpLength);
        MolGeom.plusVec(n, v1, v1);
        this.putAtomCoords(v1, alp1);
    }

    private void addMethilideneLonePairCrd(MolAtom an, MolAtom a1, MolAtom a2, MolAtom alp1) {
        double[] n = this.getAtomCoords(an);
        double[] c1 = this.getAtomCoords(a1);
        double[] c2 = this.getAtomCoords(a2);
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] vo = new double[3];
        MolGeom.minusVec(c1, n, v1);
        MolGeom.minusVec(c2, n, v2);
        V.normalize(v1);
        V.normalize(v2);
        MolGeom.plusVec(v1, v2, vo);
        V.normalize(vo);
        MolGeom.mul(vo, -1.0 * lpLength);
        MolGeom.plusVec(n, vo, vo);
        this.putAtomCoords(vo, alp1);
    }

    private void addAmineLonePairCrd(MolAtom an, MolAtom a1, MolAtom a2, MolAtom a3, MolAtom alp1) {
        double[] n = this.getAtomCoords(an);
        double[] c1 = this.getAtomCoords(a1);
        double[] c2 = this.getAtomCoords(a2);
        double[] c3 = this.getAtomCoords(a3);
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] v3 = new double[3];
        double[] vo = new double[3];
        MolGeom.minusVec(c1, n, v1);
        MolGeom.minusVec(c2, n, v2);
        MolGeom.minusVec(c3, n, v3);
        V.normalize(v1);
        V.normalize(v2);
        V.normalize(v3);
        MolGeom.plusVec(v1, v2, vo);
        MolGeom.plusVec(v3, vo, vo);
        V.normalize(vo);
        MolGeom.mul(vo, -1.0 * lpLength);
        MolGeom.plusVec(n, vo, vo);
        this.putAtomCoords(vo, alp1);
    }

    private void addArLonePairCrd(MolAtom ao, MolAtom a1, MolAtom a2, MolAtom alp1) {
        double[] c = this.getAtomCoords(a2);
        double[] o = this.getAtomCoords(ao);
        double[] h = this.getAtomCoords(a1);
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] vo = new double[3];
        MolGeom.minusVec(h, o, v1);
        MolGeom.minusVec(c, o, v2);
        V.normalize(v1);
        V.normalize(v2);
        MolGeom.plusVec(v1, v2, vo);
        V.normalize(vo);
        MolGeom.mul(vo, -1.0 * lpLength);
        MolGeom.plusVec(o, vo, vo);
        this.putAtomCoords(vo, alp1);
    }

    private void addOHLonePairCrd(MolAtom ao, MolAtom a1, MolAtom a2, MolAtom alp1, MolAtom alp2) {
        double[] c = this.getAtomCoords(a2);
        double[] o = this.getAtomCoords(ao);
        double[] h = this.getAtomCoords(a1);
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] vo = new double[3];
        double[] v1v2 = new double[3];
        double[] lp1 = new double[3];
        double[] lp2 = new double[3];
        MolGeom.minusVec(h, o, v1);
        MolGeom.minusVec(c, o, v2);
        MolGeom.getVector3D(v1, v2, v1v2);
        V.normalize(v1);
        V.normalize(v2);
        MolGeom.plusVec(v1, v2, vo);
        MolGeom.mul(vo, -1.0);
        V.normalize(vo);
        V.normalize(v1v2);
        MolGeom.mul(vo, Math.sin(0.5235987755982988) * lpLength);
        MolGeom.mul(v1v2, Math.cos(0.5235987755982988) * lpLength);
        MolGeom.plusVec(vo, v1v2, lp1);
        MolGeom.plusVec(o, lp1, lp1);
        this.putAtomCoords(lp1, alp1);
        MolGeom.mul(v1v2, -1.0);
        MolGeom.plusVec(vo, v1v2, lp2);
        MolGeom.plusVec(o, lp2, lp2);
        this.putAtomCoords(lp2, alp2);
    }

    private void addCarboxiylLonePairCrd(int ac, int ao, int ac1, MolAtom alp1, MolAtom alp2) {
        double[] c = this.getAtomCoords(this.pharmacophore.getAtom(ac));
        double[] o = this.getAtomCoords(this.pharmacophore.getAtom(ao));
        double[] c1 = null;
        if (ac1 != -1) {
            c1 = this.getAtomCoords(this.pharmacophore.getAtom(ac1));
        } else {
            c1 = MolGeom.arrayCopy(c);
            c1[0] = c1[0] + 5.0;
            c1[0] = c1[0] + 5.0;
            c1[0] = c1[0] + 5.0;
        }
        double[] v1 = new double[3];
        double[] vo = new double[3];
        double[] v1v2 = new double[3];
        double[] v1v2vo = new double[3];
        double[] lp1 = new double[3];
        double[] lp2 = new double[3];
        MolGeom.minusVec(c1, o, v1);
        MolGeom.minusVec(c, o, vo);
        V.normalize(v1);
        V.normalize(vo);
        MolGeom.getVector3D(v1, vo, v1v2);
        MolGeom.minusVec(c, o, vo);
        MolGeom.getVector3D(v1v2, vo, v1v2vo);
        V.normalize(v1v2vo);
        MolGeom.mul(vo, -1.0);
        V.normalize(vo);
        MolGeom.mul(vo, Math.sin(0.5235987755982988) * lpLength);
        MolGeom.mul(v1v2vo, Math.cos(0.5235987755982988) * lpLength);
        MolGeom.plusVec(vo, v1v2vo, lp1);
        MolGeom.plusVec(o, lp1, lp1);
        this.putAtomCoords(lp1, alp1);
        MolGeom.mul(v1v2vo, -1.0);
        MolGeom.plusVec(vo, v1v2vo, lp2);
        MolGeom.plusVec(o, lp2, lp2);
        this.putAtomCoords(lp2, alp2);
    }

    public static boolean isDonor(int t) {
        return (t & DONR) == DONR;
    }

    public static boolean isAliphaticRC(int t) {
        return (t & ALIPHATIC_RINGCENTER) == ALIPHATIC_RINGCENTER;
    }

    public static boolean isAromaticRC(int t) {
        return (t & AROMATIC_RINGCENTER) == AROMATIC_RINGCENTER;
    }

    public static int labelWithShape(int t) {
        return t | SHAPE;
    }

    public static boolean isShape(int t) {
        return (t & SHAPE) == SHAPE;
    }

    public static int withoutType(int tOrig, int tRemove) {
        int ret = tOrig;
        ret |= tRemove;
        return ret ^= tRemove;
    }

    public static boolean isAcceptor(int t) {
        return (t & ACCP) == ACCP;
    }

    public static boolean isAromatic(int t) {
        return (t & AROMATIC_ATOM) == AROMATIC_ATOM;
    }

    public static boolean isHydrophobic(int t) {
        return (t & HYDR) == HYDR;
    }

    public static boolean isPositive(int t) {
        return (t & POS) == POS;
    }

    public static boolean isNegative(int t) {
        return (t & NEG) == NEG;
    }

    public static boolean isH(int t) {
        return (t & H) == H;
    }

    public static boolean isLP(int t) {
        return (t & LP) == LP;
    }

    public int[] getColors() {
        return this.colors;
    }
}

