/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.ProximityConstraint;
import chemaxon.marvin.alignment.ProximityPotential;

class ProximityConstraintFF
extends ProximityConstraint<ProximityPotential> {
    ForceFieldInterface ffi;

    public ForceFieldInterface getFfi() {
        return this.ffi;
    }

    ProximityConstraintFF(ForceFieldInterface ffi) {
        super(null);
        this.ffi = ffi;
    }

    @Override
    public void setNode2(Node a2) {
        if (this.node1 == null) {
            throw new UnsupportedOperationException("set node1 first");
        }
        if (this.node1.getMolID() != a2.getMolID()) {
            throw new UnsupportedOperationException();
        }
        this.node2 = a2;
    }

    @Override
    public boolean isMatch() {
        return true;
    }

    @Override
    public double getEnergy() {
        if (!this.node1.isRealAtom() || !this.node2.isRealAtom()) {
            throw new UnsupportedOperationException();
        }
        this.calcDist();
        return this.ffi.longRangeEnergy(this.node1.getFirstAtomSeq(), this.node2.getFirstAtomSeq());
    }

    @Override
    public double derivateDividedByDist() {
        this.calcDist();
        return -this.ffi.longRangeGradient(this.node1.getFirstAtomSeq(), this.node2.getFirstAtomSeq()) / this.dist;
    }

    @Override
    public PotentialType getPotentialType() {
        return PotentialType.FF;
    }
}

