/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.ProximityPotential;

class ProximityPotentialGauss
implements ProximityPotential {
    double alpha = 0.0;
    double r0;
    double weight;
    static final double EXPONENT = 0.3333333333333333;

    public ProximityPotentialGauss(double weight) {
        this.weight = weight;
    }

    @Override
    public double functionValue(double x) {
        return this.weight * Math.exp(-this.alpha * x * x);
    }

    @Override
    public PotentialType getType() {
        return PotentialType.PROX_GAUSS;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double getTolerance() {
        return this.r0;
    }

    @Override
    public boolean isOk(double x) {
        return x > this.r0;
    }

    @Override
    public double functionDerivateDividedByDist(double x) {
        return this.weight * -2.0 * this.alpha * Math.exp(-this.alpha * x * x);
    }

    @Override
    public double getVanDerWaalsRadius() {
        return this.r0;
    }

    @Override
    public void setVanDerWaalsRadius(double radius) {
        this.r0 = radius;
        double lambda = 4.1887902047863905 / this.weight;
        lambda *= lambda;
        lambda = Math.pow(lambda, 0.3333333333333333);
        this.alpha = Math.PI / lambda / (radius * radius);
    }
}

