/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class QuadraticPotential
implements PotentialFunction {
    double weight;
    double r0;
    double tolerance;

    public QuadraticPotential(double r0, double weight, double tolerance) {
        this.r0 = r0;
        this.tolerance = tolerance;
        this.weight = weight;
    }

    @Override
    public double functionValue(double x) {
        double dx = this.r0 - x;
        return this.weight * dx * dx;
    }

    @Override
    public double functionDerivateDividedByDist(double x) {
        if (x < 1.0E-6) {
            throw new UnsupportedOperationException("Distance too small.");
        }
        double dx = this.r0 - x;
        return -this.weight * 2.0 * dx / x;
    }

    public void setR0(double r0) {
        this.r0 = r0;
    }

    public double getR0() {
        return this.r0;
    }

    @Override
    public PotentialType getType() {
        return PotentialType.QUADRATIC;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isOk(double dist) {
        return Math.abs(dist - this.r0) < this.tolerance;
    }
}

