/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.PotentialFunction;
import chemaxon.marvin.alignment.PotentialType;

class QuadraticPotentialZeroR0
implements PotentialFunction {
    double weight;
    double tolerance;

    public QuadraticPotentialZeroR0(double weight, double tolerance) {
        this.tolerance = tolerance;
        this.weight = weight;
    }

    @Override
    public double functionValue(double x) {
        return this.weight * x * x;
    }

    @Override
    public double functionDerivateDividedByDist(double dist) {
        return this.weight * 2.0;
    }

    @Override
    public PotentialType getType() {
        return PotentialType.QUADRATIC;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isOk(double dist) {
        return dist < this.tolerance;
    }
}

