/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.Matrix3x3;
import chemaxon.marvin.alignment.RotationByAngles;
import chemaxon.marvin.modelling.struc.MolGeom;
import java.text.DecimalFormat;

public class Quaternion
implements RotationByAngles {
    double u;
    double v;
    double w = 0.0;
    double s = 1.0;
    double n;
    Matrix3x3 r;
    Matrix3x3 dRdPar;
    Matrix3x3 gradientMatrix;
    double[] gradientTemp = new double[3];

    public Quaternion() {
        this.r = new Matrix3x3();
        this.dRdPar = new Matrix3x3();
        this.gradientMatrix = new Matrix3x3();
        this.updateNorm();
        this.updateRotationMatrix();
    }

    protected Quaternion clone() {
        Quaternion q = new Quaternion();
        q.getParamsFrom(this);
        return q;
    }

    public String toString() {
        double m = Math.sqrt(this.n);
        return " " + this.u + " " + this.v + " " + this.w + " " + this.s + "\n normalized: " + this.u * m + " " + this.v * m + " " + this.w * m + " " + this.s * m;
    }

    void getParamsFrom(Quaternion q) {
        this.setParams(q.u, q.v, q.w, q.s);
    }

    void setParams(double u, double v, double w, double s) {
        this.u = u;
        this.v = v;
        this.w = w;
        this.s = s;
    }

    public void setAxisAndAngle(double axisX, double axisY, double axisZ, double angle) {
        double l = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (l < 1.0E-4) {
            throw new UnsupportedOperationException("Axis length approaches zero");
        }
        double cos = MolGeom.cos(angle / 2.0);
        double sin = MolGeom.sin(angle / 2.0) / l;
        this.setParams(axisX * sin, axisY * sin, axisZ * sin, cos);
        this.updateRotationMatrix();
        this.updateNorm();
    }

    public double getS() {
        return this.s;
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public double getW() {
        return this.w;
    }

    @Override
    public void setEulerXYZ(double p, double t, double f) {
        double cp = MolGeom.cos(p / 2.0);
        double ct = MolGeom.cos(t / 2.0);
        double cf = MolGeom.cos(f / 2.0);
        double sp = MolGeom.sin(p / 2.0);
        double st = MolGeom.sin(t / 2.0);
        double sf = MolGeom.sin(f / 2.0);
        this.setParams(sp * ct * cf - cp * st * sf, cp * st * cf + sp * ct * sf, cp * ct * sf - sp * st * cf, cp * ct * cf + sp * st * sf);
        this.updateRotationMatrix();
        this.updateNorm();
    }

    void updateRotationMatrix() {
        this.r.setParams(this.s * this.s + this.u * this.u - this.v * this.v - this.w * this.w, 2.0 * (this.u * this.v - this.s * this.w), 2.0 * (this.u * this.w + this.s * this.v), 2.0 * (this.u * this.v + this.s * this.w), this.s * this.s - this.u * this.u + this.v * this.v - this.w * this.w, 2.0 * (this.v * this.w - this.s * this.u), 2.0 * (this.u * this.w - this.s * this.v), 2.0 * (this.v * this.w + this.s * this.u), this.s * this.s - this.u * this.u - this.v * this.v + this.w * this.w);
    }

    public String angleAndAxis() {
        double m = Math.sqrt(this.n);
        double theta = Math.acos(this.s * m) * 2.0;
        double myU = this.u * m / Math.sin(theta / 2.0);
        double myV = this.v * m / Math.sin(theta / 2.0);
        double myW = this.w * m / Math.sin(theta / 2.0);
        DecimalFormat df = new DecimalFormat("0.000");
        return "theta: " + MolGeom.forHumans(theta) + " { " + df.format(myU) + " " + df.format(myV) + " " + df.format(myW) + " }";
    }

    private void createGradientMatrixX(double v1, double v2, double v3, double v4, double v5, double v6, double v7, double v8, double v9, double x) {
        this.dRdPar.setParams(v1, v2, v3, v4, v5, v6, v7, v8, v9);
        this.dRdPar.multiplyByScalar(2.0 * this.n);
        this.gradientMatrix.getParamsFrom(this.r);
        this.gradientMatrix.multiplyByScalar(-x * 2.0 * this.n * this.n);
        this.gradientMatrix.add(this.dRdPar);
    }

    void createGradientMatrixS() {
        this.createGradientMatrixX(this.s, -this.w, this.v, this.w, this.s, -this.u, -this.v, this.u, this.s, this.s);
    }

    void createGradientMatrixU() {
        this.createGradientMatrixX(this.u, this.v, this.w, this.v, -this.u, -this.s, this.w, this.s, -this.u, this.u);
    }

    void createGradientMatrixV() {
        this.createGradientMatrixX(-this.v, this.u, this.s, this.u, this.v, this.w, -this.s, this.w, -this.v, this.v);
    }

    void createGradientMatrixW() {
        this.createGradientMatrixX(-this.w, -this.s, this.u, this.s, -this.w, this.v, this.u, this.v, this.w, this.w);
    }

    @Override
    public double[] rotate(double[] x) {
        x = this.r.mulAndWriteBack(x);
        x[0] = x[0] * this.n;
        x[1] = x[1] * this.n;
        x[2] = x[2] * this.n;
        return x;
    }

    double[] dXYZdparam(double[] x) {
        this.gradientTemp = this.gradientMatrix.multiplyByVec(x, this.gradientTemp);
        return this.gradientTemp;
    }

    void updateNorm() {
        double d = this.u * this.u + this.v * this.v + this.w * this.w + this.s * this.s;
        if (d < 1.0E-5) {
            throw new UnsupportedOperationException(" Axis length approaches zero: " + d);
        }
        this.n = 1.0 / d;
    }

    void multiply(Quaternion q) {
        double v1 = -this.w * q.v + this.v * q.w;
        double v2 = this.w * q.u - this.u * q.w;
        double v3 = -this.v * q.u + this.u * q.v;
        double sNew = q.s * this.s - this.u * q.u - this.v * q.v - this.w * q.w;
        this.u = v1 += this.s * q.u + q.s * this.u;
        this.v = v2 += this.s * q.v + q.s * this.v;
        this.w = v3 += this.s * q.w + q.s * this.w;
        this.s = sNew;
        throw new UnsupportedOperationException("Not sure if this is ok.");
    }
}

