/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import java.util.List;

class QuaternionAlign {
    private int max_sweeps = 300;
    private double[] q = new double[4];
    private double[] constrCenter = new double[3];
    private double[] molCenter = new double[3];
    private double[][] u = new double[3][3];
    private double[][] cQ = new double[4][4];
    private double[][] vQ = new double[4][4];
    private double[] dQ = new double[4];
    private List<AlignmentConstraint> constr;
    private AlignmentMolecule toRotate;

    private void check() throws AlignmentException {
        for (int i = 0; i < this.constr.size(); ++i) {
            AlignmentConstraint a = this.constr.get(i);
            int found = 0;
            if (a.getNode1().getMolID() == this.toRotate.getMolID()) {
                ++found;
            }
            if (a.getNode2().getMolID() == this.toRotate.getMolID()) {
                ++found;
            }
            if (found == 1) continue;
            throw new AlignmentException("constraint badly assigned");
        }
    }

    public void align(List<AlignmentConstraint> constr, AlignmentMolecule toRotate) throws AlignmentException {
        this.constr = constr;
        this.toRotate = toRotate;
        this.check();
        if (constr.isEmpty()) {
            throw new AlignmentException("No constraints are added.");
        }
        double[][] crdToRotate = toRotate.getAllCrd();
        this.calcCenter(this.constrCenter, false);
        this.translate(this.constrCenter, false, -1);
        this.calcCenter(this.molCenter, true);
        this.translateCrd(crdToRotate, this.molCenter, -1);
        this.qtrfit();
        this.rotmol(crdToRotate, this.u);
        this.translateCrd(crdToRotate, this.constrCenter, 1);
        this.translate(this.constrCenter, false, 1);
    }

    private void translateCrd(double[][] crd, double[] o, int sign) {
        for (int i = 0; i < crd.length; ++i) {
            double[] dArray = crd[i];
            dArray[0] = dArray[0] + (double)sign * o[0];
            double[] dArray2 = crd[i];
            dArray2[1] = dArray2[1] + (double)sign * o[1];
            double[] dArray3 = crd[i];
            dArray3[2] = dArray3[2] + (double)sign * o[2];
        }
    }

    private double[] getCrdFor(AlignmentConstraint am, int molID) {
        if (molID == am.getNode1().getMolID()) {
            return am.getNode1().getCrd();
        }
        if (molID == am.getNode2().getMolID()) {
            return am.getNode2().getCrd();
        }
        return null;
    }

    private double[] getCrdNotFor(AlignmentConstraint am, int molID) {
        if (molID == am.getNode1().getMolID()) {
            return am.getNode2().getCrd();
        }
        return am.getNode1().getCrd();
    }

    private void calcCenter(double[] o, boolean useToRotate) {
        o[0] = 0.0;
        o[1] = 0.0;
        o[2] = 0.0;
        double wnorm = 0.0;
        for (int i = 0; i < this.constr.size(); ++i) {
            double[] x = this.getCrdNotFor(this.constr.get(i), this.toRotate.getMolID());
            if (useToRotate) {
                x = this.getCrdFor(this.constr.get(i), this.toRotate.getMolID());
            }
            o[0] = o[0] + x[0] * this.constr.get(i).getWeightSqrt();
            o[1] = o[1] + x[1] * this.constr.get(i).getWeightSqrt();
            o[2] = o[2] + x[2] * this.constr.get(i).getWeightSqrt();
            wnorm += this.constr.get(i).getWeightSqrt();
        }
        o[0] = o[0] / wnorm;
        o[1] = o[1] / wnorm;
        o[2] = o[2] / wnorm;
    }

    private void translate(double[] o, boolean useMolExtr, int sign) {
        for (int i = 0; i < this.constr.size(); ++i) {
            double[] x = this.getCrdNotFor(this.constr.get(i), this.toRotate.getMolID());
            if (useMolExtr) {
                x = this.getCrdFor(this.constr.get(i), this.toRotate.getMolID());
            }
            x[0] = x[0] + (double)sign * o[0];
            x[1] = x[1] + (double)sign * o[1];
            x[2] = x[2] + (double)sign * o[2];
        }
    }

    private void rotmol(double[][] x, double[][] u) {
        for (int i = 0; i < x.length; ++i) {
            double yx = u[0][0] * x[i][0] + u[1][0] * x[i][1] + u[2][0] * x[i][2];
            double yy = u[0][1] * x[i][0] + u[1][1] * x[i][1] + u[2][1] * x[i][2];
            double yz = u[0][2] * x[i][0] + u[1][2] * x[i][1] + u[2][2] * x[i][2];
            x[i][0] = yx;
            x[i][1] = yy;
            x[i][2] = yz;
        }
    }

    private static void jacobi(double[][] a, double[] d, double[][] v, int nrot) {
        int j;
        int i;
        double small = 1.0E-12;
        double f0 = 0.0;
        double p5 = 0.5;
        double f1 = 1.0;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                v[i][j] = 0.0;
            }
            v[i][i] = 1.0;
            d[i] = a[i][i];
        }
        for (int l = 1; l <= nrot; ++l) {
            double dtemp;
            int k;
            double dnorm = 0.0;
            double onorm = 0.0;
            for (j = 0; j < 4; ++j) {
                dnorm += Math.abs(d[j]);
                for (i = 0; i <= j - 1; ++i) {
                    onorm += Math.abs(a[i][j]);
                }
            }
            if (onorm / dnorm <= 1.0E-12) {
                nrot = l;
                for (j = 0; j < 3; ++j) {
                    k = j;
                    dtemp = d[k];
                    for (i = j + 1; i <= 3; ++i) {
                        if (!(d[i] < dtemp)) continue;
                        k = i;
                        dtemp = d[k];
                    }
                    if (k <= j) continue;
                    d[k] = d[j];
                    d[j] = dtemp;
                    for (i = 0; i < 4; ++i) {
                        dtemp = v[i][k];
                        v[i][k] = v[i][j];
                        v[i][j] = dtemp;
                    }
                }
                return;
            }
            for (j = 1; j < 4; ++j) {
                for (i = 0; i < j; ++i) {
                    double atemp;
                    double t;
                    double b = a[i][j];
                    if (!(Math.abs(b) > 0.0)) continue;
                    double dma = d[j] - d[i];
                    if (Math.abs(dma) + Math.abs(b) <= Math.abs(dma)) {
                        t = b / dma;
                    } else {
                        double q = 0.5 * dma / b;
                        t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
                        if (q < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double s = t * c;
                    a[i][j] = 0.0;
                    for (k = 0; k < i; ++k) {
                        atemp = c * a[k][i] - s * a[k][j];
                        a[k][j] = s * a[k][i] + c * a[k][j];
                        a[k][i] = atemp;
                    }
                    for (k = i + 1; k < j; ++k) {
                        atemp = c * a[i][k] - s * a[k][j];
                        a[k][j] = s * a[i][k] + c * a[k][j];
                        a[i][k] = atemp;
                    }
                    for (k = j + 1; k < 4; ++k) {
                        atemp = c * a[i][k] - s * a[j][k];
                        a[j][k] = s * a[i][k] + c * a[j][k];
                        a[i][k] = atemp;
                    }
                    for (k = 0; k < 4; ++k) {
                        double vtemp = c * v[k][i] - s * v[k][j];
                        v[k][j] = s * v[k][i] + c * v[k][j];
                        v[k][i] = vtemp;
                    }
                    dtemp = c * c * d[i] + s * s * d[j] - 2.0 * c * s * b;
                    d[j] = s * s * d[i] + c * c * d[j] + 2.0 * c * s * b;
                    d[i] = dtemp;
                }
            }
        }
    }

    private static void q2mat(double[] q, double[][] u) {
        double f2 = 2.0;
        u[0][0] = q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3];
        u[0][1] = 2.0 * (q[1] * q[2] - q[0] * q[3]);
        u[0][2] = 2.0 * (q[1] * q[3] + q[0] * q[2]);
        u[1][0] = 2.0 * (q[2] * q[1] + q[0] * q[3]);
        u[1][1] = q[0] * q[0] - q[1] * q[1] + q[2] * q[2] - q[3] * q[3];
        u[1][2] = 2.0 * (q[2] * q[3] - q[0] * q[1]);
        u[2][0] = 2.0 * (q[3] * q[1] - q[0] * q[2]);
        u[2][1] = 2.0 * (q[3] * q[2] + q[0] * q[1]);
        u[2][2] = q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3];
    }

    private void qtrfit() {
        int i;
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        for (i = 0; i < this.constr.size(); ++i) {
            AlignmentConstraint a = this.constr.get(i);
            double[] x = a.getNode1().getCrd();
            double[] y = a.getNode2().getCrd();
            if (a.getNode1().getMolID() != this.toRotate.getMolID()) {
                x = a.getNode2().getCrd();
                y = a.getNode1().getCrd();
            }
            double w = this.constr.get(i).getWeight();
            xxyx += x[0] * y[0] * w;
            xxyy += x[0] * y[1] * w;
            xxyz += x[0] * y[2] * w;
            xyyx += x[1] * y[0] * w;
            xyyy += x[1] * y[1] * w;
            xyyz += x[1] * y[2] * w;
            xzyx += x[2] * y[0] * w;
            xzyy += x[2] * y[1] * w;
            xzyz += x[2] * y[2] * w;
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.cQ[i][j] = 0.0;
            }
        }
        this.cQ[0][0] = xxyx + xyyy + xzyz;
        this.cQ[0][1] = xzyy - xyyz;
        this.cQ[1][1] = xxyx - xyyy - xzyz;
        this.cQ[0][2] = xxyz - xzyx;
        this.cQ[1][2] = xxyy + xyyx;
        this.cQ[2][2] = xyyy - xzyz - xxyx;
        this.cQ[0][3] = xyyx - xxyy;
        this.cQ[1][3] = xzyx + xxyz;
        this.cQ[2][3] = xyyz + xzyy;
        this.cQ[3][3] = xzyz - xxyx - xyyy;
        QuaternionAlign.jacobi(this.cQ, this.dQ, this.vQ, this.max_sweeps);
        int pos = 3;
        this.q[0] = this.vQ[0][pos];
        this.q[1] = this.vQ[1][pos];
        this.q[2] = this.vQ[2][pos];
        this.q[3] = this.vQ[3][pos];
        QuaternionAlign.q2mat(this.q, this.u);
    }
}

