/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class RotatableBondDetector {
    Molecule m;
    int[][] ctab;

    public RotatableBondDetector(Molecule m) {
        this.m = m;
        this.ctab = m.getCtab();
    }

    private boolean isAromaticAtom(int i) {
        return this.hasBondType(i, 4, -1) > 0;
    }

    private int hasBondType(int i, int bondType, int atomicNum) {
        int count = 0;
        for (int j = 0; j < this.ctab[i].length; ++j) {
            if (this.m.getBond(this.m.getBondTable().getBondIndex(i, this.ctab[i][j])).getType() != bondType || atomicNum != -1 && atomicNum != this.m.getAtom(this.ctab[i][j]).getAtno()) continue;
            ++count;
        }
        return count;
    }

    public boolean isRotatableBond(int bond) {
        int nonAromatic;
        boolean sp3N2;
        int t = this.m.getBond(bond).getType();
        if (t == 2 || t == 3 || t == 4) {
            return false;
        }
        if (this.isAcetileneNeighborSingleBond(bond)) {
            return false;
        }
        MolAtom at1 = this.m.getBond(bond).getAtom1();
        MolAtom at2 = this.m.getBond(bond).getAtom2();
        int ai1 = this.m.indexOf(at1);
        int ai2 = this.m.indexOf(at2);
        if (this.ctab[ai1].length < 2 || this.ctab[ai2].length < 2) {
            return false;
        }
        boolean sp3N1 = at1.getAtno() == 7;
        boolean bl = sp3N2 = at2.getAtno() == 7;
        if (!sp3N1 && sp3N2 || sp3N1 && !sp3N2) {
            int other;
            int n = other = !sp3N1 ? ai1 : ai2;
            if (this.m.getAtom(other).getAtno() == 6) {
                if (this.hasBondType(other, 2, 8) == 1) {
                    return false;
                }
                if (this.hasBondType(other, 2, 16) == 1) {
                    return false;
                }
            }
            if (this.m.getAtom(other).getAtno() == 16 && this.hasBondType(other, 2, 8) == 2) {
                return false;
            }
        }
        boolean arom1 = this.isAromaticAtom(ai1);
        boolean arom2 = this.isAromaticAtom(ai2);
        if (arom1 && arom2 || !arom1 && !arom2) {
            return true;
        }
        int n = nonAromatic = !arom1 ? ai1 : ai2;
        if (this.m.getAtom(nonAromatic).getAtno() == 6 && this.hasBondType(nonAromatic, 1, 7) == 1 && this.hasBondType(nonAromatic, 2, 7) == 1) {
            return false;
        }
        if (this.m.getAtom(nonAromatic).getAtno() == 7) {
            if (this.hasBondType(nonAromatic, 1, 8) == 1 && this.hasBondType(nonAromatic, 2, 8) == 1) {
                return false;
            }
            if (this.ctab[nonAromatic].length == 2 && this.hasBondType(nonAromatic, 2, 8) == 1) {
                return false;
            }
            if (this.hasBondType(nonAromatic, 1, -1) == 3) {
                for (int i = 0; i < this.ctab[nonAromatic].length; ++i) {
                    int n2 = this.ctab[nonAromatic][i];
                    if (this.m.getAtom(n2).getAtno() != 6 || this.hasBondType(n2, 2, 8) != 1 && this.hasBondType(n2, 2, 16) != 1) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    int rotatableBondCount() {
        int count = 0;
        for (int i = 0; i < this.m.getBondCount(); ++i) {
            if (!this.isRotatableBond(i)) continue;
            ++count;
        }
        return count;
    }

    boolean isAcetileneNeighborSingleBond(int b) {
        int b2;
        int b1;
        int triple = 3;
        MolAtom a1 = this.m.getBond(b).getAtom1();
        MolAtom a2 = this.m.getBond(b).getAtom2();
        int ind1 = this.m.indexOf(a1);
        int ind2 = this.m.indexOf(a2);
        if (this.ctab[ind1].length == 2) {
            b1 = this.m.getBondTable().getBondIndex(ind1, this.ctab[ind1][0]);
            b2 = this.m.getBondTable().getBondIndex(ind1, this.ctab[ind1][1]);
            if (this.m.getBond(b1).getType() == triple || this.m.getBond(b2).getType() == triple) {
                return true;
            }
        }
        if (this.ctab[ind2].length == 2) {
            b1 = this.m.getBondTable().getBondIndex(ind2, this.ctab[ind2][0]);
            b2 = this.m.getBondTable().getBondIndex(ind2, this.ctab[ind2][1]);
            if (this.m.getBond(b1).getType() == triple || this.m.getBond(b2).getType() == triple) {
                return true;
            }
        }
        return false;
    }
}

