/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.alignment.AlignmentBase;
import chemaxon.marvin.alignment.AlignmentConstraint;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.AtomicHistogram;
import chemaxon.marvin.alignment.Backtracking;
import chemaxon.marvin.alignment.DistanceRange;
import chemaxon.marvin.alignment.DistanceRangeStore;
import chemaxon.marvin.alignment.FlexibleMolecule;
import chemaxon.marvin.alignment.FunctionMoreMols;
import chemaxon.marvin.alignment.FunctionTwoMolsQuatFit;
import chemaxon.marvin.alignment.GaussianSum;
import chemaxon.marvin.alignment.MultiCenterGaussian;
import chemaxon.marvin.alignment.Node;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.PotentialType;
import chemaxon.marvin.alignment.QuaternionAlign;
import chemaxon.marvin.alignment.VolumeOverlap;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class Similarity3D
implements Licensable {
    private AlignmentBase ab;
    private QuaternionAlign q;
    private AlignmentMolecule amq;
    private AlignmentMolecule amt;
    private SelectedQueryNode[] selectedQueryNodes;
    private NodeColor color;
    private DistanceRangeStore queryRanges;
    private DistanceRangeStore targetRanges;
    private int[] selectedFromTarget;
    private int acceptedPairCountMinLimit = 3;
    private DistanceRange d1;
    private DistanceRange d2;
    private DistanceRange d3;
    private SelectedQueryNode[] activeQueryNodes;
    private Backtracking bt;
    private double noproxyRMSDLimit = 0.2;
    private double proxyRMSDLimit = 0.7;
    private double gradientLimitForPaired = 0.1;
    private double gradientLimitForShape = 1.0;
    private boolean forcedRigidQuery = false;
    private boolean useAlignInBackTrack = false;
    private boolean useProx = false;
    private FunctionMoreMols functionShape;
    private boolean showRingCenters = true;
    private boolean showExtraGauss = false;
    private PairResult[] map;
    private int mapCountMaxLimit = 4;
    private int mapCount = 0;
    private int minPointer = 0;
    private int shapeOptSteps = 0;
    private boolean show = false;
    private int posMax = -1;
    private boolean optimizeTanimoto = false;
    private double bestHistogram = 0.0;
    private long btTime = 0L;
    private String licenseEnvironment = "";
    private boolean fastMode = false;
    private int alignCount = 0;

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("3D Alignment", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public void setPairResultArraySizeLimit(int pairResultArraySizeLimit) {
        this.mapCountMaxLimit = pairResultArraySizeLimit;
    }

    private double histogramScore() {
        double ret = 0.0;
        for (int i = 0; i <= this.bt.getPos(); ++i) {
            ret += this.activeQueryNodes[i].getHistogramScore(this.bt.getValue(i));
        }
        return ret;
    }

    public Similarity3D(AlignmentMolecule qm) throws AlignmentException {
        qm.setMolID(0);
        qm.initVariables(false);
        qm.createDFIterator();
        this.ab = new AlignmentBase();
        this.ab.setProperty(AlignmentProperties.PAIRED);
        this.ab.addMol(qm);
        this.q = new QuaternionAlign();
        this.amq = qm;
        this.color = qm.getColors();
        this.queryRanges = qm.distanceRangeStore();
        if (this.queryRanges == null) {
            throw new AlignmentException("No distance ranges were generated for query. " + qm.getMoleculeOrig().toFormat("SMILES"));
        }
        Node[] qNodes = this.queryRanges.getSelected();
        this.selectedQueryNodes = new SelectedQueryNode[qNodes.length];
        this.d1 = new DistanceRange(this.color);
        this.d2 = new DistanceRange(this.color);
        this.d3 = new DistanceRange(this.color);
        for (int i = 0; i < this.selectedQueryNodes.length; ++i) {
            this.selectedQueryNodes[i] = new SelectedQueryNode(i);
        }
        if (!qm.isRigid()) {
            FlexibleMolecule fm = (FlexibleMolecule)qm;
            fm.setProximityEnabledNodes(fm.getProximityEnabledNodes());
        }
    }

    public void keepQueryRigid(boolean rigid) {
        if (!this.amq.isRigidMol()) {
            FlexibleMolecule fm = (FlexibleMolecule)this.amq;
            fm.setRigidPath(rigid);
            this.forcedRigidQuery = rigid;
        }
    }

    private SelectedQueryNode[] getQueryNodesMatchedToTargetType() {
        int j;
        int j2;
        for (int j3 = 0; j3 < this.selectedQueryNodes.length; ++j3) {
            this.selectedQueryNodes[j3].resetCount();
        }
        Node[] tNodes = this.targetRanges.getSelected();
        for (int i = 0; i < tNodes.length; ++i) {
            for (j2 = 0; j2 < this.selectedQueryNodes.length; ++j2) {
                if (!this.selectedQueryNodes[j2].isTypeEquals(tNodes[i])) continue;
                this.selectedQueryNodes[j2].incCount();
            }
        }
        int count = 0;
        for (j2 = 0; j2 < this.selectedQueryNodes.length; ++j2) {
            if (this.selectedQueryNodes[j2].getCount() <= 0) continue;
            ++count;
        }
        SelectedQueryNode[] tmp = new SelectedQueryNode[count];
        count = 0;
        for (j = 0; j < this.selectedQueryNodes.length; ++j) {
            if (this.selectedQueryNodes[j].getCount() <= 0) continue;
            tmp[count++] = this.selectedQueryNodes[j];
            this.selectedQueryNodes[j].init();
        }
        for (j = 0; j < tmp.length; ++j) {
            for (int i = 0; i < tNodes.length; ++i) {
                if (!tmp[j].isTypeEquals(tNodes[i])) continue;
                tmp[j].add(i);
            }
        }
        for (j = 0; j < tmp.length; ++j) {
            tmp[j].calcHistogramScores();
        }
        return tmp;
    }

    private void resetToOrigCoords(AlignmentMolecule am) {
        am.resetToOriginalCoordinates();
        am.updateRingCenters();
        am.updateIterator();
        if (!am.isRigid()) {
            FlexibleMolecule fm = (FlexibleMolecule)am;
            fm.updateConstraints();
            fm.updateDihedrals();
        }
    }

    private void addConstraints() throws AlignmentException {
        this.ab.removeAllConstraints();
        this.resetToOrigCoords(this.amq);
        this.resetToOrigCoords(this.amt);
        this.ab.resetIntraDistMap();
        for (int i = 0; i <= this.bt.getPos(); ++i) {
            if (this.activeQueryNodes[i].target.length <= this.bt.getValue(i)) continue;
            Node target = this.activeQueryNodes[i].getTargetNode(this.bt.getValue(i));
            Node query = this.activeQueryNodes[i].getQueryNode();
            AlignmentConstraint ac = new AlignmentConstraint(query, target, 1.0, 1.0, PotentialType.QUADRATIC);
            ac.setStatus(2);
            this.ab.addAlignmentConstraint(ac);
        }
    }

    private void addConstraints(AlignmentConstraint[] a) throws AlignmentException {
        this.ab.removeAllConstraints();
        this.resetToOrigCoords(this.amq);
        this.resetToOrigCoords(this.amt);
        this.ab.resetIntraDistMap();
        for (int i = 0; i < a.length; ++i) {
            this.ab.addAlignmentConstraint(a[i]);
        }
    }

    private boolean acceptByAlign(boolean useProximity) throws AlignmentException {
        FlexibleMolecule f;
        if (!this.amq.isRigid()) {
            FlexibleMolecule fm = (FlexibleMolecule)this.amq;
            fm.freezeAllBonds(true);
        }
        if (!this.amq.isRigidMol() && !this.forcedRigidQuery) {
            f = (FlexibleMolecule)this.amq;
            f.setRigidPath(false);
            f.calcRigidPath(this.ab.alignmentC);
        }
        if (!this.amt.isRigidMol()) {
            f = (FlexibleMolecule)this.amt;
            f.setRigidPath(false);
            f.calcRigidPath(this.ab.alignmentC);
        }
        double rmsd = -1.0;
        if (this.amq.isRigid() && this.amt.isRigid()) {
            this.q.align(this.ab.alignmentC, this.amt);
            rmsd = 0.0;
            for (int i = 0; i < this.ab.alignmentC.size(); ++i) {
                AlignmentConstraint ac = this.ab.alignmentC.get(i);
                rmsd += ac.getDistSQ();
            }
            if ((rmsd = Math.sqrt(rmsd / (double)this.ab.alignmentC.size())) > this.noproxyRMSDLimit) {
                return false;
            }
        } else {
            FunctionTwoMolsQuatFit f2 = new FunctionTwoMolsQuatFit(this.amq, this.amt, this.ab.alignmentC, this.ab.getStepLimit(), this.ab.getTimeLimit());
            f2.setProximity(false);
            f2.update();
            f2.getVariables();
            this.ab.function = f2;
            this.ab.setConvergenceLimit(this.gradientLimitForPaired);
            ++this.alignCount;
            this.ab.optimization();
            rmsd = this.ab.calcRMSD();
            if (rmsd > this.noproxyRMSDLimit) {
                return false;
            }
            if (useProximity) {
                f2.setProximity(true);
                this.ab.optimization();
                rmsd = this.ab.calcRMSD();
                if (rmsd > this.proxyRMSDLimit) {
                    return false;
                }
            }
        }
        return true;
    }

    private void deleteAssignedToQuery(int query) {
        boolean found = false;
        for (int i = 0; i < this.selectedFromTarget.length; ++i) {
            if (this.selectedFromTarget[i] != query) continue;
            this.selectedFromTarget[i] = -1;
            if (found) {
                throw new UnsupportedOperationException();
            }
            found = true;
        }
    }

    private void initShapeFunction() throws AlignmentException {
        FlexibleMolecule f;
        if (!this.amq.isRigidMol() && !this.forcedRigidQuery) {
            f = (FlexibleMolecule)this.amq;
            f.setRigidPath(false);
        }
        if (!this.amt.isRigidMol()) {
            f = (FlexibleMolecule)this.amt;
            f.setRigidPath(false);
        }
        this.functionShape = new FunctionMoreMols(this.ab.molecules, new ArrayList<AlignmentConstraint>(), this.ab.getStepLimit(), this.ab.getTimeLimit());
        this.functionShape.setMode(VolumeOverlap.MODE.ATOMIC);
        this.functionShape.setCenterDisplacementLimit(2.0);
        this.ab.setConvergenceLimit(this.gradientLimitForShape);
        this.ab.function = this.functionShape;
        this.functionShape.resetStepCount();
        this.functionShape.update();
    }

    private double optShape() throws AlignmentException {
        this.ab.removeAllConstraints();
        this.functionShape.update();
        this.functionShape.setMode(VolumeOverlap.MODE.ATOMIC);
        do {
            this.ab.optimization();
        } while (this.functionShape.isCenterDisplacement());
        return -this.functionShape.getFunctionValue();
    }

    private double tanimoto() throws AlignmentException {
        this.functionShape.setMode(VolumeOverlap.MODE.FULL);
        this.amq.updateGaussianProducts();
        this.amt.updateGaussianProducts();
        if (this.optimizeTanimoto) {
            do {
                this.ab.optimization();
            } while (this.functionShape.isCenterDisplacement());
            this.shapeOptSteps = this.functionShape.getStepCount();
        }
        GaussianSum sum1 = (GaussianSum)this.amq.nodes;
        GaussianSum sum2 = (GaussianSum)this.amt.nodes;
        sum1.updateGaussianProducts();
        sum2.updateGaussianProducts();
        VolumeOverlap o12 = this.functionShape.overlaps[0];
        VolumeOverlap o11 = new VolumeOverlap(this.amq, this.amq);
        VolumeOverlap o22 = new VolumeOverlap(this.amt, this.amt);
        o12.update();
        o11.update();
        o22.update();
        double x = o12.getWeightedOverlap();
        double denom1 = o11.getWeightedOverlap();
        double denom2 = o22.getWeightedOverlap();
        return x / (denom1 + denom2 - x);
    }

    public Molecule getAlignedQuery() {
        this.map[this.posMax].loadCoordinates();
        return this.amq.getAlignedMolecule().cloneMolecule();
    }

    public Molecule getAlignedTarget() {
        this.map[this.posMax].loadCoordinates();
        return this.amt.getAlignedMolecule().cloneMolecule();
    }

    private Molecule save(double shapeBefore, int steps, double tanimoto, double histogram, boolean wantColoring) {
        Molecule ret = this.amq.getAlignedMolecule().cloneMolecule();
        if (this.showExtraGauss) {
            this.amq.addGaussProducts(ret);
        }
        if (this.showRingCenters) {
            this.amq.addRingCenterNodes(ret, false);
        }
        Molecule t = this.amt.getAlignedMolecule().cloneMolecule();
        if (this.showExtraGauss) {
            this.amt.addGaussProducts(ret);
        }
        if (this.showRingCenters) {
            this.amt.addRingCenterNodes(t, false);
        }
        ret.fuse(t);
        if (wantColoring) {
            int i;
            ret.setProperty("shapeBefore", "" + shapeBefore);
            ret.setProperty("tanimoto", "" + tanimoto);
            ret.setProperty("step", "" + steps);
            ret.setProperty("histogram", "" + histogram);
            MDocument mdoc = new MDocument(ret);
            mdoc.setAtomSetColorMode(1, 1);
            mdoc.setAtomSetRGB(1, Color.BLUE.getRGB());
            mdoc.setAtomSetColorMode(2, 1);
            mdoc.setAtomSetRGB(2, Color.YELLOW.getRGB());
            mdoc.setAtomSetColorMode(2, 1);
            mdoc.setAtomSetRGB(3, Color.RED.getRGB());
            int qCount = this.amq.getAtomCountInReturnedMol(this.showExtraGauss, this.showRingCenters);
            int tCount = this.amt.getAtomCountInReturnedMol(this.showExtraGauss, this.showRingCenters);
            for (i = 0; i < qCount; ++i) {
                ret.getAtom(i).setSetSeq(1);
            }
            for (i = qCount; i < qCount + tCount; ++i) {
                ret.getAtom(i).setSetSeq(2);
            }
            for (i = 0; i < this.ab.alignmentC.size(); ++i) {
                AlignmentConstraint ac = this.ab.alignmentC.get(i);
                Node query = ac.getNode1();
                Node target = ac.getNode2();
                if (query.getMolID() != 0) {
                    query = ac.getNode2();
                    target = ac.getNode1();
                }
                int targetAtom = this.amt.getAtomSeqInReturnedMol(target, this.showExtraGauss);
                int queryAtom = this.amq.getAtomSeqInReturnedMol(query, this.showExtraGauss);
                MolAtom qa = ret.getAtom(queryAtom);
                qa.setSetSeq(3);
                qa.setExtraLabel("Q" + queryAtom);
                MolAtom ta = ret.getAtom(qCount + targetAtom);
                ta.setSetSeq(3);
                ta.setExtraLabel("T" + targetAtom);
            }
        }
        return ret;
    }

    private int activePairCount() {
        int ret = 0;
        for (int i = 0; i < this.activeQueryNodes.length; ++i) {
            if (this.activeQueryNodes[i].isJoker(this.bt.getValue(i))) continue;
            ++ret;
        }
        return ret;
    }

    private boolean checkRangeOverlap() {
        int targetIndex = this.activeQueryNodes[this.bt.getPos()].getTargetIndex(this.bt.getValue());
        int queryIndex = this.activeQueryNodes[this.bt.getPos()].querySelectedIndex;
        for (int i = 0; i < this.bt.getPos(); ++i) {
            if (this.activeQueryNodes[i].isJoker(this.bt.getValue(i))) continue;
            DistanceRange dq = this.queryRanges.get(queryIndex, this.activeQueryNodes[i].querySelectedIndex);
            int targetIndexPrev = this.activeQueryNodes[i].getTargetIndex(this.bt.getValue(i));
            DistanceRange t = this.targetRanges.get(targetIndex, targetIndexPrev);
            double d = dq.tanimoto(t);
            boolean ov = DistanceRange.section(dq, t, this.d3);
            if (d == 0.0 && ov || d != 0.0 && !ov) {
                System.err.println(dq);
                System.err.println("");
                System.err.println(t);
                System.err.println("D: " + d);
                System.err.println("ov: " + ov);
                MolGeom.writeMol(this.amt.getAlignedMolecule(), "molID1.mrv");
                throw new UnsupportedOperationException();
            }
            if (d != 0.0) continue;
            return false;
        }
        return true;
    }

    private boolean checkTriangleInequality() {
        if (this.bt.getPos() > 1) {
            int targetIndex = this.activeQueryNodes[this.bt.getPos()].getTargetIndex(this.bt.getValue());
            int queryIndex = this.activeQueryNodes[this.bt.getPos()].querySelectedIndex;
            for (int i = 0; i < this.bt.getPos() - 1; ++i) {
                if (this.activeQueryNodes[i].isJoker(this.bt.getValue(i))) continue;
                DistanceRange q1 = this.queryRanges.get(queryIndex, this.activeQueryNodes[i].querySelectedIndex);
                DistanceRange t1 = this.targetRanges.get(targetIndex, this.activeQueryNodes[i].getTargetIndex(this.bt.getValue(i)));
                for (int j = i + 1; j < this.bt.getPos(); ++j) {
                    if (this.activeQueryNodes[j].isJoker(this.bt.getValue(j))) continue;
                    DistanceRange q2 = this.queryRanges.get(queryIndex, this.activeQueryNodes[j].querySelectedIndex);
                    DistanceRange q3 = this.queryRanges.get(this.activeQueryNodes[i].querySelectedIndex, this.activeQueryNodes[j].querySelectedIndex);
                    DistanceRange t2 = this.targetRanges.get(targetIndex, this.activeQueryNodes[j].getTargetIndex(this.bt.getValue(j)));
                    DistanceRange t3 = this.targetRanges.get(this.activeQueryNodes[i].getTargetIndex(this.bt.getValue(i)), this.activeQueryNodes[j].getTargetIndex(this.bt.getValue(j)));
                    if (DistanceRange.section(q1, t1, this.d1) && DistanceRange.section(q2, t2, this.d2) && DistanceRange.section(q3, t3, this.d3)) {
                        boolean t = DistanceRange.fulfillsTriangleInequality(this.d1, this.d2, this.d3);
                        if (t) continue;
                        return false;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return true;
    }

    private void tryToSaveResult() throws AlignmentException {
        double h = this.histogramScore();
        if (this.mapCount == this.mapCountMaxLimit && this.map[this.minPointer].histogram >= h) {
            return;
        }
        this.addConstraints();
        if (!this.acceptByAlign(this.useProx)) {
            return;
        }
        AlignmentConstraint[] c = new AlignmentConstraint[this.ab.alignmentC.size()];
        for (int i = 0; i < this.ab.alignmentC.size(); ++i) {
            c[i] = this.ab.alignmentC.get(i);
        }
        PairResult p = new PairResult(h, c);
        if (this.mapCount == 0) {
            this.map[this.mapCount] = p;
            this.minPointer = this.mapCount++;
            return;
        }
        if (this.mapCount < this.mapCountMaxLimit) {
            this.map[this.mapCount] = p;
            if (this.map[this.minPointer].histogram > p.histogram) {
                this.minPointer = this.mapCount;
            }
            ++this.mapCount;
            return;
        }
        if (this.map[this.minPointer].histogram >= p.histogram) {
            throw new UnsupportedOperationException();
        }
        this.map[this.minPointer] = p;
        double minVal = this.map[0].histogram;
        this.minPointer = 0;
        for (int i = 1; i < this.map.length; ++i) {
            if (!(minVal > this.map[i].histogram)) continue;
            minVal = this.map[i].histogram;
            this.minPointer = i;
        }
    }

    private String pairsToString() {
        int a = 1;
        String s = "";
        for (int i = 0; i <= this.bt.getPos(); ++i) {
            if (this.activeQueryNodes[i].target.length <= this.bt.getValue(i)) continue;
            Node target = this.activeQueryNodes[i].getTargetNode(this.bt.getValue(i));
            Node query = this.activeQueryNodes[i].getQueryNode();
            s = s + "[" + (this.amq.getAtomSeqInReturnedMol(query, this.showExtraGauss) + a) + "," + (this.amt.getAtomSeqInReturnedMol(target, this.showExtraGauss) + a) + "]";
        }
        return s;
    }

    private String pairsToString(AlignmentConstraint[] a) {
        int at = 1;
        String s = "";
        for (int i = 0; i < a.length; ++i) {
            Node target = a[i].getNode1();
            Node query = a[i].getNode2();
            if (target.getMolID() == 0) {
                target = a[i].getNode2();
                query = a[i].getNode1();
            }
            s = s + "[" + (this.amq.getAtomSeqInReturnedMol(query, this.showExtraGauss) + at) + "," + (this.amt.getAtomSeqInReturnedMol(target, this.showExtraGauss) + at) + "]";
        }
        return s;
    }

    private void initBT(int[] baseNumber) {
        this.bt = new Backtracking(baseNumber.length, baseNumber){

            @Override
            protected void processBeforeNext() {
                Similarity3D.this.deleteAssignedToQuery(this.getPos());
            }

            @Override
            protected void processAfterNext() {
                Similarity3D.this.deleteAssignedToQuery(this.getPos());
            }

            @Override
            protected boolean good() {
                if (Similarity3D.this.activeQueryNodes[this.getPos()].isJoker(this.getValue())) {
                    int jokerCount = 0;
                    for (int i = 0; i < Similarity3D.this.activeQueryNodes.length; ++i) {
                        if (Similarity3D.this.activeQueryNodes[i].getCount() != this.getValue(i)) continue;
                        ++jokerCount;
                    }
                    return jokerCount <= Similarity3D.this.activeQueryNodes.length - Similarity3D.this.acceptedPairCountMinLimit;
                }
                int targetIndex = Similarity3D.this.activeQueryNodes[this.getPos()].getTargetIndex(this.getValue());
                if (Similarity3D.this.selectedFromTarget[targetIndex] != -1) {
                    return false;
                }
                ((Similarity3D)Similarity3D.this).selectedFromTarget[targetIndex] = this.getPos();
                if (!Similarity3D.this.checkRangeOverlap()) {
                    return false;
                }
                if (!Similarity3D.this.checkTriangleInequality()) {
                    return false;
                }
                if (Similarity3D.this.useAlignInBackTrack && this.getPos() >= 3) {
                    try {
                        Similarity3D.this.addConstraints();
                        return Similarity3D.this.acceptByAlign(Similarity3D.this.useProx);
                    }
                    catch (AlignmentException a) {
                        throw new UnsupportedOperationException(a);
                    }
                }
                return true;
            }
        };
    }

    public double similarity(byte[] target) throws AlignmentException {
        return this.similarity(AlignmentMolecule.create(target));
    }

    public double similarity(AlignmentMolecule tm) throws AlignmentException {
        this.checkLicense();
        if (this.ab.molecules.isEmpty()) {
            throw new AlignmentException("specify query!");
        }
        tm.initVariables(true);
        tm.createDFIterator();
        if (this.ab.molecules.size() == 1) {
            this.ab.addMol(tm);
        } else if (this.ab.molecules.size() == 2) {
            this.ab.molecules.set(1, tm);
        } else {
            throw new IllegalStateException("Molecule count mismatch");
        }
        this.amt = this.ab.getAlignmentMolecule(1);
        tm.setMolID(1);
        if (!this.amt.getColoringScheme().equals(this.amq.getColoringScheme())) {
            throw new AlignmentException("Query and target color mismatch!");
        }
        this.amt = tm;
        if (!this.amt.isRigid()) {
            FlexibleMolecule fm = (FlexibleMolecule)this.amt;
            fm.setProximityEnabledNodes(fm.getProximityEnabledNodes());
        }
        this.targetRanges = tm.distanceRangeStore();
        if (this.targetRanges == null) {
            this.initShapeFunction();
            this.ab.optimization();
            this.posMax = 0;
            this.map = new PairResult[1];
            this.map[0] = new PairResult(-1.0, null);
            this.map[0].tanimoto = this.tanimoto();
            return -1.0;
        }
        this.activeQueryNodes = this.getQueryNodesMatchedToTargetType();
        this.selectedFromTarget = new int[this.targetRanges.getSelected().length];
        for (int i = 0; i < this.targetRanges.getSelected().length; ++i) {
            this.selectedFromTarget[i] = -1;
        }
        this.acceptedPairCountMinLimit = (int)Math.ceil((double)this.activeQueryNodes.length / 2.0);
        this.acceptedPairCountMinLimit = Math.max(this.acceptedPairCountMinLimit, 2);
        int[] baseNumber = new int[this.activeQueryNodes.length];
        for (int i = 0; i < baseNumber.length; ++i) {
            baseNumber[i] = this.activeQueryNodes[i].getCount() + 1;
        }
        this.map = new PairResult[this.mapCountMaxLimit];
        this.mapCount = 0;
        this.minPointer = 0;
        int sc = 0;
        long t = System.currentTimeMillis();
        do {
            this.initBT(baseNumber);
            boolean found = this.bt.findFirst();
            if (found) {
                while (found) {
                    ++sc;
                    this.tryToSaveResult();
                    found = this.bt.findNext();
                }
            }
            if (this.mapCount != 0) continue;
            --this.acceptedPairCountMinLimit;
        } while (this.mapCount == 0 && this.acceptedPairCountMinLimit > 1);
        this.btTime = System.currentTimeMillis() - t;
        if (this.mapCount == 0) {
            return 0.0;
        }
        this.posMax = -1;
        double shapeMax = -1.0;
        this.bestHistogram = -1.0;
        for (int i = 0; i < this.mapCount; ++i) {
            if (!this.fastMode) {
                this.addConstraints(this.map[i].c);
                this.acceptByAlign(true);
                this.amt.setEnableTranslateAndRotate(true);
                this.initShapeFunction();
                this.map[i].shape = this.optShape();
                if (this.bestHistogram == -1.0 || this.bestHistogram < this.map[i].histogram) {
                    this.bestHistogram = this.map[i].histogram;
                }
                if (this.posMax == -1 || shapeMax < this.map[i].shape) {
                    shapeMax = this.map[i].shape;
                    this.posMax = i;
                    this.map[i].saveCoordinates();
                    this.map[i].tanimoto = this.tanimoto();
                }
            } else if (this.bestHistogram == -1.0 || this.bestHistogram < this.map[i].histogram) {
                this.bestHistogram = this.map[i].histogram;
                this.posMax = i;
                this.map[i].saveCoordinates();
            }
            if (!this.show) continue;
            this.map[i].saveCoordinates();
        }
        if (this.show) {
            long tNow = System.currentTimeMillis();
            String fn = "result_" + tNow + ".mrv";
            System.err.println("tot: " + sc + " T: " + (tNow - t) + " alignCount : " + this.alignCount + " file: " + fn + " acceptedPairCount : " + this.acceptedPairCountMinLimit);
            System.err.println("histogram shapeBefore optSteps tanimotoFinal");
            ArrayList<Molecule> v = new ArrayList<Molecule>();
            for (int i = 0; i < this.mapCount; ++i) {
                this.map[i].loadCoordinates();
                for (int j = 0; j < this.map[i].c.length; ++j) {
                    this.ab.addAlignmentConstraint(this.map[i].c[j]);
                }
                v.add(this.save(this.map[i].shape, this.shapeOptSteps, this.map[i].tanimoto, this.map[i].histogram, true));
                System.err.println(this.map[i]);
            }
            Collections.sort(v, new MyComp("tanimoto"));
        }
        return this.map[this.posMax].histogram;
    }

    public double getBestVolumeOverlap() {
        if (this.mapCount == 0) {
            return 0.0;
        }
        return this.map[this.posMax].shape;
    }

    public double getBestTanimoto() {
        if (this.mapCount == 0) {
            return 0.0;
        }
        return this.map[this.posMax].tanimoto;
    }

    public Molecule getAlignedMoleculesAsFragments() throws AlignmentException {
        if (this.mapCount == 0) {
            Molecule e = this.amq.getMoleculeOrig().cloneMolecule();
            e.fuse(this.amt.getMoleculeOrig().cloneMolecule());
            return e;
        }
        this.showRingCenters = false;
        this.showExtraGauss = false;
        Molecule m = null;
        if (this.posMax != -1) {
            this.map[this.posMax].loadCoordinates();
            m = this.save(this.map[this.posMax].shape, this.shapeOptSteps, this.map[this.posMax].tanimoto, this.map[this.posMax].histogram, false);
        } else {
            m = this.ab.getAlignedMoleculesAsFragments();
        }
        return m;
    }

    public long getBtTime() {
        return this.btTime;
    }

    public double getBestHistogram() {
        return this.bestHistogram;
    }

    private static class MyComp
    implements Comparator<Molecule> {
        String prop;

        MyComp(String prop) {
            this.prop = prop;
        }

        @Override
        public int compare(Molecule o1, Molecule o2) {
            double d2;
            double d1 = Double.parseDouble(o1.getProperty(this.prop));
            if (d1 - (d2 = Double.parseDouble(o2.getProperty(this.prop))) < 0.0) {
                return 1;
            }
            if (d1 - d2 > 0.0) {
                return -1;
            }
            return 0;
        }
    }

    private class PairResult {
        double shape;
        double histogram;
        double tanimoto;
        AlignmentConstraint[] c;
        double[][] queryCrd;
        double[][] targetCrd;

        PairResult(double h, AlignmentConstraint[] c) {
            this.histogram = h;
            this.c = c;
        }

        public String toString() {
            return "h: " + this.histogram + " sh: " + this.shape + " tan: " + this.tanimoto + " " + Similarity3D.this.pairsToString(this.c);
        }

        public void saveCoordinates() {
            this.queryCrd = MolGeom.arrayCopy(Similarity3D.this.amq.getAllCrd());
            this.targetCrd = MolGeom.arrayCopy(Similarity3D.this.amt.getAllCrd());
        }

        public void loadCoordinates() {
            Similarity3D.this.amq.copyAllCrd(this.queryCrd);
            Similarity3D.this.amt.copyAllCrd(this.targetCrd);
        }
    }

    private class SelectedQueryNode {
        int count = 0;
        int querySelectedIndex;
        private TargetSimilarity[] target;

        SelectedQueryNode(int n) {
            this.querySelectedIndex = n;
        }

        int getTargetIndex(int i) {
            return this.target[i].getTarget();
        }

        void resetCount() {
            this.count = 0;
        }

        void incCount() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        void init() {
            this.target = new TargetSimilarity[this.count];
            this.count = 0;
        }

        public boolean add(int t) {
            if (this.count >= this.target.length) {
                return false;
            }
            this.target[this.count++] = new TargetSimilarity(t);
            return true;
        }

        public boolean isTypeEquals(Node n) {
            Node node = this.getQueryNode();
            return Similarity3D.this.color.isSameTypeOrBothShapeLabelled(n.getType(), node.getType());
        }

        Node getQueryNode() {
            return Similarity3D.this.queryRanges.getSelected()[this.querySelectedIndex];
        }

        Node getTargetNode(int seq) {
            return Similarity3D.this.targetRanges.getSelected()[this.target[seq].getTarget()];
        }

        public double getHistogramScore(int btValue) {
            if (this.isJoker(btValue)) {
                return 0.0;
            }
            return this.target[btValue].getSimilarity();
        }

        public void calcHistogramScores() {
            AtomicHistogram[] ahq = Similarity3D.this.queryRanges.getHistogram(this.querySelectedIndex);
            for (int btValue = 0; btValue < this.target.length; ++btValue) {
                double ret = 0.0;
                AtomicHistogram[] aht = Similarity3D.this.targetRanges.getHistogram(this.getTargetIndex(btValue));
                for (int i = 0; i < ahq.length; ++i) {
                    for (int j = 0; j < aht.length; ++j) {
                        if (!ahq[i].isComaparable(aht[j], Similarity3D.this.color)) continue;
                        ret += ahq[i].tanimoto(aht[j]);
                    }
                }
                this.target[btValue].setSimilarity(ret);
                Arrays.sort(this.target, new HistogramComparator());
            }
        }

        public boolean isJoker(int i) {
            return this.target.length <= i;
        }

        public String toString() {
            DecimalFormat d = new DecimalFormat("0.00");
            int queryAtom = Similarity3D.this.amq.getAtomSeqInReturnedMol(this.getQueryNode(), Similarity3D.this.showExtraGauss);
            String s = "{ " + queryAtom + " } ";
            for (int j = 0; j < this.getCount(); ++j) {
                int targetAtom = Similarity3D.this.amt.getAtomSeqInReturnedMol(this.getTargetNode(j), Similarity3D.this.showExtraGauss);
                String mc = "";
                if (this.getTargetNode(j) instanceof MultiCenterGaussian) {
                    mc = "R";
                }
                s = s + targetAtom + mc + "[" + d.format(this.getHistogramScore(j)) + "]" + " ";
            }
            return s;
        }

        private class HistogramComparator
        implements Comparator<TargetSimilarity> {
            private HistogramComparator() {
            }

            @Override
            public int compare(TargetSimilarity o1, TargetSimilarity o2) {
                if (o1.getSimilarity() < o2.getSimilarity()) {
                    return 1;
                }
                if (o1.getSimilarity() > o2.getSimilarity()) {
                    return -1;
                }
                return 0;
            }
        }
    }

    private static class TargetSimilarity {
        private int target;
        private double similarity;

        TargetSimilarity(int target) {
            this.target = target;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public void setSimilarity(double similarity) {
            this.similarity = similarity;
        }

        public int getTarget() {
            return this.target;
        }
    }
}

