/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.alignment;

import chemaxon.marvin.modelling.struc.MolGeom;
import java.io.Serializable;

public class StatusMol
implements Serializable {
    public static final int BUG = 4;
    public static final int MOL_IS_NOT_3D = 8;
    public static final int RING_VIOLATION = 16;
    public static final int MOL_IS_NOT_ONE_FRAGMENT = 32;
    public static final int MOL_IS_RIGID = 64;
    public static final int PATH_IS_RIGID = 128;
    public static final int PROXIMITY_VIOLATION = 256;
    public static final int LINEAR_BONDANGLE = 512;
    public static final int REOPTIMIZED = 8192;
    public static final int FORCEDRIGID = 16384;
    public static final int TRIPLEBOND_PRESENT = 32768;
    int status = 0;
    double[][] alignedCrd;
    int molID;
    int dihedralCount = 0;

    public StatusMol(int molID) {
        this.molID = molID;
    }

    protected StatusMol clone() {
        StatusMol ret = new StatusMol(this.molID);
        ret.status = this.status;
        ret.alignedCrd = this.alignedCrd;
        ret.dihedralCount = this.dihedralCount;
        return ret;
    }

    public void resetForFindNext() {
        int mask = 0;
        mask |= 0x100;
        mask |= 0x10;
        this.status |= (mask |= 0x2000);
        this.status ^= mask;
    }

    public void cleanProxViolation() {
        int mask = 0;
        this.status |= (mask |= 0x100);
        this.status ^= mask;
    }

    public void cleanRingViolation() {
        int mask = 0;
        this.status |= (mask |= 0x10);
        this.status ^= mask;
    }

    public void cleanRigidMol() {
        int mask = 0;
        this.status |= (mask |= 0x40);
        this.status ^= mask;
    }

    public void cleanRigidPath() {
        int mask = 0;
        this.status |= (mask |= 0x80);
        this.status ^= mask;
    }

    public void resetForNewMap() {
        this.resetForFindNext();
        int mask = 0;
        this.status |= (mask |= 0x80);
        this.status ^= mask;
    }

    public boolean isRigidMol() {
        return (this.status & 0x40) == 64;
    }

    public boolean isProximityViolated() {
        return (this.status & 0x100) == 256;
    }

    boolean isReopt() {
        return (this.status & 0x2000) == 8192;
    }

    public boolean isTripleBondPresent() {
        return (this.status & 0x8000) == 32768;
    }

    public boolean isRigidPath() {
        return (this.status & 0x80) == 128;
    }

    public boolean isRingViolated() {
        return (this.status & 0x10) == 16;
    }

    public void setStatus(int b) {
        this.status |= b;
    }

    private static void integerPrinter(int integ) {
        for (int i = 0; i < 31; ++i) {
            int tmp = 1 << i;
            if ((integ & tmp) == tmp) {
                System.out.print("1");
                continue;
            }
            System.out.print("0");
        }
        System.out.println("");
    }

    public boolean isError() {
        return (this.status & 0x20) == 32 || (this.status & 8) == 8 || this.isBug();
    }

    public boolean isBug() {
        return (this.status & 4) == 4;
    }

    public String toString() {
        return this.detailedInfo();
    }

    public String detailedInfo() {
        String ret = "MolID: " + this.molID + " DihedralCount: " + this.dihedralCount + "\t";
        if ((this.status & 0x20) == 32) {
            ret = ret + "One fragment molecule is requested\t";
        }
        if ((this.status & 8) == 8) {
            ret = ret + "3D molecule is requested\t";
        }
        if ((this.status & 0x40) == 64) {
            ret = ret + "Molecule is rigid\t";
        }
        if ((this.status & 0x80) == 128) {
            ret = ret + "Path is rigid\t";
        }
        if ((this.status & 4) == 4) {
            ret = ret + "Program bug, please send bug report.\t";
        }
        if ((this.status & 0x2000) == 8192) {
            ret = ret + " Reoptimization was performed\t";
        }
        if ((this.status & 0x100) == 256) {
            ret = ret + " Proximiy violated\t";
        }
        if ((this.status & 0x10) == 16) {
            ret = ret + " Flexible ring violated\t";
        }
        if ((this.status & 0x200) == 512) {
            ret = ret + "Linear bondangle found, cannot calculate dihedral\t";
        }
        if ((this.status & 0x4000) == 16384) {
            ret = ret + "Forced rigid alignment\t";
        }
        if ((this.status & 0x8000) == 32768) {
            ret = ret + "Triple bond present\t";
        }
        return ret;
    }

    public double[][] getAlignedCrd() {
        return this.alignedCrd;
    }

    public void setAlignedCrd(double[][] alignedCrd) {
        this.alignedCrd = MolGeom.arrayCopy(alignedCrd);
    }

    public int getMolID() {
        return this.molID;
    }

    public int getDihedralCount() {
        return this.dihedralCount;
    }

    public void setDihedralCount(int dihedralCount) {
        this.dihedralCount = dihedralCount;
    }
}

